/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.builder;

import com.microsoft.java.builder.jdtbuilder.JavaBuilder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public class BuildStateManager
implements ISaveParticipant {
    private static BuildStateManager MANAGER = new BuildStateManager();
    private static final boolean SAVE_ZIPPED = !Boolean.getBoolean("org.eclipse.jdt.disable_gzip");
    private static final Integer SAVE_THREAD_COUNT = Integer.getInteger("org.eclipse.jdt.model_save_threads");
    protected Map<IProject, ProjectInfo> perProjectInfos = new HashMap<IProject, ProjectInfo>(5);

    private BuildStateManager() {
    }

    public void startup() {
        try {
            ResourcesPlugin.getWorkspace().addSaveParticipant("org.eclipse.jdt.core", (ISaveParticipant)this);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException((String)"Failed to register save participant", (Throwable)e);
        }
    }

    public static final BuildStateManager getBuildStateManager() {
        return MANAGER;
    }

    public static final boolean hasBSPNature(IProject project) {
        try {
            return project.hasNature("com.microsoft.gradle.bs.importer.GradleBuildServerProjectNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
        long startTime = System.currentTimeMillis();
        this.savingTimed(context);
        if (JavaBuilder.DEBUG) {
            long stopTime = System.currentTimeMillis();
            System.out.println("saving took " + (stopTime - startTime) + "ms:" + this.perProjectInfos.values().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savingTimed(ISaveContext context) throws CoreException {
        IStatus[] stats;
        ArrayList<ProjectInfo> infos;
        IProject savedProject = context.getProject();
        if (savedProject != null) {
            if (!BuildStateManager.hasBSPNature(savedProject)) {
                return;
            }
            ProjectInfo info = this.getPerProjectInfo(savedProject, true);
            this.saveState(info, context);
            return;
        }
        Map<IProject, ProjectInfo> map = this.perProjectInfos;
        synchronized (map) {
            infos = new ArrayList<ProjectInfo>(this.perProjectInfos.values());
        }
        int parallelism = Math.max(1, SAVE_THREAD_COUNT == null ? Math.min(infos.size(), 50) : SAVE_THREAD_COUNT);
        ForkJoinPool forkJoinPool = new ForkJoinPool(parallelism, pool -> new ForkJoinWorkerThread(pool){}, null, false);
        try {
            try {
                stats = (IStatus[])((ForkJoinTask)forkJoinPool.submit(() -> (IStatus[])((Stream)infos.stream().parallel()).map(info -> {
                    try {
                        this.saveState((ProjectInfo)info, context);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return null;
                }).filter(Objects::nonNull).toArray(IStatus[]::new))).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new CoreException(Status.error((String)Messages.build_cannotSaveStates, (Throwable)e));
            }
        }
        finally {
            forkJoinPool.shutdown();
        }
        if (stats.length > 0) {
            throw new CoreException((IStatus)new MultiStatus("org.eclipse.jdt.core", 4, stats, Messages.build_cannotSaveStates, null));
        }
    }

    public Object getLastBuiltState(IProject project, IProgressMonitor monitor) {
        if (!BuildStateManager.hasBSPNature(project)) {
            if (JavaBuilder.DEBUG) {
                System.out.println(project + " is not a BSP Java project");
            }
            return null;
        }
        ProjectInfo info = this.getPerProjectInfo(project, true);
        if (!info.triedRead) {
            info.triedRead = true;
            try {
                if (monitor != null) {
                    monitor.subTask(Messages.bind((String)Messages.build_readStateProgress, (Object)project.getName()));
                }
                info.savedState = this.readState(project);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException((String)("Exception while reading last build state for: " + project), (Throwable)e);
            }
        }
        return info.savedState;
    }

    public void setLastBuiltState(IProject project, Object state) {
        if (BuildStateManager.hasBSPNature(project)) {
            ProjectInfo info = this.getPerProjectInfo(project, true);
            info.triedRead = true;
            info.savedState = state;
        }
        if (state == null) {
            try {
                File file = this.getSerializationFile(project);
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
            catch (SecurityException securityException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectInfo getPerProjectInfo(IProject project, boolean create) {
        Map<IProject, ProjectInfo> map = this.perProjectInfos;
        synchronized (map) {
            ProjectInfo info = this.perProjectInfos.get(project);
            if (info == null && create) {
                info = new ProjectInfo(project);
                this.perProjectInfos.put(project, info);
            }
            return info;
        }
    }

    private void saveState(ProjectInfo info, ISaveContext context) throws CoreException {
        if (context.getKind() == 2) {
            return;
        }
        if (info.triedRead) {
            long startTime = System.currentTimeMillis();
            this.saveBuiltState(info);
            if (JavaBuilder.DEBUG) {
                long stopTime = System.currentTimeMillis();
                System.out.println("saveState took " + (stopTime - startTime) + "ms:" + info.project.getName());
            }
        }
    }

    protected Object readState(IProject project) throws CoreException {
        long startTime = System.currentTimeMillis();
        Object result = this.readStateTimed(project);
        if (JavaBuilder.DEBUG) {
            long stopTime = System.currentTimeMillis();
            System.out.println("readState took " + (stopTime - startTime) + "ms:" + project.getName());
        }
        return result;
    }

    private void saveBuiltState(ProjectInfo info) throws CoreException {
        File file;
        if (JavaBuilder.DEBUG) {
            System.out.println(Messages.bind((String)Messages.build_saveStateProgress, (Object)info.project.getName()));
        }
        if ((file = this.getSerializationFile(info.project)) == null) {
            return;
        }
        long t = System.currentTimeMillis();
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (DataOutputStream out = new DataOutputStream(this.createOutputStream(file));){
                out.writeUTF("org.eclipse.jdt.core");
                out.writeUTF("STATE");
                if (info.savedState == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    JavaBuilder.writeState(info.savedState, out);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | RuntimeException e) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", 2, Messages.bind((String)Messages.build_cannotSaveState, (Object)info.project.getName()), (Throwable)e));
        }
        if (JavaBuilder.DEBUG) {
            t = System.currentTimeMillis() - t;
            System.out.println(Messages.bind((String)Messages.build_saveStateComplete, (Object)String.valueOf(t)));
        }
    }

    private OutputStream createOutputStream(File file) throws IOException {
        if (SAVE_ZIPPED) {
            return new BufferedOutputStream(new GZIPOutputStream((OutputStream)new FileOutputStream(file), 8192));
        }
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    private File getSerializationFile(IProject project) {
        if (!project.exists()) {
            return null;
        }
        IPath workingLocation = project.getWorkingLocation("org.eclipse.jdt.core");
        return workingLocation.append("buildstate.dat").toFile();
    }

    private Object readStateTimed(IProject project) throws CoreException {
        block20: {
            File file = this.getSerializationFile(project);
            if (file != null && file.exists()) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (DataInputStream in = new DataInputStream(this.createInputStream(file));){
                        String pluginID = in.readUTF();
                        if (!pluginID.equals("org.eclipse.jdt.core")) {
                            throw new IOException(Messages.build_wrongFileFormat);
                        }
                        String kind = in.readUTF();
                        if (!kind.equals("STATE")) {
                            throw new IOException(Messages.build_wrongFileFormat);
                        }
                        if (in.readBoolean()) {
                            return JavaBuilder.readState(project, in);
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Saved state thinks last build failed for " + project.getName());
                        }
                        break block20;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", 2, "Error reading last build state for project " + project.getName(), (Throwable)e));
                }
            }
            if (JavaBuilder.DEBUG) {
                if (file == null) {
                    System.out.println("Project does not exist: " + project);
                } else {
                    System.out.println("Build state file " + file.getPath() + " does not exist");
                }
            }
        }
        return null;
    }

    private InputStream createInputStream(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            return new BufferedInputStream(new GZIPInputStream((InputStream)in, 8192));
        }
        catch (ZipException e) {
            boolean isZip;
            ((InputStream)in).close();
            Throwable throwable = null;
            Object var6_6 = null;
            try (DataInputStream din = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));){
                isZip = din.readShort() == -29921;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (isZip) {
                throw e;
            }
            return new BufferedInputStream(new FileInputStream(file));
        }
    }

    public static class ProjectInfo {
        public IProject project;
        public Object savedState = null;
        public boolean triedRead = false;

        public ProjectInfo(IProject project) {
            this.project = project;
        }
    }
}

