/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.llvm.ui.preferences;

import java.util.regex.Pattern;
import org.eclipse.cdt.managedbuilder.llvm.util.Separators;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class LlvmListEditor
extends ListEditor {
    List list;
    Composite buttonBox;
    Button addButton;
    Button removeButton;
    Button upButton;
    Button downButton;
    private SelectionListener selectionListener;

    protected LlvmListEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected String createList(String[] items) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (stringBuilder.length() > 0) {
                stringBuilder.append(Separators.getPathSeparator());
            }
            stringBuilder.append(item);
            ++n2;
        }
        return stringBuilder.toString();
    }

    protected String[] parseString(String stringList) {
        if (stringList != null && stringList.length() > 0) {
            return stringList.split(Pattern.quote(Separators.getPathSeparator()));
        }
        return new String[0];
    }

    private void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, "ListEditor.add");
        this.removeButton = this.createPushButton(box, "ListEditor.remove");
        this.upButton = this.createPushButton(box, "ListEditor.up");
        this.downButton = this.createPushButton(box, "ListEditor.down");
    }

    private Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setText(JFaceResources.getString((String)key));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == LlvmListEditor.this.addButton) {
                    LlvmListEditor.this.addPressed();
                } else if (widget == LlvmListEditor.this.removeButton) {
                    LlvmListEditor.this.removePressed();
                } else if (widget == LlvmListEditor.this.upButton) {
                    LlvmListEditor.this.upPressed();
                } else if (widget == LlvmListEditor.this.downButton) {
                    LlvmListEditor.this.downPressed();
                } else if (widget == LlvmListEditor.this.list) {
                    LlvmListEditor.this.selectionChanged();
                }
            }
        };
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    LlvmListEditor.this.addButton = null;
                    LlvmListEditor.this.removeButton = null;
                    LlvmListEditor.this.upButton = null;
                    LlvmListEditor.this.downButton = null;
                    LlvmListEditor.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public List getListControl(Composite parent) {
        if (this.list == null) {
            this.list = new List(parent, 2818);
            this.list.setFont(parent.getFont());
            this.list.addSelectionListener(this.getSelectionListener());
            this.list.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    LlvmListEditor.this.list = null;
                }
            });
        } else {
            this.checkParent((Control)this.list, parent);
        }
        return this.list;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected void selectionChanged() {
        int index = this.list.getSelectionIndex();
        int size = this.list.getItemCount();
        this.removeButton.setEnabled(index >= 0);
        this.upButton.setEnabled(size > 1 && index > 0);
        this.downButton.setEnabled(size > 1 && index >= 0 && index < size - 1);
    }

    private void swap(boolean up) {
        int target;
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        int n = target = up ? index - 1 : index + 1;
        if (index >= 0) {
            String[] selection = this.list.getSelection();
            Assert.isTrue((selection.length == 1 ? 1 : 0) != 0);
            this.list.remove(index);
            this.list.add(selection[0], target);
            this.list.setSelection(target);
        }
        this.selectionChanged();
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    void addPressed() {
        this.setPresentsDefaultValue(false);
        String input = this.getNewInputObject();
        if (input != null) {
            int index = this.list.getSelectionIndex();
            if (index >= 0) {
                this.list.add(input, index + 1);
            } else {
                this.list.add(input, 0);
            }
            this.selectionChanged();
        }
    }

    protected abstract void removePressed();

    void upPressed() {
        this.swap(true);
    }

    void downPressed() {
        this.swap(false);
    }
}

