/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.serial.core;

import java.io.IOException;
import org.eclipse.cdt.serial.BaudRate;
import org.eclipse.cdt.serial.ByteSize;
import org.eclipse.cdt.serial.Parity;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.cdt.serial.StopBits;
import org.eclipse.remote.core.IRemoteCommandShellService;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.RemoteConnectionChangeEvent;
import org.eclipse.remote.serial.core.ISerialPortService;
import org.eclipse.remote.serial.core.SerialPortCommandShell;
import org.eclipse.remote.serial.internal.core.Activator;
import org.eclipse.remote.serial.internal.core.Messages;

public class SerialPortConnection
implements ISerialPortService,
IRemoteCommandShellService {
    private final IRemoteConnection remoteConnection;
    private SerialPort serialPort;

    private SerialPortConnection(IRemoteConnection remoteConnection) {
        this.remoteConnection = remoteConnection;
        this.remoteConnection.addConnectionChangeListener(new IRemoteConnectionChangeListener(){

            public void connectionChanged(RemoteConnectionChangeEvent event) {
                if (event.getType() == 64) {
                    SerialPortConnection.this.serialPort = null;
                }
            }
        });
    }

    public IRemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    @Override
    public SerialPort getSerialPort() {
        String portName;
        if (this.serialPort == null && (portName = this.remoteConnection.getAttribute("serial.portName")) != null) {
            this.serialPort = new SerialPort(portName);
            try {
                this.serialPort.setBaudRate(BaudRate.fromStringIndex((int)Integer.parseInt(this.remoteConnection.getAttribute("serial.baudRate"))));
                this.serialPort.setByteSize(ByteSize.fromStringIndex((int)Integer.parseInt(this.remoteConnection.getAttribute("serial.byteSize"))));
                this.serialPort.setParity(Parity.fromStringIndex((int)Integer.parseInt(this.remoteConnection.getAttribute("serial.parity"))));
                this.serialPort.setStopBits(StopBits.fromStringIndex((int)Integer.parseInt(this.remoteConnection.getAttribute("serial.stopBits"))));
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
        return this.serialPort;
    }

    public IRemoteProcess getCommandShell(int flags) throws IOException {
        SerialPort serialPort = this.getSerialPort();
        if (serialPort == null) {
            throw new IOException(Messages.SerialPortConnection_SerialPortNotAvailable);
        }
        return new SerialPortCommandShell(this.remoteConnection, this.getSerialPort());
    }

    public static class Factory
    implements IRemoteConnection.Service.Factory {
        public <T extends IRemoteConnection.Service> T getService(IRemoteConnection remoteConnection, Class<T> service) {
            if (ISerialPortService.class.equals(service)) {
                return (T)new SerialPortConnection(remoteConnection);
            }
            if (IRemoteCommandShellService.class.equals(service)) {
                return (T)this.getService(remoteConnection, ISerialPortService.class);
            }
            return null;
        }
    }
}

