/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly;

import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.AddressRangePosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.DisassemblyPosition;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.DisassemblyDocument;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.DisassemblyRulerColumn;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.util.PropertyChangeEvent;

public class FunctionOffsetRulerColumn
extends DisassemblyRulerColumn {
    public static final String ID = "org.eclipse.cdt.dsf.ui.disassemblyColumn.functionOffset";
    private static final int MAXWIDTH = 20;

    public FunctionOffsetRulerColumn() {
        this.setForeground(this.getColor("disassembly.functionOffsetsColor"));
        this.setBackground(this.getColor("disassembly.rulerBackgroundColor"));
    }

    @Override
    protected String createDisplayString(int line) {
        DisassemblyDocument doc = (DisassemblyDocument)this.getParentRuler().getTextViewer().getDocument();
        try {
            int offset = doc.getLineOffset(line);
            AddressRangePosition pos = doc.getDisassemblyPosition(offset);
            if (pos instanceof DisassemblyPosition && pos.length > 0 && pos.offset == offset && pos.fValid) {
                DisassemblyPosition disassPos = (DisassemblyPosition)pos;
                int length = disassPos.fFunction.length;
                if (length > 20) {
                    return "..." + new String(disassPos.fFunction, length - 20 + 3, 17);
                }
                return new String(disassPos.fFunction);
            }
            if (pos != null && !pos.fValid) {
                return "......................................................................".substring(0, Math.min(20, doc.getMaxFunctionLength()));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return "";
    }

    @Override
    protected int computeNumberOfCharacters() {
        DisassemblyDocument doc = (DisassemblyDocument)this.getParentRuler().getTextViewer().getDocument();
        return Math.min(20, doc.getMaxFunctionLength());
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        boolean needRedraw = false;
        if ("disassembly.functionOffsetsColor".equals(property)) {
            this.setForeground(this.getColor(property));
            needRedraw = true;
        } else if ("disassembly.rulerBackgroundColor".equals(property)) {
            this.setBackground(this.getColor(property));
            needRedraw = true;
        }
        if (needRedraw) {
            this.redraw();
        }
    }
}

