/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.switchtolsp;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.cdt.lsp.ResolveProjectScope;
import org.eclipse.cdt.lsp.editor.ConfigurationVisibility;
import org.eclipse.cdt.lsp.editor.EditorConfiguration;
import org.eclipse.cdt.lsp.editor.EditorMetadata;
import org.eclipse.cdt.lsp.internal.switchtolsp.LinkHelper;
import org.eclipse.cdt.lsp.internal.switchtolsp.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.ServiceCaller;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.notifications.NotificationPopup;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class SwitchToLspWizard {
    public static final String TRY_LSP_HELP_PATH = "/org.eclipse.cdt.lsp.doc/html/lsp_cpp_editor.html";
    public static final String FEEDBACK_URL = "https://github.com/eclipse-cdt/cdt-lsp/issues/new/choose";

    public void startSwitch(ITextEditor editor, boolean newExperience) {
        boolean saveAllEditors;
        boolean hasProjectSpecificSetting = false;
        IProject project = null;
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            project = fileEditorInput.getFile().getProject();
            hasProjectSpecificSetting = SwitchToLspWizard.hasProjectSpecificSettingForPreferLspEditor(project);
        }
        Shell shell = editor.getSite().getShell();
        if (hasProjectSpecificSetting && project != null) {
            if (this.promptToOpenProjectProperties(shell, project)) {
                PreferenceDialog preferenceDialogOn = PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)project, (String)"org.eclipse.cdt.lsp.editor.propertyPage", null, (Object)"HIGHLIGHT_PREFER_LSP");
                preferenceDialogOn.setBlockOnOpen(false);
                preferenceDialogOn.open();
            }
            return;
        }
        if (this.openConfirmation(shell, newExperience) && (saveAllEditors = IDE.saveAllEditors((IResource[])new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, (boolean)true))) {
            this.doIt(editor, newExperience);
        }
    }

    public static boolean showPreferLsp(ITextEditor editor) {
        IEditorInput editorInput;
        ConfigurationVisibility visibility = (ConfigurationVisibility)PlatformUI.getWorkbench().getService(ConfigurationVisibility.class);
        boolean hasProjectSpecificSetting = false;
        if (editor != null && (editorInput = editor.getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            IProject project = fileEditorInput.getFile().getProject();
            hasProjectSpecificSetting = SwitchToLspWizard.hasProjectSpecificSettingForPreferLspEditor(project);
        }
        boolean showBanner = visibility.showPreferLsp(hasProjectSpecificSetting);
        return showBanner;
    }

    public static boolean hasProjectSpecificSettingForPreferLspEditor(IProject project) {
        if (project == null) {
            return false;
        }
        IWorkspace workspace = (IWorkspace)PlatformUI.getWorkbench().getService(IWorkspace.class);
        EditorConfiguration configuration = (EditorConfiguration)PlatformUI.getWorkbench().getService(EditorConfiguration.class);
        return ((Optional)new ResolveProjectScope(workspace).apply(project)).map(p -> p.getNode(configuration.qualifier())).map(n -> n.get(EditorMetadata.Predefined.preferLspEditor.identifer(), null)).isPresent();
    }

    private void doIt(ITextEditor editor, boolean newExperience) {
        IWorkspace workspace = (IWorkspace)PlatformUI.getWorkbench().getService(IWorkspace.class);
        ServiceCaller.callOnce(SwitchToLspWizard.class, EditorConfiguration.class, cc -> cc.storage(workspace).save((Object)newExperience, EditorMetadata.Predefined.preferLspEditor));
        IEditorInput editorInput = editor.getEditorInput();
        IWorkbenchPage page = editor.getSite().getPage();
        this.reopenEditors(page, editorInput, newExperience);
        editor = null;
        this.notifyUserWhatsHappening(page.getWorkbenchWindow().getShell(), newExperience);
    }

    private void reopenEditors(IWorkbenchPage firstPage, IEditorInput firstEditorInput, boolean newExperience) {
        for (InfoOnEditorsToReopen info : this.collectAllEditorRefsToReopen(firstEditorInput, firstPage, newExperience)) {
            SafeRunner.run(() -> {
                IEditorReference[] refsToOpen;
                infoOnEditorsToReopen.page.closeEditors(infoOnEditorsToReopen.refsToClose, false);
                IEditorReference[] iEditorReferenceArray = refsToOpen = infoOnEditorsToReopen.page.openEditors(infoOnEditorsToReopen.editorInputs, infoOnEditorsToReopen.editorIds, 1);
                int n = refsToOpen.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference ref = iEditorReferenceArray[n2];
                    ref.getEditor(true);
                    ++n2;
                }
            });
        }
    }

    private List<InfoOnEditorsToReopen> collectAllEditorRefsToReopen(IEditorInput firstInput, IWorkbenchPage firstPage, boolean newExperience) {
        IWorkbenchWindow[] windows;
        String editorIdToClose = newExperience ? "org.eclipse.cdt.ui.editor.CEditor" : "org.eclipse.cdt.lsp.CEditor";
        String editorIdToOpen = newExperience ? "org.eclipse.cdt.lsp.CEditor" : "org.eclipse.cdt.ui.editor.CEditor";
        ArrayList<InfoOnEditorsToReopen> allCdtEditors = new ArrayList<InfoOnEditorsToReopen>();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] editorRefs = page.getEditorReferences();
                ArrayList<IEditorReference> cEditorsOnThisPage = new ArrayList<IEditorReference>();
                ArrayList<IEditorInput> editorInputs = new ArrayList<IEditorInput>();
                ArrayList<String> editorIds = new ArrayList<String>();
                IEditorReference[] iEditorReferenceArray = editorRefs;
                int n5 = editorRefs.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorInput editorInput;
                    IEditorReference editorRef = iEditorReferenceArray[n6];
                    String id = editorRef.getId();
                    if (editorIdToClose.equals(id) && (editorInput = (IEditorInput)SafeRunner.run(() -> editorRef.getEditorInput())) != null) {
                        if (editorInput.equals(firstInput) && page.equals(firstPage)) {
                            cEditorsOnThisPage.addFirst(editorRef);
                            editorInputs.addFirst(editorInput);
                            editorIds.addFirst(editorIdToOpen);
                        } else {
                            cEditorsOnThisPage.add(editorRef);
                            editorInputs.add(editorInput);
                            editorIds.add(editorIdToOpen);
                        }
                    }
                    ++n6;
                }
                InfoOnEditorsToReopen info = new InfoOnEditorsToReopen();
                info.page = page;
                info.refsToClose = (IEditorReference[])cEditorsOnThisPage.toArray(IEditorReference[]::new);
                info.editorInputs = (IEditorInput[])editorInputs.toArray(IEditorInput[]::new);
                info.editorIds = (String[])editorIds.toArray(String[]::new);
                allCdtEditors.add(info);
                ++n4;
            }
            ++n2;
        }
        return allCdtEditors;
    }

    private void notifyUserWhatsHappening(Shell shell, boolean newExperience) {
        NotificationPopup.Builder notification = NotificationPopup.forShell((Shell)shell).title(Messages.SwitchToLsp_NewExperienceTitle, true).content(parent -> this.createInfoWithLinks((Composite)parent, shell, newExperience, true));
        notification.open();
    }

    private boolean promptToOpenProjectProperties(final Shell shell, IProject project) {
        boolean indexOfDialogButtonToProceed = false;
        String[] dialogButtonLabels = new String[]{Messages.SwitchToLsp_OpenProjectSettings, Messages.SwitchToLsp_Cancel};
        MessageDialog dialog = new MessageDialog(shell, Messages.SwitchToLsp_NewExperienceTitile, null, null, 2, 0, dialogButtonLabels){

            protected Control createMessageArea(Composite parent) {
                Control result = super.createMessageArea(parent);
                Link link = new Link(parent, 0);
                String message = Messages.SwitchToLsp_ProjectSpecificSettingsLabel + LinkHelper.getLinks(false);
                link.setText(message);
                link.setFont(parent.getFont());
                GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)link);
                link.addListener(13, event -> {
                    boolean bl = LinkHelper.handleLinkClick(shell, event);
                });
                return result;
            }
        };
        return dialog.open() == 0;
    }

    private boolean openConfirmation(Shell shell, final boolean newExperience) {
        boolean indexOfDialogButtonToProceed = false;
        String[] dialogButtonLabels = new String[]{newExperience ? Messages.SwitchToLsp_UseNewExperience : Messages.SwitchToLsp_UseClassicExperience, Messages.SwitchToLsp_Cancel};
        MessageDialog dialog = new MessageDialog(shell, Messages.SwitchToLsp_NewExperienceTitile, null, null, 2, 0, dialogButtonLabels){

            protected Control createMessageArea(Composite parent) {
                Control result = super.createMessageArea(parent);
                SwitchToLspWizard.this.createInfoWithLinks(parent, parent.getShell(), newExperience, false);
                return result;
            }
        };
        return dialog.open() == 0;
    }

    private Control createInfoWithLinks(Composite parent, Shell parentShell, boolean newExperience, boolean showPreferenceLink) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        Link link = new Link(composite, 0);
        String message = newExperience ? Messages.SwitchToLsp_EditorsWitllReopenToNewExperience + LinkHelper.getLinks(showPreferenceLink) : Messages.SwitchToLsp_EditorsWitllReopenToClassicExperience + LinkHelper.getLinks(showPreferenceLink);
        link.setText(message);
        link.setFont(composite.getFont());
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)link);
        link.addListener(13, event -> {
            boolean bl = LinkHelper.handleLinkClick(parentShell, event);
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)link);
        return link;
    }

    private static class InfoOnEditorsToReopen {
        private IWorkbenchPage page;
        private IEditorReference[] refsToClose;
        private IEditorInput[] editorInputs;
        private String[] editorIds;

        private InfoOnEditorsToReopen() {
        }
    }
}

