/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ClassDeclaration
extends TypeDeclaration {
    public static final int MODIFIER_NONE = 0;
    public static final int MODIFIER_ABSTRACT = 1;
    public static final int MODIFIER_FINAL = 2;
    public static final int MODIFIER_TRAIT = 3;
    private int modifier;
    private Expression superClass;
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(ClassDeclaration.class, "name", Identifier.class, true, false);
    public static final ChildListPropertyDescriptor INTERFACES_PROPERTY = new ChildListPropertyDescriptor(ClassDeclaration.class, "interfaces", Identifier.class, false);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(ClassDeclaration.class, "body", Block.class, true, true);
    public static final ChildPropertyDescriptor SUPER_CLASS_PROPERTY = new ChildPropertyDescriptor(ClassDeclaration.class, "superClass", Expression.class, false, false);
    public static final SimplePropertyDescriptor MODIFIER_PROPERTY = new SimplePropertyDescriptor(ClassDeclaration.class, "modifier", Integer.class, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(5);
        propertyList.add(NAME_PROPERTY);
        propertyList.add(INTERFACES_PROPERTY);
        propertyList.add(BODY_PROPERTY);
        propertyList.add(SUPER_CLASS_PROPERTY);
        propertyList.add(MODIFIER_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    @Override
    protected ChildPropertyDescriptor getBodyProperty() {
        return BODY_PROPERTY;
    }

    @Override
    protected ChildListPropertyDescriptor getInterfacesProperty() {
        return INTERFACES_PROPERTY;
    }

    @Override
    protected ChildPropertyDescriptor getNameProperty() {
        return NAME_PROPERTY;
    }

    private ClassDeclaration(int start, int end, AST ast, int modifier, Identifier className, Expression superClass, Identifier[] interfaces, Block body) {
        super(start, end, ast, className, interfaces, body);
        this.setModifier(modifier);
        if (superClass != null) {
            this.setSuperClass(superClass);
        }
    }

    public ClassDeclaration(AST ast) {
        super(ast);
    }

    public ClassDeclaration(int start, int end, AST ast, int modifier, Identifier className, Expression superClass, List interfaces, Block body) {
        this(start, end, ast, modifier, className, superClass, interfaces == null ? null : interfaces.toArray(new Identifier[interfaces.size()]), body);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.getName().accept(visitor);
        if (this.superClass != null) {
            this.superClass.accept(visitor);
        }
        for (Identifier object : this.interfaces()) {
            ASTNode node = object;
            node.accept(visitor);
        }
        this.getBody().accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getName().traverseTopDown(visitor);
        if (this.superClass != null) {
            this.superClass.traverseTopDown(visitor);
        }
        this.getInterfaces();
        for (Identifier object : this.interfaces()) {
            ASTNode node = object;
            node.traverseTopDown(visitor);
        }
        this.getBody().traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.getName().traverseBottomUp(visitor);
        if (this.superClass != null) {
            this.superClass.traverseBottomUp(visitor);
        }
        this.getInterfaces();
        for (Identifier object : this.interfaces()) {
            ASTNode node = object;
            node.traverseBottomUp(visitor);
        }
        this.getBody().traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public static String getModifier(int modifier) {
        switch (modifier) {
            case 0: {
                return "";
            }
            case 1: {
                return "abstract";
            }
            case 2: {
                return "final";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ClassDeclaration");
        this.appendInterval(buffer);
        buffer.append(" modifier='").append(ClassDeclaration.getModifier(this.modifier)).append("'>\n");
        buffer.append(tab).append("\t").append("<ClassName>\n");
        this.getName().toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("\t").append("</ClassName>\n");
        buffer.append(tab).append("\t").append("<SuperClassName>\n");
        if (this.superClass != null) {
            this.superClass.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("\t").append("</SuperClassName>\n");
        buffer.append(tab).append("\t").append("<Interfaces>\n");
        for (Identifier object : this.interfaces()) {
            ASTNode node = object;
            node.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("\t").append("</Interfaces>\n");
        this.getBody().toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</ClassDeclaration>");
    }

    @Override
    public int getType() {
        return 12;
    }

    public int getModifier() {
        return this.modifier;
    }

    public final void setModifier(int value) {
        this.preValueChange(MODIFIER_PROPERTY);
        this.modifier = value;
        this.postValueChange(MODIFIER_PROPERTY);
    }

    public Expression getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(Expression id) {
        if (id != null && !(id instanceof Identifier) && !(id instanceof NamespaceName)) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.superClass;
        this.preReplaceChild(oldChild, id, SUPER_CLASS_PROPERTY);
        this.superClass = id;
        this.postReplaceChild(oldChild, id, SUPER_CLASS_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == SUPER_CLASS_PROPERTY) {
            if (get) {
                return this.getSuperClass();
            }
            this.setSuperClass((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int child) {
        if (property == MODIFIER_PROPERTY) {
            if (get) {
                return this.getModifier();
            }
            this.setModifier(child);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, child);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Block body = ASTNode.copySubtree(target, this.getBody());
        Expression superName = ASTNode.copySubtree(target, this.getSuperClass());
        int modifier = this.getModifier();
        List interfaces = ASTNode.copySubtrees(target, this.interfaces());
        Identifier name = ASTNode.copySubtree(target, this.getName());
        ClassDeclaration result = new ClassDeclaration(this.getStart(), this.getEnd(), target, modifier, name, superName, interfaces, body);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

