/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.IFunctionBinding;
import org.eclipse.php.internal.core.ast.nodes.PHPArrayDereferenceList;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class FunctionInvocation
extends VariableBase {
    private FunctionName functionName;
    private final ASTNode.NodeList<Expression> parameters = new ASTNode.NodeList(PARAMETERS_PROPERTY);
    private PHPArrayDereferenceList arrayDereferenceList;
    public static final ChildPropertyDescriptor FUNCTION_PROPERTY = new ChildPropertyDescriptor(FunctionInvocation.class, "functionName", FunctionName.class, true, false);
    public static final ChildListPropertyDescriptor PARAMETERS_PROPERTY = new ChildListPropertyDescriptor(FunctionInvocation.class, "parameters", Expression.class, true);
    public static final ChildPropertyDescriptor ARRAY_DEREFERENCE_LIST = new ChildPropertyDescriptor(FunctionInvocation.class, "arrayDereferenceList", PHPArrayDereferenceList.class, false, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(2);
        propertyList.add(FUNCTION_PROPERTY);
        propertyList.add(PARAMETERS_PROPERTY);
        propertyList.add(ARRAY_DEREFERENCE_LIST);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    private FunctionInvocation(int start, int end, AST ast, FunctionName functionName, Expression[] parameters, PHPArrayDereferenceList arrayDereferenceList) {
        super(start, end, ast);
        if (functionName == null || parameters == null) {
            throw new IllegalArgumentException();
        }
        this.setFunctionName(functionName);
        Expression[] expressionArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expression = expressionArray[n2];
            this.parameters.add(expression);
            ++n2;
        }
        this.arrayDereferenceList = arrayDereferenceList;
    }

    public FunctionInvocation(AST ast) {
        super(ast);
    }

    public FunctionInvocation(int start, int end, AST ast, FunctionName functionName, List parameters) {
        this(start, end, ast, functionName, parameters == null ? null : parameters.toArray(new Expression[parameters.size()]), null);
    }

    public FunctionInvocation(int start, int end, AST ast, FunctionName functionName, List parameters, PHPArrayDereferenceList arrayDereferenceList) {
        this(start, end, ast, functionName, parameters == null ? null : parameters.toArray(new Expression[parameters.size()]), arrayDereferenceList);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.functionName.accept(visitor);
        for (ASTNode aSTNode : this.parameters) {
            aSTNode.accept(visitor);
        }
        if (this.arrayDereferenceList != null) {
            this.arrayDereferenceList.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.functionName.traverseTopDown(visitor);
        for (ASTNode aSTNode : this.parameters) {
            aSTNode.traverseTopDown(visitor);
        }
        if (this.arrayDereferenceList != null) {
            this.arrayDereferenceList.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.functionName.traverseBottomUp(visitor);
        for (ASTNode aSTNode : this.parameters) {
            aSTNode.traverseBottomUp(visitor);
        }
        if (this.arrayDereferenceList != null) {
            this.arrayDereferenceList.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<FunctionInvocation");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.functionName.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("<Parameters>\n");
        for (ASTNode aSTNode : this.parameters) {
            aSTNode.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</Parameters>\n");
        if (this.arrayDereferenceList != null) {
            this.arrayDereferenceList.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</FunctionInvocation>");
    }

    @Override
    public int getType() {
        return 30;
    }

    public FunctionName getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(FunctionName functionname) {
        if (functionname == null) {
            throw new IllegalArgumentException();
        }
        FunctionName oldChild = this.functionName;
        this.preReplaceChild(oldChild, functionname, FUNCTION_PROPERTY);
        this.functionName = functionname;
        this.postReplaceChild(oldChild, functionname, FUNCTION_PROPERTY);
    }

    public PHPArrayDereferenceList getArrayDereferenceList() {
        return this.arrayDereferenceList;
    }

    public void setArrayDereferenceList(PHPArrayDereferenceList arrayDereferenceList) {
        this.arrayDereferenceList = arrayDereferenceList;
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == FUNCTION_PROPERTY) {
            if (get) {
                return this.getFunctionName();
            }
            this.setFunctionName((FunctionName)child);
            return null;
        }
        if (property == ARRAY_DEREFERENCE_LIST) {
            if (get) {
                return this.getArrayDereferenceList();
            }
            this.setArrayDereferenceList((PHPArrayDereferenceList)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == PARAMETERS_PROPERTY) {
            return this.parameters();
        }
        return super.internalGetChildListProperty(property);
    }

    public Expression[] getParameters() {
        return this.parameters.toArray((Expression[])new Expression[this.parameters.size()]);
    }

    public List<Expression> parameters() {
        return this.parameters;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        FunctionName function = ASTNode.copySubtree(target, this.getFunctionName());
        List params = ASTNode.copySubtrees(target, this.parameters());
        PHPArrayDereferenceList newArrayDereferenceList = null;
        if (this.arrayDereferenceList != null) {
            newArrayDereferenceList = ASTNode.copySubtree(target, this.arrayDereferenceList);
        }
        FunctionInvocation result = new FunctionInvocation(this.getStart(), this.getEnd(), target, function, params, newArrayDereferenceList);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    public IFunctionBinding resolveFunctionBinding() {
        return this.ast.getBindingResolver().resolveFunction(this);
    }
}

