/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalTypesStrategy;
import org.eclipse.php.internal.core.model.PhpModelAccess;

public class UseTraitNameStrategy
extends GlobalTypesStrategy {
    public UseTraitNameStrategy(ICompletionContext context, int trueFlag, int falseFlag) {
        super(context, trueFlag, falseFlag);
    }

    public UseTraitNameStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        AbstractCompletionContext completionContext = (AbstractCompletionContext)this.getContext();
        if (completionContext.getPrefix() != null && completionContext.getPrefix().indexOf(92) >= 0) {
            return;
        }
        super.apply(reporter);
    }

    @Override
    protected IType[] getTypes(AbstractCompletionContext context) throws BadLocationException {
        IType[] types;
        String prefix = context.getPrefix();
        if (prefix.startsWith("$")) {
            return EMPTY;
        }
        IDLTKSearchScope scope = this.createSearchScope();
        if (context.getCompletionRequestor().isContextInformationMode()) {
            return PhpModelAccess.getDefault().findTypes(prefix, ISearchEngine.MatchRule.EXACT, this.trueFlag, this.falseFlag, scope, null);
        }
        LinkedList<IType> result = new LinkedList<IType>();
        if (prefix.length() > 1 && prefix.toUpperCase().equals(prefix)) {
            types = PhpModelAccess.getDefault().findTraits(prefix, ISearchEngine.MatchRule.CAMEL_CASE, this.trueFlag, this.falseFlag, scope, null);
            result.addAll(Arrays.asList(types));
        }
        types = PhpModelAccess.getDefault().findTraits(null, prefix, ISearchEngine.MatchRule.PREFIX, this.trueFlag, this.falseFlag, scope, null);
        result.addAll(Arrays.asList(types));
        return result.toArray(new IType[result.size()]);
    }

    @Override
    public String getNSSuffix(AbstractCompletionContext abstractContext) {
        return "";
    }

    @Override
    protected int getExtraInfo() {
        return 2;
    }
}

