/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class PHPFileVisitor
implements IResourceProxyVisitor {
    protected List fFiles = new ArrayList();
    protected IReporter fReporter = null;

    public PHPFileVisitor(IReporter reporter) {
        this.fReporter = reporter;
    }

    public boolean visit(IResourceProxy proxy) throws CoreException {
        IFile file;
        if (this.fReporter.isCancelled()) {
            return false;
        }
        if (proxy.getType() == 1 && (file = (IFile)proxy.requestResource()).exists() && this.canHandle(file)) {
            this.fFiles.add(file);
            return false;
        }
        return true;
    }

    protected boolean canHandle(IFile file) {
        boolean result = false;
        if (file != null) {
            try {
                IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
                IContentDescription contentDescription = file.getContentDescription();
                IContentType phpContentType = contentTypeManager.getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
                if (contentDescription != null) {
                    IContentType fileContentType = contentDescription.getContentType();
                    if (phpContentType != null && fileContentType.isKindOf(phpContentType)) {
                        result = true;
                    }
                } else if (phpContentType != null) {
                    result = phpContentType.isAssociatedWith(file.getName());
                }
            }
            catch (CoreException coreException) {}
        }
        return result;
    }

    public final IFile[] getFiles() {
        return this.fFiles.toArray(new IFile[this.fFiles.size()]);
    }
}

