/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.evaluation.types.ModelClassType;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.evaluation.types.SimpleType;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferencer;
import org.eclipse.php.internal.core.typeinference.context.IModelCacheContext;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPTraitType;

public class PHPTypeInferenceUtils {
    public static IEvaluatedType combineMultiType(Collection<IEvaluatedType> evaluatedTypes) {
        MultiTypeType multiTypeType = new MultiTypeType();
        for (IEvaluatedType type : evaluatedTypes) {
            if (type == null) {
                type = PHPSimpleTypes.NULL;
            }
            multiTypeType.addType(type);
        }
        return multiTypeType;
    }

    private static Collection<IEvaluatedType> resolveAmbiguousTypes(Collection<IEvaluatedType> evaluatedTypes) {
        LinkedList<IEvaluatedType> resolved = new LinkedList<IEvaluatedType>();
        for (IEvaluatedType type : evaluatedTypes) {
            if (type instanceof AmbiguousType) {
                AmbiguousType ambType = (AmbiguousType)type;
                resolved.addAll(PHPTypeInferenceUtils.resolveAmbiguousTypes(Arrays.asList(ambType.getPossibleTypes())));
                continue;
            }
            resolved.add(type);
        }
        return resolved;
    }

    public static IEvaluatedType combineTypes(Collection<IEvaluatedType> evaluatedTypes) {
        LinkedHashSet<IEvaluatedType> types = new LinkedHashSet<IEvaluatedType>(PHPTypeInferenceUtils.resolveAmbiguousTypes(evaluatedTypes));
        if (types.contains(null)) {
            types.remove(null);
            types.add(PHPSimpleTypes.NULL);
        }
        if (types.size() == 0) {
            return UnknownType.INSTANCE;
        }
        if (types.size() == 1) {
            return (IEvaluatedType)types.iterator().next();
        }
        return new AmbiguousType(types.toArray(new IEvaluatedType[types.size()]));
    }

    public static IEvaluatedType resolveExpression(ISourceModule sourceModule, ASTNode expression) {
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        IContext context = ASTUtils.findContext(sourceModule, moduleDeclaration, expression);
        return PHPTypeInferenceUtils.resolveExpression(sourceModule, moduleDeclaration, context, expression);
    }

    public static IEvaluatedType resolveExpression(ISourceModule sourceModule, ModuleDeclaration moduleDeclaration, IContext context, ASTNode expression) {
        if (context != null) {
            PHPTypeInferencer typeInferencer = new PHPTypeInferencer();
            return typeInferencer.evaluateType((AbstractTypeGoal)new ExpressionTypeGoal(context, expression));
        }
        return UnknownType.INSTANCE;
    }

    public static IType[] getModelElements(IEvaluatedType evaluatedType, ISourceModuleContext context) {
        return PHPTypeInferenceUtils.getModelElements(evaluatedType, context, 0, context instanceof IModelCacheContext ? ((IModelCacheContext)context).getCache() : null);
    }

    public static IType[] getModelElements(IEvaluatedType evaluatedType, ISourceModuleContext context, IModelAccessCache cache) {
        return PHPTypeInferenceUtils.getModelElements(evaluatedType, context, 0, cache);
    }

    public static IType[] getModelElements(IEvaluatedType evaluatedType, ISourceModuleContext context, int offset) {
        return PHPTypeInferenceUtils.internalGetModelElements(evaluatedType, context, offset, context instanceof IModelCacheContext ? ((IModelCacheContext)context).getCache() : null);
    }

    public static IType[] getModelElements(IEvaluatedType evaluatedType, ISourceModuleContext context, int offset, IModelAccessCache cache) {
        return PHPTypeInferenceUtils.internalGetModelElements(evaluatedType, context, offset, cache);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IType[] internalGetModelElements(IEvaluatedType evaluatedType, ISourceModuleContext context, int offset, IModelAccessCache cache) {
        IEvaluatedType[] possibleTypes;
        ISourceModule sourceModule = context.getSourceModule();
        if (evaluatedType instanceof ModelClassType) {
            return new IType[]{((ModelClassType)evaluatedType).getTypeDeclaration()};
        }
        if (evaluatedType instanceof PHPClassType) {
            IScriptProject scriptProject = sourceModule.getScriptProject();
            if (!ScriptProject.hasScriptNature((IProject)scriptProject.getProject())) {
                LinkedList<IType> result = new LinkedList<IType>();
                try {
                    IType[] types;
                    IType[] iTypeArray = types = sourceModule.getTypes();
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType t = iTypeArray[n2];
                        if (t.getElementName().equalsIgnoreCase(evaluatedType.getTypeName())) {
                            Class<?> expressionClass = evaluatedType.getClass();
                            if ((expressionClass != PHPTraitType.class || !PHPFlags.isTrait(t.getFlags())) && (expressionClass != PHPClassType.class || !PHPFlags.isClass(t.getFlags()))) return result.toArray(new IType[result.size()]);
                            result.add(t);
                            return result.toArray(new IType[result.size()]);
                        }
                        ++n2;
                    }
                    return result.toArray(new IType[result.size()]);
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) return result.toArray(new IType[result.size()]);
                    e.printStackTrace();
                }
                return result.toArray(new IType[result.size()]);
            }
            try {
                Class<?> expressionClass = evaluatedType.getClass();
                if (expressionClass != PHPTraitType.class) return PHPModelUtils.getTypes(evaluatedType.getTypeName(), sourceModule, offset, cache, null);
                return PHPModelUtils.getTypes(evaluatedType.getTypeName(), sourceModule, offset, cache, null, false);
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) return null;
                e.printStackTrace();
                return null;
            }
        }
        if (!(evaluatedType instanceof AmbiguousType)) return null;
        LinkedList<IType> tmpList = new LinkedList<IType>();
        IEvaluatedType[] iEvaluatedTypeArray = possibleTypes = ((AmbiguousType)evaluatedType).getPossibleTypes();
        int n = possibleTypes.length;
        int n3 = 0;
        while (n3 < n) {
            IEvaluatedType possibleType = iEvaluatedTypeArray[n3];
            IType[] tmpArray = PHPTypeInferenceUtils.internalGetModelElements(possibleType, context, offset, cache);
            if (tmpArray != null) {
                tmpList.addAll(Arrays.asList(tmpArray));
            }
            ++n3;
        }
        return tmpList.toArray(new IType[tmpList.size()]);
    }

    public static boolean isSimple(Object object) {
        if (object == null || object instanceof SimpleType) {
            return true;
        }
        if (PHPSimpleTypes.RESOURCE == object || PHPSimpleTypes.OBJECT == object) {
            return true;
        }
        if (object instanceof MultiTypeType) {
            for (IEvaluatedType type : ((MultiTypeType)object).getTypes()) {
                if (PHPTypeInferenceUtils.isSimple(type)) continue;
                return false;
            }
            return true;
        }
        if (object instanceof AmbiguousType) {
            IEvaluatedType[] iEvaluatedTypeArray = ((AmbiguousType)object).getPossibleTypes();
            int n = iEvaluatedTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEvaluatedType type = iEvaluatedTypeArray[n2];
                if (!PHPTypeInferenceUtils.isSimple(type)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }
}

