/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.ui.pathmapper.PathMappingComposite;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.ui.Messages;
import org.eclipse.php.internal.server.ui.ServerEditDialog;
import org.eclipse.php.internal.server.ui.ServersPluginImages;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PathMapperCompositeFragment
extends CompositeFragment {
    private PathMappingComposite pathMapperComposite;

    public PathMapperCompositeFragment(Composite parent, IControlHandler handler, boolean isForEditing) {
        super(parent, handler, isForEditing);
        this.controlHandler.setTitle(Messages.PathMapperCompositeFragment_0);
        this.controlHandler.setDescription(Messages.PathMapperCompositeFragment_1);
        this.controlHandler.setImageDescriptor(ServersPluginImages.DESC_WIZ_SERVER);
        this.setDisplayName(Messages.PathMapperCompositeFragment_2);
        this.setTitle(Messages.PathMapperCompositeFragment_3);
        this.setDescription(Messages.PathMapperCompositeFragment_4);
        if (isForEditing) {
            this.setData(((ServerEditDialog)this.controlHandler).getServer());
        }
        this.createControl(isForEditing);
    }

    protected void createControl(boolean isForEditing) {
        GridLayout pageLayout = new GridLayout();
        this.setLayout((Layout)pageLayout);
        Composite composite = new Composite((Composite)this, 0);
        pageLayout.numColumns = 1;
        composite.setLayout((Layout)pageLayout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.pathMapperComposite = new PathMappingComposite(composite, 0);
        data = new GridData(1808);
        this.pathMapperComposite.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)this);
        this.init();
        this.validate();
    }

    protected void init() {
        PathMapper pathMapper;
        if (this.pathMapperComposite == null || this.pathMapperComposite.isDisposed()) {
            return;
        }
        Server server = this.getServer();
        if (server != null && (pathMapper = PathMapperRegistry.getByServer((Server)server)) != null) {
            this.pathMapperComposite.setData((Object)pathMapper.getMapping());
        }
    }

    public void validate() {
        this.setMessage(this.getDescription(), 0);
        this.setComplete(true);
        this.controlHandler.update();
    }

    protected void setMessage(String message, int type) {
        this.controlHandler.setMessage(message, type);
        this.setComplete(type != 3);
        this.controlHandler.update();
    }

    public boolean performOk() {
        Server server = this.getServer();
        if (server != null) {
            PathMapper pathMapper = PathMapperRegistry.getByServer((Server)server);
            pathMapper.setMapping(this.pathMapperComposite.getMappings());
            PathMapperRegistry.storeToPreferences();
        }
        return true;
    }

    public void setData(Object server) {
        if (!(server instanceof Server)) {
            throw new IllegalArgumentException("The given object is not a Server");
        }
        super.setData(server);
        this.init();
        this.validate();
    }

    public PathMapper.Mapping[] getMappings() {
        return this.pathMapperComposite.getMappings();
    }

    public Server getServer() {
        return (Server)this.getData();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.pathMapperComposite.setEnabled(enabled);
    }
}

