/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.internal.server.PHPServerUIMessages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.ui.ServersPluginImages;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.php.internal.ui.wizards.WizardFragmentsFactoryRegistry;
import org.eclipse.php.ui.wizards.ICompositeFragmentFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ServerEditDialog
extends TitleAreaDialog
implements IControlHandler {
    protected static final String FRAGMENT_GROUP_ID = "org.eclipse.php.server.ui.serverWizardAndComposite";
    private Server server;
    private ArrayList runtimeComposites;
    private SelectionListener tabsListener;
    private CTabFolder tabs;
    private String tabID;

    public ServerEditDialog(Shell parentShell, Server server) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.server = server;
        this.runtimeComposites = new ArrayList(3);
    }

    public ServerEditDialog(Shell parentShell, Server server, String tabID) {
        this(parentShell, server);
        this.tabID = tabID;
    }

    protected Control createDialogArea(Composite parent) {
        ICompositeFragmentFactory[] factories;
        this.tabs = SWTUtil.createTabFolder((Composite)parent);
        ICompositeFragmentFactory[] iCompositeFragmentFactoryArray = factories = WizardFragmentsFactoryRegistry.getFragmentsFactories((String)FRAGMENT_GROUP_ID);
        int n = factories.length;
        int n2 = 0;
        while (n2 < n) {
            ICompositeFragmentFactory element = iCompositeFragmentFactoryArray[n2];
            CTabItem tabItem = new CTabItem(this.tabs, 2048);
            CompositeFragment fragment = element.createComposite((Composite)this.tabs, (IControlHandler)this);
            fragment.setData((Object)this.server);
            tabItem.setText(fragment.getDisplayName());
            tabItem.setControl((Control)fragment);
            tabItem.setData((Object)fragment.getId());
            this.runtimeComposites.add(fragment);
            ++n2;
        }
        this.getShell().setText(PHPServerUIMessages.getString("ServerEditDialog.editServer"));
        this.getShell().setImage(ServersPluginImages.get("org.eclipse.php.server.ui.server.gif"));
        this.tabsListener = new TabsSelectionListener();
        this.tabs.addSelectionListener(this.tabsListener);
        if (this.tabID != null) {
            this.setSelect(this.tabID);
        }
        return this.tabs;
    }

    private void setSelect(String id) {
        if (id == null) {
            return;
        }
        int i = 0;
        while (i < this.tabs.getItemCount()) {
            if (id.equals(this.tabs.getItem(i).getData())) {
                this.tabs.setSelection(i);
                break;
            }
            ++i;
        }
    }

    protected void cancelPressed() {
        Iterator composites = this.runtimeComposites.iterator();
        while (composites.hasNext()) {
            ((CompositeFragment)composites.next()).performCancel();
        }
        super.cancelPressed();
    }

    protected void okPressed() {
        Iterator composites = this.runtimeComposites.iterator();
        while (composites.hasNext()) {
            ((CompositeFragment)composites.next()).performOk();
        }
        super.okPressed();
    }

    public void setDescription(String desc) {
        super.setMessage(desc);
    }

    public void setImageDescriptor(ImageDescriptor image) {
        super.setTitleImage(image.createImage());
    }

    public void update() {
        Button button = this.getButton(0);
        if (button != null) {
            Iterator composites = this.runtimeComposites.iterator();
            while (composites.hasNext()) {
                if (((CompositeFragment)composites.next()).isComplete()) continue;
                button.setEnabled(false);
                return;
            }
            button.setEnabled(true);
        }
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    private class TabsSelectionListener
    implements SelectionListener {
        private TabsSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            CTabItem item = (CTabItem)e.item;
            CompositeFragment fragment = (CompositeFragment)item.getControl();
            ServerEditDialog.this.setTitle(fragment.getTitle());
            fragment.validate();
        }
    }
}

