/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui.launching;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.debug.ui.IDebugServerConnectionTest;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.server.PHPServerUIMessages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.core.tunneling.TunnelTester;
import org.eclipse.php.internal.server.ui.Logger;
import org.eclipse.php.internal.server.ui.PixelConverter;
import org.eclipse.php.internal.server.ui.launching.MD5;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;

public class PHPServerAdvancedTab
extends AbstractLaunchConfigurationTab {
    private static final String READ_ONLY = "read-only";
    private Button debugFirstPageBt;
    private Button debugAllPagesBt;
    private Button debugStartFromBt;
    private Button debugContinueBt;
    private Button resetBt;
    private Text debugFromTxt;
    protected Button openBrowser;
    protected WidgetListener listener;
    protected ILaunchConfiguration launchConfiguration;
    private Group tunnelGroup;
    private Composite sessionGroup;
    protected boolean isOpenInBrowser;
    private Button debugThroughTunnel;
    private Text userName;
    private Text password;
    private Button testButton;
    private CLabel testResultLabel;
    private Label nameLabel;
    private Label passwordLabel;
    private Combo fDebuggersCombo;
    private Button validateDebuggerBtn;
    private Button configureDebugger;
    private Button breakOnFirstLine;
    public boolean isTextModificationChange;
    private IDebugServerConnectionTest[] debugTesters = new IDebugServerConnectionTest[0];
    private Set<String> fDebuggerIds;

    public PHPServerAdvancedTab() {
        this.listener = new WidgetListener();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createDebuggerSelectionControl(composite);
        this.createBreakControl(composite);
        this.createAdvanceControl(composite);
        this.createExtensionControls(composite);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    protected void createAdvanceControl(Composite composite) {
        this.tunnelGroup = new Group(composite, 0);
        this.tunnelGroup.setLayout((Layout)new GridLayout(1, false));
        this.tunnelGroup.setLayoutData((Object)new GridData(768));
        this.tunnelGroup.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.1"));
        Group browserGroup = new Group(composite, 0);
        browserGroup.setLayout((Layout)new GridLayout(1, false));
        browserGroup.setLayoutData((Object)new GridData(768));
        browserGroup.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.2"));
        PixelConverter converter = new PixelConverter((Control)composite);
        this.debugThroughTunnel = new Button((Composite)this.tunnelGroup, 32);
        this.debugThroughTunnel.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.3"));
        Composite credentialsComposite = new Composite((Composite)this.tunnelGroup, 0);
        credentialsComposite.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(768);
        data.horizontalIndent = 20;
        credentialsComposite.setLayoutData((Object)data);
        this.nameLabel = new Label(credentialsComposite, 0);
        this.nameLabel.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.4"));
        this.userName = new Text(credentialsComposite, 2052);
        data = new GridData();
        data.widthHint = converter.convertHorizontalDLUsToPixels(150);
        this.userName.setLayoutData((Object)data);
        this.passwordLabel = new Label(credentialsComposite, 0);
        this.passwordLabel.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.5"));
        this.password = new Text(credentialsComposite, 0x400804);
        data = new GridData();
        data.widthHint = converter.convertHorizontalDLUsToPixels(150);
        this.password.setLayoutData((Object)data);
        Composite testConnectionComposite = new Composite(credentialsComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        testConnectionComposite.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        testConnectionComposite.setLayoutData((Object)data);
        this.testButton = new Button(testConnectionComposite, 8);
        this.testButton.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.6"));
        this.testResultLabel = new CLabel(testConnectionComposite, 0);
        this.testResultLabel.setLayoutData((Object)new GridData(768));
        this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPServerAdvancedTab.this.testTunnelConnection();
            }
        });
        this.testResultLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Object messageData = PHPServerAdvancedTab.this.testResultLabel.getData("info");
                if (messageData != null) {
                    MessageDialog.openInformation((Shell)PHPServerAdvancedTab.this.getShell(), (String)PHPServerUIMessages.getString("PHPServerAdvancedTab.8"), (String)messageData.toString());
                }
            }
        });
        this.debugThroughTunnel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Button b = (Button)se.getSource();
                boolean selection = b.getSelection();
                PHPServerAdvancedTab.this.updateTunnelComponents(selection);
                PHPServerAdvancedTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.openBrowser = new Button((Composite)browserGroup, 32);
        this.openBrowser.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.9"));
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.openBrowser.setLayoutData((Object)data);
        this.sessionGroup = new Composite((Composite)browserGroup, 0);
        this.sessionGroup.setLayout((Layout)new GridLayout(3, false));
        this.sessionGroup.setLayoutData((Object)new GridData(768));
        this.openBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Button b = (Button)se.getSource();
                PHPServerAdvancedTab.this.isOpenInBrowser = b.getSelection();
                if (!PHPServerAdvancedTab.this.isOpenInBrowser) {
                    PHPServerAdvancedTab.this.debugFirstPageBt.setSelection(true);
                    PHPServerAdvancedTab.this.debugAllPagesBt.setSelection(false);
                } else {
                    PHPServerAdvancedTab.this.debugFirstPageBt.setSelection(false);
                    PHPServerAdvancedTab.this.debugAllPagesBt.setSelection(true);
                }
                PHPServerAdvancedTab.this.debugStartFromBt.setSelection(false);
                PHPServerAdvancedTab.this.debugContinueBt.setSelection(false);
                PHPServerAdvancedTab.this.enableSessionSettingButtons(PHPServerAdvancedTab.this.isOpenInBrowser && "debug".equals(PHPServerAdvancedTab.this.getLaunchConfigurationDialog().getMode()));
                PHPServerAdvancedTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.debugAllPagesBt = this.createRadioButton(this.sessionGroup, PHPServerUIMessages.getString("PHPServerAdvancedTab.10"));
        data = (GridData)this.debugAllPagesBt.getLayoutData();
        data.horizontalSpan = 3;
        data.horizontalIndent = 20;
        this.debugFirstPageBt = this.createRadioButton(this.sessionGroup, PHPServerUIMessages.getString("PHPServerAdvancedTab.11"));
        data = (GridData)this.debugFirstPageBt.getLayoutData();
        data.horizontalSpan = 3;
        data.horizontalIndent = 20;
        this.debugStartFromBt = this.createRadioButton(this.sessionGroup, PHPServerUIMessages.getString("PHPServerAdvancedTab.12"));
        data = (GridData)this.debugStartFromBt.getLayoutData();
        data.horizontalIndent = 20;
        this.debugFromTxt = new Text(this.sessionGroup, 2052);
        this.debugFromTxt.setLayoutData((Object)new GridData(768));
        this.resetBt = this.createPushButton(this.sessionGroup, PHPServerUIMessages.getString("PHPServerAdvancedTab.13"), null);
        this.resetBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PHPServerAdvancedTab.this.launchConfiguration != null) {
                    try {
                        PHPServerAdvancedTab.this.debugFromTxt.setText(PHPServerAdvancedTab.this.launchConfiguration.getAttribute("base_url", ""));
                    }
                    catch (CoreException coreException) {}
                }
            }
        });
        this.debugContinueBt = this.createCheckButton(this.sessionGroup, PHPServerUIMessages.getString("PHPServerAdvancedTab.15"));
        data = (GridData)this.debugContinueBt.getLayoutData();
        data.horizontalSpan = 3;
        data.horizontalIndent = 40;
        this.debugStartFromBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPServerAdvancedTab.this.updateDebugFrom();
            }
        });
        this.updateDebugFrom();
        this.debugFirstPageBt.addSelectionListener((SelectionListener)this.listener);
        this.debugAllPagesBt.addSelectionListener((SelectionListener)this.listener);
        this.debugContinueBt.addSelectionListener((SelectionListener)this.listener);
        this.debugStartFromBt.addSelectionListener((SelectionListener)this.listener);
        this.debugFromTxt.addModifyListener((ModifyListener)this.listener);
        this.debugThroughTunnel.addSelectionListener((SelectionListener)this.listener);
        this.userName.addModifyListener((ModifyListener)this.listener);
        this.password.addModifyListener((ModifyListener)this.listener);
        KeyListener userInputListener = new KeyListener(){

            public void keyReleased(KeyEvent e) {
                PHPServerAdvancedTab.this.testResultLabel.setText("");
                PHPServerAdvancedTab.this.testButton.setEnabled(PHPServerAdvancedTab.this.userName.getText().trim().length() > 0);
            }

            public void keyPressed(KeyEvent e) {
                PHPServerAdvancedTab.this.testResultLabel.setText("");
            }
        };
        this.userName.addKeyListener(userInputListener);
        this.password.addKeyListener(userInputListener);
    }

    protected void createDebuggerSelectionControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.18"));
        GridLayout ly = new GridLayout(1, false);
        ly.marginHeight = 0;
        ly.marginWidth = 0;
        group.setLayout((Layout)ly);
        group.setLayoutData((Object)new GridData(768));
        Composite debuggerServerComp = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout(4, false);
        debuggerServerComp.setLayout((Layout)layout);
        GridData data = new GridData(768);
        debuggerServerComp.setLayoutData((Object)data);
        Font font = parent.getFont();
        debuggerServerComp.setFont(font);
        Label label = new Label(debuggerServerComp, 64);
        data = new GridData(1);
        data.widthHint = 100;
        label.setLayoutData((Object)data);
        label.setFont(font);
        label.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.19"));
        this.fDebuggersCombo = new Combo(debuggerServerComp, 2060);
        this.fDebuggersCombo.setFont(font);
        this.fDebuggersCombo.setLayoutData((Object)new GridData(768));
        this.fDebuggersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isXDebug = PHPServerAdvancedTab.this.isXdebug();
                PHPServerAdvancedTab.this.openBrowser.setEnabled(!isXDebug);
                PHPServerAdvancedTab.this.sessionGroup.setVisible(!isXDebug);
                PHPServerAdvancedTab.this.openBrowser.setSelection(isXDebug || PHPServerAdvancedTab.this.debugFirstPageBt.getEnabled());
                if (isXDebug) {
                    PHPServerAdvancedTab.this.openBrowser.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.20"));
                } else {
                    PHPServerAdvancedTab.this.openBrowser.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.21"));
                }
                PHPServerAdvancedTab.this.updateLaunchConfigurationDialog();
                PHPServerAdvancedTab.this.updateDebugServerTesters();
            }
        });
        this.validateDebuggerBtn = this.createPushButton(debuggerServerComp, PHPServerUIMessages.getString("PHPServerAdvancedTab.22"), null);
        this.validateDebuggerBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PHPServerAdvancedTab.this.updateDebugServerTesters();
                String serverName = null;
                try {
                    serverName = PHPServerAdvancedTab.this.launchConfiguration.getAttribute("name", null);
                }
                catch (CoreException coreException) {}
                if (serverName != null) {
                    Server server = ServersManager.getServer(serverName);
                    IDebugServerConnectionTest[] iDebugServerConnectionTestArray = PHPServerAdvancedTab.this.debugTesters;
                    int n = iDebugServerConnectionTestArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDebugServerConnectionTest debugServerTester = iDebugServerConnectionTestArray[n2];
                        debugServerTester.testConnection(server, PHPServerAdvancedTab.this.getShell());
                        ++n2;
                    }
                }
            }
        });
        this.configureDebugger = this.createPushButton(debuggerServerComp, PHPServerUIMessages.getString(PHPServerUIMessages.getString("PHPServerAdvancedTab.23")), null);
        this.configureDebugger.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPServerAdvancedTab.this.handleConfigureDebuggerSelected();
            }
        });
        this.fillDebuggers();
    }

    protected void createBreakControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.24"));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        this.breakOnFirstLine = this.createCheckButton((Composite)group, PHPServerUIMessages.getString("PHPServerAdvancedTab.25"));
        this.breakOnFirstLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPServerAdvancedTab.this.setDirty(true);
                PHPServerAdvancedTab.this.updateLaunchConfigurationDialog();
            }
        });
        String mode = this.getLaunchConfigurationDialog().getMode();
        boolean isDebugMode = "debug".equals(mode);
        this.breakOnFirstLine.setEnabled(isDebugMode);
    }

    protected void handleConfigureDebuggerSelected() {
        AbstractDebuggerConfiguration[] debuggersConfigurations;
        String selectedDebugger = this.getSelectedDebuggerId();
        AbstractDebuggerConfiguration[] abstractDebuggerConfigurationArray = debuggersConfigurations = PHPDebuggersRegistry.getDebuggersConfigurations();
        int n = debuggersConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDebuggerConfiguration debuggerConfig = abstractDebuggerConfigurationArray[n2];
            if (debuggerConfig.getDebuggerId().equals(selectedDebugger)) {
                debuggerConfig.openConfigurationDialog(Display.getDefault().getActiveShell());
            }
            ++n2;
        }
    }

    protected void fillDebuggers() {
        this.fDebuggerIds = PHPDebuggersRegistry.getDebuggersIds();
        for (String id : this.fDebuggerIds) {
            this.fDebuggersCombo.add(PHPDebuggersRegistry.getDebuggerName((String)id));
        }
        String defaultName = PHPDebuggersRegistry.getDebuggerName((String)PHPDebuggersRegistry.getDefaultDebuggerId());
        int index = this.fDebuggersCombo.indexOf(defaultName);
        if (index > -1) {
            this.fDebuggersCombo.select(index);
        } else if (this.fDebuggersCombo.getItemCount() > 0) {
            this.fDebuggersCombo.select(0);
        }
    }

    protected void updateTunnelComponents(boolean enabled) {
        this.testResultLabel.setText("");
        this.setEnabled(enabled, new Control[]{this.userName, this.password, this.nameLabel, this.passwordLabel, this.testResultLabel});
        this.testButton.setEnabled(enabled && this.userName.getText().trim().length() > 0);
    }

    protected void setEnabled(boolean enabled, Control ... controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setEnabled(enabled);
            ++n2;
        }
    }

    private void enableSessionSettingButtons(boolean isOpenInBrowser) {
        String mode = this.getLaunchConfigurationDialog().getMode();
        isOpenInBrowser = isOpenInBrowser && "debug".equals(mode);
        this.debugFirstPageBt.setEnabled(isOpenInBrowser);
        this.debugAllPagesBt.setEnabled(isOpenInBrowser);
        this.debugStartFromBt.setEnabled(isOpenInBrowser);
        this.debugContinueBt.setEnabled(false);
        this.resetBt.setEnabled(false);
        this.debugFromTxt.setEnabled(false);
    }

    private void testTunnelConnection() {
        this.testButton.setEnabled(false);
        this.testResultLabel.setForeground(Display.getDefault().getSystemColor(9));
        this.testResultLabel.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.27"));
        this.testResultLabel.setCursor(Display.getDefault().getSystemCursor(1));
        this.testResultLabel.setData("info", null);
        UIJob connectionTest = new UIJob(PHPServerUIMessages.getString("PHPServerAdvancedTab.29")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                block15: {
                    try {
                        String remoteHost = PHPLaunchUtilities.getDebugHost((ILaunchConfiguration)PHPServerAdvancedTab.this.launchConfiguration);
                        int port = PHPLaunchUtilities.getDebugPort((ILaunchConfiguration)PHPServerAdvancedTab.this.launchConfiguration);
                        if (remoteHost == null || remoteHost.length() == 0 || port < 0) {
                            PHPServerAdvancedTab.this.testButton.setEnabled(true);
                            PHPServerAdvancedTab.this.testResultLabel.setCursor(Display.getDefault().getSystemCursor(21));
                            PHPServerAdvancedTab.this.testResultLabel.setForeground(Display.getDefault().getSystemColor(4));
                            if (port > -1) {
                                PHPServerAdvancedTab.this.testResultLabel.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.30"));
                                PHPServerAdvancedTab.this.testResultLabel.setData("info", (Object)PHPServerUIMessages.getString("PHPServerAdvancedTab.32"));
                            } else {
                                PHPServerAdvancedTab.this.testResultLabel.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.33"));
                                PHPServerAdvancedTab.this.testResultLabel.setData("info", (Object)PHPServerUIMessages.getString("PHPServerAdvancedTab.35"));
                            }
                        }
                        PHPServerAdvancedTab.this.testResultLabel.setCursor(Display.getDefault().getSystemCursor(1));
                        IStatus connectionStatus = TunnelTester.test((String)remoteHost, (String)PHPServerAdvancedTab.this.userName.getText().trim(), (String)PHPServerAdvancedTab.this.password.getText().trim(), (int)port, (int)port);
                        PHPServerAdvancedTab.this.testButton.setEnabled(true);
                        PHPServerAdvancedTab.this.testResultLabel.setCursor(null);
                        if (connectionStatus.isOK()) {
                            PHPServerAdvancedTab.this.testResultLabel.setForeground(Display.getDefault().getSystemColor(6));
                            PHPServerAdvancedTab.this.testResultLabel.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.36"));
                            break block15;
                        }
                        if (connectionStatus.isMultiStatus()) {
                            PHPServerAdvancedTab.this.testResultLabel.setCursor(Display.getDefault().getSystemCursor(21));
                            PHPServerAdvancedTab.this.testResultLabel.setForeground(Display.getDefault().getSystemColor(8));
                            PHPServerAdvancedTab.this.testResultLabel.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.37"));
                            PHPServerAdvancedTab.this.testResultLabel.setData("info", (Object)connectionStatus.getMessage());
                            IStatus[] children = connectionStatus.getChildren();
                            if (children == null) break block15;
                            IStatus[] iStatusArray = children;
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IStatus child = iStatusArray[n2];
                                if (child.getSeverity() == 1 && child.getCode() == 300) {
                                    PHPServerAdvancedTab.this.password.setText(child.getMessage());
                                    break block15;
                                }
                                ++n2;
                            }
                            break block15;
                        }
                        if (connectionStatus.getSeverity() == 2) {
                            PHPServerAdvancedTab.this.testResultLabel.setCursor(Display.getDefault().getSystemCursor(21));
                            PHPServerAdvancedTab.this.testResultLabel.setForeground(Display.getDefault().getSystemColor(6));
                            PHPServerAdvancedTab.this.testResultLabel.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.39"));
                            PHPServerAdvancedTab.this.testResultLabel.setData("info", (Object)connectionStatus.getMessage());
                        } else if (connectionStatus.getSeverity() == 1) {
                            PHPServerAdvancedTab.this.testResultLabel.setForeground(Display.getDefault().getSystemColor(6));
                            PHPServerAdvancedTab.this.testResultLabel.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.41"));
                            if (connectionStatus.getCode() == 300) {
                                PHPServerAdvancedTab.this.password.setText(connectionStatus.getMessage());
                            }
                        } else if (connectionStatus.getSeverity() == 4) {
                            PHPServerAdvancedTab.this.testResultLabel.setCursor(Display.getDefault().getSystemCursor(21));
                            PHPServerAdvancedTab.this.testResultLabel.setForeground(Display.getDefault().getSystemColor(4));
                            PHPServerAdvancedTab.this.testResultLabel.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.42"));
                            PHPServerAdvancedTab.this.testResultLabel.setData("info", (Object)connectionStatus.getMessage());
                        }
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        PHPServerAdvancedTab.this.testButton.setEnabled(true);
                        PHPServerAdvancedTab.this.testResultLabel.setCursor(null);
                        PHPServerAdvancedTab.this.testResultLabel.setForeground(null);
                        PHPServerAdvancedTab.this.testResultLabel.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.44"));
                    }
                }
                return Status.OK_STATUS;
            }
        };
        connectionTest.setUser(true);
        connectionTest.setPriority(30);
        connectionTest.schedule();
    }

    protected void createExtensionControls(Composite composite) {
    }

    public String getName() {
        return PHPServerUIMessages.getString("PHPServerAdvancedTab.45");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.launchConfiguration = configuration;
        this.initializeDebuggerControl(configuration);
        boolean isXdebugger = this.isXdebug();
        try {
            boolean isUsingTunnel = configuration.getAttribute("org.eclipse.php.debug.core.UseSSHTunnel", false);
            this.debugThroughTunnel.setSelection(isUsingTunnel);
            this.updateTunnelComponents(isUsingTunnel);
            if (isUsingTunnel) {
                this.userName.setText(configuration.getAttribute("org.eclipse.php.debug.core.SSHTunnelUserName", ""));
                if (this.userName.getText().length() > 0) {
                    try {
                        this.password.setText(PHPLaunchUtilities.getSecurePreferences((String)PHPLaunchUtilities.getDebugHost((ILaunchConfiguration)this.launchConfiguration)).get(this.userName.getText(), ""));
                    }
                    catch (StorageException e) {
                        Logger.logException("Error accessing the secured storage", e);
                        this.password.setText("");
                    }
                } else {
                    this.password.setText("");
                }
            }
            this.isOpenInBrowser = isXdebugger || configuration.getAttribute("org.eclipse.php.debug.core.OpenInBrowser", PHPDebugPlugin.getOpenInBrowserOption());
            this.openBrowser.setSelection(this.isOpenInBrowser);
            if (isXdebugger) {
                this.openBrowser.setEnabled(false);
            }
            this.sessionGroup.setVisible(!isXdebugger);
            String debugSetting = configuration.getAttribute("debugPages", "debugAllPages");
            if ("debugAllPages".equals(debugSetting)) {
                this.debugFirstPageBt.setSelection(false);
                this.debugAllPagesBt.setSelection(true);
                this.debugStartFromBt.setSelection(false);
            } else if ("debugFirstPage".equals(debugSetting)) {
                this.debugFirstPageBt.setSelection(true);
                this.debugAllPagesBt.setSelection(false);
                this.debugStartFromBt.setSelection(false);
            } else if ("debugFrom".equals(debugSetting)) {
                this.debugFirstPageBt.setSelection(false);
                this.debugAllPagesBt.setSelection(false);
                this.debugStartFromBt.setSelection(true);
                boolean shouldContinue = configuration.getAttribute("debugFromURL", false);
                this.debugContinueBt.setSelection(shouldContinue);
            }
            String startFromURL = configuration.getAttribute("debugContinue", "");
            this.debugFromTxt.setText(startFromURL);
            this.updateDebugFrom();
            this.enableSessionSettingButtons(isXdebugger || this.isOpenInBrowser && "debug".equals(this.getLaunchConfigurationDialog().getMode()));
            if (this.breakOnFirstLine != null) {
                this.breakOnFirstLine.setSelection(configuration.getAttribute("firstLineBreakpoint", PHPDebugPlugin.getStopAtFirstLine()));
            }
        }
        catch (CoreException coreException) {}
        this.isValid(configuration);
    }

    protected void initializeDebuggerControl(ILaunchConfiguration configuration) {
        try {
            String debuggerID = configuration.getAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, null);
            if (debuggerID != null) {
                this.fDebuggersCombo.setText(PHPDebuggersRegistry.getDebuggerName((String)debuggerID));
            } else {
                this.selectDefaultDebugger(configuration);
            }
            if (configuration.getAttribute(READ_ONLY, false)) {
                this.fDebuggersCombo.setEnabled(false);
            }
        }
        catch (Exception exception) {}
    }

    private void selectDefaultDebugger(ILaunchConfiguration configuration) throws CoreException {
        if (this.fDebuggersCombo != null && this.fDebuggersCombo.getItemCount() > 0) {
            String serverName = this.launchConfiguration.getAttribute("name", null);
            String debuggerId = PHPDebugPlugin.getDebuggerId((String)serverName);
            String debuggerName = PHPDebuggersRegistry.getDebuggerName((String)debuggerId);
            int nameIndex = this.fDebuggersCombo.indexOf(debuggerName);
            if (nameIndex > -1) {
                this.fDebuggersCombo.select(nameIndex);
            } else {
                this.fDebuggersCombo.select(0);
            }
        }
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        super.activated(workingCopy);
        boolean isXDebug = this.isXdebug();
        this.sessionGroup.setVisible(!isXDebug);
        this.openBrowser.setEnabled(!isXDebug);
        if (isXDebug) {
            this.openBrowser.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.54"));
        } else {
            this.openBrowser.setText(PHPServerUIMessages.getString("PHPServerAdvancedTab.55"));
        }
    }

    private boolean isXdebug() {
        return "org.eclipse.php.debug.core.xdebugDebugger".equals(this.getSelectedDebuggerId());
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.launchConfiguration = configuration;
        configuration.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, this.getSelectedDebuggerId());
        configuration.setAttribute("firstLineBreakpoint", this.breakOnFirstLine.getSelection());
        configuration.setAttribute("org.eclipse.php.debug.core.UseSSHTunnel", this.debugThroughTunnel.getSelection());
        if (this.debugThroughTunnel.getSelection()) {
            configuration.setAttribute("org.eclipse.php.debug.core.SSHTunnelUserName", this.userName.getText().trim());
            String passwordDigest = MD5.digest(this.password.getText().trim());
            if (passwordDigest == null) {
                passwordDigest = String.valueOf(this.password.getText().trim().hashCode());
            }
            configuration.setAttribute("org.eclipse.php.debug.core.SSHTunnelPassword", passwordDigest);
            try {
                if (!this.isTextModificationChange) {
                    PHPLaunchUtilities.getSecurePreferences((String)PHPLaunchUtilities.getDebugHost((ILaunchConfiguration)this.launchConfiguration)).put(this.userName.getText(), this.password.getText().trim(), true);
                }
            }
            catch (StorageException e) {
                Logger.logException("Error saving to the secured storage", e);
            }
        } else {
            configuration.setAttribute("org.eclipse.php.debug.core.SSHTunnelUserName", "");
            configuration.setAttribute("org.eclipse.php.debug.core.SSHTunnelPassword", "");
        }
        configuration.setAttribute("org.eclipse.php.debug.core.OpenInBrowser", this.isOpenInBrowser);
        if (this.isOpenInBrowser) {
            if (this.debugAllPagesBt.getSelection()) {
                configuration.setAttribute("debugPages", "debugAllPages");
            } else if (this.debugFirstPageBt.getSelection()) {
                configuration.setAttribute("debugPages", "debugFirstPage");
            } else {
                configuration.setAttribute("debugPages", "debugFrom");
                configuration.setAttribute("debugContinue", this.debugFromTxt.getText());
                configuration.setAttribute("debugFromURL", this.debugContinueBt.getSelection());
            }
        } else {
            configuration.setAttribute("debugPages", "debugFirstPage");
        }
        this.applyExtension(configuration);
        this.isTextModificationChange = false;
        this.updateDebugServerTesters();
    }

    protected void applyExtension(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.launchConfiguration = configuration;
        this.setErrorMessage(null);
        configuration.setAttribute("debugPages", "debugAllPages");
        try {
            this.selectDefaultDebugger((ILaunchConfiguration)configuration);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.launchConfiguration = launchConfig;
        this.setMessage(null);
        this.setErrorMessage(null);
        if (this.debugThroughTunnel.getSelection()) {
            boolean valid = this.userName.getText().trim().length() > 0;
            this.testButton.setEnabled(valid);
            if (!valid) {
                this.setErrorMessage(PHPServerUIMessages.getString("PHPServerAdvancedTab.59"));
                return false;
            }
        }
        if (this.debugStartFromBt.getSelection()) {
            if (this.debugFromTxt.getText().trim().equals("")) {
                this.setErrorMessage(PHPServerUIMessages.getString("PHPServerAdvancedTab.61"));
                return false;
            }
            try {
                new URL(this.debugFromTxt.getText());
            }
            catch (MalformedURLException malformedURLException) {
                this.setErrorMessage(PHPServerUIMessages.getString("PHPServerAdvancedTab.62"));
                return false;
            }
        }
        return this.isValidExtension(launchConfig);
    }

    protected boolean isValidExtension(ILaunchConfiguration launchConfig) {
        return true;
    }

    private String getSelectedDebuggerId() {
        int selectedIndex = this.fDebuggersCombo.getSelectionIndex();
        String debuggerId = "org.eclipse.php.debug.core.zendDebugger";
        if (selectedIndex > -1 && this.fDebuggerIds.size() > selectedIndex) {
            debuggerId = this.fDebuggerIds.toArray()[selectedIndex].toString();
        }
        return debuggerId;
    }

    private void updateDebugServerTesters() {
        int selectedDebuggerIndex = this.fDebuggersCombo.getSelectionIndex();
        String currentDebuggerType = this.fDebuggersCombo.getItem(selectedDebuggerIndex);
        this.debugTesters = this.retrieveAllServerTestExtensions(currentDebuggerType);
        if (this.debugTesters.length == 0) {
            this.validateDebuggerBtn.setEnabled(false);
        } else {
            this.validateDebuggerBtn.setEnabled(true);
        }
    }

    private IDebugServerConnectionTest[] retrieveAllServerTestExtensions(String currentDebuggerType) {
        String debugServerTestExtensionName = "org.eclipse.php.debug.ui.debugServerConnectionTest";
        HashMap<String, IDebugServerConnectionTest> filtersMap = new HashMap<String, IDebugServerConnectionTest>();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(debugServerTestExtensionName);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if ("debugServerTest".equals(element.getName())) {
                String id;
                String debuggerTypeName = elements[i].getAttribute("debuggerTypeName");
                String overridesIds = elements[i].getAttribute("overridesId");
                if (debuggerTypeName.equals(currentDebuggerType) && !filtersMap.containsKey(id = element.getAttribute("id"))) {
                    if (overridesIds != null) {
                        StringTokenizer st = new StringTokenizer(overridesIds, ", ");
                        while (st.hasMoreTokens()) {
                            filtersMap.put(st.nextToken(), null);
                        }
                    }
                    try {
                        filtersMap.put(id, (IDebugServerConnectionTest)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        PHPDebugPlugin.log((Throwable)e);
                    }
                }
            }
            ++i;
        }
        Collection l = filtersMap.values();
        while (l.remove(null)) {
        }
        this.debugTesters = l.toArray(new IDebugServerConnectionTest[l.size()]);
        return this.debugTesters;
    }

    private void updateDebugFrom() {
        if (this.launchConfiguration != null && this.debugFromTxt.getText().trim().equals("")) {
            try {
                this.debugFromTxt.setText(this.launchConfiguration.getAttribute("base_url", ""));
            }
            catch (CoreException coreException) {}
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean debugFromSelected = PHPServerAdvancedTab.this.debugStartFromBt.getSelection();
                    PHPServerAdvancedTab.this.debugFromTxt.setEnabled(debugFromSelected);
                    PHPServerAdvancedTab.this.debugContinueBt.setEnabled(debugFromSelected);
                    PHPServerAdvancedTab.this.resetBt.setEnabled(debugFromSelected);
                }
                catch (SWTException sWTException) {}
            }
        });
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            PHPServerAdvancedTab.this.isTextModificationChange = true;
            PHPServerAdvancedTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            PHPServerAdvancedTab.this.setDirty(true);
            PHPServerAdvancedTab.this.updateLaunchConfigurationDialog();
        }
    }
}

