/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.core;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class DocumentReader
extends Reader {
    private int index;
    private int size;
    private IDocument phpDocument;

    public DocumentReader(IDocument document, int offset, int length) {
        this.index = offset;
        this.size = offset + length;
        this.phpDocument = document;
    }

    @Override
    public int read() throws IOException {
        try {
            if (this.index < this.size) {
                return this.phpDocument.getChar(this.index++);
            }
            return -1;
        }
        catch (BadLocationException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public int read(char[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (char)c;
        int i = 1;
        try {
            while (i < len) {
                c = this.read();
                if (c != -1) {
                    if (b != null) {
                        b[off + i] = (char)c;
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        return i;
    }

    @Override
    public void close() throws IOException {
    }
}

