/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.preferences.AbstractDebuggerConfigurationDialog;
import org.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceMgr;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandler;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.XDebugDebuggerConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class XDebugConfigurationDialog
extends AbstractDebuggerConfigurationDialog {
    private ComboListener comboListener;
    private Text portTextBox;
    private Button showGlobals;
    private Spinner variableDepth;
    private Spinner maxChildren;
    private Spinner maxData;
    private Button useMultiSession;
    private Combo acceptRemoteSession;
    private Combo captureStdout;
    private Combo captureStderr;
    private Button useProxy;
    private Text idekeyTextBox;
    private Text proxyTextBox;
    private XDebugDebuggerConfiguration xdebugDebuggerConfiguration;

    public XDebugConfigurationDialog(XDebugDebuggerConfiguration xdebugDebuggerConfiguration, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.xdebugDebuggerConfiguration = xdebugDebuggerConfiguration;
    }

    private void toggleProxyFields(boolean selection) {
        this.idekeyTextBox.setEnabled(selection);
        this.proxyTextBox.setEnabled(selection);
    }

    protected Control createDialogArea(Composite parent) {
        this.comboListener = new ComboListener();
        parent = (Composite)super.createDialogArea(parent);
        this.setTitle(PHPDebugCoreMessages.XDebugConfigurationDialog_mainTitle);
        Composite[] subsections = this.createSubsections(parent, PHPDebugCoreMessages.XDebugConfigurationDialog_generalGroup, PHPDebugCoreMessages.XDebugConfigurationDialog_captureGroup, PHPDebugCoreMessages.XDebugConfigurationDialog_proxyGroup);
        Composite mainSubSection = subsections[0];
        this.addLabelControl(mainSubSection, PHPDebugCoreMessages.DebuggerConfigurationDialog_debugPort, "org.eclipse.php.debug.core.xdebug_port");
        this.portTextBox = this.addNumTextField(mainSubSection, "org.eclipse.php.debug.core.xdebug_port", 5, 2, false);
        this.showGlobals = this.addCheckBox(mainSubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_showSuperGlobals, "org.eclipse.php.debug.core.xdebug_showSuperGlobals", 0);
        this.addLabelControl(mainSubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_maxArrayDepth, "org.eclipse.php.debug.core.xdebug_arrayDepth");
        this.variableDepth = this.addVariableLevel(mainSubSection, "org.eclipse.php.debug.core.xdebug_arrayDepth", 1, 150, 2);
        this.addLabelControl(mainSubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_maxChildren, "org.eclipse.php.debug.core.xdebug_children");
        this.maxChildren = this.addVariableLevel(mainSubSection, "org.eclipse.php.debug.core.xdebug_children", 1, 500, 2);
        this.addLabelControl(mainSubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_MaxData, "org.eclipse.php.debug.core.xdebug_data");
        this.maxData = this.addVariableLevel(mainSubSection, "org.eclipse.php.debug.core.xdebug_data", 1, Integer.MAX_VALUE, 2);
        this.useMultiSession = this.addCheckBox(mainSubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_useMultisession, "org.eclipse.php.debug.core.xdebug_multisession", 0);
        this.acceptRemoteSession = this.addComboField(mainSubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_remoteSession, XDebugPreferenceMgr.remoteSessionOptions);
        Composite captureSubSection = subsections[1];
        this.captureStdout = this.addComboField(captureSubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_captureStdout, XDebugPreferenceMgr.captureOutputOptions);
        this.captureStderr = this.addComboField(captureSubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_captureStderr, XDebugPreferenceMgr.captureOutputOptions);
        Composite proxySubSection = subsections[2];
        this.useProxy = this.addCheckBox(proxySubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_useProxy, "org.eclipse.php.debug.core.xdebug_useproxy", 0);
        this.useProxy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XDebugConfigurationDialog.this.toggleProxyFields(XDebugConfigurationDialog.this.useProxy.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                XDebugConfigurationDialog.this.toggleProxyFields(XDebugConfigurationDialog.this.useProxy.getSelection());
            }
        });
        this.addLabelControl(proxySubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_idekey, "org.eclipse.php.debug.core.xdebug_idekey");
        this.idekeyTextBox = this.addATextField(proxySubSection, "org.eclipse.php.debug.core.xdebug_idekey", 100, 2);
        this.addLabelControl(proxySubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_proxy, "org.eclipse.php.debug.core.xdebug_proxy");
        this.proxyTextBox = this.addATextField(proxySubSection, "org.eclipse.php.debug.core.xdebug_proxy", 100, 2);
        GridData gridData = (GridData)this.proxyTextBox.getLayoutData();
        gridData.widthHint = this.convertWidthInCharsToPixels(90);
        this.internalInitializeValues();
        return parent;
    }

    private Text addNumTextField(Composite parent, String key, int textLimit, int horizontalIndent, boolean isTimeout) {
        Text text = super.addTextField(parent, key, textLimit, horizontalIndent);
        text.addModifyListener((ModifyListener)new NumFieldValidateListener(isTimeout));
        return text;
    }

    private Text addATextField(Composite parent, String key, int minWidth, int horizontalIndent) {
        Text textBox = new Text(parent, 2052);
        textBox.setData((Object)key);
        GridData data = new GridData(768);
        data.horizontalIndent = horizontalIndent;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.minimumWidth = minWidth;
        textBox.setLayoutData((Object)data);
        return textBox;
    }

    private Combo addComboField(Composite parent, String text, String[] options) {
        this.addLabelControl(parent, text, null);
        Combo comboBox = new Combo(parent, 12);
        GridData data = new GridData(768);
        data.horizontalIndent = 1;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        comboBox.setLayoutData((Object)data);
        comboBox.setItems(options);
        comboBox.addSelectionListener((SelectionListener)this.comboListener);
        return comboBox;
    }

    protected Composite[] createSubsections(Composite parent, String label, String label2, String label3) {
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new GridLayout(1, true));
        GridData data = new GridData(1808);
        parent.setLayoutData((Object)data);
        Group group = new Group(parent, 32);
        group.setText(label);
        data = new GridData(4, 4, true, true);
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        Group group2 = new Group(parent, 32);
        group2.setText(label2);
        data = new GridData(4, 4, true, true);
        group2.setLayoutData((Object)data);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 3;
        group2.setLayout((Layout)layout2);
        Group group3 = new Group(parent, 32);
        group3.setText(label3);
        data = new GridData(4, 4, true, true);
        group3.setLayoutData((Object)data);
        GridLayout layout3 = new GridLayout();
        layout3.numColumns = 2;
        group3.setLayout((Layout)layout3);
        return new Group[]{group, group2, group3};
    }

    protected void okPressed() {
        Preferences prefs = XDebugPreferenceMgr.getPreferences();
        prefs.setValue("org.eclipse.php.debug.core.xdebug_port", this.portTextBox.getText());
        prefs.setValue("org.eclipse.php.debug.core.xdebug_showSuperGlobals", this.showGlobals.getSelection());
        prefs.setValue("org.eclipse.php.debug.core.xdebug_arrayDepth", this.variableDepth.getSelection());
        prefs.setValue("org.eclipse.php.debug.core.xdebug_children", this.maxChildren.getSelection());
        prefs.setValue("org.eclipse.php.debug.core.xdebug_data", this.maxData.getSelection());
        prefs.setValue("org.eclipse.php.debug.core.xdebug_multisession", this.useMultiSession.getSelection());
        prefs.setValue("org.eclipse.php.debug.core.xdebug_remotesession", this.acceptRemoteSession.getSelectionIndex());
        prefs.setValue("org.eclipse.php.debug.core.xdebug_capturestdout", this.captureStdout.getSelectionIndex());
        prefs.setValue("org.eclipse.php.debug.core.xdebug_capturestderr", this.captureStderr.getSelectionIndex());
        prefs.setValue("org.eclipse.php.debug.core.xdebug_useproxy", this.useProxy.getSelection());
        prefs.setValue("org.eclipse.php.debug.core.xdebug_idekey", this.idekeyTextBox.getText());
        prefs.setValue("org.eclipse.php.debug.core.xdebug_proxy", this.proxyTextBox.getText());
        DBGpProxyHandler.instance.configure();
        PHPDebugPlugin.getDefault().savePluginPreferences();
        super.okPressed();
    }

    private void internalInitializeValues() {
        Preferences prefs = XDebugPreferenceMgr.getPreferences();
        int port = prefs.getInt("org.eclipse.php.debug.core.xdebug_port");
        if (port == 0) {
            XDebugPreferenceMgr.setDefaults();
            port = prefs.getInt("org.eclipse.php.debug.core.xdebug_port");
        }
        this.portTextBox.setText(Integer.toString(port));
        this.showGlobals.setSelection(prefs.getBoolean("org.eclipse.php.debug.core.xdebug_showSuperGlobals"));
        this.useMultiSession.setSelection(prefs.getBoolean("org.eclipse.php.debug.core.xdebug_multisession"));
        this.variableDepth.setSelection(prefs.getInt("org.eclipse.php.debug.core.xdebug_arrayDepth"));
        this.maxChildren.setSelection(prefs.getInt("org.eclipse.php.debug.core.xdebug_children"));
        this.maxData.setSelection(prefs.getInt("org.eclipse.php.debug.core.xdebug_data"));
        this.acceptRemoteSession.select(prefs.getInt("org.eclipse.php.debug.core.xdebug_remotesession"));
        this.captureStdout.select(prefs.getInt("org.eclipse.php.debug.core.xdebug_capturestdout"));
        this.captureStderr.select(prefs.getInt("org.eclipse.php.debug.core.xdebug_capturestderr"));
        boolean useProxyState = prefs.getBoolean("org.eclipse.php.debug.core.xdebug_useproxy");
        this.useProxy.setSelection(useProxyState);
        String ideKey = prefs.getString("org.eclipse.php.debug.core.xdebug_idekey");
        if (ideKey == null || ideKey.length() == 0) {
            ideKey = DBGpProxyHandler.instance.generateIDEKey();
        }
        this.idekeyTextBox.setText(ideKey);
        this.proxyTextBox.setText(prefs.getString("org.eclipse.php.debug.core.xdebug_proxy"));
        this.toggleProxyFields(useProxyState);
    }

    private Spinner addVariableLevel(Composite parent, String key, int min, int max, int horizontalIndent) {
        Spinner spin = new Spinner(parent, 512);
        spin.setData((Object)key);
        spin.setMinimum(min);
        spin.setMaximum(max);
        GridData data = new GridData();
        data.horizontalIndent = horizontalIndent;
        data.horizontalSpan = 2;
        spin.setLayoutData((Object)data);
        spin.setIncrement(1);
        spin.setPageIncrement(3);
        return spin;
    }

    static /* synthetic */ Combo access$2(XDebugConfigurationDialog xDebugConfigurationDialog) {
        return xDebugConfigurationDialog.captureStderr;
    }

    class ComboListener
    implements SelectionListener {
        ComboListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == XDebugConfigurationDialog.this.acceptRemoteSession || source != XDebugConfigurationDialog.this.captureStdout) {
                // empty if block
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == XDebugConfigurationDialog.this.acceptRemoteSession || source != XDebugConfigurationDialog.this.captureStdout) {
                // empty if block
            }
        }
    }

    class NumFieldValidateListener
    implements ModifyListener {
        private boolean timeoutField;

        NumFieldValidateListener(boolean isTimeout) {
            this.timeoutField = isTimeout;
        }

        public void modifyText(ModifyEvent e) {
            String errorMessage = null;
            boolean valid = true;
            String value = ((Text)e.widget).getText();
            try {
                Integer iValue = Integer.valueOf(value);
                int i = iValue;
                if (!this.timeoutField) {
                    if (i <= 0 || i > 65535) {
                        valid = false;
                        errorMessage = PHPDebugCoreMessages.XDebugConfigurationDialog_invalidPortRange;
                    }
                    if (valid && iValue != PHPDebugPlugin.getDebugPort("org.eclipse.php.debug.core.xdebugDebugger") && !PHPLaunchUtilities.isPortAvailable(iValue)) {
                        valid = false;
                        errorMessage = PHPDebugCoreMessages.XDebugConfigurationDialog_PortInUse;
                    }
                } else if (i < 10 || i > 100000) {
                    valid = false;
                    errorMessage = PHPDebugCoreMessages.XDebugConfigurationDialog_invalidTimeout;
                }
            }
            catch (NumberFormatException numberFormatException) {
                valid = false;
                errorMessage = !this.timeoutField ? PHPDebugCoreMessages.DebuggerConfigurationDialog_invalidPort : PHPDebugCoreMessages.XDebugConfigurationDialog_invalidTimeoutValue;
            }
            XDebugConfigurationDialog.this.setErrorMessage(errorMessage);
            Button bt = XDebugConfigurationDialog.this.getButton(0);
            if (bt != null) {
                bt.setEnabled(valid);
            }
        }
    }
}

