/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.communication;

import java.net.Socket;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.daemon.AbstractDebuggerCommunicationDaemon;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.zend.communication.DebugConnectionThread;

public class DebuggerCommunicationDaemon
extends AbstractDebuggerCommunicationDaemon
implements ICommunicationDaemon {
    public static final String ZEND_DEBUGGER_ID = "org.eclipse.php.debug.core.zendDebugger";
    private Preferences.IPropertyChangeListener portChangeListener;

    @Override
    public void init() {
        this.initDeamonChangeListener();
        super.init();
    }

    protected void initDeamonChangeListener() {
        if (this.portChangeListener == null) {
            Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
            this.portChangeListener = new PortChangeListener();
            preferences.addPropertyChangeListener(this.portChangeListener);
        }
    }

    @Override
    public int getReceiverPort() {
        return PHPDebugPlugin.getDebugPort(ZEND_DEBUGGER_ID);
    }

    @Override
    protected void startConnectionThread(Socket socket) {
        new DebugConnectionThread(socket);
    }

    @Override
    public String getDebuggerID() {
        return ZEND_DEBUGGER_ID;
    }

    public boolean isDebuggerDaemon() {
        return true;
    }

    private class PortChangeListener
    implements Preferences.IPropertyChangeListener {
        private PortChangeListener() {
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (event.getProperty().equals(PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT)) {
                DebuggerCommunicationDaemon.this.resetSocket();
            }
        }
    }
}

