/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.codeassist;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.codeassist.CodeAssistPdttFile;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.typeinference.FakeConstructor;

public class CodeAssistTests
extends AbstractPDTTTest {
    protected static final char OFFSET_CHAR = '|';
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected static IProject project;
    protected static IFile testFile;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/codeassist/php5/exclusive", "/workspace/codeassist/php5", "/workspace/codeassist/php5/classExclusive"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php5/classExclusive", "/workspace/codeassist/php53/exclusive", "/workspace/codeassist/php53/classExclusive", "/workspace/codeassist/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php5/classExclusive", "/workspace/codeassist/php53", "/workspace/codeassist/php53/classExclusive", "/workspace/codeassist/php54", "/workspace/codeassist/php54/classExclusive"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php54", "/workspace/codeassist/php55"});
    }

    public static void setUpSuite() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("CodeAssistTests");
        if (project.exists()) {
            return;
        }
        project.create(null);
        project.open(null);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        project.setDescription(desc, null);
    }

    public static void tearDownSuite() throws Exception {
        project.close(null);
        project.delete(true, true, null);
        project = null;
    }

    public CodeAssistTests(String description) {
        super(description);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Auto Code Assist Tests");
        for (final PHPVersion phpVersion : TESTS.keySet()) {
            TestSuite phpVerSuite = new TestSuite(phpVersion.getAlias());
            String[] stringArray = TESTS.get(phpVersion);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String testsDirectory = stringArray[n2];
                String[] stringArray2 = CodeAssistTests.getPDTTFiles(testsDirectory);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fileName = stringArray2[n4];
                    try {
                        final CodeAssistPdttFile pdttFile = new CodeAssistPdttFile(fileName);
                        phpVerSuite.addTest((Test)new CodeAssistTests(String.valueOf(phpVersion.getAlias()) + " - /" + fileName){

                            protected void setUp() throws Exception {
                                PHPCoreTests.setProjectPhpVersion(project, phpVersion);
                                pdttFile.applyPreferences();
                            }

                            protected void tearDown() throws Exception {
                                if (testFile != null) {
                                    testFile.delete(true, null);
                                    testFile = null;
                                }
                            }

                            protected void runTest() throws Throwable {
                                CompletionProposal[] proposals = 1.getProposals(pdttFile.getFile());
                                1.compareProposals(proposals, pdttFile);
                            }
                        });
                    }
                    catch (Exception e) {
                        phpVerSuite.addTest((Test)new TestCase(fileName){

                            protected void runTest() throws Throwable {
                                throw e;
                            }
                        });
                    }
                    ++n4;
                }
                ++n2;
            }
            suite.addTest((Test)phpVerSuite);
        }
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                CodeAssistTests.setUpSuite();
            }

            protected void tearDown() throws Exception {
                CodeAssistTests.tearDownSuite();
            }
        };
        return setup;
    }

    protected static int createFile(String data) throws Exception {
        int offset = data.lastIndexOf(124);
        if (offset == -1) {
            throw new IllegalArgumentException("Offset character is not set");
        }
        data = String.valueOf(data.substring(0, offset)) + data.substring(offset + 1);
        testFile = project.getFile("test.php");
        testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        project.refreshLocal(2, null);
        project.build(6, null);
        PHPCoreTests.waitForIndexer();
        return offset;
    }

    protected static ISourceModule getSourceModule() {
        return DLTKCore.createSourceModuleFrom((IFile)testFile);
    }

    public static CompletionProposal[] getProposals(String data) throws Exception {
        int offset = CodeAssistTests.createFile(data);
        return CodeAssistTests.getProposals(offset);
    }

    public static CompletionProposal[] getProposals(int offset) throws ModelException {
        return CodeAssistTests.getProposals(CodeAssistTests.getSourceModule(), offset);
    }

    public static CompletionProposal[] getProposals(ISourceModule sourceModule, int offset) throws ModelException {
        final LinkedList proposals = new LinkedList();
        sourceModule.codeComplete(offset, new CompletionRequestor(){

            public void accept(CompletionProposal proposal) {
                proposals.add(proposal);
            }
        });
        return proposals.toArray(new CompletionProposal[proposals.size()]);
    }

    public static void compareProposals(CompletionProposal[] proposals, CodeAssistPdttFile pdttFile) throws Exception {
        int n;
        CodeAssistPdttFile.ExpectedProposal[] expectedProposals = pdttFile.getExpectedProposals();
        boolean proposalsEqual = true;
        if (proposals.length == expectedProposals.length) {
            CodeAssistPdttFile.ExpectedProposal[] expectedProposalArray = pdttFile.getExpectedProposals();
            n = expectedProposalArray.length;
            int n2 = 0;
            while (n2 < n) {
                CodeAssistPdttFile.ExpectedProposal expectedProposal = expectedProposalArray[n2];
                boolean found = false;
                CompletionProposal[] completionProposalArray = proposals;
                int n3 = proposals.length;
                int n4 = 0;
                while (n4 < n3) {
                    CompletionProposal proposal = completionProposalArray[n4];
                    IModelElement modelElement = proposal.getModelElement();
                    if (modelElement == null) {
                        if (new String(proposal.getName()).equalsIgnoreCase(expectedProposal.name)) {
                            found = true;
                            break;
                        }
                    } else if (modelElement.getElementType() == expectedProposal.type) {
                        if (modelElement instanceof AliasType) {
                            if (((AliasType)modelElement).getAlias().equals(expectedProposal.name)) {
                                found = true;
                                break;
                            }
                        } else if (modelElement instanceof FakeConstructor && modelElement.getParent() instanceof AliasType) {
                            if (((AliasType)modelElement.getParent()).getAlias().equals(expectedProposal.name)) {
                                found = true;
                                break;
                            }
                        } else if (modelElement.getElementName().equalsIgnoreCase(expectedProposal.name)) {
                            found = true;
                            break;
                        }
                    } else if (modelElement.getElementType() == expectedProposal.type && new String(proposal.getName()).equalsIgnoreCase(expectedProposal.name)) {
                        found = true;
                        break;
                    }
                    ++n4;
                }
                if (!found) {
                    proposalsEqual = false;
                    break;
                }
                ++n2;
            }
        } else {
            proposalsEqual = false;
        }
        if (!proposalsEqual) {
            StringBuilder errorBuf = new StringBuilder();
            errorBuf.append("\nEXPECTED COMPLETIONS LIST:\n-----------------------------\n");
            errorBuf.append(pdttFile.getExpected());
            errorBuf.append("\nACTUAL COMPLETIONS LIST:\n-----------------------------\n");
            CompletionProposal[] completionProposalArray = proposals;
            int n5 = proposals.length;
            n = 0;
            while (n < n5) {
                CompletionProposal p = completionProposalArray[n];
                IModelElement modelElement = p.getModelElement();
                if (modelElement == null || modelElement.getElementName() == null) {
                    errorBuf.append("keyword(").append(p.getName()).append(")\n");
                } else {
                    switch (modelElement.getElementType()) {
                        case 8: {
                            errorBuf.append("field");
                            break;
                        }
                        case 9: {
                            errorBuf.append("method");
                            break;
                        }
                        case 7: {
                            errorBuf.append("type");
                        }
                    }
                    if (modelElement instanceof AliasType) {
                        errorBuf.append('(').append(((AliasType)modelElement).getAlias()).append(")\n");
                    } else {
                        errorBuf.append('(').append(modelElement.getElementName()).append(")\n");
                    }
                }
                ++n;
            }
            CodeAssistTests.fail((String)errorBuf.toString());
        }
    }
}

