/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.dom_ast.binding;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.ExpressionStatement;
import org.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.IBinding;
import org.eclipse.php.internal.core.ast.nodes.IFunctionBinding;
import org.eclipse.php.internal.core.ast.nodes.IMethodBinding;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.IVariableBinding;
import org.eclipse.php.internal.core.ast.nodes.Include;
import org.eclipse.php.internal.core.ast.nodes.InfixExpression;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.project.ProjectOptions;

public class BindingTests
extends TestCase {
    protected IProject project;
    private IFile testFile;

    public BindingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        if (this.project == null) {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("BindingTests");
            if (this.project.exists()) {
                return;
            }
            this.project.create(null);
            this.project.open(null);
            IProjectDescription desc = this.project.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
            this.project.setDescription(desc, null);
        }
    }

    private int locateElement(String content, int fromIndex) {
        int indexOf = content.indexOf("/**/", fromIndex);
        return indexOf + 4;
    }

    private int locateElement(String content) {
        return this.locateElement(content, 0);
    }

    protected Program createAndParse(String code) throws Exception {
        this.testFile = this.project.getFile("test.php");
        ByteArrayInputStream source = new ByteArrayInputStream(code.getBytes());
        if (this.testFile.exists()) {
            this.testFile.setContents((InputStream)source, true, false, null);
        } else {
            this.testFile.create((InputStream)source, true, null);
        }
        this.project.refreshLocal(2, null);
        this.project.build(6, null);
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        PHPVersion version = ProjectOptions.getDefaultPhpVersion();
        ISourceModule sourceModule = null;
        sourceModule = DLTKCore.createSourceModuleFrom((IFile)this.testFile);
        ASTParser parser = ASTParser.newParser((Reader)new InputStreamReader(this.testFile.getContents()), (PHPVersion)version, (boolean)false, (ISourceModule)sourceModule);
        return parser.createAST((IProgressMonitor)new NullProgressMonitor());
    }

    protected ITypeBinding getTypeBinding(String content, int fromIndex) throws CoreException, Exception {
        Program program = this.createAndParse(content);
        int indexOf = this.locateElement(content, fromIndex);
        Expression expr = (Expression)program.getElementAt(indexOf);
        ITypeBinding type = expr.resolveTypeBinding();
        return type;
    }

    protected ITypeBinding getTypeBinding(String content) throws CoreException, Exception {
        return this.getTypeBinding(content, 0);
    }

    protected void tearDown() throws Exception {
        this.project.delete(true, null);
    }

    public void testBasicExpression() throws Exception {
        String content = "<? class A { function foo() { $a = 4; $b =  /**/$a; } } ?>";
        ITypeBinding type = this.getTypeBinding(content);
        Assert.assertEquals((String)type.getName(), (String)"number");
    }

    public void testBasicType() throws Exception {
        String content = "<? class A {  } ; class B extends /**/A { } ?>";
        ITypeBinding type = this.getTypeBinding(content);
        Assert.assertEquals((String)type.getName(), (String)"A");
    }

    public void testIsArray() throws Exception {
        String content = "<? interface B {} class A implements B { function foo() { $a = array(1, 2, 3); $b = /**/$a; } } ?>";
        ITypeBinding type = this.getTypeBinding(content);
        Assert.assertTrue((boolean)type.isArray());
    }

    public void testIsClass() throws Exception {
        String content = "<? interface B {} class A implements B { function foo() { $a = new A(); $b = /**/$a; } } ?>";
        ITypeBinding type = this.getTypeBinding(content);
        Assert.assertTrue((boolean)type.isClass());
    }

    public void testIsInterface() throws Exception {
        String content = "<? interface B {} class A implements /**/B { function foo() { $a = new A(); $b = $a; } } ?>";
        ITypeBinding type = this.getTypeBinding(content);
        Assert.assertTrue((boolean)type.isInterface());
    }

    public void testIsNullType() throws Exception {
        String content = "<? interface B {} class A implements B { function foo() { $a = null; $b = /**/$a; } } ?>";
        ITypeBinding type = this.getTypeBinding(content);
        Assert.assertTrue((boolean)type.isNullType());
    }

    public void testIsPrimitive() throws Exception {
        String content = "<? interface B {} class A implements B { function foo() { $a = true; $b = /**/$a; } } ?>";
        ITypeBinding type = this.getTypeBinding(content);
        Assert.assertTrue((boolean)type.isPrimitive());
    }

    public void testIsSubTypeCompatibleTrue() throws Exception {
        String content = "<? interface B {} class A implements /**/B { function foo() { $a = true; $b = $a; } } class C extends A{} /**/$c = new C()?>";
        int indexOf = this.locateElement(content, 0);
        ITypeBinding type = this.getTypeBinding(content);
        ITypeBinding otherType = this.getTypeBinding(content, indexOf + 4);
        Assert.assertTrue((String)"Should be sub-type compatible", (boolean)otherType.isSubTypeCompatible(type));
    }

    public void testIsSubTypeCompatibleFalse() throws Exception {
        String content = "<? interface B {} class A implements /**/B { function foo() { $a = true; $b = $a; } } class C extends A{} /**/$c = new C()?>";
        int indexOf = this.locateElement(content, 0);
        ITypeBinding type = this.getTypeBinding(content);
        ITypeBinding otherType = this.getTypeBinding(content, indexOf + 4);
        Assert.assertFalse((String)"Should NOT be sub-type compatible", (boolean)type.isSubTypeCompatible(otherType));
    }

    public void testBinaryName() throws Exception {
        String content = "<? interface B {} class A implements B { function foo() { $a = new A(); $b = /**/$a; } } ?>";
        ITypeBinding type = this.getTypeBinding(content);
        String binaryName = type.getBinaryName();
        Assert.assertNotNull((String)"Binary name was null", (Object)binaryName);
    }

    public void testGetDeclaredFields() throws Exception {
        String content = "<? interface B {} class A implements B { public $value; private $pValue; function foo() { $a = new A(); $b = /**/$a; } } ?>";
        ITypeBinding type = this.getTypeBinding(content);
        IVariableBinding[] declaredFields = type.getDeclaredFields();
        declaredFields[0].getDeclaringClass();
    }

    public void testGetDeclaredMethods() throws Exception {
        String content = "<? interface B {} class A implements B { public $value; private $pValue; function foo() { $a = new A(); $b = /**/$a; } } ?>";
        ITypeBinding type = this.getTypeBinding(content);
        IMethodBinding[] declaredMethods = type.getDeclaredMethods();
        Assert.assertTrue((String)"The declaring type name is wrong", (boolean)declaredMethods[0].getDeclaringClass().getName().equals("A"));
    }

    public void testOverrides() throws Exception {
        String content = "<? interface B { function foo(); } class A implements /**/B { public $value; private $pValue; function foo() { $a = new A(); $b = /**/$a; } function boo() {} function foo($g) {} } ?>";
        int index = this.locateElement(content);
        ITypeBinding type = this.getTypeBinding(content);
        IMethodBinding[] interfaceBMethods = type.getDeclaredMethods();
        type = this.getTypeBinding(content, index + 4);
        IMethodBinding[] classAMethods = type.getDeclaredMethods();
        Assert.assertTrue((String)"Should override", (boolean)classAMethods[0].overrides(interfaceBMethods[0]));
        Assert.assertFalse((String)"Should NOT override", (boolean)classAMethods[1].overrides(interfaceBMethods[0]));
        Assert.assertTrue((String)"Should override", (boolean)classAMethods[2].overrides(interfaceBMethods[0]));
    }

    public void testConstructorBinding() throws Exception {
        String str = "<?php $a = new MyClass(); class MyClass { public function MyClass() {} } ?>";
        Program program = this.createAndParse(str);
        ExpressionStatement statement = (ExpressionStatement)program.statements().get(0);
        Assignment assignment = (Assignment)statement.getExpression();
        ClassInstanceCreation instanceCreation = (ClassInstanceCreation)assignment.getRightHandSide();
        IMethodBinding constructorBinding = instanceCreation.resolveConstructorBinding();
        Assert.assertNotNull((Object)constructorBinding);
        Assert.assertTrue((boolean)constructorBinding.isConstructor());
        Assert.assertTrue((boolean)constructorBinding.getName().equals("MyClass"));
        Assert.assertTrue((constructorBinding.getKind() == 4 ? 1 : 0) != 0);
    }

    public void testExpressionBinding() throws Exception {
        String str = "<?php $a = 5+5 ?>";
        Program program = this.createAndParse(str);
        ExpressionStatement statement = (ExpressionStatement)program.statements().get(0);
        Assignment assignment = (Assignment)statement.getExpression();
        InfixExpression infixExpression = (InfixExpression)assignment.getRightHandSide();
        ITypeBinding expressionBinding = infixExpression.resolveTypeBinding();
        Assert.assertTrue((expressionBinding.getKind() == 2 ? 1 : 0) != 0);
    }

    public void testFieldAccessBinding() throws Exception {
        String str = "<?php class MyClass { var $anotherOne; }; $a = new MyClass(); $b = $a->anotherOne ?>";
        Program program = this.createAndParse(str);
        ExpressionStatement statement = (ExpressionStatement)program.statements().get(3);
        Assignment assignment = (Assignment)statement.getExpression();
        FieldAccess fieldAccess = (FieldAccess)assignment.getRightHandSide();
        IVariableBinding variableBinding = fieldAccess.resolveFieldBinding();
        Assert.assertTrue((boolean)variableBinding.isField());
        Assert.assertTrue((boolean)variableBinding.getName().equals("$anotherOne"));
        Assert.assertTrue((variableBinding.getKind() == 3 ? 1 : 0) != 0);
    }

    public void testThisFieldAccessBinding() throws Exception {
        String str = "<?php class MyClass { public $myvar = \"test\"; public function mymethod(){ return $this->myvar; }} $a = new MyClass(); $a->mymethod();?>";
        Program program = this.createAndParse(str);
        ExpressionStatement statement = (ExpressionStatement)program.statements().get(2);
        MethodInvocation methodInvocation = (MethodInvocation)statement.getExpression();
        IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
        Assert.assertNotNull((Object)methodBinding);
        Assert.assertTrue((boolean)methodBinding.getName().equals("mymethod"));
        Assert.assertNotNull((Object)methodBinding.getDeclaringClass());
        Assert.assertTrue((boolean)methodBinding.getDeclaringClass().getName().equals("MyClass"));
        Assert.assertTrue((!methodBinding.isConstructor() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)methodBinding.getReturnType()[0].getName().equals("string"));
    }

    public void testStaticFieldAccessBinding() throws Exception {
        String str = "<?php class MyClass { public static $a = 4; } ; /**/MyClass::$a;?>";
        Program program = this.createAndParse(str);
        ExpressionStatement statement = (ExpressionStatement)program.statements().get(2);
        StaticFieldAccess staticFieldAcces = (StaticFieldAccess)statement.getExpression();
        IVariableBinding fieldBinding = staticFieldAcces.resolveFieldBinding();
        Assert.assertTrue((boolean)fieldBinding.isField());
        Assert.assertTrue((boolean)fieldBinding.getName().equals("$a"));
        Assert.assertTrue((fieldBinding.getKind() == 3 ? 1 : 0) != 0);
    }

    public void testStaticConstantAccessBinding() throws Exception {
        String str = "<?php class MyClass { const A = 4; } ; /**/MyClass::A;?>";
        Program program = this.createAndParse(str);
        ExpressionStatement statement = (ExpressionStatement)program.statements().get(2);
        StaticConstantAccess constantAccess = (StaticConstantAccess)statement.getExpression();
        IVariableBinding fieldBinding = constantAccess.resolveFieldBinding();
        Assert.assertNotNull((Object)fieldBinding);
        Assert.assertTrue((boolean)fieldBinding.isField());
    }

    public void testIncludeBinding() throws Exception {
        String str = "<?php include('myFile.php');?>";
        Program program = this.createAndParse(str);
        IFile myFile = this.project.getFile("myFile.php");
        myFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
        try {
            ExpressionStatement statement = (ExpressionStatement)program.statements().get(0);
            Include include = (Include)statement.getExpression();
            IBinding sourceBinding = include.resolveBinding();
            Assert.assertTrue((boolean)sourceBinding.getName().equals("myFile.php"));
            Assert.assertTrue((sourceBinding.getPHPElement().getElementType() == 5 ? 1 : 0) != 0);
            Assert.assertTrue((sourceBinding.getKind() == 8 ? 1 : 0) != 0);
        }
        finally {
            myFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void testFunctionDeclarationBinding() throws Exception {
        String str = "<?php function foo() { return new SoapClient(); } ?> ";
        Program program = this.createAndParse(str);
        FunctionDeclaration functionDeclaration = (FunctionDeclaration)program.statements().get(0);
        IFunctionBinding functionBinding = functionDeclaration.resolveFunctionBinding();
        Assert.assertNotNull((Object)functionBinding);
        Assert.assertTrue((boolean)functionBinding.getName().equals("foo"));
        ITypeBinding[] returnTypes = functionBinding.getReturnType();
        Assert.assertTrue((boolean)returnTypes[0].getName().equals("SoapClient"));
    }

    public void testMethodDeclarationBinding() throws Exception {
        String str = "<?php class MyClass { function foo(){ return new MyClass(); } } ?>";
        Program program = this.createAndParse(str);
        ClassDeclaration classDeclaration = (ClassDeclaration)program.statements().get(0);
        MethodDeclaration methodDeclaration = (MethodDeclaration)classDeclaration.getBody().statements().get(0);
        IMethodBinding methodBinding = methodDeclaration.resolveMethodBinding();
        Assert.assertNotNull((Object)methodBinding);
        Assert.assertTrue((boolean)methodBinding.getName().equals("foo"));
        Assert.assertNotNull((Object)methodBinding.getDeclaringClass());
        Assert.assertTrue((boolean)methodBinding.getDeclaringClass().getName().equals("MyClass"));
        Assert.assertTrue((!methodBinding.isConstructor() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)methodBinding.getReturnType()[0].getName().equals("MyClass"));
    }

    public void testMethodDeclarationGeneratorBinding() throws Exception {
        String str = "<?php class MyClass { function foo(){ yield 1; } } ?>";
        Program program = this.createAndParse(str);
        ClassDeclaration classDeclaration = (ClassDeclaration)program.statements().get(0);
        MethodDeclaration methodDeclaration = (MethodDeclaration)classDeclaration.getBody().statements().get(0);
        IMethodBinding methodBinding = methodDeclaration.resolveMethodBinding();
        Assert.assertNotNull((Object)methodBinding);
        Assert.assertTrue((boolean)methodBinding.getName().equals("foo"));
        Assert.assertNotNull((Object)methodBinding.getDeclaringClass());
        Assert.assertTrue((boolean)methodBinding.getDeclaringClass().getName().equals("MyClass"));
        Assert.assertTrue((!methodBinding.isConstructor() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)methodBinding.getReturnType()[0].getName().equals("Generator"));
    }

    public void testFunctionInvocationBinding() throws Exception {
        String str = "<?php function foo(){} foo(); ?>";
        Program program = this.createAndParse(str);
        ExpressionStatement statement = (ExpressionStatement)program.statements().get(1);
        FunctionInvocation functionInvocation = (FunctionInvocation)statement.getExpression();
        IFunctionBinding functionBinding = functionInvocation.resolveFunctionBinding();
        Assert.assertNotNull((Object)functionBinding);
        Assert.assertTrue((boolean)functionBinding.getName().equals("foo"));
        Assert.assertTrue((!functionBinding.isVarargs() ? 1 : 0) != 0);
    }

    public void testMethodInvocationBinding() throws Exception {
        String str = "<?php class MyClass { function foo(){} } $a = new MyClass(); $a->foo(); ?>";
        Program program = this.createAndParse(str);
        ExpressionStatement statement = (ExpressionStatement)program.statements().get(2);
        MethodInvocation methodInvocation = (MethodInvocation)statement.getExpression();
        IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
        Assert.assertNotNull((Object)methodBinding);
        Assert.assertTrue((boolean)methodBinding.getName().equals("foo"));
        ITypeBinding declaringClass = methodBinding.getDeclaringClass();
        Assert.assertNotNull((Object)declaringClass);
        Assert.assertTrue((boolean)declaringClass.getName().equals("MyClass"));
        Assert.assertTrue((!methodBinding.isConstructor() ? 1 : 0) != 0);
    }

    public void testStaticMethodInvocationBinding() throws Exception {
        String str = "<?php class MyClass { static function foo(){} } MyClass::foo($a); ?>";
        Program program = this.createAndParse(str);
        ExpressionStatement statement = (ExpressionStatement)program.statements().get(1);
        StaticMethodInvocation staticMethodInvocation = (StaticMethodInvocation)statement.getExpression();
        IMethodBinding methodBinding = staticMethodInvocation.resolveMethodBinding();
        Assert.assertNotNull((Object)methodBinding);
        Assert.assertTrue((!methodBinding.isConstructor() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)methodBinding.getName().equals("foo"));
        ITypeBinding declaringClass = methodBinding.getDeclaringClass();
        Assert.assertNotNull((Object)declaringClass);
        Assert.assertTrue((boolean)declaringClass.getName().equals("MyClass"));
        Assert.assertTrue((methodBinding.getKind() == 4 ? 1 : 0) != 0);
    }

    public void testClassDeclarationBinding() throws Exception {
        String str = "<?php class A {} ?>";
        Program program = this.createAndParse(str);
        ClassDeclaration classDeclaration = (ClassDeclaration)program.statements().get(0);
        ITypeBinding binding = classDeclaration.resolveTypeBinding();
        Assert.assertNotNull((Object)binding);
        Assert.assertTrue((boolean)binding.getName().equals("A"));
        Assert.assertTrue((binding.getKind() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)binding.isClass());
    }

    public void testInterfaceDeclarationBinding() throws Exception {
        String str = "<?php interface A {} ?>";
        Program program = this.createAndParse(str);
        InterfaceDeclaration interfaceDeclaration = (InterfaceDeclaration)program.statements().get(0);
        ITypeBinding binding = interfaceDeclaration.resolveTypeBinding();
        Assert.assertNotNull((Object)binding);
        Assert.assertTrue((boolean)binding.getName().equals("A"));
        Assert.assertTrue((binding.getKind() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)binding.isInterface());
    }
}

