/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.dom_ast.rewrite;

import java.util.List;
import junit.framework.Assert;
import junit.framework.TestSuite;
import org.eclipse.php.core.tests.dom_ast.rewrite.ASTRewriteTests;
import org.eclipse.php.core.tests.dom_ast.rewrite.NodeDeletionTestsPHP54;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.LambdaFunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.TraitAliasStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitDeclaration;
import org.eclipse.php.internal.core.ast.nodes.TraitPrecedenceStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitUseStatement;
import org.eclipse.php.internal.core.ast.nodes.Variable;

public class ASTRewriteTestsPHP54
extends ASTRewriteTests {
    public ASTRewriteTestsPHP54(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(new Class[]{ASTRewriteTestsPHP54.class, NodeDeletionTestsPHP54.class}, ASTRewriteTestsPHP54.class.getName());
    }

    @Override
    protected PHPVersion getPHPVersion() {
        return PHPVersion.PHP5_4;
    }

    @Override
    public void testClassConstant() throws Exception {
        String str = "<?php $a = MyClass::MY_CONST; ?>";
        this.initialize(str);
        List<StaticConstantAccess> staticConstants = this.getAllOfType(this.program, StaticConstantAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (staticConstants.size() == 1 ? 1 : 0) != 0);
        ((Identifier)((NamespaceName)staticConstants.get(0).getClassName()).segments().get(0)).setName("Foo");
        staticConstants.get(0).setConstant(this.ast.newIdentifier("BAR_CONST"));
        this.rewrite();
        this.checkResult("<?php $a = Foo::BAR_CONST; ?>");
    }

    @Override
    public void testClassDeclarationReplaceSuper() throws Exception {
        String str = "<?php class MyClass extends Foo { } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((Identifier)((NamespaceName)declarations.get(0).getSuperClass()).segments().get(0)).setName("Bar");
        this.rewrite();
        this.checkResult("<?php class MyClass extends Bar { } ?> ");
    }

    @Override
    public void testClassDeclarationRenameInterface() throws Exception {
        String str = "<?php class MyClass extends AAA implements Foo,Bar{ } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((Identifier)((NamespaceName)declarations.get(0).interfaces().get(1)).segments().get(0)).setName("BooBo");
        this.rewrite();
        this.checkResult("<?php class MyClass extends AAA implements Foo,BooBo{ } ?> ");
    }

    @Override
    public void testInterfaceDeclarationRenameExtend() throws Exception {
        String str = "<?php interface MyInterface extends Foo, Bar{ const MY_CONSTANT = 3; public function myFunction($a); } ?> ";
        this.initialize(str);
        List<InterfaceDeclaration> declarations = this.getAllOfType(this.program, InterfaceDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((Identifier)((NamespaceName)declarations.get(0).interfaces().get(0)).segments().get(0)).setName("Boobo");
        this.rewrite();
        this.checkResult("<?php interface MyInterface extends Boobo, Bar{ const MY_CONSTANT = 3; public function myFunction($a); } ?> ");
    }

    @Override
    public void testEmptyHeredoc() throws Exception {
        String str = "<?php <<<Heredoc\nHeredoc;\n?>";
        this.initialize(str);
        this.checkResult("<?php <<<Heredoc\nHeredoc;\n?>");
    }

    public void testTraitDeclarationSimple() throws Exception {
        String str = "<?php trait MyTrait { } ?> ";
        this.initialize(str);
        List<TraitDeclaration> declarations = this.getAllOfType(this.program, TraitDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setName(this.ast.newIdentifier("Foo"));
        this.rewrite();
        this.checkResult("<?php trait Foo { } ?> ");
    }

    public void testTraitFieldDeclaration() throws Exception {
        String str = "<?php trait A { public $a = 3; final private static $var; }?>";
        this.initialize(str);
        List<FieldsDeclaration> declarations = this.getAllOfType(this.program, FieldsDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 2 ? 1 : 0) != 0);
        declarations.get(0).fields().add(this.ast.newSingleFieldDeclaration(this.ast.newVariable("b"), (Expression)this.ast.newScalar("4")));
        ((SingleFieldDeclaration)declarations.get(0).fields().get(0)).getValue().delete();
        declarations.get(1).setModifier(36);
        this.rewrite();
        this.checkResult("<?php trait A { public $a, $b = 4; protected final $var; }?>");
    }

    public void testTraitFunctionDeclaration() throws Exception {
        String str = "<?php function foo() {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setFunctionName(this.ast.newIdentifier("bar"));
        declarations.get(0).formalParameters().add(this.ast.newFormalParameter(this.ast.newIdentifier("int"), (Expression)this.ast.newVariable("a"), null, false));
        this.rewrite();
        this.checkResult("<?php function bar(int $a) {} ?> ");
    }

    public void testFunctionDeclarationWithCallableParam2() throws Exception {
        String str = "<?php function foo($a, callable $b) {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((FormalParameter)declarations.get(0).formalParameters().get(1)).setParameterType((Expression)this.ast.newIdentifier("string"));
        this.rewrite();
        this.checkResult("<?php function foo($a, string $b) {} ?> ");
    }

    public void testTraitMethodDeclaration() throws Exception {
        String str = "<?php trait A { public function foo(int $a){} }?> ";
        this.initialize(str);
        List<MethodDeclaration> declarations = this.getAllOfType(this.program, MethodDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setModifier(33);
        declarations.get(0).getFunction().setFunctionName(this.ast.newIdentifier("bar"));
        this.rewrite();
        this.checkResult("<?php trait A { protected abstract function bar(int $a){} }?> ");
    }

    public void testArrayInitializer() throws Exception {
        String str = "<?php $f = [new Human('Gonzalo'), 'hello']; ?>";
        this.initialize(str);
        List<ArrayElement> arrayAccess = this.getAllOfType(this.program, ArrayElement.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 2 ? 1 : 0) != 0);
        ((Scalar)arrayAccess.get(1).getValue()).setStringValue("'world'");
        this.rewrite();
        this.checkResult("<?php $f = [new Human('Gonzalo'), 'world']; ?>");
    }

    public void testClassInitializer() throws Exception {
        String str = "<?php (new Human('Gonzalo'))->hello(); ?>";
        this.initialize(str);
        List<FunctionInvocation> arrayAccess = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        Variable name = this.ast.newVariable("world");
        name.setIsDollared(false);
        arrayAccess.get(0).getFunctionName().setName((Expression)name);
        this.rewrite();
        this.checkResult("<?php (new Human('Gonzalo'))->world(); ?>");
    }

    public void testExpresionFunctionInvocation() throws Exception {
        String str = "<?php $human->{'hello'}(); ?>";
        this.initialize(str);
        List<FunctionInvocation> arrayAccess = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        ((Variable)arrayAccess.get(0).getFunctionName().getName()).setName((Expression)this.ast.newScalar("'world'"));
        this.rewrite();
        this.checkResult("<?php $human->{'world'}(); ?>");
    }

    public void testStaticLambdaFunction() throws Exception {
        String str = "<?php $lambda = static function () { }; ?>";
        this.initialize(str);
        List<LambdaFunctionDeclaration> arrayAccess = this.getAllOfType(this.program, LambdaFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
    }

    public void testUseTrait1() throws Exception {
        String str = "<?php class Test { use Hello, World; } ?>";
        this.initialize(str);
        List<TraitUseStatement> arrayAccess = this.getAllOfType(this.program, TraitUseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        ((Identifier)((NamespaceName)arrayAccess.get(0).getTraitList().get(0)).segments().get(0)).setName("Hi");
        this.rewrite();
        this.checkResult("<?php class Test { use Hi, World; } ?>");
    }

    public void testUseTrait2() throws Exception {
        String str = "<?php class Aliased_Talker { use A, B {B::smallTalk insteadof A;\nA::bigTalk insteadof B;\nB::bigTalk as talk;\n}\n } ?>";
        this.initialize(str);
        List<TraitPrecedenceStatement> arrayAccess = this.getAllOfType(this.program, TraitPrecedenceStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 2 ? 1 : 0) != 0);
        ((Identifier)arrayAccess.get(0).getPrecedence().getMethodReference().getClassName().segments().get(0)).setName("B1");
        arrayAccess.get(0).getPrecedence().getMethodReference().setFunctionName(this.ast.newIdentifier("bigTalk"));
        List<TraitAliasStatement> aliasStatement = this.getAllOfType(this.program, TraitAliasStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (aliasStatement.size() == 1 ? 1 : 0) != 0);
        aliasStatement.get(0).getAlias().setFunctionName(this.ast.newIdentifier("talking"));
        this.rewrite();
        this.checkResult("<?php class Aliased_Talker { use A, B {B1::bigTalk insteadof A;\nA::bigTalk insteadof B;\nB::bigTalk as talking;\n}\n } ?>");
    }

    public void testUseTrait3() throws Exception {
        String str = "<?php class Test { use HelloWorld { sayHello as protected; } } ?>";
        this.initialize(str);
        List<TraitAliasStatement> arrayAccess = this.getAllOfType(this.program, TraitAliasStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        arrayAccess.get(0).getAlias().setModifier(64);
        this.rewrite();
        this.checkResult("<?php class Test { use HelloWorld { sayHello as public; } } ?>");
    }

    public void testUseTrait4() throws Exception {
        String str = "<?php class Test { use HelloWorld { sayHello as private myPrivateHello; } } ?>";
        this.initialize(str);
        List<TraitAliasStatement> arrayAccess = this.getAllOfType(this.program, TraitAliasStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        arrayAccess.get(0).getAlias().setModifier(64);
        arrayAccess.get(0).getAlias().setFunctionName(this.ast.newIdentifier("myPublicHello"));
        this.rewrite();
        this.checkResult("<?php class Test { use HelloWorld { sayHello as public myPublicHello; } } ?>");
    }
}

