/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.phar;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.internal.core.phar.IStub;
import org.eclipse.php.internal.core.phar.PharEntry;
import org.eclipse.php.internal.core.phar.PharFile;
import org.eclipse.php.internal.core.phar.PharFileExporter;
import org.eclipse.php.internal.core.phar.PharPackage;
import org.eclipse.php.internal.core.phar.Stub;
import org.osgi.framework.Bundle;

public class PharFileTest
extends AbstractPDTTTest {
    private static final String PHAR_PHARS_FOLDER = "/workspace/phar";
    protected static final String[] TESTS = new String[]{"/workspace/phar"};

    public PharFileTest(String description) {
        super(description);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("PHAR Tests");
        String[] stringArray = TESTS;
        int n = TESTS.length;
        int n2 = 0;
        while (n2 < n) {
            String testsDirectory = stringArray[n2];
            File folder = PharFileTest.getResourceFolder(testsDirectory).toFile();
            try {
                File[] fileArray = folder.listFiles();
                int n3 = fileArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    File pharFolder = fileArray[n4];
                    if (!pharFolder.getName().equalsIgnoreCase("CVS") && pharFolder.isDirectory()) {
                        IPath stubLocation = new Path(pharFolder.getAbsolutePath()).append(".phar/stub.php");
                        PharPackage pharPackage = new PharPackage();
                        if (stubLocation.toFile().exists()) {
                            pharPackage.setStubGenerated(false);
                            pharPackage.setStubLocation(stubLocation);
                        }
                        pharPackage.setExportType(0);
                        pharPackage.setCompressType(0);
                        pharPackage.setSignature("SHA1");
                        suite.addTest((Test)new PharTest(pharFolder.getName(), pharFolder.getAbsolutePath(), pharPackage));
                        pharPackage.setCompressType(2);
                        pharPackage.setSignature("SHA1");
                        suite.addTest((Test)new PharTest(pharFolder.getName(), pharFolder.getAbsolutePath(), pharPackage));
                        pharPackage.setCompressType(1);
                        pharPackage.setSignature("MD5");
                        suite.addTest((Test)new PharTest(pharFolder.getName(), pharFolder.getAbsolutePath(), pharPackage));
                    }
                    ++n4;
                }
            }
            catch (Exception e) {
                suite.addTest((Test)new TestCase(folder.getAbsolutePath()){

                    protected void runTest() throws Throwable {
                        throw e;
                    }
                });
            }
            ++n2;
        }
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                PharFileTest.setUpSuite();
            }

            protected void tearDown() throws Exception {
                PharFileTest.tearDownSuite();
            }
        };
        return setup;
    }

    public static void setUpSuite() throws Exception {
    }

    public static void tearDownSuite() throws Exception {
    }

    private static IPath getResourceFolder(String fileName) {
        IPath path = null;
        try {
            path = new Path(FileLocator.getBundleFile((Bundle)PHPCoreTests.getDefault().getBundle()).getAbsolutePath()).append(fileName);
        }
        catch (IOException e) {
            PharFileTest.fail((String)e.getLocalizedMessage());
        }
        return path;
    }

    public void compareContent(String pharFileFolder, PharFile pharFile) throws Exception {
        Map pharEntryMap = pharFile.getPharEntryMap();
        for (Map.Entry entry : pharEntryMap.entrySet()) {
            String filename = (String)entry.getKey();
            if (".phar/signature.php".endsWith(filename) || ".phar/stub.php".endsWith(filename)) continue;
            File file = new File(pharFileFolder, filename);
            Assert.assertTrue((boolean)PharFileTest.inputStreamEquals(new BufferedInputStream(new FileInputStream(file)), pharFile.getInputStream((PharEntry)entry.getValue())));
        }
    }

    public static boolean inputStreamEquals(InputStream is1, InputStream is2) throws IOException {
        byte[] buffer1 = new byte[512];
        byte[] buffer2 = new byte[512];
        try {
            int n2;
            int n1;
            while ((n1 = is1.read(buffer1, 0, buffer1.length)) != -1) {
                n2 = is2.read(buffer2, 0, buffer2.length);
                if (n1 != n2) {
                    return false;
                }
                if (PharFileTest.byteArrayEquals(buffer1, buffer2, n1)) continue;
                return false;
            }
            n2 = is2.read(buffer2, 0, buffer2.length);
            if (n1 != n2) {
                return false;
            }
        }
        finally {
            is1.close();
            is2.close();
        }
        return true;
    }

    public static boolean byteArrayEquals(byte[] b1, byte[] b2, int n) {
        if (b1 != null && b2 != null && b1.length == b2.length) {
            int i = 0;
            while (i < n) {
                if (b1[i] != b2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        byte[] buffer = new byte[512];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        baos.reset();
        try {
            int n;
            while ((n = is.read(buffer, 0, buffer.length)) != -1) {
                baos.write(buffer, 0, n);
            }
        }
        finally {
            is.close();
        }
        return baos.toByteArray();
    }

    private static final class PharTest
    extends PharFileTest {
        private final String pharFileFolder;
        private final IPath path;
        private PharPackage pharPackage;

        private PharTest(String description, String resourceFolder, PharPackage pharPackage) {
            super(description);
            this.pharFileFolder = resourceFolder;
            this.path = new Path(this.pharFileFolder);
            this.pharPackage = pharPackage;
        }

        protected void setUp() throws Exception {
        }

        protected void tearDown() throws Exception {
        }

        protected void runTest() throws Throwable {
            File tempPhar = this.exportTempPhar(this.pharFileFolder);
            this.compareContent(this.pharFileFolder, new PharFile(tempPhar));
            tempPhar.delete();
        }

        private File exportTempPhar(String pharFileFolder) throws IOException, CoreException {
            File result = File.createTempFile("temp", ".phar");
            this.pharPackage.setPharLocation((IPath)new Path(result.getAbsolutePath()));
            PharFileExporter exporter = new PharFileExporter(this.pharPackage);
            Stub stub = new Stub(this.pharPackage);
            exporter.writeStub((IStub)stub);
            File file = new File(pharFileFolder);
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.export(exporter, children[i]);
                ++i;
            }
            exporter.writeSignature();
            exporter.finished();
            return result;
        }

        private void export(PharFileExporter exporter, File file) throws IOException, CoreException {
            if (file.isFile()) {
                this.exportFile(exporter, file);
            } else {
                this.exportFolder(exporter, file);
            }
        }

        private void exportFolder(PharFileExporter exporter, File file) throws IOException, CoreException {
            if (file.getName().equalsIgnoreCase("CVS")) {
                return;
            }
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.export(exporter, children[i]);
                ++i;
            }
        }

        private void exportFile(PharFileExporter exporter, File file) throws IOException, CoreException {
            String destinationPath = this.getDestinationPath(file);
            if (destinationPath.equals(".phar/stub.php") || destinationPath.equals(".phar/signature.php")) {
                return;
            }
            exporter.write(file, destinationPath);
        }

        private String getDestinationPath(File file) {
            Path filePath = new Path(file.getAbsolutePath());
            filePath = filePath.removeFirstSegments(this.path.segmentCount());
            filePath = filePath.setDevice(null);
            return filePath.toString();
        }
    }
}

