/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.searchEngine;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.index2.search.ISearchRequestor;
import org.eclipse.dltk.core.index2.search.ModelAccess;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.internal.core.PHPVersion;

public class SearchFieldTests
extends AbstractPDTTTest {
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected static IProject project;
    protected static IFile testFile;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/searchEngine/php5"});
    }

    public static void setUpSuite() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("AutoSelectionEngine");
        if (project.exists()) {
            return;
        }
        project.create(null);
        project.open(null);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        project.setDescription(desc, null);
    }

    public static void tearDownSuite() throws Exception {
        project.close(null);
        project.delete(true, true, null);
        project = null;
    }

    public SearchFieldTests(String description) {
        super(description);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Search Field Tests");
        for (final PHPVersion phpVersion : TESTS.keySet()) {
            TestSuite phpVerSuite = new TestSuite(phpVersion.getAlias());
            String[] stringArray = TESTS.get(phpVersion);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String testsDirectory = stringArray[n2];
                String[] stringArray2 = SearchFieldTests.getPDTTFiles(testsDirectory);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fileName = stringArray2[n4];
                    try {
                        final PdttFile pdttFile = new PdttFile(fileName);
                        phpVerSuite.addTest((Test)new SearchFieldTests(String.valueOf(phpVersion.getAlias()) + " - /" + fileName){

                            protected void setUp() throws Exception {
                                PHPCoreTests.setProjectPhpVersion(project, phpVersion);
                            }

                            protected void tearDown() throws Exception {
                                if (testFile != null) {
                                    testFile.delete(true, null);
                                    testFile = null;
                                }
                            }

                            protected void runTest() throws Throwable {
                                List<String> paths = 1.getSelection(pdttFile.getFile());
                                int occurrences = Integer.parseInt(pdttFile.getExpected().trim());
                                boolean proposalsEqual = true;
                                if (paths.size() != occurrences) {
                                    proposalsEqual = false;
                                }
                                if (!proposalsEqual) {
                                    StringBuilder errorBuf = new StringBuilder();
                                    errorBuf.append("\nEXPECTED OCCURRENCE TIMES:\n-----------------------------\n");
                                    errorBuf.append(pdttFile.getExpected());
                                    errorBuf.append("\nACTUAL OCCURRENCE TIMES:\n-----------------------------\n");
                                    errorBuf.append(paths.size());
                                    1.fail((String)errorBuf.toString());
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        phpVerSuite.addTest((Test)new TestCase(fileName){

                            protected void runTest() throws Throwable {
                                throw e;
                            }
                        });
                    }
                    ++n4;
                }
                ++n2;
            }
            suite.addTest((Test)phpVerSuite);
        }
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                SearchFieldTests.setUpSuite();
            }

            protected void tearDown() throws Exception {
                SearchFieldTests.tearDownSuite();
            }
        };
        return setup;
    }

    protected static void createFile(String data) throws Exception {
        testFile = project.getFile("test.php");
        testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        project.refreshLocal(2, null);
        project.build(6, null);
        PHPCoreTests.waitForIndexer();
    }

    protected static ISourceModule getSourceModule() {
        return DLTKCore.createSourceModuleFrom((IFile)testFile);
    }

    protected static int getSearchFlags(boolean includeInterp) {
        int flags = 3;
        if (includeInterp) {
            flags |= 4;
        }
        return flags;
    }

    protected static List<String> getSelection(String data) throws Exception {
        SearchFieldTests.createFile(data);
        ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)testFile);
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule, (int)SearchFieldTests.getSearchFlags(false));
        ISearchEngine searchEngine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)scope.getLanguageToolkit());
        final ArrayList<String> paths = new ArrayList<String>();
        if (searchEngine != null) {
            ISearchRequestor requestor = new ISearchRequestor(){

                public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                    paths.add(sourceModule.getPath().toString());
                }
            };
            searchEngine.search(8, null, "$testField", 0, 0, 0, ISearchEngine.SearchFor.ALL_OCCURENCES, ISearchEngine.MatchRule.EXACT, scope, requestor, (IProgressMonitor)new NullProgressMonitor());
        }
        return paths;
    }
}

