/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.locator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.internal.core.ast.locator.AbstraceConciliatorTest;
import org.eclipse.php.internal.core.ast.locator.PhpElementConciliator;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.TypeDeclaration;

public class PhpElementConciliatorTest
extends AbstraceConciliatorTest {
    private IProject project1;

    protected void setUp() throws Exception {
        System.setProperty("disableStartupRunner", "true");
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        this.project1 = this.createProject("project1");
    }

    private IFile setFileContent(String content) throws CoreException {
        IFile file = this.project1.getFile("test1.php");
        ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes());
        if (!file.exists()) {
            file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        return file;
    }

    public void testConcileClassName() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php class TestRenameClass{}?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 13;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)4, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 7;
        selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)4, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileClassName1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php class TestRenameClass{} class TestExtendedClass extends TestRenameClass{}?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 63;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)4, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileClassName2() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php class A{function foo(){}} class B{function bar(){}} $a = new A();$a->foo(); A::foo(); $b = new B();$b->bar();B::bar();?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 68;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)4, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 83;
        selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)4, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileInterface() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php interface iTemplate{public function setVariable($name, $var);}?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 6;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)4, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 17;
        selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)4, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileInterface1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php interface iTemplate{public function setVariable($name, $var);} class Template implements iTemplate{  public function setVariable($name, $var){}}?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 6;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)4, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 96;
        selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)4, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileProgram() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php class TestRenameClass{}?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        PhpElementConciliatorTest.assertEquals((int)7, (int)PhpElementConciliator.concile((ASTNode)program));
    }

    public void testConcileGlobalVar() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php $a = 1;  function test(){  global $a; echo $a;} ?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 7;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)1, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 41;
        selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)1, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 50;
        selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)1, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileGlobalVar1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php $a = 1;  function test(){ echo $GLOBALS['a'];} ?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 48;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)1, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileGlobalVar2() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php $a = 1;  function test(){  global $a; echo $a;} ?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 41;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        selectedNode = selectedNode.getParent();
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)1, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileFunc() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php $a = 1;  function test(){ echo $GLOBALS['a'];} ?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 16;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)2, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 25;
        selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)2, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileFunc1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php function a($n){return ($n * $n);}echo a(5);?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 45;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)2, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileMethod1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {public static function bar(){return 'bar in a class called';}}$strFN2 = foo::bar;echo bar();?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 91;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)6, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileMethod2() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {public function bar(){return 'bar in a class called';}}$strFN2 = new foo(); $strFN2->bar()?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 99;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)6, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileMethod3() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {public function bar(){return 'bar in a class called';} public function f(){$this->bar();}}?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 96;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)6, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileMethod4() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {public function bar(){return 'bar in a class called';} public function f(){$this->bar();}}?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 30;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)6, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileField1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {var $f; public function f(){$this->$f;}}?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 14;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)6, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 45;
        selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)6, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileField2() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {var $f; public function f(){$this->$f;}} $cls= new foo(); $cls->f;?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 78;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)6, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileField3() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {var $f; public function f(){$this->$f;}} $cls= new foo(); $cls->f;?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 18;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        selectedNode = selectedNode.getParent();
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)6, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileStaticField1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {public static $my_static = 'foo';} echo Foo::$my_static; echo $foo->my_static?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 28;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)6, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 59;
        selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)6, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 82;
        selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)6, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testLocalVar() {
        IFile file = null;
        try {
            file = this.setFileContent("<? $x = 4; function assignx () {$x = 0; echo $x;} ?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 46;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)3, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 33;
        selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)3, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testLocalVar1() {
        IFile file = null;
        try {
            file = this.setFileContent("<? $x = 4; function assignx () {$x = 0; echo $x;} ?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 33;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        selectedNode = selectedNode.getParent();
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)3, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileConstant() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php define(\"CONSTANT\", \"Hello world.\"); echo CONSTANT; echo Constant; ?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 6;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)5, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 15;
        selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)5, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 48;
        selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)5, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 63;
        selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)5, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileConstant1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php define (\"TEST\", 1234);");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 6;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertEquals((int)5, (int)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    public void testConcileConstantExists() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php define (\"TEST\", 1234);");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        PhpElementConciliatorTest.assertTrue((boolean)PhpElementConciliator.constantAlreadyExists((Program)program, (String)"TEST"));
    }

    public void testConcileClsMemberExists() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {public static function bar(){return 'bar in a class called';}}$strFN2 = foo::bar;echo bar();?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 8;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        selectedNode = selectedNode.getParent();
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliatorTest.assertTrue((boolean)(selectedNode instanceof TypeDeclaration));
        PhpElementConciliatorTest.assertTrue((boolean)PhpElementConciliator.classMemeberAlreadyExists((TypeDeclaration)((TypeDeclaration)selectedNode), (String)"bar", (int)29));
    }

    public void testConcileClassNameExists() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php class TestRenameClass{}?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        PhpElementConciliator.classNameAlreadyExists((Program)program, (String)"TestRenameClass");
    }

    public void testLocalVarExists() {
        IFile file = null;
        try {
            file = this.setFileContent("<? $x = 4; function assignx () {$x = 0; echo $x;} ?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        int start = 21;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        selectedNode = selectedNode.getParent();
        PhpElementConciliatorTest.assertNotNull((Object)selectedNode);
        PhpElementConciliator.localVariableAlreadyExists((FunctionDeclaration)((FunctionDeclaration)selectedNode), (String)"x");
    }

    public void testFunExists1() {
        IFile file = null;
        try {
            file = this.setFileContent("<? $x = 4; function assignx () {$x = 0; echo $x;} ?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        PhpElementConciliator.functionAlreadyExists((Program)program, (String)"assignx");
    }

    public void testConcileGlobalExists() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php $a = 1;  function test(){ echo $GLOBALS['a'];} ?>");
        }
        catch (CoreException e) {
            PhpElementConciliatorTest.fail((String)e.getMessage());
        }
        PhpElementConciliatorTest.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        PhpElementConciliatorTest.assertNotNull((Object)program);
        PhpElementConciliatorTest.assertTrue((boolean)PhpElementConciliator.globalVariableAlreadyExists((Program)program, (String)"a"));
    }
}

