/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.compare;

import com.ibm.icu.text.MessageFormat;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.IEditableContentExtension;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.INavigatable;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.compare.contentmergeviewer.IDocumentRange;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.contentmergeviewer.TokenComparator;
import org.eclipse.compare.internal.BufferedCanvas;
import org.eclipse.compare.internal.ChangePropertyAction;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.DocumentManager;
import org.eclipse.compare.internal.ICompareUIConstants;
import org.eclipse.compare.internal.IMergeViewerTestAdapter;
import org.eclipse.compare.internal.MergeViewerContentProvider;
import org.eclipse.compare.internal.NavigationEndDialog;
import org.eclipse.compare.internal.OutlineViewerCreator;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.merge.DocumentMerger;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.documentModel.parser.PhpSourceParser;
import org.eclipse.php.internal.ui.compare.ContentMergeViewer;
import org.eclipse.php.internal.ui.compare.MergeSourceViewer;
import org.eclipse.php.internal.ui.compare.ShowWhitespaceAction;
import org.eclipse.php.internal.ui.compare.TextEditorPropertyAction;
import org.eclipse.php.internal.ui.editor.configuration.PHPStructuredTextViewerConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.wst.sse.core.internal.document.StructuredDocumentFactory;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.JobSafeStructuredDocument;

public class TextMergeViewer
extends ContentMergeViewer
implements IAdaptable {
    private static final String COPY_LEFT_TO_RIGHT_INDICATOR = ">";
    private static final String COPY_RIGHT_TO_LEFT_INDICATOR = "<";
    private static final char ANCESTOR_CONTRIBUTOR = 'A';
    private static final char RIGHT_CONTRIBUTOR = 'R';
    private static final char LEFT_CONTRIBUTOR = 'L';
    private static final String DIFF_RANGE_CATEGORY = "org.eclipse.compare.DIFF_RANGE_CATEGORY";
    static final boolean DEBUG = false;
    private static final boolean FIX_47640 = true;
    private static final String[] GLOBAL_ACTIONS = new String[]{ActionFactory.UNDO.getId(), ActionFactory.REDO.getId(), ActionFactory.CUT.getId(), ActionFactory.COPY.getId(), ActionFactory.PASTE.getId(), ActionFactory.DELETE.getId(), ActionFactory.SELECT_ALL.getId(), ActionFactory.SAVE.getId(), ActionFactory.FIND.getId()};
    private static final String[] TEXT_ACTIONS = new String[]{"undo", "redo", "cut", "copy", "paste", "delete", "selectAll", "save", "find"};
    private static final String BUNDLE_NAME = "org.eclipse.compare.contentmergeviewer.TextMergeViewerResources";
    private static final String INCOMING_COLOR = "INCOMING_COLOR";
    private static final String OUTGOING_COLOR = "OUTGOING_COLOR";
    private static final String CONFLICTING_COLOR = "CONFLICTING_COLOR";
    private static final String RESOLVED_COLOR = "RESOLVED_COLOR";
    private static final int MARGIN_WIDTH = 6;
    private static final int CENTER_WIDTH = 34;
    private static final int BIRDS_EYE_VIEW_WIDTH = 12;
    private static final int BIRDS_EYE_VIEW_INSET = 2;
    private static final int RESOLVE_SIZE = 5;
    private static final int LW = 1;
    private boolean fLeftIsLocal;
    private boolean fShowCurrentOnly = false;
    private boolean fShowCurrentOnly2 = false;
    private int fMarginWidth = 6;
    private int fTopInset;
    private RGB fBackground;
    private RGB fForeground;
    private boolean fPollSystemForeground = true;
    private boolean fPollSystemBackground = true;
    private RGB SELECTED_INCOMING;
    private RGB INCOMING;
    private RGB INCOMING_FILL;
    private RGB INCOMING_TEXT_FILL;
    private RGB SELECTED_CONFLICT;
    private RGB CONFLICT;
    private RGB CONFLICT_FILL;
    private RGB CONFLICT_TEXT_FILL;
    private RGB SELECTED_OUTGOING;
    private RGB OUTGOING;
    private RGB OUTGOING_FILL;
    private RGB OUTGOING_TEXT_FILL;
    private RGB RESOLVED;
    private IPreferenceStore fPreferenceStore;
    private IPropertyChangeListener fPreferenceChangeListener;
    private HashMap fNewAncestorRanges = new HashMap();
    private HashMap fNewLeftRanges = new HashMap();
    private HashMap fNewRightRanges = new HashMap();
    private MergeSourceViewer fAncestor;
    private MergeSourceViewer fLeft;
    private MergeSourceViewer fRight;
    private int fLeftLineCount;
    private int fRightLineCount;
    private boolean fInScrolling;
    private int[] fPts = new int[8];
    private int fInheritedDirection;
    private int fTextDirection;
    private ActionContributionItem fIgnoreAncestorItem;
    private boolean fHighlightRanges;
    private boolean fShowPseudoConflicts = false;
    private boolean fUseSplines = true;
    private boolean fUseSingleLine = true;
    private boolean fUseResolveUI = true;
    private boolean fHighlightTokenChanges = false;
    private String fSymbolicFontName;
    private ActionContributionItem fNextDiff;
    private ActionContributionItem fPreviousDiff;
    private ActionContributionItem fCopyDiffLeftToRightItem;
    private ActionContributionItem fCopyDiffRightToLeftItem;
    private CompareHandlerService fHandlerService;
    private boolean fSynchronizedScrolling = true;
    private MergeSourceViewer fFocusPart;
    private boolean fSubDoc = true;
    private IPositionUpdater fPositionUpdater;
    private boolean fIsMotif;
    private boolean fIsCarbon;
    private boolean fHasErrors;
    private BufferedCanvas fAncestorCanvas;
    private BufferedCanvas fLeftCanvas;
    private BufferedCanvas fRightCanvas;
    private Canvas fScrollCanvas;
    private ScrollBar fVScrollBar;
    private Canvas fBirdsEyeCanvas;
    private Canvas fSummaryHeader;
    private HeaderPainter fHeaderPainter;
    private Map fColors;
    private Cursor fBirdsEyeCursor;
    private double[] fBasicCenterCurve;
    private Button fCenterButton;
    private DocumentMerger.Diff fButtonDiff;
    private ContributorInfo fLeftContributor;
    private ContributorInfo fRightContributor;
    private ContributorInfo fAncestorContributor;
    private boolean isRefreshing;
    private int fSynchronziedScrollPosition;
    private ActionContributionItem fNextChange;
    private ActionContributionItem fPreviousChange;
    private ShowWhitespaceAction showWhitespaceAction;
    private InternalOutlineViewerCreator fOutlineViewerCreator;
    private TextEditorPropertyAction toggleLineNumbersAction;
    private IFindReplaceTarget fFindReplaceTarget;
    private ChangePropertyAction fIgnoreWhitespace;
    private DocumentMerger fMerger = new DocumentMerger(new DocumentMerger.IDocumentMergerInput(){

        public ITokenComparator createTokenComparator(String line) {
            return TextMergeViewer.this.createTokenComparator(line);
        }

        public CompareConfiguration getCompareConfiguration() {
            return TextMergeViewer.this.getCompareConfiguration();
        }

        public IDocument getDocument(char contributor) {
            switch (contributor) {
                case 'L': {
                    return TextMergeViewer.this.fLeft.getDocument();
                }
                case 'R': {
                    return TextMergeViewer.this.fRight.getDocument();
                }
                case 'A': {
                    return TextMergeViewer.this.fAncestor.getDocument();
                }
            }
            return null;
        }

        public int getHunkStart() {
            return TextMergeViewer.this.getHunkStart();
        }

        public Position getRegion(char contributor) {
            switch (contributor) {
                case 'L': {
                    return TextMergeViewer.this.fLeft.getRegion();
                }
                case 'R': {
                    return TextMergeViewer.this.fRight.getRegion();
                }
                case 'A': {
                    return TextMergeViewer.this.fAncestor.getRegion();
                }
            }
            return null;
        }

        public boolean isHunkOnLeft() {
            ITypedElement left = ((ICompareInput)TextMergeViewer.this.getInput()).getRight();
            return left != null && Utilities.getAdapter((Object)left, IHunk.class) != null;
        }

        public boolean isIgnoreAncestor() {
            return TextMergeViewer.this.isIgnoreAncestor();
        }

        public boolean isPatchHunk() {
            return TextMergeViewer.this.isPatchHunk();
        }

        public boolean isShowPseudoConflicts() {
            return TextMergeViewer.this.fShowPseudoConflicts;
        }

        public boolean isThreeWay() {
            return TextMergeViewer.this.isThreeWay();
        }

        public boolean isPatchHunkOk() {
            return TextMergeViewer.this.isPatchHunkOk();
        }
    });
    private DocumentMerger.Diff fCurrentDiff;

    public TextMergeViewer(Composite parent, CompareConfiguration configuration) {
        this(parent, 0, configuration);
    }

    public TextMergeViewer(Composite parent, int style, CompareConfiguration configuration) {
        super(style, ResourceBundle.getBundle(BUNDLE_NAME), configuration);
        int inheritedStyle = parent.getStyle();
        this.fInheritedDirection = (inheritedStyle & 0x2000000) != 0 ? 0x2000000 : ((inheritedStyle & 0x4000000) != 0 ? 0x4000000 : 0);
        this.fTextDirection = (style & 0x2000000) != 0 ? 0x2000000 : ((style & 0x4000000) != 0 ? 0x4000000 : 0);
        this.fSymbolicFontName = ((Object)((Object)this)).getClass().getName();
        String platform = SWT.getPlatform();
        this.fIsMotif = "motif".equals(platform);
        this.fIsCarbon = "carbon".equals(platform);
        if (this.fIsMotif) {
            this.fMarginWidth = 0;
        }
        Display display = parent.getDisplay();
        this.fPreferenceChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                TextMergeViewer.this.handlePropertyChangeEvent(event);
            }
        };
        this.fPreferenceStore = this.createChainedPreferenceStore();
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener(this.fPreferenceChangeListener);
            this.checkForColorUpdate(display);
            this.fLeftIsLocal = Utilities.getBoolean((CompareConfiguration)this.getCompareConfiguration(), (String)"LEFT_IS_LOCAL", (boolean)false);
            this.fSynchronizedScrolling = this.fPreferenceStore.getBoolean("org.eclipse.compare.SynchronizeScrolling");
            this.fShowPseudoConflicts = this.fPreferenceStore.getBoolean("org.eclipse.compare.ShowPseudoConflicts");
            this.fUseSingleLine = this.fPreferenceStore.getBoolean("org.eclipse.compare.UseSingleLine");
            this.fHighlightTokenChanges = this.fPreferenceStore.getBoolean("org.eclipse.compare.HighlightTokenChanges");
        }
        this.buildControl(parent);
        INavigatable nav = new INavigatable(){

            public boolean selectChange(int flag) {
                if (flag == 3 || flag == 4) {
                    TextMergeViewer.this.selectFirstDiff(flag == 3);
                    return false;
                }
                return TextMergeViewer.this.navigate(flag == 1, false, false);
            }

            public Object getInput() {
                return TextMergeViewer.this.getInput();
            }

            public boolean openSelectedChange() {
                return false;
            }

            public boolean hasChange(int flag) {
                return TextMergeViewer.this.getNextVisibleDiff(flag == 1, false) != null;
            }
        };
        this.fComposite.setData("org.eclipse.compare.internal.Navigator", (Object)nav);
        this.fBirdsEyeCursor = new Cursor((Device)parent.getDisplay(), 21);
        JFaceResources.getFontRegistry().addListener(this.fPreferenceChangeListener);
        JFaceResources.getColorRegistry().addListener(this.fPreferenceChangeListener);
        this.updateFont();
    }

    private ChainedPreferenceStore createChainedPreferenceStore() {
        ArrayList<IPreferenceStore> stores = new ArrayList<IPreferenceStore>(2);
        stores.add(this.getCompareConfiguration().getPreferenceStore());
        stores.add(EditorsUI.getPreferenceStore());
        return new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()]));
    }

    private void updateFont() {
        Font f = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
        if (f != null) {
            if (this.fAncestor != null) {
                this.fAncestor.setFont(f);
            }
            if (this.fLeft != null) {
                this.fLeft.setFont(f);
            }
            if (this.fRight != null) {
                this.fRight.setFont(f);
            }
        }
    }

    private void checkForColorUpdate(Display display) {
        if (this.fPollSystemForeground) {
            RGB fg;
            RGB rGB = fg = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? display.getSystemColor(24).getRGB() : new Color((Device)display, PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)"AbstractTextEditor.Color.Foreground")).getRGB();
            if (this.fForeground == null || !fg.equals((Object)this.fForeground)) {
                this.fForeground = fg;
                this.updateColors(display);
            }
        }
        if (this.fPollSystemBackground) {
            RGB bg;
            RGB rGB = bg = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? display.getSystemColor(25).getRGB() : new Color((Device)display, PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)"AbstractTextEditor.Color.Background")).getRGB();
            if (this.fBackground == null || !bg.equals((Object)this.fBackground)) {
                this.fBackground = bg;
                this.updateColors(display);
            }
        }
    }

    public void setBackgroundColor(RGB background) {
        this.fPollSystemBackground = background == null;
        this.fBackground = background;
        this.updateColors(null);
    }

    private RGB getBackground(Display display) {
        if (this.fBackground != null) {
            return this.fBackground;
        }
        if (display == null) {
            display = this.fComposite.getDisplay();
        }
        return display.getSystemColor(25).getRGB();
    }

    public void setForegroundColor(RGB foreground) {
        this.fPollSystemForeground = foreground == null;
        this.fForeground = foreground;
        this.updateColors(null);
    }

    private void updateColors(Display display) {
        if (display == null) {
            display = this.fComposite.getDisplay();
        }
        Color color = null;
        if (this.fBackground != null) {
            color = this.getColor(display, this.fBackground);
        }
        if (this.fAncestor != null) {
            this.fAncestor.setBackgroundColor(color);
        }
        if (this.fLeft != null) {
            this.fLeft.setBackgroundColor(color);
        }
        if (this.fRight != null) {
            this.fRight.setBackgroundColor(color);
        }
        ColorRegistry registry = JFaceResources.getColorRegistry();
        RGB bg = this.getBackground(display);
        this.SELECTED_INCOMING = registry.getRGB(INCOMING_COLOR);
        if (this.SELECTED_INCOMING == null) {
            this.SELECTED_INCOMING = new RGB(0, 0, 255);
        }
        this.INCOMING = TextMergeViewer.interpolate(this.SELECTED_INCOMING, bg, 0.6);
        this.INCOMING_FILL = TextMergeViewer.interpolate(this.SELECTED_INCOMING, bg, 0.97);
        this.INCOMING_TEXT_FILL = TextMergeViewer.interpolate(this.SELECTED_INCOMING, bg, 0.85);
        this.SELECTED_OUTGOING = registry.getRGB(OUTGOING_COLOR);
        if (this.SELECTED_OUTGOING == null) {
            this.SELECTED_OUTGOING = new RGB(0, 0, 0);
        }
        this.OUTGOING = TextMergeViewer.interpolate(this.SELECTED_OUTGOING, bg, 0.6);
        this.OUTGOING_FILL = TextMergeViewer.interpolate(this.SELECTED_OUTGOING, bg, 0.97);
        this.OUTGOING_TEXT_FILL = TextMergeViewer.interpolate(this.SELECTED_OUTGOING, bg, 0.85);
        this.SELECTED_CONFLICT = registry.getRGB(CONFLICTING_COLOR);
        if (this.SELECTED_CONFLICT == null) {
            this.SELECTED_CONFLICT = new RGB(255, 0, 0);
        }
        this.CONFLICT = TextMergeViewer.interpolate(this.SELECTED_CONFLICT, bg, 0.6);
        this.CONFLICT_FILL = TextMergeViewer.interpolate(this.SELECTED_CONFLICT, bg, 0.97);
        this.CONFLICT_TEXT_FILL = TextMergeViewer.interpolate(this.SELECTED_CONFLICT, bg, 0.85);
        this.RESOLVED = registry.getRGB(RESOLVED_COLOR);
        if (this.RESOLVED == null) {
            this.RESOLVED = new RGB(0, 255, 0);
        }
        this.updatePresentation(display);
    }

    private void updatePresentation(Display display) {
        if (display == null) {
            display = this.fComposite.getDisplay();
        }
        this.refreshBirdsEyeView();
        this.invalidateLines();
        this.updateAllDiffBackgrounds(display);
        this.invalidateTextPresentation();
    }

    public void invalidateTextPresentation() {
        if (this.fAncestor != null) {
            this.fAncestor.invalidateTextPresentation();
        }
        if (this.fLeft != null) {
            this.fLeft.invalidateTextPresentation();
        }
        if (this.fRight != null) {
            this.fRight.invalidateTextPresentation();
        }
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer instanceof MergeSourceViewer) {
            SourceViewerConfiguration configuration = new SourceViewerConfiguration();
            ((MergeSourceViewer)textViewer).configure(configuration);
        }
    }

    protected ITokenComparator createTokenComparator(String line) {
        return new TokenComparator(line);
    }

    protected void setupDocument(IDocument document) {
        String partitioning = this.getDocumentPartitioning();
        if (partitioning == null || !(document instanceof IDocumentExtension3)) {
            IDocumentPartitioner partitioner;
            if (document.getDocumentPartitioner() == null && (partitioner = this.getDocumentPartitioner()) != null) {
                document.setDocumentPartitioner(partitioner);
                partitioner.connect(document);
            }
        } else {
            IDocumentPartitioner partitioner;
            IDocumentExtension3 ex3 = (IDocumentExtension3)document;
            if (ex3.getDocumentPartitioner(partitioning) == null && (partitioner = this.getDocumentPartitioner()) != null) {
                ex3.setDocumentPartitioner(partitioning, partitioner);
                partitioner.connect(document);
            }
        }
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return null;
    }

    protected String getDocumentPartitioning() {
        return null;
    }

    @Override
    protected void handleDispose(DisposeEvent event) {
        if (this.fHandlerService != null) {
            this.fHandlerService.dispose();
        }
        Object input = this.getInput();
        this.removeFromDocumentManager('A', input);
        this.removeFromDocumentManager('L', input);
        this.removeFromDocumentManager('R', input);
        if (this.fPreferenceChangeListener != null) {
            JFaceResources.getFontRegistry().removeListener(this.fPreferenceChangeListener);
            JFaceResources.getColorRegistry().removeListener(this.fPreferenceChangeListener);
            if (this.fPreferenceStore != null) {
                this.fPreferenceStore.removePropertyChangeListener(this.fPreferenceChangeListener);
            }
            this.fPreferenceChangeListener = null;
        }
        this.fLeftCanvas = null;
        this.fRightCanvas = null;
        this.fVScrollBar = null;
        this.fBirdsEyeCanvas = null;
        this.fSummaryHeader = null;
        this.fAncestorContributor.unsetDocument(this.fAncestor);
        this.fLeftContributor.unsetDocument(this.fLeft);
        this.fRightContributor.unsetDocument(this.fRight);
        this.disconnect(this.fLeftContributor);
        this.disconnect(this.fRightContributor);
        this.disconnect(this.fAncestorContributor);
        if (this.fColors != null) {
            for (Color color : this.fColors.values()) {
                if (color.isDisposed()) continue;
                color.dispose();
            }
            this.fColors = null;
        }
        if (this.fBirdsEyeCursor != null) {
            this.fBirdsEyeCursor.dispose();
            this.fBirdsEyeCursor = null;
        }
        if (this.showWhitespaceAction != null) {
            this.showWhitespaceAction.dispose();
        }
        if (this.toggleLineNumbersAction != null) {
            this.toggleLineNumbersAction.dispose();
        }
        if (this.fIgnoreWhitespace != null) {
            this.fIgnoreWhitespace.dispose();
        }
        super.handleDispose(event);
    }

    private void disconnect(ContributorInfo legInfo) {
        if (legInfo != null) {
            legInfo.disconnect();
        }
    }

    @Override
    protected void createControls(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.compare.text_merge_view_context");
        if (this.fMarginWidth > 0) {
            this.fAncestorCanvas = new BufferedCanvas(composite, 0){

                public void doPaint(GC gc) {
                    TextMergeViewer.this.paintSides(gc, TextMergeViewer.this.fAncestor, (Canvas)TextMergeViewer.this.fAncestorCanvas, false);
                }
            };
            this.fAncestorCanvas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handleMouseInSides((Canvas)TextMergeViewer.this.fAncestorCanvas, TextMergeViewer.this.fAncestor, e.y), false);
                }
            });
        }
        this.fAncestor = this.createPart(composite);
        this.fAncestor.setEditable(false);
        this.fAncestor.getTextWidget().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = NLS.bind((String)CompareMessages.TextMergeViewer_accessible_ancestor, (Object)TextMergeViewer.this.getCompareConfiguration().getAncestorLabel(TextMergeViewer.this.getInput()));
            }
        });
        this.fAncestor.addTextPresentationListener(new ChangeHighlighter(this.fAncestor));
        this.fSummaryHeader = new Canvas(composite, 0);
        this.fHeaderPainter = new HeaderPainter();
        this.fSummaryHeader.addPaintListener((PaintListener)this.fHeaderPainter);
        this.updateResolveStatus();
        if (this.fMarginWidth > 0) {
            this.fLeftCanvas = new BufferedCanvas(composite, 0){

                public void doPaint(GC gc) {
                    TextMergeViewer.this.paintSides(gc, TextMergeViewer.this.fLeft, (Canvas)TextMergeViewer.this.fLeftCanvas, false);
                }
            };
            this.fLeftCanvas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handleMouseInSides((Canvas)TextMergeViewer.this.fLeftCanvas, TextMergeViewer.this.fLeft, e.y), false);
                }
            });
        }
        this.fLeft = this.createPart(composite);
        this.fLeft.getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
        this.fLeft.addAction("save", this.fLeftSaveAction);
        this.fLeft.getTextWidget().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = NLS.bind((String)CompareMessages.TextMergeViewer_accessible_left, (Object)TextMergeViewer.this.getCompareConfiguration().getLeftLabel(TextMergeViewer.this.getInput()));
            }
        });
        this.fLeft.addTextPresentationListener(new ChangeHighlighter(this.fLeft));
        this.fRight = this.createPart(composite);
        this.fRight.getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
        this.fRight.addAction("save", this.fRightSaveAction);
        this.fRight.getTextWidget().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = NLS.bind((String)CompareMessages.TextMergeViewer_accessible_right, (Object)TextMergeViewer.this.getCompareConfiguration().getRightLabel(TextMergeViewer.this.getInput()));
            }
        });
        this.fRight.addTextPresentationListener(new ChangeHighlighter(this.fRight));
        this.hsynchViewport((TextViewer)this.fAncestor, (TextViewer)this.fLeft, (TextViewer)this.fRight);
        this.hsynchViewport((TextViewer)this.fLeft, (TextViewer)this.fAncestor, (TextViewer)this.fRight);
        this.hsynchViewport((TextViewer)this.fRight, (TextViewer)this.fAncestor, (TextViewer)this.fLeft);
        if (this.fMarginWidth > 0) {
            this.fRightCanvas = new BufferedCanvas(composite, 0){

                public void doPaint(GC gc) {
                    TextMergeViewer.this.paintSides(gc, TextMergeViewer.this.fRight, (Canvas)TextMergeViewer.this.fRightCanvas, TextMergeViewer.this.fSynchronizedScrolling);
                }
            };
            this.fRightCanvas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handleMouseInSides((Canvas)TextMergeViewer.this.fRightCanvas, TextMergeViewer.this.fRight, e.y), false);
                }
            });
        }
        this.fScrollCanvas = new Canvas(composite, 512);
        Rectangle trim = this.fLeft.getTextWidget().computeTrim(0, 0, 0, 0);
        this.fTopInset = trim.y;
        this.fVScrollBar = this.fScrollCanvas.getVerticalBar();
        this.fVScrollBar.setIncrement(1);
        this.fVScrollBar.setVisible(true);
        this.fVScrollBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int vpos = ((ScrollBar)e.widget).getSelection();
                TextMergeViewer.this.synchronizedScrollVertical(vpos);
            }
        });
        this.fBirdsEyeCanvas = new BufferedCanvas(composite, 0){

            public void doPaint(GC gc) {
                TextMergeViewer.this.paintBirdsEyeView((Canvas)this, gc);
            }
        };
        this.fBirdsEyeCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handlemouseInBirdsEyeView(TextMergeViewer.this.fBirdsEyeCanvas, e.y), true);
            }
        });
        this.fBirdsEyeCanvas.addMouseMoveListener(new MouseMoveListener(){
            private Cursor fLastCursor;

            public void mouseMove(MouseEvent e) {
                Cursor cursor = null;
                DocumentMerger.Diff diff = TextMergeViewer.this.handlemouseInBirdsEyeView(TextMergeViewer.this.fBirdsEyeCanvas, e.y);
                if (diff != null && diff.getKind() != 0) {
                    cursor = TextMergeViewer.this.fBirdsEyeCursor;
                }
                if (this.fLastCursor != cursor) {
                    TextMergeViewer.this.fBirdsEyeCanvas.setCursor(cursor);
                    this.fLastCursor = cursor;
                }
            }
        });
    }

    private void hsynchViewport(TextViewer tv1, TextViewer tv2, TextViewer tv3) {
        StyledText st1 = tv1.getTextWidget();
        final StyledText st2 = tv2.getTextWidget();
        final StyledText st3 = tv3.getTextWidget();
        final ScrollBar sb1 = st1.getHorizontalBar();
        sb1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TextMergeViewer.this.fSynchronizedScrolling) {
                    int v = sb1.getSelection();
                    if (st2.isVisible()) {
                        st2.setHorizontalPixel(v);
                    }
                    if (st3.isVisible()) {
                        st3.setHorizontalPixel(v);
                    }
                    TextMergeViewer.this.workaround65205();
                }
            }
        });
    }

    private void workaround65205() {
        if (this.fIsCarbon && this.fComposite != null && !this.fComposite.isDisposed()) {
            this.fComposite.getDisplay().update();
        }
    }

    private void setCurrentDiff2(DocumentMerger.Diff diff, boolean reveal) {
        if (diff != null && diff.getKind() != 0) {
            this.setCurrentDiff(diff, reveal);
        }
    }

    private DocumentMerger.Diff handleMouseInSides(Canvas canvas, MergeSourceViewer tp, int my) {
        int lineHeight = tp.getTextWidget().getLineHeight();
        int visibleHeight = tp.getViewportHeight();
        if (!this.fHighlightRanges) {
            return null;
        }
        if (this.fMerger.hasChanges()) {
            int shift = tp.getVerticalScrollOffset() + 1;
            Point region = new Point(0, 0);
            char leg = this.getLeg(tp);
            Iterator iterator = this.fMerger.changesIterator();
            while (iterator.hasNext()) {
                DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                tp.getLineRange(diff.getPosition(leg), region);
                int y = region.x * lineHeight + shift;
                int h = region.y * lineHeight;
                if (y + h < 0) continue;
                if (y >= visibleHeight) break;
                if (my < y || my >= y + h) continue;
                return diff;
            }
        }
        return null;
    }

    private DocumentMerger.Diff getDiffUnderMouse(Canvas canvas, int mx, int my, Rectangle r) {
        if (!this.fSynchronizedScrolling) {
            return null;
        }
        int lineHeight = this.fLeft.getTextWidget().getLineHeight();
        int visibleHeight = this.fRight.getViewportHeight();
        Point size = canvas.getSize();
        int w = size.x;
        if (!this.fHighlightRanges) {
            return null;
        }
        if (this.fMerger.hasChanges()) {
            int lshift = this.fLeft.getVerticalScrollOffset();
            int rshift = this.fRight.getVerticalScrollOffset();
            Point region = new Point(0, 0);
            Iterator iterator = this.fMerger.changesIterator();
            while (iterator.hasNext()) {
                DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                this.fLeft.getLineRange(diff.getPosition('L'), region);
                int ly = region.x * lineHeight + lshift;
                int lh = region.y * lineHeight;
                this.fRight.getLineRange(diff.getPosition('R'), region);
                int ry = region.x * lineHeight + rshift;
                int rh = region.y * lineHeight;
                if (Math.max(ly + lh, ry + rh) < 0) continue;
                if (Math.min(ly, ry) >= visibleHeight) break;
                int cx = (w - 5) / 2;
                int cy = (ly + lh / 2 + (ry + rh / 2) - 5) / 2;
                if (my < cy || my >= cy + 5 || mx < cx || mx >= cx + 5) continue;
                if (r != null) {
                    int SIZE = this.fIsCarbon ? 30 : 20;
                    r.x = cx + (5 - SIZE) / 2;
                    r.y = cy + (5 - SIZE) / 2;
                    r.width = SIZE;
                    r.height = SIZE;
                }
                return diff;
            }
        }
        return null;
    }

    private DocumentMerger.Diff handlemouseInBirdsEyeView(Canvas canvas, int my) {
        return this.fMerger.findDiff(this.getViewportHeight(), this.fSynchronizedScrolling, canvas.getSize(), my);
    }

    private void paintBirdsEyeView(Canvas canvas, GC gc) {
        int virtualHeight;
        Rectangle r = new Rectangle(0, 0, 0, 0);
        Point size = canvas.getSize();
        int n = virtualHeight = this.fSynchronizedScrolling ? this.fMerger.getVirtualHeight() : this.fMerger.getRightHeight();
        if (virtualHeight < this.getViewportHeight()) {
            return;
        }
        Display display = canvas.getDisplay();
        int y = 0;
        Iterator iterator = this.fMerger.rangesIterator();
        while (iterator.hasNext()) {
            int h;
            DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
            int n2 = h = this.fSynchronizedScrolling ? diff.getMaxDiffHeight() : diff.getRightHeight();
            if (this.fMerger.useChange(diff)) {
                Color c;
                int yy = y * size.y / virtualHeight;
                int hh = h * size.y / virtualHeight;
                if (hh < 3) {
                    hh = 3;
                }
                if ((c = this.getColor(display, this.getFillColor(diff))) != null) {
                    gc.setBackground(c);
                    gc.fillRectangle(2, yy, size.x - 4, hh);
                }
                if ((c = this.getColor(display, this.getStrokeColor(diff))) != null) {
                    gc.setForeground(c);
                    r.x = 2;
                    r.y = yy;
                    r.width = size.x - 4 - 1;
                    r.height = hh;
                    if (this.isCurrentDiff(diff)) {
                        gc.setLineWidth(2);
                        ++r.x;
                        ++r.y;
                        --r.width;
                        --r.height;
                    } else {
                        gc.setLineWidth(0);
                    }
                    gc.drawRectangle(r);
                }
            }
            y += h;
        }
    }

    private void refreshBirdsEyeView() {
        if (this.fBirdsEyeCanvas != null) {
            this.fBirdsEyeCanvas.redraw();
        }
    }

    @Override
    protected boolean handleSetFocus() {
        StyledText st;
        if (this.fFocusPart == null) {
            if (this.fLeft != null && this.fLeft.getEnabled()) {
                this.fFocusPart = this.fLeft;
            } else if (this.fRight != null && this.fRight.getEnabled()) {
                this.fFocusPart = this.fRight;
            } else if (this.fAncestor != null && this.fAncestor.getEnabled()) {
                this.fFocusPart = this.fAncestor;
            }
        }
        if (this.fFocusPart != null && (st = this.fFocusPart.getTextWidget()) != null) {
            return st.setFocus();
        }
        return false;
    }

    @Override
    protected final Control createCenterControl(Composite parent) {
        if (this.fSynchronizedScrolling) {
            BufferedCanvas canvas = new BufferedCanvas(parent, 0){

                public void doPaint(GC gc) {
                    TextMergeViewer.this.paintCenter((Canvas)this, gc);
                }
            };
            if (this.fUseResolveUI) {
                new HoverResizer((Canvas)canvas, 1);
                this.fCenterButton = new Button((Composite)canvas, this.fIsCarbon ? 0x800000 : 8);
                if (this.fNormalCursor == null) {
                    this.fNormalCursor = new Cursor((Device)canvas.getDisplay(), 0);
                }
                this.fCenterButton.setCursor(this.fNormalCursor);
                this.fCenterButton.setText(COPY_RIGHT_TO_LEFT_INDICATOR);
                this.fCenterButton.pack();
                this.fCenterButton.setVisible(false);
                this.fCenterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TextMergeViewer.this.fCenterButton.setVisible(false);
                        if (TextMergeViewer.this.fButtonDiff != null) {
                            TextMergeViewer.this.setCurrentDiff(TextMergeViewer.this.fButtonDiff, false);
                            TextMergeViewer.this.copy(TextMergeViewer.this.fCurrentDiff, TextMergeViewer.this.fCenterButton.getText().equals(TextMergeViewer.COPY_LEFT_TO_RIGHT_INDICATOR), TextMergeViewer.this.fCurrentDiff.getKind() != 1);
                        }
                    }
                });
            } else {
                new ContentMergeViewer.Resizer(this, (Control)canvas, 1);
            }
            return canvas;
        }
        return super.createCenterControl(parent);
    }

    private boolean handleMouseMoveOverCenter(Canvas canvas, int x, int y) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        DocumentMerger.Diff diff = this.getDiffUnderMouse(canvas, x, y, r);
        if (diff != null && !diff.isUnresolvedIncomingOrConflicting()) {
            diff = null;
        }
        if (diff != this.fButtonDiff) {
            if (diff != null) {
                if (this.fLeft.isEditable()) {
                    this.fButtonDiff = diff;
                    this.fCenterButton.setText(COPY_RIGHT_TO_LEFT_INDICATOR);
                    String tt = this.fCopyDiffRightToLeftItem.getAction().getToolTipText();
                    this.fCenterButton.setToolTipText(tt);
                    this.fCenterButton.setBounds(r);
                    this.fCenterButton.setVisible(true);
                } else if (this.fRight.isEditable()) {
                    this.fButtonDiff = diff;
                    this.fCenterButton.setText(COPY_LEFT_TO_RIGHT_INDICATOR);
                    String tt = this.fCopyDiffLeftToRightItem.getAction().getToolTipText();
                    this.fCenterButton.setToolTipText(tt);
                    this.fCenterButton.setBounds(r);
                    this.fCenterButton.setVisible(true);
                } else {
                    this.fButtonDiff = null;
                }
            } else {
                this.fCenterButton.setVisible(false);
                this.fButtonDiff = null;
            }
        }
        return this.fButtonDiff != null;
    }

    @Override
    protected final int getCenterWidth() {
        if (this.fSynchronizedScrolling) {
            return 34;
        }
        return super.getCenterWidth();
    }

    private int getDirection() {
        switch (this.fTextDirection) {
            case 0x2000000: 
            case 0x4000000: {
                if (this.fInheritedDirection == this.fTextDirection) {
                    return 0;
                }
                return this.fTextDirection;
            }
        }
        return this.fInheritedDirection;
    }

    private MergeSourceViewer createPart(Composite parent) {
        final MergeSourceViewer part = new MergeSourceViewer(parent, this.getDirection(), this.getResourceBundle(), this.getCompareConfiguration().getContainer());
        StyledText te = part.getTextWidget();
        if (!this.fConfirmSave) {
            part.hideSaveAction();
        }
        te.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TextMergeViewer.this.paint(e, part);
            }
        });
        te.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TextMergeViewer.this.handleSelectionChanged(part);
            }
        });
        te.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TextMergeViewer.this.handleSelectionChanged(part);
            }
        });
        te.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent fe) {
                TextMergeViewer.this.fFocusPart = part;
                TextMergeViewer.this.connectGlobalActions(TextMergeViewer.this.fFocusPart);
            }

            public void focusLost(FocusEvent fe) {
                TextMergeViewer.this.connectGlobalActions(null);
            }
        });
        part.addViewportListener(new IViewportListener(){

            public void viewportChanged(int verticalPosition) {
                TextMergeViewer.this.syncViewport(part);
            }
        });
        Font font = JFaceResources.getFont((String)this.fSymbolicFontName);
        if (font != null) {
            te.setFont(font);
        }
        if (this.fBackground != null) {
            te.setBackground(this.getColor(parent.getDisplay(), this.fBackground));
        }
        this.contributeFindAction(part);
        this.configureTextViewer((TextViewer)part);
        return part;
    }

    private void contributeFindAction(MergeSourceViewer viewer) {
        IWorkbenchPart wp = this.getCompareConfiguration().getContainer().getWorkbenchPart();
        FindReplaceAction action = wp != null ? new FindReplaceAction(this.getResourceBundle(), "Editor.FindReplace.", wp) : new FindReplaceAction(this.getResourceBundle(), "Editor.FindReplace.", viewer.getControl().getShell(), this.getFindReplaceTarget());
        action.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        viewer.addAction("find", (IAction)action);
    }

    private void connectGlobalActions(final MergeSourceViewer part) {
        if (this.fHandlerService != null) {
            if (part != null) {
                part.updateActions();
            }
            this.fHandlerService.updatePaneActionHandlers(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < GLOBAL_ACTIONS.length) {
                        IAction action = null;
                        if (part != null && (action = part.getAction(TEXT_ACTIONS[i])) == null && TEXT_ACTIONS[i].equals("save")) {
                            action = part == TextMergeViewer.this.fLeft ? TextMergeViewer.this.fLeftSaveAction : TextMergeViewer.this.fRightSaveAction;
                        }
                        TextMergeViewer.this.fHandlerService.setGlobalActionHandler(GLOBAL_ACTIONS[i], action);
                        ++i;
                    }
                }
            });
        }
    }

    private IDocument getElementDocument(char type, Object element) {
        if (element instanceof IDocument) {
            return (IDocument)element;
        }
        ITypedElement te = Utilities.getLeg((char)type, (Object)element);
        IDocument document = null;
        switch (type) {
            case 'A': {
                document = this.getDocument(te, this.fAncestorContributor);
                break;
            }
            case 'L': {
                document = this.getDocument(te, this.fLeftContributor);
                break;
            }
            case 'R': {
                document = this.getDocument(te, this.fRightContributor);
            }
        }
        if (document != null) {
            return document;
        }
        return Utilities.getDocument((char)type, (Object)element, (boolean)this.isUsingDefaultContentProvider(), (boolean)this.canHaveSharedDocument());
    }

    private boolean isUsingDefaultContentProvider() {
        return this.getContentProvider() instanceof MergeViewerContentProvider;
    }

    private boolean canHaveSharedDocument() {
        return this.getDocumentPartitioning() != null || this.getDocumentPartitioner() == null;
    }

    private IDocument getDocument(ITypedElement te, ContributorInfo info) {
        if (info != null && info.getElement() == te) {
            return info.getDocument();
        }
        return null;
    }

    IDocument getDocument(char type, Object input) {
        IDocument doc = this.getElementDocument(type, input);
        if (doc != null) {
            return doc;
        }
        if (input instanceof IDiffElement) {
            IDiffContainer parent = ((IDiffElement)input).getParent();
            return this.getElementDocument(type, parent);
        }
        return null;
    }

    boolean sameDoc(char type, Object newInput, Object oldInput) {
        IDocument oldDoc;
        IDocument newDoc = this.getDocument(type, newInput);
        return newDoc == (oldDoc = this.getDocument(type, oldInput));
    }

    @Override
    protected boolean doSave(Object newInput, Object oldInput) {
        if (oldInput != null && newInput != null && this.sameDoc('A', newInput, oldInput) && this.sameDoc('L', newInput, oldInput) && this.sameDoc('R', newInput, oldInput)) {
            return false;
        }
        this.removeFromDocumentManager('A', oldInput);
        this.removeFromDocumentManager('L', oldInput);
        this.removeFromDocumentManager('R', oldInput);
        return super.doSave(newInput, oldInput);
    }

    private void removeFromDocumentManager(char leg, Object oldInput) {
        IDocument document = this.getDocument(leg, oldInput);
        if (document != null) {
            DocumentManager.remove((IDocument)document);
        }
    }

    private ITypedElement getParent(char type) {
        Object input = this.getInput();
        if (input instanceof IDiffElement) {
            IDiffContainer parent = ((IDiffElement)input).getParent();
            return Utilities.getLeg((char)type, (Object)parent);
        }
        return null;
    }

    @Override
    protected void updateContent(Object ancestor, Object left, Object right) {
        ICompareInput ci;
        IDiffContainer parent;
        boolean emptyInput = ancestor == null && left == null && right == null;
        Object input = this.getInput();
        Position leftRange = null;
        Position rightRange = null;
        if (!emptyInput && (left == null || right == null) && input instanceof IDiffElement && (parent = ((IDiffElement)input).getParent()) instanceof ICompareInput && ((ci = (ICompareInput)parent).getAncestor() instanceof IDocumentRange || ci.getLeft() instanceof IDocumentRange || ci.getRight() instanceof IDocumentRange)) {
            if (left instanceof IDocumentRange) {
                leftRange = ((IDocumentRange)left).getRange();
            }
            if (right instanceof IDocumentRange) {
                rightRange = ((IDocumentRange)right).getRange();
            }
            ancestor = ci.getAncestor();
            left = ci.getLeft();
            right = ci.getRight();
        }
        int n = 0;
        if (left != null) {
            ++n;
        }
        if (right != null) {
            ++n;
        }
        this.fHighlightRanges = n > 1;
        this.resetDiffs();
        this.fHasErrors = false;
        CompareConfiguration cc = this.getCompareConfiguration();
        IMergeViewerContentProvider cp = this.getMergeContentProvider();
        if (cp instanceof MergeViewerContentProvider) {
            MergeViewerContentProvider mcp = (MergeViewerContentProvider)cp;
            mcp.setAncestorError(null);
            mcp.setLeftError(null);
            mcp.setRightError(null);
        }
        ContributorInfo oldLeftContributor = this.fLeftContributor;
        ContributorInfo oldRightContributor = this.fRightContributor;
        ContributorInfo oldAncestorContributor = this.fAncestorContributor;
        this.fLeftContributor = this.createLegInfoFor(left, 'L');
        this.fRightContributor = this.createLegInfoFor(right, 'R');
        this.fAncestorContributor = this.createLegInfoFor(ancestor, 'A');
        this.fLeftContributor.transferContributorStateFrom(oldLeftContributor);
        this.fRightContributor.transferContributorStateFrom(oldRightContributor);
        this.fAncestorContributor.transferContributorStateFrom(oldAncestorContributor);
        this.disconnect(oldLeftContributor);
        this.disconnect(oldRightContributor);
        this.disconnect(oldAncestorContributor);
        this.fLeftContributor.setEncodingIfAbsent(this.fRightContributor);
        this.fRightContributor.setEncodingIfAbsent(this.fLeftContributor);
        this.fAncestorContributor.setEncodingIfAbsent(this.fLeftContributor);
        this.fLeftContributor.setDocument(this.fLeft, cc.isLeftEditable() && cp.isLeftEditable(input));
        this.fLeftLineCount = this.fLeft.getLineCount();
        this.fRightContributor.setDocument(this.fRight, cc.isRightEditable() && cp.isRightEditable(input));
        this.fRightLineCount = this.fRight.getLineCount();
        this.fAncestorContributor.setDocument(this.fAncestor, false);
        this.setSyncScrolling(this.fPreferenceStore.getBoolean("org.eclipse.compare.SynchronizeScrolling"));
        this.update(false);
        if (!(this.fHasErrors || emptyInput || this.fComposite.isDisposed())) {
            if (this.isRefreshing()) {
                this.fLeftContributor.updateSelection(this.fLeft, !this.fSynchronizedScrolling);
                this.fRightContributor.updateSelection(this.fRight, !this.fSynchronizedScrolling);
                this.fAncestorContributor.updateSelection(this.fAncestor, !this.fSynchronizedScrolling);
                if (this.fSynchronizedScrolling && this.fSynchronziedScrollPosition != -1) {
                    this.synchronizedScrollVertical(this.fSynchronziedScrollPosition);
                }
            } else if (this.isPatchHunk()) {
                if (right != null && Utilities.getAdapter((Object)right, IHunk.class) != null) {
                    this.fLeft.setTopIndex(this.getHunkStart());
                } else {
                    this.fRight.setTopIndex(this.getHunkStart());
                }
            } else {
                DocumentMerger.Diff selectDiff = null;
                if (leftRange != null) {
                    selectDiff = this.fMerger.findDiff('L', leftRange);
                } else if (rightRange != null) {
                    selectDiff = this.fMerger.findDiff('R', rightRange);
                }
                if (selectDiff != null) {
                    this.setCurrentDiff(selectDiff, true);
                } else {
                    this.selectFirstDiff(true);
                }
            }
        }
    }

    private boolean isRefreshing() {
        return this.isRefreshing;
    }

    private ContributorInfo createLegInfoFor(Object element, char leg) {
        return new ContributorInfo(this, element, leg);
    }

    private void updateDiffBackground(DocumentMerger.Diff diff) {
        if (!this.fHighlightRanges) {
            return;
        }
        if (diff == null || diff.isToken()) {
            return;
        }
        if (this.fShowCurrentOnly && !this.isCurrentDiff(diff)) {
            return;
        }
        Color c = this.getColor(null, this.getFillColor(diff));
        if (c == null) {
            return;
        }
        if (this.isThreeWay()) {
            this.fAncestor.setLineBackground(diff.getPosition('A'), c);
        }
        this.fLeft.setLineBackground(diff.getPosition('L'), c);
        this.fRight.setLineBackground(diff.getPosition('R'), c);
    }

    private void updateAllDiffBackgrounds(Display display) {
        if (this.fMerger.hasChanges()) {
            boolean threeWay = this.isThreeWay();
            Iterator iterator = this.fMerger.changesIterator();
            while (iterator.hasNext()) {
                DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
                Color c = this.getColor(display, this.getFillColor(diff));
                if (threeWay) {
                    this.fAncestor.setLineBackground(diff.getPosition('A'), c);
                }
                this.fLeft.setLineBackground(diff.getPosition('L'), c);
                this.fRight.setLineBackground(diff.getPosition('R'), c);
            }
        }
    }

    private void documentChanged(DocumentEvent e, boolean dirty) {
        IDocument doc = e.getDocument();
        if (doc == this.fLeft.getDocument()) {
            this.setLeftDirty(dirty);
        } else if (doc == this.fRight.getDocument()) {
            this.setRightDirty(dirty);
        }
        this.updateLines(doc);
    }

    protected int findInsertionPosition(char type, ICompareInput input) {
        ITypedElement other = null;
        char otherType = '\u0000';
        switch (type) {
            case 'A': {
                other = input.getLeft();
                otherType = 'L';
                if (other != null) break;
                other = input.getRight();
                otherType = 'R';
                break;
            }
            case 'L': {
                other = input.getRight();
                otherType = 'R';
                if (other != null) break;
                other = input.getAncestor();
                otherType = 'A';
                break;
            }
            case 'R': {
                other = input.getLeft();
                otherType = 'L';
                if (other != null) break;
                other = input.getAncestor();
                otherType = 'A';
            }
        }
        if (other instanceof IDocumentRange) {
            IDocumentRange dr = (IDocumentRange)other;
            Position p = dr.getRange();
            DocumentMerger.Diff diff = this.findDiff(otherType, p.offset);
            return this.fMerger.findInsertionPoint(diff, type);
        }
        return 0;
    }

    private void setError(char type, String message) {
        IMergeViewerContentProvider cp = this.getMergeContentProvider();
        if (cp instanceof MergeViewerContentProvider) {
            MergeViewerContentProvider mcp = (MergeViewerContentProvider)cp;
            switch (type) {
                case 'A': {
                    mcp.setAncestorError(message);
                    break;
                }
                case 'L': {
                    mcp.setLeftError(message);
                    break;
                }
                case 'R': {
                    mcp.setRightError(message);
                }
            }
        }
        this.fHasErrors = true;
    }

    private void updateDirtyState(IEditorInput key, IDocumentProvider documentProvider, char type) {
        boolean dirty = documentProvider.canSaveDocument((Object)key);
        if (type == 'L') {
            this.setLeftDirty(dirty);
        } else if (type == 'R') {
            this.setRightDirty(dirty);
        }
    }

    private Position getNewRange(char type, Object input) {
        switch (type) {
            case 'A': {
                return (Position)this.fNewAncestorRanges.get(input);
            }
            case 'L': {
                return (Position)this.fNewLeftRanges.get(input);
            }
            case 'R': {
                return (Position)this.fNewRightRanges.get(input);
            }
        }
        return null;
    }

    private void addNewRange(char type, Object input, Position range) {
        switch (type) {
            case 'A': {
                this.fNewAncestorRanges.put(input, range);
                break;
            }
            case 'L': {
                this.fNewLeftRanges.put(input, range);
                break;
            }
            case 'R': {
                this.fNewRightRanges.put(input, range);
            }
        }
    }

    @Override
    protected byte[] getContents(boolean left) {
        String contents;
        IDocument d;
        MergeSourceViewer v;
        MergeSourceViewer mergeSourceViewer = v = left ? this.fLeft : this.fRight;
        if (v != null && (d = v.getDocument()) != null && (contents = d.get()) != null) {
            byte[] bytes;
            try {
                bytes = contents.getBytes(left ? this.fLeftContributor.getEncoding() : this.fRightContributor.getEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = contents.getBytes();
            }
            return bytes;
        }
        return null;
    }

    private IRegion normalizeDocumentRegion(IDocument doc, IRegion region) {
        if (region == null || doc == null) {
            return region;
        }
        int maxLength = doc.getLength();
        int start = region.getOffset();
        if (start < 0) {
            start = 0;
        } else if (start > maxLength) {
            start = maxLength;
        }
        int length = region.getLength();
        if (length < 0) {
            length = 0;
        } else if (start + length > maxLength) {
            length = maxLength - start;
        }
        return new Region(start, length);
    }

    @Override
    protected final void handleResizeAncestor(int x, int y, int width, int height) {
        if (width > 0) {
            Rectangle trim = this.fLeft.getTextWidget().computeTrim(0, 0, 0, 0);
            int scrollbarHeight = trim.height;
            if (Utilities.okToUse((Widget)this.fAncestorCanvas)) {
                this.fAncestorCanvas.setVisible(true);
            }
            if (this.fAncestor.isControlOkToUse()) {
                this.fAncestor.getTextWidget().setVisible(true);
            }
            if (this.fAncestorCanvas != null) {
                this.fAncestorCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
                x += this.fMarginWidth;
                width -= this.fMarginWidth;
            }
            this.fAncestor.setBounds(x, y, width, height);
        } else {
            if (Utilities.okToUse((Widget)this.fAncestorCanvas)) {
                this.fAncestorCanvas.setVisible(false);
            }
            if (this.fAncestor.isControlOkToUse()) {
                StyledText t = this.fAncestor.getTextWidget();
                t.setVisible(false);
                this.fAncestor.setBounds(0, 0, 0, 0);
                if (this.fFocusPart == this.fAncestor) {
                    this.fFocusPart = this.fLeft;
                    this.fFocusPart.getTextWidget().setFocus();
                }
            }
        }
    }

    @Override
    protected final void handleResizeLeftRight(int x, int y, int width1, int centerWidth, int width2, int height) {
        if (this.fBirdsEyeCanvas != null) {
            width2 -= 12;
        }
        Rectangle trim = this.fLeft.getTextWidget().computeTrim(0, 0, 0, 0);
        int scrollbarHeight = trim.height + trim.x;
        Composite composite = (Composite)this.getControl();
        int leftTextWidth = width1;
        if (this.fLeftCanvas != null) {
            this.fLeftCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
            x += this.fMarginWidth;
            leftTextWidth -= this.fMarginWidth;
        }
        this.fLeft.setBounds(x, y, leftTextWidth, height);
        x += leftTextWidth;
        if (this.fCenter == null || this.fCenter.isDisposed()) {
            this.fCenter = this.createCenterControl(composite);
        }
        this.fCenter.setBounds(x, y, centerWidth, height - scrollbarHeight);
        x += centerWidth;
        if (!this.fSynchronizedScrolling && this.fRightCanvas != null) {
            this.fRightCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
            this.fRightCanvas.redraw();
            x += this.fMarginWidth;
        }
        int scrollbarWidth = 0;
        if (this.fSynchronizedScrolling && this.fScrollCanvas != null) {
            trim = this.fLeft.getTextWidget().computeTrim(0, 0, 0, 0);
            scrollbarWidth = trim.width + 2 * trim.x + 1;
        }
        int rightTextWidth = width2 - scrollbarWidth;
        if (this.fRightCanvas != null) {
            rightTextWidth -= this.fMarginWidth;
        }
        this.fRight.setBounds(x, y, rightTextWidth, height);
        x += rightTextWidth;
        if (this.fSynchronizedScrolling) {
            if (this.fRightCanvas != null) {
                this.fRightCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
                x += this.fMarginWidth;
            }
            if (this.fScrollCanvas != null) {
                this.fScrollCanvas.setBounds(x, y, scrollbarWidth, height - scrollbarHeight);
            }
        }
        if (this.fBirdsEyeCanvas != null) {
            int verticalScrollbarButtonHeight = scrollbarWidth;
            int horizontalScrollbarButtonHeight = scrollbarHeight;
            if (this.fIsCarbon) {
                verticalScrollbarButtonHeight += 2;
                horizontalScrollbarButtonHeight = 18;
            }
            if (this.fSummaryHeader != null) {
                this.fSummaryHeader.setBounds(x + scrollbarWidth, y, 12, verticalScrollbarButtonHeight);
            }
            this.fBirdsEyeCanvas.setBounds(x + scrollbarWidth, y += verticalScrollbarButtonHeight, 12, height - (2 * verticalScrollbarButtonHeight + horizontalScrollbarButtonHeight));
        }
        this.updateVScrollBar();
        this.refreshBirdsEyeView();
    }

    private void handleSelectionChanged(MergeSourceViewer tw) {
        Point p = tw.getSelectedRange();
        DocumentMerger.Diff d = this.findDiff(tw, p.x, p.x + p.y);
        this.updateStatus(d);
        this.setCurrentDiff(d, false);
    }

    private static IRegion toRegion(Position position) {
        if (position != null) {
            return new Region(position.getOffset(), position.getLength());
        }
        return null;
    }

    private void doDiff() {
        IDocument lDoc = this.fLeft.getDocument();
        IDocument rDoc = this.fRight.getDocument();
        if (lDoc == null || rDoc == null) {
            return;
        }
        this.fAncestor.resetLineBackground();
        this.fLeft.resetLineBackground();
        this.fRight.resetLineBackground();
        this.fCurrentDiff = null;
        try {
            this.fMerger.doDiff();
        }
        catch (CoreException e) {
            CompareUIPlugin.log((IStatus)e.getStatus());
            String title = Utilities.getString((ResourceBundle)this.getResourceBundle(), (String)"tooComplexError.title");
            String format = Utilities.getString((ResourceBundle)this.getResourceBundle(), (String)"tooComplexError.format");
            String msg = MessageFormat.format((String)format, (Object[])new Object[]{Integer.toString(PlatformUI.getWorkbench().getProgressService().getLongOperationTime() / 1000)});
            MessageDialog.openError((Shell)this.fComposite.getShell(), (String)title, (String)msg);
        }
        if (this.fMerger.hasChanges()) {
            Iterator iterator = this.fMerger.changesIterator();
            while (iterator.hasNext()) {
                DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
                this.updateDiffBackground(diff);
            }
        }
        this.invalidateTextPresentation();
    }

    private DocumentMerger.Diff findDiff(char type, int pos) {
        try {
            return this.fMerger.findDiff(type, pos);
        }
        catch (CoreException e) {
            CompareUIPlugin.log((IStatus)e.getStatus());
            String title = Utilities.getString((ResourceBundle)this.getResourceBundle(), (String)"tooComplexError.title");
            String format = Utilities.getString((ResourceBundle)this.getResourceBundle(), (String)"tooComplexError.format");
            String msg = MessageFormat.format((String)format, (Object[])new Object[]{Integer.toString(PlatformUI.getWorkbench().getProgressService().getLongOperationTime() / 1000)});
            MessageDialog.openError((Shell)this.fComposite.getShell(), (String)title, (String)msg);
            return null;
        }
    }

    private void resetPositions(IDocument doc) {
        if (doc == null) {
            return;
        }
        try {
            doc.removePositionCategory(DIFF_RANGE_CATEGORY);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        doc.addPositionCategory(DIFF_RANGE_CATEGORY);
    }

    private void updateControls() {
        IAction a;
        IMergeViewerContentProvider cp;
        boolean leftToRight = false;
        boolean rightToLeft = false;
        this.updateStatus(this.fCurrentDiff);
        this.updateResolveStatus();
        if (this.fCurrentDiff != null && (cp = this.getMergeContentProvider()) != null && !this.isPatchHunk()) {
            rightToLeft = cp.isLeftEditable(this.getInput());
            leftToRight = cp.isRightEditable(this.getInput());
        }
        if (this.fDirectionLabel != null) {
            if (this.fHighlightRanges && this.fCurrentDiff != null && this.isThreeWay() && !this.isIgnoreAncestor()) {
                this.fDirectionLabel.setImage(this.fCurrentDiff.getImage());
            } else {
                this.fDirectionLabel.setImage(null);
            }
        }
        if (this.fCopyDiffLeftToRightItem != null) {
            ((Action)this.fCopyDiffLeftToRightItem.getAction()).setEnabled(leftToRight);
        }
        if (this.fCopyDiffRightToLeftItem != null) {
            ((Action)this.fCopyDiffRightToLeftItem.getAction()).setEnabled(rightToLeft);
        }
        boolean enableNavigation = this.isNavigationPossible();
        if (this.fNextDiff != null) {
            a = this.fNextDiff.getAction();
            a.setEnabled(enableNavigation || this.hasNextElement(true));
        }
        if (this.fPreviousDiff != null) {
            a = this.fPreviousDiff.getAction();
            a.setEnabled(enableNavigation || this.hasNextElement(false));
        }
        if (this.fNextChange != null) {
            a = this.fNextChange.getAction();
            a.setEnabled(enableNavigation);
        }
        if (this.fPreviousChange != null) {
            a = this.fPreviousChange.getAction();
            a.setEnabled(enableNavigation);
        }
    }

    private void updateResolveStatus() {
        RGB rgb = null;
        if (this.showResolveUI()) {
            int incomingOrConflicting = 0;
            int unresolvedIncoming = 0;
            int unresolvedConflicting = 0;
            if (this.fMerger.hasChanges()) {
                Iterator iterator = this.fMerger.changesIterator();
                while (iterator.hasNext()) {
                    DocumentMerger.Diff d = (DocumentMerger.Diff)iterator.next();
                    if (!d.isIncomingOrConflicting()) continue;
                    ++incomingOrConflicting;
                    if (d.isResolved()) continue;
                    if (d.getKind() == 1) {
                        ++unresolvedConflicting;
                        break;
                    }
                    ++unresolvedIncoming;
                }
            }
            if (incomingOrConflicting > 0) {
                rgb = unresolvedConflicting > 0 ? this.SELECTED_CONFLICT : (unresolvedIncoming > 0 ? this.SELECTED_INCOMING : this.RESOLVED);
            }
        }
        if (this.fHeaderPainter.setColor(rgb)) {
            this.fSummaryHeader.redraw();
        }
    }

    private void updateStatus(DocumentMerger.Diff diff) {
        String format;
        String diffDescription;
        if (diff == null) {
            diffDescription = CompareMessages.TextMergeViewer_diffDescription_noDiff_format;
        } else {
            if (diff.isToken()) {
                diff = diff.getParent();
            }
            format = CompareMessages.TextMergeViewer_diffDescription_diff_format;
            diffDescription = MessageFormat.format((String)format, (Object[])new String[]{this.getDiffType(diff), this.getDiffNumber(diff), this.getDiffRange(this.fLeft, diff.getPosition('L')), this.getDiffRange(this.fRight, diff.getPosition('R'))});
        }
        format = CompareMessages.TextMergeViewer_statusLine_format;
        String s = MessageFormat.format((String)format, (Object[])new String[]{this.getCursorPosition(this.fLeft), this.getCursorPosition(this.fRight), diffDescription});
        this.getCompareConfiguration().getContainer().setStatusMessage(s);
    }

    private void clearStatus() {
        this.getCompareConfiguration().getContainer().setStatusMessage(null);
    }

    private String getDiffType(DocumentMerger.Diff diff) {
        String s = "";
        switch (diff.getKind()) {
            case 3: {
                s = CompareMessages.TextMergeViewer_direction_outgoing;
                break;
            }
            case 2: {
                s = CompareMessages.TextMergeViewer_direction_incoming;
                break;
            }
            case 1: {
                s = CompareMessages.TextMergeViewer_direction_conflicting;
            }
        }
        String format = CompareMessages.TextMergeViewer_diffType_format;
        return MessageFormat.format((String)format, (Object[])new String[]{s, diff.changeType()});
    }

    private String getDiffNumber(DocumentMerger.Diff diff) {
        int diffNumber = 0;
        if (this.fMerger.hasChanges()) {
            Iterator iterator = this.fMerger.changesIterator();
            while (iterator.hasNext()) {
                DocumentMerger.Diff d = (DocumentMerger.Diff)iterator.next();
                ++diffNumber;
                if (d == diff) break;
            }
        }
        return Integer.toString(diffNumber);
    }

    private String getDiffRange(MergeSourceViewer v, Position pos) {
        Point p = v.getLineRange(pos, new Point(0, 0));
        int endLine = p.x + p.y;
        int startLine = p.x + 1;
        String format = endLine < startLine ? CompareMessages.TextMergeViewer_beforeLine_format : CompareMessages.TextMergeViewer_range_format;
        return MessageFormat.format((String)format, (Object[])new String[]{Integer.toString(startLine), Integer.toString(endLine)});
    }

    private String getCursorPosition(MergeSourceViewer v) {
        if (v != null) {
            StyledText styledText = v.getTextWidget();
            IDocument document = v.getDocument();
            if (document != null) {
                int offset = v.getVisibleRegion().getOffset();
                int caret = offset + styledText.getCaretOffset();
                try {
                    int line = document.getLineOfOffset(caret);
                    int lineOffset = document.getLineOffset(line);
                    int occurrences = 0;
                    int i = lineOffset;
                    while (i < caret) {
                        if ('\t' == document.getChar(i)) {
                            ++occurrences;
                        }
                        ++i;
                    }
                    int tabWidth = styledText.getTabs();
                    int column = caret - lineOffset + (tabWidth - 1) * occurrences;
                    String format = CompareMessages.TextMergeViewer_cursorPosition_format;
                    return MessageFormat.format((String)format, (Object[])new String[]{Integer.toString(line + 1), Integer.toString(column + 1)});
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return "";
    }

    @Override
    protected void updateHeader() {
        super.updateHeader();
        this.updateControls();
    }

    @Override
    protected void createToolItems(ToolBarManager tbm) {
        this.fHandlerService = CompareHandlerService.createFor((ICompareContainer)this.getCompareConfiguration().getContainer(), (Shell)this.fLeft.getControl().getShell());
        Action ignoreAncestorAction = new Action(){

            public void run() {
                if (!TextMergeViewer.this.isIgnoreAncestor()) {
                    TextMergeViewer.this.getCompareConfiguration().setProperty(ICompareUIConstants.PROP_ANCESTOR_VISIBLE, (Object)Boolean.FALSE);
                }
                TextMergeViewer.this.getCompareConfiguration().setProperty(ICompareUIConstants.PROP_IGNORE_ANCESTOR, (Object)(!TextMergeViewer.this.isIgnoreAncestor() ? 1 : 0));
                Utilities.initToggleAction((IAction)this, (ResourceBundle)TextMergeViewer.this.getResourceBundle(), (String)"action.IgnoreAncestor.", (boolean)TextMergeViewer.this.isIgnoreAncestor());
            }
        };
        ignoreAncestorAction.setChecked(this.isIgnoreAncestor());
        Utilities.initAction((IAction)ignoreAncestorAction, (ResourceBundle)this.getResourceBundle(), (String)"action.IgnoreAncestor.");
        Utilities.initToggleAction((IAction)ignoreAncestorAction, (ResourceBundle)this.getResourceBundle(), (String)"action.IgnoreAncestor.", (boolean)this.isIgnoreAncestor());
        this.fIgnoreAncestorItem = new ActionContributionItem((IAction)ignoreAncestorAction);
        this.fIgnoreAncestorItem.setVisible(false);
        tbm.appendToGroup("modes", (IContributionItem)this.fIgnoreAncestorItem);
        tbm.add((IContributionItem)new Separator());
        Action a = new Action(){

            public void run() {
                if (TextMergeViewer.this.navigate(true, false, false)) {
                    TextMergeViewer.this.endOfDocumentReached(true);
                }
            }
        };
        Utilities.initAction((IAction)a, (ResourceBundle)this.getResourceBundle(), (String)"action.NextDiff.");
        this.fNextDiff = new ActionContributionItem((IAction)a);
        tbm.appendToGroup("navigation", (IContributionItem)this.fNextDiff);
        a = new Action(){

            public void run() {
                if (TextMergeViewer.this.navigate(false, false, false)) {
                    TextMergeViewer.this.endOfDocumentReached(false);
                }
            }
        };
        Utilities.initAction((IAction)a, (ResourceBundle)this.getResourceBundle(), (String)"action.PrevDiff.");
        this.fPreviousDiff = new ActionContributionItem((IAction)a);
        tbm.appendToGroup("navigation", (IContributionItem)this.fPreviousDiff);
        a = new Action(){

            public void run() {
                if (TextMergeViewer.this.navigate(true, false, true)) {
                    TextMergeViewer.this.endOfDocumentReached(true);
                }
            }
        };
        Utilities.initAction((IAction)a, (ResourceBundle)this.getResourceBundle(), (String)"action.NextChange.");
        this.fNextChange = new ActionContributionItem((IAction)a);
        tbm.appendToGroup("navigation", (IContributionItem)this.fNextChange);
        this.fHandlerService.registerAction((IAction)a, "org.eclipse.compare.selectNextChange");
        a = new Action(){

            public void run() {
                if (TextMergeViewer.this.navigate(false, false, true)) {
                    TextMergeViewer.this.endOfDocumentReached(false);
                }
            }
        };
        Utilities.initAction((IAction)a, (ResourceBundle)this.getResourceBundle(), (String)"action.PrevChange.");
        this.fPreviousChange = new ActionContributionItem((IAction)a);
        tbm.appendToGroup("navigation", (IContributionItem)this.fPreviousChange);
        this.fHandlerService.registerAction((IAction)a, "org.eclipse.compare.selectPreviousChange");
        CompareConfiguration cc = this.getCompareConfiguration();
        if (cc.isRightEditable()) {
            a = new Action(){

                public void run() {
                    TextMergeViewer.this.copyDiffLeftToRight();
                }
            };
            Utilities.initAction((IAction)a, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyDiffLeftToRight.");
            this.fCopyDiffLeftToRightItem = new ActionContributionItem((IAction)a);
            this.fCopyDiffLeftToRightItem.setVisible(true);
            tbm.appendToGroup("merge", (IContributionItem)this.fCopyDiffLeftToRightItem);
            this.fHandlerService.registerAction((IAction)a, "org.eclipse.compare.copyLeftToRight");
        }
        if (cc.isLeftEditable()) {
            a = new Action(){

                public void run() {
                    TextMergeViewer.this.copyDiffRightToLeft();
                }
            };
            Utilities.initAction((IAction)a, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyDiffRightToLeft.");
            this.fCopyDiffRightToLeftItem = new ActionContributionItem((IAction)a);
            this.fCopyDiffRightToLeftItem.setVisible(true);
            tbm.appendToGroup("merge", (IContributionItem)this.fCopyDiffRightToLeftItem);
            this.fHandlerService.registerAction((IAction)a, "org.eclipse.compare.copyRightToLeft");
        }
        this.fIgnoreWhitespace = ChangePropertyAction.createIgnoreWhiteSpaceAction((ResourceBundle)this.getResourceBundle(), (CompareConfiguration)this.getCompareConfiguration());
        this.fIgnoreWhitespace.setActionDefinitionId(ICompareUIConstants.COMMAND_IGNORE_WHITESPACE);
        this.fLeft.addTextAction((IAction)this.fIgnoreWhitespace);
        this.fRight.addTextAction((IAction)this.fIgnoreWhitespace);
        this.fAncestor.addTextAction((IAction)this.fIgnoreWhitespace);
        this.fHandlerService.registerAction((IAction)this.fIgnoreWhitespace, this.fIgnoreWhitespace.getActionDefinitionId());
        this.showWhitespaceAction = new ShowWhitespaceAction(new MergeSourceViewer[]{this.fLeft, this.fRight, this.fAncestor});
        this.fHandlerService.registerAction((IAction)this.showWhitespaceAction, "org.eclipse.ui.edit.text.toggleShowWhitespaceCharacters");
        this.toggleLineNumbersAction = new TextEditorPropertyAction(CompareMessages.TextMergeViewer_16, new MergeSourceViewer[]{this.fLeft, this.fRight, this.fAncestor}, "lineNumberRuler");
        this.fHandlerService.registerAction((IAction)this.toggleLineNumbersAction, "org.eclipse.ui.editors.lineNumberToggle");
    }

    @Override
    protected void handlePropertyChangeEvent(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals("IGNORE_WHITESPACE") || key.equals("org.eclipse.compare.ShowPseudoConflicts")) {
            this.fShowPseudoConflicts = this.fPreferenceStore.getBoolean("org.eclipse.compare.ShowPseudoConflicts");
            this.update(true);
            this.selectFirstDiff(true);
        } else if (key.equals("org.eclipse.compare.UseSingleLine")) {
            this.fUseSingleLine = this.fPreferenceStore.getBoolean("org.eclipse.compare.UseSingleLine");
            this.fBasicCenterCurve = null;
            this.updateResolveStatus();
            this.invalidateLines();
        } else if (key.equals("org.eclipse.compare.HighlightTokenChanges")) {
            this.fHighlightTokenChanges = this.fPreferenceStore.getBoolean("org.eclipse.compare.HighlightTokenChanges");
            this.updateResolveStatus();
            this.updatePresentation(null);
        } else if (key.equals(this.fSymbolicFontName)) {
            this.updateFont();
            this.invalidateLines();
        } else if (key.equals(INCOMING_COLOR) || key.equals(OUTGOING_COLOR) || key.equals(CONFLICTING_COLOR) || key.equals(RESOLVED_COLOR)) {
            this.updateColors(null);
            this.invalidateLines();
            this.invalidateTextPresentation();
        } else if (key.equals("org.eclipse.compare.SynchronizeScrolling")) {
            boolean b = this.fPreferenceStore.getBoolean("org.eclipse.compare.SynchronizeScrolling");
            this.setSyncScrolling(b);
        } else {
            super.handlePropertyChangeEvent(event);
            if (key.equals(ICompareUIConstants.PROP_IGNORE_ANCESTOR)) {
                this.update(false);
                this.selectFirstDiff(true);
            }
        }
    }

    private void selectFirstDiff(boolean first) {
        if (this.fLeft == null || this.fRight == null) {
            return;
        }
        if (this.fLeft.getDocument() == null || this.fRight.getDocument() == null) {
            return;
        }
        DocumentMerger.Diff firstDiff = null;
        firstDiff = first ? this.findNext(this.fRight, -1, -1, false) : this.findPrev(this.fRight, 9999999, 9999999, false);
        this.setCurrentDiff(firstDiff, true);
    }

    private void setSyncScrolling(boolean newMode) {
        if (this.fSynchronizedScrolling != newMode) {
            this.fSynchronizedScrolling = newMode;
            this.scrollVertical(0, 0, 0, null);
            Control center = this.getCenterControl();
            if (center != null && !center.isDisposed()) {
                center.dispose();
            }
            this.fLeft.getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
            this.fRight.getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
            this.fComposite.layout(true);
        }
    }

    @Override
    protected void updateToolItems() {
        if (!this.isPatchHunk()) {
            IAction a;
            if (this.fIgnoreAncestorItem != null) {
                this.fIgnoreAncestorItem.setVisible(this.isThreeWay());
            }
            if (this.fCopyDiffLeftToRightItem != null && (a = this.fCopyDiffLeftToRightItem.getAction()) != null) {
                a.setEnabled(a.isEnabled() && !this.fHasErrors);
            }
            if (this.fCopyDiffRightToLeftItem != null && (a = this.fCopyDiffRightToLeftItem.getAction()) != null) {
                a.setEnabled(a.isEnabled() && !this.fHasErrors);
            }
            super.updateToolItems();
        }
    }

    private void updateLines(IDocument d) {
        int l;
        boolean left = false;
        boolean right = false;
        if (d == this.fLeft.getDocument()) {
            l = this.fLeft.getLineCount();
            left = this.fLeftLineCount != l;
            this.fLeftLineCount = l;
        } else if (d == this.fRight.getDocument()) {
            l = this.fRight.getLineCount();
            right = this.fRightLineCount != l;
            this.fRightLineCount = l;
        }
        if (left || right) {
            Control center;
            if (left) {
                if (this.fLeftCanvas != null) {
                    this.fLeftCanvas.redraw();
                }
            } else if (this.fRightCanvas != null) {
                this.fRightCanvas.redraw();
            }
            if ((center = this.getCenterControl()) != null) {
                center.redraw();
            }
            this.updateVScrollBar();
            this.refreshBirdsEyeView();
        }
    }

    private void invalidateLines() {
        if (this.isThreeWay()) {
            if (Utilities.okToUse((Widget)this.fAncestorCanvas)) {
                this.fAncestorCanvas.redraw();
            }
            if (this.fAncestor != null && this.fAncestor.isControlOkToUse()) {
                this.fAncestor.getTextWidget().redraw();
            }
        }
        if (Utilities.okToUse((Widget)this.fLeftCanvas)) {
            this.fLeftCanvas.redraw();
        }
        if (this.fLeft != null && this.fLeft.isControlOkToUse()) {
            this.fLeft.getTextWidget().redraw();
        }
        if (Utilities.okToUse((Widget)this.getCenterControl())) {
            this.getCenterControl().redraw();
        }
        if (this.fRight != null && this.fRight.isControlOkToUse()) {
            this.fRight.getTextWidget().redraw();
        }
        if (Utilities.okToUse((Widget)this.fRightCanvas)) {
            this.fRightCanvas.redraw();
        }
    }

    private boolean showResolveUI() {
        if (!this.fUseResolveUI || !this.isThreeWay() || this.isIgnoreAncestor()) {
            return false;
        }
        CompareConfiguration cc = this.getCompareConfiguration();
        boolean l = cc.isLeftEditable();
        boolean r = cc.isRightEditable();
        return l || r;
    }

    private void paintCenter(Canvas canvas, GC g) {
        Display display = canvas.getDisplay();
        this.checkForColorUpdate(display);
        if (!this.fSynchronizedScrolling) {
            return;
        }
        int lineHeightLeft = this.fLeft.getTextWidget().getLineHeight();
        int lineHeightRight = this.fRight.getTextWidget().getLineHeight();
        int visibleHeight = this.fRight.getViewportHeight();
        Point size = canvas.getSize();
        int x = 0;
        int w = size.x;
        g.setBackground(canvas.getBackground());
        g.fillRectangle(x + 1, 0, w - 2, size.y);
        if (!this.fIsMotif) {
            g.setBackground(display.getSystemColor(18));
            g.fillRectangle(0, 0, 1, size.y);
            g.fillRectangle(w - 1, 0, 1, size.y);
        }
        if (!this.fHighlightRanges) {
            return;
        }
        boolean showResolveUI = this.showResolveUI();
        if (this.fMerger.hasChanges()) {
            int lshift = this.fLeft.getVerticalScrollOffset();
            int rshift = this.fRight.getVerticalScrollOffset();
            Point region = new Point(0, 0);
            Iterator iterator = this.fMerger.changesIterator();
            while (iterator.hasNext()) {
                int i;
                DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                this.fLeft.getLineRange(diff.getPosition('L'), region);
                int ly = region.x * lineHeightLeft + lshift;
                int lh = region.y * lineHeightLeft;
                this.fRight.getLineRange(diff.getPosition('R'), region);
                int ry = region.x * lineHeightRight + rshift;
                int rh = region.y * lineHeightRight;
                if (Math.max(ly + lh, ry + rh) < 0) continue;
                if (Math.min(ly, ry) >= visibleHeight) break;
                this.fPts[0] = x;
                this.fPts[1] = ly;
                this.fPts[2] = w;
                this.fPts[3] = ry;
                this.fPts[6] = x;
                this.fPts[7] = ly + lh;
                this.fPts[4] = w;
                this.fPts[5] = ry + rh;
                Color fillColor = this.getColor(display, this.getFillColor(diff));
                Color strokeColor = this.getColor(display, this.getStrokeColor(diff));
                if (this.fUseSingleLine) {
                    int w2 = 3;
                    g.setBackground(fillColor);
                    g.fillRectangle(0, ly, w2, lh);
                    g.fillRectangle(w - w2, ry, w2, rh);
                    g.setLineWidth(0);
                    g.setForeground(strokeColor);
                    g.drawRectangle(-1, ly, w2, lh);
                    g.drawRectangle(w - w2, ry, w2, rh);
                    if (this.fUseSplines) {
                        int[] points = this.getCenterCurvePoints(w2, ly + lh / 2, w - w2, ry + rh / 2);
                        i = 1;
                        while (i < points.length) {
                            g.drawLine(w2 + i - 1, points[i - 1], w2 + i, points[i]);
                            ++i;
                        }
                    } else {
                        g.drawLine(w2, ly + lh / 2, w - w2, ry + rh / 2);
                    }
                } else if (this.fUseSplines) {
                    g.setBackground(fillColor);
                    g.setLineWidth(0);
                    g.setForeground(strokeColor);
                    int[] topPoints = this.getCenterCurvePoints(this.fPts[0], this.fPts[1], this.fPts[2], this.fPts[3]);
                    int[] bottomPoints = this.getCenterCurvePoints(this.fPts[6], this.fPts[7], this.fPts[4], this.fPts[5]);
                    g.setForeground(fillColor);
                    g.drawLine(0, bottomPoints[0], 0, topPoints[0]);
                    i = 1;
                    while (i < bottomPoints.length) {
                        g.setForeground(fillColor);
                        g.drawLine(i, bottomPoints[i], i, topPoints[i]);
                        g.setForeground(strokeColor);
                        g.drawLine(i - 1, topPoints[i - 1], i, topPoints[i]);
                        g.drawLine(i - 1, bottomPoints[i - 1], i, bottomPoints[i]);
                        ++i;
                    }
                } else {
                    g.setBackground(fillColor);
                    g.fillPolygon(this.fPts);
                    g.setLineWidth(0);
                    g.setForeground(strokeColor);
                    g.drawLine(this.fPts[0], this.fPts[1], this.fPts[2], this.fPts[3]);
                    g.drawLine(this.fPts[6], this.fPts[7], this.fPts[4], this.fPts[5]);
                }
                if (!this.fUseSingleLine || !showResolveUI || !diff.isUnresolvedIncomingOrConflicting()) continue;
                int cx = (w - 5) / 2;
                int cy = (ly + lh / 2 + (ry + rh / 2) - 5) / 2;
                g.setBackground(fillColor);
                g.fillRectangle(cx, cy, 5, 5);
                g.setForeground(strokeColor);
                g.drawRectangle(cx, cy, 5, 5);
            }
        }
    }

    private int[] getCenterCurvePoints(int startx, int starty, int endx, int endy) {
        if (this.fBasicCenterCurve == null) {
            this.buildBaseCenterCurve(endx - startx);
        }
        double height = endy - starty;
        height /= 2.0;
        int width = endx - startx;
        int[] points = new int[width];
        int i = 0;
        while (i < width) {
            points[i] = (int)(-height * this.fBasicCenterCurve[i] + height + (double)starty);
            ++i;
        }
        return points;
    }

    private void buildBaseCenterCurve(int w) {
        double width = w;
        this.fBasicCenterCurve = new double[this.getCenterWidth()];
        int i = 0;
        while (i < this.getCenterWidth()) {
            double r = (double)i / width;
            this.fBasicCenterCurve[i] = Math.cos(Math.PI * r);
            ++i;
        }
    }

    private void paintSides(GC g, MergeSourceViewer tp, Canvas canvas, boolean right) {
        Display display = canvas.getDisplay();
        int lineHeight = tp.getTextWidget().getLineHeight();
        int visibleHeight = tp.getViewportHeight();
        Point size = canvas.getSize();
        int x = 0;
        int w = this.fMarginWidth;
        int w2 = w / 2;
        g.setBackground(canvas.getBackground());
        g.fillRectangle(x, 0, w, size.y);
        if (!this.fIsMotif) {
            g.setBackground(display.getSystemColor(18));
            if (right) {
                g.fillRectangle(0, 0, 1, size.y);
            } else {
                g.fillRectangle(size.x - 1, 0, 1, size.y);
            }
        }
        if (!this.fHighlightRanges) {
            return;
        }
        if (this.fMerger.hasChanges()) {
            int shift = tp.getVerticalScrollOffset() + 1;
            Point region = new Point(0, 0);
            char leg = this.getLeg(tp);
            Iterator iterator = this.fMerger.changesIterator();
            while (iterator.hasNext()) {
                DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                tp.getLineRange(diff.getPosition(leg), region);
                int y = region.x * lineHeight + shift;
                int h = region.y * lineHeight;
                if (y + h < 0) continue;
                if (y >= visibleHeight) break;
                g.setBackground(this.getColor(display, this.getFillColor(diff)));
                if (right) {
                    g.fillRectangle(x, y, w2, h);
                } else {
                    g.fillRectangle(x + w2, y, w2, h);
                }
                g.setLineWidth(0);
                g.setForeground(this.getColor(display, this.getStrokeColor(diff)));
                if (right) {
                    g.drawRectangle(x - 1, y - 1, w2, h);
                    continue;
                }
                g.drawRectangle(x + w2, y - 1, w2, h);
            }
        }
    }

    private void paint(PaintEvent event, MergeSourceViewer tp) {
        if (!this.fHighlightRanges) {
            return;
        }
        if (!this.fMerger.hasChanges()) {
            return;
        }
        Control canvas = (Control)event.widget;
        GC g = event.gc;
        Display display = canvas.getDisplay();
        int lineHeight = tp.getTextWidget().getLineHeight();
        int w = canvas.getSize().x;
        int shift = tp.getVerticalScrollOffset() + 1;
        int maxh = event.y + event.height;
        shift += this.fTopInset;
        Point range = new Point(0, 0);
        char leg = this.getLeg(tp);
        Iterator iterator = this.fMerger.changesIterator();
        while (iterator.hasNext()) {
            DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
            if (diff.isDeleted() || this.fShowCurrentOnly && !this.isCurrentDiff(diff)) continue;
            tp.getLineRange(diff.getPosition(leg), range);
            int y = range.x * lineHeight + shift;
            int h = range.y * lineHeight;
            if (y + h < event.y) continue;
            if (y > maxh) break;
            g.setBackground(this.getColor(display, this.getStrokeColor(diff)));
            g.fillRectangle(0, y - 1, w, 1);
            g.fillRectangle(0, y + h - 1, w, 1);
        }
    }

    private RGB getFillColor(DocumentMerger.Diff diff) {
        boolean selected = this.fCurrentDiff != null && this.fCurrentDiff.getParent() == diff;
        RGB selected_fill = this.getBackground(null);
        if (this.isThreeWay() && !this.isIgnoreAncestor()) {
            switch (diff.getKind()) {
                case 2: {
                    if (this.fLeftIsLocal) {
                        return selected ? selected_fill : this.INCOMING_FILL;
                    }
                    return selected ? selected_fill : this.OUTGOING_FILL;
                }
                case 4: {
                    return selected ? selected_fill : this.CONFLICT_FILL;
                }
                case 3: {
                    if (this.fLeftIsLocal) {
                        return selected ? selected_fill : this.OUTGOING_FILL;
                    }
                    return selected ? selected_fill : this.INCOMING_FILL;
                }
                case 1: {
                    return selected ? selected_fill : this.CONFLICT_FILL;
                }
            }
            return null;
        }
        return selected ? selected_fill : this.OUTGOING_FILL;
    }

    private RGB getStrokeColor(DocumentMerger.Diff diff) {
        boolean selected;
        boolean bl = selected = this.fCurrentDiff != null && this.fCurrentDiff.getParent() == diff;
        if (this.isThreeWay() && !this.isIgnoreAncestor()) {
            switch (diff.getKind()) {
                case 2: {
                    if (this.fLeftIsLocal) {
                        return selected ? this.SELECTED_INCOMING : this.INCOMING;
                    }
                    return selected ? this.SELECTED_OUTGOING : this.OUTGOING;
                }
                case 4: {
                    return selected ? this.SELECTED_CONFLICT : this.CONFLICT;
                }
                case 3: {
                    if (this.fLeftIsLocal) {
                        return selected ? this.SELECTED_OUTGOING : this.OUTGOING;
                    }
                    return selected ? this.SELECTED_INCOMING : this.INCOMING;
                }
                case 1: {
                    return selected ? this.SELECTED_CONFLICT : this.CONFLICT;
                }
            }
            return null;
        }
        return selected ? this.SELECTED_OUTGOING : this.OUTGOING;
    }

    private Color getColor(Display display, RGB rgb) {
        Color c;
        if (rgb == null) {
            return null;
        }
        if (this.fColors == null) {
            this.fColors = new HashMap(20);
        }
        if ((c = (Color)this.fColors.get(rgb)) == null) {
            c = new Color((Device)display, rgb);
            this.fColors.put(rgb, c);
        }
        return c;
    }

    static RGB interpolate(RGB fg, RGB bg, double scale) {
        if (fg != null && bg != null) {
            return new RGB((int)((1.0 - scale) * (double)fg.red + scale * (double)bg.red), (int)((1.0 - scale) * (double)fg.green + scale * (double)bg.green), (int)((1.0 - scale) * (double)fg.blue + scale * (double)bg.blue));
        }
        if (fg != null) {
            return fg;
        }
        if (bg != null) {
            return bg;
        }
        return new RGB(128, 128, 128);
    }

    private DocumentMerger.Diff getNextVisibleDiff(boolean down, boolean deep) {
        DocumentMerger.Diff diff = null;
        MergeSourceViewer part = this.getNavigationPart();
        if (part == null) {
            return null;
        }
        Point s = part.getSelectedRange();
        char leg = this.getLeg(part);
        while (true) {
            diff = null;
            diff = this.internalGetNextDiff(down, deep, part, s);
            if (diff == null || diff.getKind() != 4 || this.isAncestorVisible()) break;
            Position position = diff.getPosition(leg);
            s = new Point(position.getOffset(), position.getLength());
            diff = null;
        }
        return diff;
    }

    private DocumentMerger.Diff internalGetNextDiff(boolean down, boolean deep, MergeSourceViewer part, Point s) {
        if (this.fMerger.hasChanges()) {
            if (down) {
                return this.findNext(part, s.x, s.x + s.y, deep);
            }
            return this.findPrev(part, s.x, s.x + s.y, deep);
        }
        return null;
    }

    private MergeSourceViewer getNavigationPart() {
        MergeSourceViewer part = this.fFocusPart;
        if (part == null) {
            part = this.fRight;
        }
        return part;
    }

    private DocumentMerger.Diff getWrappedDiff(DocumentMerger.Diff diff, boolean down) {
        return this.fMerger.getWrappedDiff(diff, down);
    }

    private boolean navigate(boolean down, boolean wrap, boolean deep) {
        DocumentMerger.Diff diff = null;
        boolean wrapped = false;
        do {
            if ((diff = this.getNextVisibleDiff(down, deep)) == null && wrap) {
                if (wrapped) break;
                wrapped = true;
                diff = this.getWrappedDiff(null, down);
            }
            if (diff == null) continue;
            this.setCurrentDiff(diff, true, deep);
        } while (diff != null && diff.getKind() == 4 && !this.isAncestorVisible());
        return diff == null;
    }

    private void endOfDocumentReached(boolean down) {
        Control c = this.getControl();
        if (Utilities.okToUse((Widget)c)) {
            this.handleEndOfDocumentReached(c.getShell(), down);
        }
    }

    private void handleEndOfDocumentReached(Shell shell, boolean next) {
        boolean hasNextElement = this.hasNextElement(next);
        IPreferenceStore store = CompareUIPlugin.getDefault().getPreferenceStore();
        String value = store.getString(ICompareUIConstants.PREF_NAVIGATION_END_ACTION);
        if (!value.equals("prompt") && (hasNextElement || store.getString(ICompareUIConstants.PREF_NAVIGATION_END_ACTION).equals("loop"))) {
            this.performEndOfDocumentAction(shell, store, ICompareUIConstants.PREF_NAVIGATION_END_ACTION, next);
            return;
        }
        shell.getDisplay().beep();
        if (hasNextElement) {
            String nextMessage;
            String loopMessage;
            String message;
            String title;
            if (next) {
                title = CompareMessages.TextMergeViewer_0;
                message = CompareMessages.TextMergeViewer_1;
                loopMessage = CompareMessages.TextMergeViewer_2;
                nextMessage = CompareMessages.TextMergeViewer_3;
            } else {
                title = CompareMessages.TextMergeViewer_4;
                message = CompareMessages.TextMergeViewer_5;
                loopMessage = CompareMessages.TextMergeViewer_6;
                nextMessage = CompareMessages.TextMergeViewer_7;
            }
            String[] localLoopOption = new String[]{loopMessage, "loop"};
            String[] nextElementOption = new String[]{nextMessage, "next"};
            NavigationEndDialog dialog = new NavigationEndDialog(shell, title, null, message, (String[][])new String[][]{localLoopOption, nextElementOption});
            int result = dialog.open();
            if (result == 0) {
                this.performEndOfDocumentAction(shell, store, ICompareUIConstants.PREF_NAVIGATION_END_ACTION_LOCAL, next);
                if (dialog.getToggleState()) {
                    store.putValue(ICompareUIConstants.PREF_NAVIGATION_END_ACTION, store.getString(ICompareUIConstants.PREF_NAVIGATION_END_ACTION_LOCAL));
                }
            }
        } else {
            String message;
            String title;
            if (next) {
                title = CompareMessages.TextMergeViewer_8;
                message = CompareMessages.TextMergeViewer_9;
            } else {
                title = CompareMessages.TextMergeViewer_10;
                message = CompareMessages.TextMergeViewer_11;
            }
            if (MessageDialog.openQuestion((Shell)shell, (String)title, (String)message)) {
                this.selectFirstDiff(next);
            }
        }
    }

    private void performEndOfDocumentAction(Shell shell, IPreferenceStore store, String key, boolean next) {
        String value = store.getString(key);
        if (value.equals("next")) {
            ICompareNavigator navigator = this.getCompareConfiguration().getContainer().getNavigator();
            if (this.hasNextElement(next)) {
                navigator.selectChange(next);
            } else {
                shell.getDisplay().beep();
            }
        } else {
            this.selectFirstDiff(next);
        }
    }

    private boolean hasNextElement(boolean down) {
        ICompareNavigator navigator = this.getCompareConfiguration().getContainer().getNavigator();
        if (navigator instanceof CompareNavigator) {
            CompareNavigator n = (CompareNavigator)navigator;
            return n.hasChange(down);
        }
        return false;
    }

    private DocumentMerger.Diff findDiff(MergeSourceViewer tp, int rangeStart, int rangeEnd) {
        char contributor = this.getLeg(tp);
        return this.fMerger.findDiff(contributor, rangeStart, rangeEnd);
    }

    private DocumentMerger.Diff findNext(MergeSourceViewer tp, int start, int end, boolean deep) {
        return this.fMerger.findNext(this.getLeg(tp), start, end, deep);
    }

    private DocumentMerger.Diff findPrev(MergeSourceViewer tp, int start, int end, boolean deep) {
        return this.fMerger.findPrev(this.getLeg(tp), start, end, deep);
    }

    private void setCurrentDiff(DocumentMerger.Diff d, boolean revealAndSelect) {
        this.setCurrentDiff(d, revealAndSelect, false);
    }

    private void setCurrentDiff(DocumentMerger.Diff d, boolean revealAndSelect, boolean deep) {
        DocumentMerger.Diff d2;
        if (this.fCenterButton != null && !this.fCenterButton.isDisposed()) {
            this.fCenterButton.setVisible(false);
        }
        DocumentMerger.Diff oldDiff = this.fCurrentDiff;
        if (d != null && revealAndSelect) {
            if (d.isToken() || !this.fHighlightTokenChanges || deep || !d.hasChildren()) {
                if (this.isThreeWay() && !this.isIgnoreAncestor()) {
                    this.fAncestor.setSelection(d.getPosition('A'));
                }
                this.fLeft.setSelection(d.getPosition('L'));
                this.fRight.setSelection(d.getPosition('R'));
            } else {
                if (this.isThreeWay() && !this.isIgnoreAncestor()) {
                    this.fAncestor.setSelection(new Position(d.getPosition((char)'A').offset, 0));
                }
                this.fLeft.setSelection(new Position(d.getPosition((char)'L').offset, 0));
                this.fRight.setSelection(new Position(d.getPosition((char)'R').offset, 0));
            }
            this.fCurrentDiff = d;
            this.revealDiff(d, d.isToken());
        } else {
            this.fCurrentDiff = d;
        }
        DocumentMerger.Diff d1 = oldDiff != null ? oldDiff.getParent() : null;
        DocumentMerger.Diff diff = d2 = this.fCurrentDiff != null ? this.fCurrentDiff.getParent() : null;
        if (d1 != d2) {
            this.updateDiffBackground(d1);
            this.updateDiffBackground(d2);
        }
        this.updateControls();
        this.invalidateLines();
        this.refreshBirdsEyeView();
    }

    private void revealDiff(DocumentMerger.Diff d, boolean smart) {
        boolean ancestorIsVisible = false;
        boolean leftIsVisible = false;
        boolean rightIsVisible = false;
        if (smart) {
            int as;
            Point region = new Point(0, 0);
            int ls = this.fLeft.getLineRange((Position)d.getPosition((char)'L'), (Point)region).x;
            int rs = this.fRight.getLineRange((Position)d.getPosition((char)'R'), (Point)region).x;
            if (this.isThreeWay() && !this.isIgnoreAncestor() && (as = this.fAncestor.getLineRange((Position)d.getPosition((char)'A'), (Point)region).x) >= this.fAncestor.getTopIndex() && as <= this.fAncestor.getBottomIndex()) {
                ancestorIsVisible = true;
            }
            if (ls >= this.fLeft.getTopIndex() && ls <= this.fLeft.getBottomIndex()) {
                leftIsVisible = true;
            }
            if (rs >= this.fRight.getTopIndex() && rs <= this.fRight.getBottomIndex()) {
                rightIsVisible = true;
            }
        }
        if (!leftIsVisible || !rightIsVisible) {
            int avpos = 0;
            int lvpos = 0;
            int rvpos = 0;
            MergeSourceViewer allButThis = null;
            if (leftIsVisible) {
                lvpos = rvpos = this.realToVirtualPosition('L', this.fLeft.getTopIndex());
                avpos = rvpos;
                allButThis = this.fLeft;
            } else if (rightIsVisible) {
                lvpos = rvpos = this.realToVirtualPosition('R', this.fRight.getTopIndex());
                avpos = rvpos;
                allButThis = this.fRight;
            } else if (ancestorIsVisible) {
                lvpos = rvpos = this.realToVirtualPosition('A', this.fAncestor.getTopIndex());
                avpos = rvpos;
                allButThis = this.fAncestor;
            } else {
                int delta;
                int vpos = 0;
                Iterator iterator = this.fMerger.rangesIterator();
                while (iterator.hasNext()) {
                    DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
                    if (diff == d) break;
                    if (this.fSynchronizedScrolling) {
                        vpos += diff.getMaxDiffHeight();
                        continue;
                    }
                    avpos += diff.getAncestorHeight();
                    lvpos += diff.getLeftHeight();
                    rvpos += diff.getRightHeight();
                }
                if (this.fSynchronizedScrolling) {
                    lvpos = rvpos = vpos;
                    avpos = rvpos;
                }
                if ((avpos -= (delta = this.fRight.getViewportLines() / 4)) < 0) {
                    avpos = 0;
                }
                if ((lvpos -= delta) < 0) {
                    lvpos = 0;
                }
                if ((rvpos -= delta) < 0) {
                    rvpos = 0;
                }
            }
            this.scrollVertical(avpos, lvpos, rvpos, allButThis);
            if (this.fVScrollBar != null) {
                this.fVScrollBar.setSelection(avpos);
            }
        }
        if (d.isToken()) {
            TextMergeViewer.reveal(this.fAncestor, d.getPosition('A'));
            TextMergeViewer.reveal(this.fLeft, d.getPosition('L'));
            TextMergeViewer.reveal(this.fRight, d.getPosition('R'));
        } else {
            TextMergeViewer.hscroll(this.fAncestor);
            TextMergeViewer.hscroll(this.fLeft);
            TextMergeViewer.hscroll(this.fRight);
        }
    }

    private static void reveal(MergeSourceViewer v, Position p) {
        Rectangle r;
        StyledText st;
        if (v != null && p != null && (st = v.getTextWidget()) != null && !(r = st.getClientArea()).isEmpty()) {
            v.revealRange(p.offset, p.length);
        }
    }

    private static void hscroll(MergeSourceViewer v) {
        StyledText st;
        if (v != null && (st = v.getTextWidget()) != null) {
            st.setHorizontalIndex(0);
        }
    }

    void copyAllUnresolved(boolean leftToRight) {
        if (this.fMerger.hasChanges() && this.isThreeWay() && !this.isIgnoreAncestor()) {
            IRewriteTarget target = leftToRight ? this.fRight.getRewriteTarget() : this.fLeft.getRewriteTarget();
            boolean compoundChangeStarted = false;
            try {
                Iterator iterator = this.fMerger.changesIterator();
                while (iterator.hasNext()) {
                    DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
                    switch (diff.getKind()) {
                        case 3: {
                            if (!leftToRight) break;
                            if (!compoundChangeStarted) {
                                target.beginCompoundChange();
                                compoundChangeStarted = true;
                            }
                            this.copy(diff, leftToRight);
                            break;
                        }
                        case 2: {
                            if (leftToRight) break;
                            if (!compoundChangeStarted) {
                                target.beginCompoundChange();
                                compoundChangeStarted = true;
                            }
                            this.copy(diff, leftToRight);
                            break;
                        }
                    }
                }
            }
            finally {
                if (compoundChangeStarted) {
                    target.endCompoundChange();
                }
            }
        }
    }

    @Override
    protected void copy(boolean leftToRight) {
        if (!this.validateChange(!leftToRight)) {
            return;
        }
        if (this.showResolveUI()) {
            this.copyAllUnresolved(leftToRight);
            this.invalidateLines();
            return;
        }
        if (leftToRight) {
            if (this.fLeft.getEnabled()) {
                String text = this.fLeft.getTextWidget().getText();
                this.fRight.getTextWidget().setText(text);
                this.fRight.setEnabled(true);
            } else {
                this.fRight.getTextWidget().setText("");
                this.fRight.setEnabled(false);
            }
            this.fRightLineCount = this.fRight.getLineCount();
            this.setRightDirty(true);
        } else {
            if (this.fRight.getEnabled()) {
                String text = this.fRight.getTextWidget().getText();
                this.fLeft.getTextWidget().setText(text);
                this.fLeft.setEnabled(true);
            } else {
                this.fLeft.getTextWidget().setText("");
                this.fLeft.setEnabled(false);
            }
            this.fLeftLineCount = this.fLeft.getLineCount();
            this.setLeftDirty(true);
        }
        this.update(false);
        this.selectFirstDiff(true);
    }

    private void copyDiffLeftToRight() {
        this.copy(this.fCurrentDiff, true, false);
    }

    private void copyDiffRightToLeft() {
        this.copy(this.fCurrentDiff, false, false);
    }

    private void copy(DocumentMerger.Diff diff, boolean leftToRight, boolean gotoNext) {
        if (this.copy(diff, leftToRight)) {
            if (gotoNext) {
                this.navigate(true, true, false);
            } else {
                this.revealDiff(diff, true);
                this.updateControls();
            }
        }
    }

    private boolean copy(DocumentMerger.Diff diff, boolean leftToRight) {
        if (diff != null && !diff.isResolved()) {
            if (!this.validateChange(!leftToRight)) {
                return false;
            }
            if (leftToRight) {
                this.fRight.setEnabled(true);
            } else {
                this.fLeft.setEnabled(true);
            }
            boolean result = this.fMerger.copy(diff, leftToRight);
            if (result) {
                this.updateResolveStatus();
            }
            return result;
        }
        return false;
    }

    private boolean validateChange(boolean left) {
        ContributorInfo info = left ? this.fLeftContributor : this.fRightContributor;
        return info.validateChange();
    }

    private int getViewportHeight() {
        StyledText te = this.fLeft.getTextWidget();
        int vh = te.getClientArea().height;
        if (vh == 0) {
            Rectangle trim = te.computeTrim(0, 0, 0, 0);
            int scrollbarHeight = trim.height;
            int headerHeight = this.getHeaderHeight();
            Composite composite = (Composite)this.getControl();
            Rectangle r = composite.getClientArea();
            vh = r.height - headerHeight - scrollbarHeight;
        }
        return vh / te.getLineHeight();
    }

    private int realToVirtualPosition(char contributor, int vpos) {
        if (!this.fSynchronizedScrolling) {
            return vpos;
        }
        return this.fMerger.realToVirtualPosition(contributor, vpos);
    }

    private void scrollVertical(int avpos, int lvpos, int rvpos, MergeSourceViewer allBut) {
        Control center;
        int y;
        int s = 0;
        if (this.fSynchronizedScrolling) {
            s = this.fMerger.getVirtualHeight() - rvpos;
            int height = this.fRight.getViewportLines() / 4;
            if (s < 0) {
                s = 0;
            }
            if (s > height) {
                s = height;
            }
        }
        this.fInScrolling = true;
        if (this.isThreeWay() && allBut != this.fAncestor && (this.fSynchronizedScrolling || allBut == null)) {
            y = this.virtualToRealPosition('A', avpos + s) - s;
            this.fAncestor.vscroll(y);
        }
        if (allBut != this.fLeft && (this.fSynchronizedScrolling || allBut == null)) {
            y = this.virtualToRealPosition('L', lvpos + s) - s;
            this.fLeft.vscroll(y);
        }
        if (allBut != this.fRight && (this.fSynchronizedScrolling || allBut == null)) {
            y = this.virtualToRealPosition('R', rvpos + s) - s;
            this.fRight.vscroll(y);
        }
        this.fInScrolling = false;
        if (this.isThreeWay() && this.fAncestorCanvas != null) {
            this.fAncestorCanvas.repaint();
        }
        if (this.fLeftCanvas != null) {
            this.fLeftCanvas.repaint();
        }
        if ((center = this.getCenterControl()) instanceof BufferedCanvas) {
            ((BufferedCanvas)center).repaint();
        }
        if (this.fRightCanvas != null) {
            this.fRightCanvas.repaint();
        }
    }

    private void syncViewport(MergeSourceViewer w) {
        if (this.fInScrolling) {
            return;
        }
        int ix = w.getTopIndex();
        int ix2 = w.getDocumentRegionOffset();
        int viewPosition = this.realToVirtualPosition(this.getLeg(w), ix - ix2);
        this.scrollVertical(viewPosition, viewPosition, viewPosition, w);
        if (this.fVScrollBar != null) {
            int value = Math.max(0, Math.min(viewPosition, this.fMerger.getVirtualHeight() - this.getViewportHeight()));
            this.fVScrollBar.setSelection(value);
        }
    }

    private void updateVScrollBar() {
        if (Utilities.okToUse((Widget)this.fVScrollBar) && this.fSynchronizedScrolling) {
            int virtualHeight = this.fMerger.getVirtualHeight();
            int viewPortHeight = this.getViewportHeight();
            int pageIncrement = viewPortHeight - 1;
            int thumb = viewPortHeight > virtualHeight ? virtualHeight : viewPortHeight;
            this.fVScrollBar.setPageIncrement(pageIncrement);
            this.fVScrollBar.setMaximum(virtualHeight);
            this.fVScrollBar.setThumb(thumb);
        }
    }

    private int virtualToRealPosition(char contributor, int v) {
        if (!this.fSynchronizedScrolling) {
            return v;
        }
        return this.fMerger.virtualToRealPosition(contributor, v);
    }

    @Override
    protected void flushContentOld(Object oldInput, IProgressMonitor monitor) {
        IMergeViewerContentProvider content = this.getMergeContentProvider();
        Object leftContent = content.getLeftContent(oldInput);
        Object rightContent = content.getRightContent(oldInput);
        if (leftContent != null && this.getCompareConfiguration().isLeftEditable() && this.isLeftDirty() && this.fLeftContributor.hasSharedDocument(leftContent) && this.flush(this.fLeftContributor)) {
            this.setLeftDirty(false);
        }
        if (rightContent != null && this.getCompareConfiguration().isRightEditable() && this.isRightDirty() && this.fRightContributor.hasSharedDocument(rightContent) && this.flush(this.fRightContributor)) {
            this.setRightDirty(false);
        }
        if (!(content instanceof MergeViewerContentProvider) || this.isLeftDirty() || this.isRightDirty()) {
            super.flushContent(oldInput, monitor);
        }
    }

    @Override
    protected void flushContent(Object oldInput, IProgressMonitor monitor) {
        this.flushLeftSide(oldInput, monitor);
        this.flushRightSide(oldInput, monitor);
        IMergeViewerContentProvider content = this.getMergeContentProvider();
        if (!(content instanceof MergeViewerContentProvider) || this.isLeftDirty() || this.isRightDirty()) {
            super.flushContent(oldInput, monitor);
        }
    }

    private boolean flush(ContributorInfo info) {
        try {
            return info.flush();
        }
        catch (CoreException e) {
            this.handleException(e);
            return false;
        }
    }

    private void handleException(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            InvocationTargetException ite = (InvocationTargetException)throwable;
            this.handleException(ite.getTargetException());
            return;
        }
        CompareUIPlugin.log((Throwable)throwable);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IMergeViewerTestAdapter.class) {
            return new IMergeViewerTestAdapter(){

                public IDocument getDocument(char leg) {
                    switch (leg) {
                        case 'L': {
                            return TextMergeViewer.this.fLeft.getDocument();
                        }
                        case 'R': {
                            return TextMergeViewer.this.fRight.getDocument();
                        }
                        case 'A': {
                            return TextMergeViewer.this.fAncestor.getDocument();
                        }
                    }
                    return null;
                }

                public int getChangesCount() {
                    return 0;
                }
            };
        }
        if (adapter == OutlineViewerCreator.class) {
            if (this.fOutlineViewerCreator == null) {
                this.fOutlineViewerCreator = new InternalOutlineViewerCreator();
            }
            return this.fOutlineViewerCreator;
        }
        if (adapter == IFindReplaceTarget.class) {
            return this.getFindReplaceTarget();
        }
        if (adapter == CompareHandlerService.class) {
            return this.fHandlerService;
        }
        return null;
    }

    @Override
    protected void handleCompareInputChange() {
        try {
            this.beginRefresh();
            super.handleCompareInputChange();
        }
        finally {
            this.endRefresh();
        }
    }

    private void beginRefresh() {
        this.isRefreshing = true;
        this.fLeftContributor.cacheSelection(this.fLeft);
        this.fRightContributor.cacheSelection(this.fRight);
        this.fAncestorContributor.cacheSelection(this.fAncestor);
        if (this.fSynchronizedScrolling) {
            this.fSynchronziedScrollPosition = this.fVScrollBar.getSelection();
        }
    }

    private void endRefresh() {
        this.isRefreshing = false;
        this.fLeftContributor.cacheSelection(null);
        this.fRightContributor.cacheSelection(null);
        this.fAncestorContributor.cacheSelection(null);
        this.fSynchronziedScrollPosition = -1;
    }

    private void synchronizedScrollVertical(int vpos) {
        this.scrollVertical(vpos, vpos, vpos, null);
        this.workaround65205();
    }

    private boolean isIgnoreAncestor() {
        return Utilities.getBoolean((CompareConfiguration)this.getCompareConfiguration(), (String)ICompareUIConstants.PROP_IGNORE_ANCESTOR, (boolean)false);
    }

    void update(boolean includeControls) {
        if (this.getControl().isDisposed()) {
            return;
        }
        if (this.fHasErrors) {
            this.resetDiffs();
        } else {
            this.doDiff();
        }
        if (includeControls) {
            this.updateControls();
        }
        this.updateVScrollBar();
        this.updatePresentation(null);
    }

    private void resetDiffs() {
        this.fCurrentDiff = null;
        this.fMerger.reset();
        this.resetPositions(this.fLeft.getDocument());
        this.resetPositions(this.fRight.getDocument());
        this.resetPositions(this.fAncestor.getDocument());
    }

    private boolean isPatchHunk() {
        return Utilities.isHunk((Object)this.getInput());
    }

    private boolean isPatchHunkOk() {
        if (this.isPatchHunk()) {
            return Utilities.isHunkOk((Object)this.getInput());
        }
        return false;
    }

    private int getHunkStart() {
        Object input = this.getInput();
        if (input != null && input instanceof DiffNode) {
            Object element;
            Object element2;
            ITypedElement right = ((DiffNode)input).getRight();
            if (right != null && (element2 = Utilities.getAdapter((Object)right, IHunk.class)) instanceof IHunk) {
                return ((IHunk)element2).getStartPosition();
            }
            ITypedElement left = ((DiffNode)input).getLeft();
            if (left != null && (element = Utilities.getAdapter((Object)left, IHunk.class)) instanceof IHunk) {
                return ((IHunk)element).getStartPosition();
            }
        }
        return 0;
    }

    private IFindReplaceTarget getFindReplaceTarget() {
        if (this.fFindReplaceTarget == null) {
            this.fFindReplaceTarget = new FindReplaceTarget();
        }
        return this.fFindReplaceTarget;
    }

    char getLeg(MergeSourceViewer w) {
        if (w == this.fLeft) {
            return 'L';
        }
        if (w == this.fRight) {
            return 'R';
        }
        if (w == this.fAncestor) {
            return 'A';
        }
        return 'A';
    }

    private boolean isCurrentDiff(DocumentMerger.Diff diff) {
        if (diff == null) {
            return false;
        }
        if (diff == this.fCurrentDiff) {
            return true;
        }
        return this.fCurrentDiff != null && this.fCurrentDiff.getParent() == diff;
    }

    private boolean isNavigationPossible() {
        if (this.fCurrentDiff == null && this.fMerger.hasChanges()) {
            return true;
        }
        if (this.fMerger.changesCount() > 1) {
            return true;
        }
        if (this.fCurrentDiff != null && this.fCurrentDiff.hasChildren()) {
            return true;
        }
        return this.fCurrentDiff != null && this.fCurrentDiff.isToken();
    }

    @Override
    void flushLeftSide(Object oldInput, IProgressMonitor monitor) {
        IMergeViewerContentProvider content = this.getMergeContentProvider();
        Object leftContent = content.getLeftContent(oldInput);
        if (leftContent != null && this.getCompareConfiguration().isLeftEditable() && this.isLeftDirty() && this.fLeftContributor.hasSharedDocument(leftContent) && this.flush(this.fLeftContributor)) {
            this.setLeftDirty(false);
        }
        if (!(content instanceof MergeViewerContentProvider) || this.isLeftDirty()) {
            super.flushLeftSide(oldInput, monitor);
        }
    }

    @Override
    void flushRightSide(Object oldInput, IProgressMonitor monitor) {
        IMergeViewerContentProvider content = this.getMergeContentProvider();
        Object rightContent = content.getRightContent(oldInput);
        if (rightContent != null && this.getCompareConfiguration().isRightEditable() && this.isRightDirty() && this.fRightContributor.hasSharedDocument(rightContent) && this.flush(this.fRightContributor)) {
            this.setRightDirty(false);
        }
        if (!(content instanceof MergeViewerContentProvider) || this.isRightDirty()) {
            super.flushRightSide(oldInput, monitor);
        }
    }

    private class ChangeHighlighter
    implements ITextPresentationListener {
        private final MergeSourceViewer viewer;

        public ChangeHighlighter(MergeSourceViewer viewer) {
            this.viewer = viewer;
        }

        public void applyTextPresentation(TextPresentation textPresentation) {
            if (!TextMergeViewer.this.fHighlightTokenChanges) {
                return;
            }
            IRegion region = textPresentation.getExtent();
            DocumentMerger.Diff[] changeDiffs = TextMergeViewer.this.fMerger.getChangeDiffs(TextMergeViewer.this.getLeg(this.viewer), region);
            int i = 0;
            while (i < changeDiffs.length) {
                DocumentMerger.Diff diff = changeDiffs[i];
                StyleRange range = this.getStyleRange(diff, region);
                if (range != null) {
                    textPresentation.mergeStyleRange(range);
                }
                ++i;
            }
        }

        private StyleRange getStyleRange(DocumentMerger.Diff diff, IRegion region) {
            int regionEnd;
            Color cTextFill = TextMergeViewer.this.getColor(null, this.getTextFillColor(diff));
            if (cTextFill == null) {
                return null;
            }
            Position p = diff.getPosition(TextMergeViewer.this.getLeg(this.viewer));
            int start = p.getOffset();
            int length = p.getLength();
            if (start < region.getOffset()) {
                length -= region.getOffset() - start;
                start = region.getOffset();
            }
            if (start + length > (regionEnd = region.getOffset() + region.getLength())) {
                length = regionEnd - start;
            }
            if (length < 0) {
                return null;
            }
            return new StyleRange(start, length, null, cTextFill);
        }

        private RGB getTextFillColor(DocumentMerger.Diff diff) {
            if (TextMergeViewer.this.isThreeWay() && !TextMergeViewer.this.isIgnoreAncestor()) {
                switch (diff.getKind()) {
                    case 2: {
                        if (TextMergeViewer.this.fLeftIsLocal) {
                            return TextMergeViewer.this.INCOMING_TEXT_FILL;
                        }
                        return TextMergeViewer.this.OUTGOING_TEXT_FILL;
                    }
                    case 4: {
                        return TextMergeViewer.this.CONFLICT_TEXT_FILL;
                    }
                    case 3: {
                        if (TextMergeViewer.this.fLeftIsLocal) {
                            return TextMergeViewer.this.OUTGOING_TEXT_FILL;
                        }
                        return TextMergeViewer.this.INCOMING_TEXT_FILL;
                    }
                    case 1: {
                        return TextMergeViewer.this.CONFLICT_TEXT_FILL;
                    }
                }
                return null;
            }
            return TextMergeViewer.this.OUTGOING_TEXT_FILL;
        }
    }

    class ChildPositionUpdater
    extends DefaultPositionUpdater {
        protected ChildPositionUpdater(String category) {
            super(category);
        }

        protected boolean notDeleted() {
            return true;
        }

        protected void adaptToInsert() {
            if (this.fPosition == TextMergeViewer.this.fLeft.getRegion() || this.fPosition == TextMergeViewer.this.fRight.getRegion()) {
                int yoursStart;
                int myStart = this.fPosition.offset;
                int myEnd = this.fPosition.offset + this.fPosition.length;
                if ((myEnd = Math.max(myStart, myEnd)) < (yoursStart = this.fOffset)) {
                    return;
                }
                if (myStart <= yoursStart) {
                    this.fPosition.length += this.fReplaceLength;
                } else {
                    this.fPosition.offset += this.fReplaceLength;
                }
            } else {
                super.adaptToInsert();
            }
        }
    }

    class ContributorInfo
    implements IElementStateListener,
    VerifyListener,
    IDocumentListener {
        private final TextMergeViewer fViewer;
        private final Object fElement;
        private char fLeg;
        private String fEncoding;
        private IDocumentProvider fDocumentProvider;
        private IEditorInput fDocumentKey;
        private ISelection fSelection;
        private int fTopIndex = -1;
        private boolean fNeedsValidation = false;
        private MergeSourceViewer fSourceViewer;

        public ContributorInfo(TextMergeViewer viewer, Object element, char leg) {
            this.fViewer = viewer;
            this.fElement = element;
            this.fLeg = leg;
            if (this.fElement instanceof IEncodedStreamContentAccessor) {
                try {
                    this.fEncoding = ((IEncodedStreamContentAccessor)this.fElement).getCharset();
                }
                catch (CoreException coreException) {}
            }
        }

        public String getEncoding() {
            if (this.fEncoding == null) {
                return ResourcesPlugin.getEncoding();
            }
            return this.fEncoding;
        }

        public void setEncodingIfAbsent(ContributorInfo otherContributor) {
            if (this.fEncoding == null) {
                this.fEncoding = otherContributor.fEncoding;
            }
        }

        public IDocument getDocument() {
            IDocument document;
            if (this.fDocumentProvider != null && (document = this.fDocumentProvider.getDocument((Object)this.getDocumentKey())) != null) {
                return document;
            }
            if (this.fElement instanceof IDocument) {
                return (IDocument)this.fElement;
            }
            if (this.fElement instanceof IDocumentRange) {
                return ((IDocumentRange)this.fElement).getDocument();
            }
            if (this.fElement instanceof IStreamContentAccessor) {
                return DocumentManager.get((Object)this.fElement);
            }
            return null;
        }

        public void setDocument(MergeSourceViewer viewer, boolean isEditable) {
            Assert.isTrue((this.fSourceViewer == null ? 1 : 0) != 0);
            this.fSourceViewer = viewer;
            try {
                this.internalSetDocument(viewer);
            }
            catch (RuntimeException e) {
                this.clearCachedDocument();
                throw e;
            }
            viewer.setEditable(isEditable);
            if (isEditable) {
                this.fNeedsValidation = true;
                viewer.getTextWidget().addVerifyListener((VerifyListener)this);
            }
        }

        private boolean internalSetDocument(MergeSourceViewer tp) {
            IDocument oldDoc;
            if (tp == null) {
                return false;
            }
            tp.unconfigure();
            IDocument newDocument = null;
            Position range = null;
            if (this.fElement instanceof IDocumentRange) {
                newDocument = ((IDocumentRange)this.fElement).getDocument();
                range = ((IDocumentRange)this.fElement).getRange();
                this.connectToSharedDocument();
            } else if (this.fElement instanceof IDocument) {
                newDocument = (IDocument)this.fElement;
            } else if (this.fElement instanceof IStreamContentAccessor) {
                newDocument = DocumentManager.get((Object)this.fElement);
                if (newDocument == null) {
                    newDocument = this.createDocument();
                    DocumentManager.put((Object)this.fElement, (IDocument)newDocument);
                    TextMergeViewer.this.setupDocument(newDocument);
                } else if (this.fDocumentProvider == null) {
                    this.connectToSharedDocument();
                }
            } else if (this.fElement == null) {
                ITypedElement parent = this.fViewer.getParent(this.fLeg);
                if (parent instanceof IDocumentRange) {
                    newDocument = ((IDocumentRange)parent).getDocument();
                    newDocument.addPositionCategory(TextMergeViewer.DIFF_RANGE_CATEGORY);
                    Object input = this.fViewer.getInput();
                    range = this.fViewer.getNewRange(this.fLeg, input);
                    if (range == null) {
                        int pos = 0;
                        if (input instanceof ICompareInput) {
                            pos = this.fViewer.findInsertionPosition(this.fLeg, (ICompareInput)input);
                        }
                        range = new Position(pos, 0);
                        try {
                            newDocument.addPosition(TextMergeViewer.DIFF_RANGE_CATEGORY, range);
                        }
                        catch (BadPositionCategoryException badPositionCategoryException) {
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        this.fViewer.addNewRange(this.fLeg, input, range);
                    }
                } else if (parent instanceof IDocument) {
                    newDocument = (IDocument)this.fElement;
                }
            }
            boolean enabled = true;
            if (newDocument == null) {
                newDocument = new Document("");
                enabled = false;
            }
            if (newDocument != (oldDoc = tp.getDocument())) {
                this.updateViewerDocument(tp, newDocument, range);
            } else {
                this.updateViewerDocumentRange(tp, range);
            }
            newDocument.addDocumentListener((IDocumentListener)this);
            if (newDocument instanceof IStructuredDocument) {
                tp.setDocument(newDocument);
                tp.configure((SourceViewerConfiguration)new PHPStructuredTextViewerConfiguration());
            }
            tp.setEnabled(enabled);
            return enabled;
        }

        private void updateViewerDocumentRange(MergeSourceViewer tp, Position range) {
            tp.setRegion(range);
            if (this.fViewer.fSubDoc) {
                if (range != null) {
                    IRegion r = this.fViewer.normalizeDocumentRegion(tp.getDocument(), TextMergeViewer.toRegion(range));
                    tp.setVisibleRegion(r.getOffset(), r.getLength());
                } else {
                    tp.resetVisibleRegion();
                }
            } else {
                tp.resetVisibleRegion();
            }
        }

        private void updateViewerDocument(MergeSourceViewer tp, IDocument document, Position range) {
            this.unsetDocument(tp);
            if (document == null) {
                return;
            }
            document.addPositionCategory(TextMergeViewer.DIFF_RANGE_CATEGORY);
            if (this.fViewer.fPositionUpdater == null) {
                TextMergeViewer textMergeViewer = this.fViewer;
                ((Object)((Object)textMergeViewer)).getClass();
                this.fViewer.fPositionUpdater = (IPositionUpdater)textMergeViewer.new ChildPositionUpdater(TextMergeViewer.DIFF_RANGE_CATEGORY);
            } else {
                document.removePositionUpdater(this.fViewer.fPositionUpdater);
            }
            document.addPositionUpdater(this.fViewer.fPositionUpdater);
            tp.setRegion(range);
            if (this.fViewer.fSubDoc) {
                if (range != null) {
                    IRegion r = this.fViewer.normalizeDocumentRegion(document, TextMergeViewer.toRegion(range));
                    tp.setDocument(document, r.getOffset(), r.getLength());
                } else {
                    tp.setDocument(document);
                }
            } else {
                tp.setDocument(document);
            }
            tp.rememberDocument(document);
        }

        private void unsetDocument(MergeSourceViewer tp) {
            IDocument oldDoc = this.internalGetDocument(tp);
            if (oldDoc != null) {
                tp.rememberDocument(null);
                try {
                    oldDoc.removePositionCategory(TextMergeViewer.DIFF_RANGE_CATEGORY);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                if (TextMergeViewer.this.fPositionUpdater != null) {
                    oldDoc.removePositionUpdater(TextMergeViewer.this.fPositionUpdater);
                }
                oldDoc.removeDocumentListener((IDocumentListener)this);
            }
        }

        private IDocument createDocument() {
            IDocument newDoc = this.connectToSharedDocument();
            if (newDoc == null || !(newDoc instanceof IStructuredDocument)) {
                IStreamContentAccessor sca = (IStreamContentAccessor)this.fElement;
                String s = null;
                try {
                    String encoding = this.getEncoding();
                    s = Utilities.readString((IStreamContentAccessor)sca, (String)encoding);
                }
                catch (CoreException ex) {
                    this.fViewer.setError(this.fLeg, ex.getMessage());
                }
                newDoc = StructuredDocumentFactory.getNewStructuredDocumentInstance((RegionParser)new PhpSourceParser());
                newDoc.set(s != null ? s : "");
                IDocumentPartitioner partitioner = TextMergeViewer.this.getDocumentPartitioner();
                if (partitioner != null) {
                    if (newDoc instanceof JobSafeStructuredDocument) {
                        ((JobSafeStructuredDocument)newDoc).setDocumentPartitioner("org.eclipse.wst.sse.core.default_structured_text_partitioning", partitioner);
                    } else {
                        newDoc.setDocumentPartitioner(partitioner);
                    }
                    partitioner.connect(newDoc);
                }
            }
            return newDoc;
        }

        private IDocument connectToSharedDocument() {
            IEditorInput key = this.getDocumentKey();
            if (key != null) {
                if (this.fDocumentProvider != null) {
                    return this.fDocumentProvider.getDocument((Object)key);
                }
                IDocumentProvider documentProvider = this.getDocumentProvider();
                if (documentProvider != null) {
                    try {
                        this.connect(documentProvider, key);
                        this.setCachedDocumentProvider(key, documentProvider);
                        IDocument newDoc = documentProvider.getDocument((Object)key);
                        this.fViewer.updateDirtyState(key, documentProvider, this.fLeg);
                        return newDoc;
                    }
                    catch (CoreException e) {
                        CompareUIPlugin.log((Throwable)e);
                    }
                }
            }
            return null;
        }

        private void connect(IDocumentProvider documentProvider, IEditorInput input) throws CoreException {
            ISharedDocumentAdapter sda = (ISharedDocumentAdapter)Utilities.getAdapter((Object)this.fElement, ISharedDocumentAdapter.class);
            if (sda != null) {
                sda.connect(documentProvider, input);
            } else {
                documentProvider.connect((Object)input);
            }
        }

        private void disconnect(IDocumentProvider provider, IEditorInput input) {
            ISharedDocumentAdapter sda = (ISharedDocumentAdapter)Utilities.getAdapter((Object)this.fElement, ISharedDocumentAdapter.class);
            if (sda != null) {
                sda.disconnect(provider, input);
            } else {
                provider.disconnect((Object)input);
            }
        }

        private void setCachedDocumentProvider(IEditorInput key, IDocumentProvider documentProvider) {
            this.fDocumentKey = key;
            this.fDocumentProvider = documentProvider;
            documentProvider.addElementStateListener((IElementStateListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() {
            IDocumentProvider provider = null;
            IEditorInput input = this.getDocumentKey();
            ContributorInfo contributorInfo = this;
            synchronized (contributorInfo) {
                if (this.fDocumentProvider != null) {
                    provider = this.fDocumentProvider;
                    this.fDocumentProvider = null;
                    this.fDocumentKey = null;
                }
            }
            if (provider != null) {
                this.disconnect(provider, input);
                provider.removeElementStateListener((IElementStateListener)this);
            }
            if (this.fSourceViewer != null && !this.fSourceViewer.getTextWidget().isDisposed()) {
                IDocument oldDoc;
                if (this.fNeedsValidation) {
                    this.fSourceViewer.getTextWidget().removeVerifyListener((VerifyListener)this);
                    this.fNeedsValidation = false;
                }
                if ((oldDoc = this.internalGetDocument(this.fSourceViewer)) != null) {
                    oldDoc.removeDocumentListener((IDocumentListener)this);
                }
            }
            this.clearCachedDocument();
        }

        private void clearCachedDocument() {
            IDocument doc = DocumentManager.get((Object)this.fElement);
            if (doc != null) {
                DocumentManager.remove((IDocument)doc);
            }
        }

        private IDocument internalGetDocument(MergeSourceViewer tp) {
            IDocument oldDoc = tp.getDocument();
            if (oldDoc == null) {
                oldDoc = tp.getRememberedDocument();
            }
            return oldDoc;
        }

        private IEditorInput getDocumentKey() {
            ISharedDocumentAdapter sda;
            if (this.fDocumentKey != null) {
                return this.fDocumentKey;
            }
            if (this.isUsingDefaultContentProvider() && this.fElement != null && this.canHaveSharedDocument() && (sda = (ISharedDocumentAdapter)Utilities.getAdapter((Object)this.fElement, ISharedDocumentAdapter.class, (boolean)true)) != null) {
                return sda.getDocumentKey(this.fElement);
            }
            return null;
        }

        private IDocumentProvider getDocumentProvider() {
            IEditorInput input;
            if (this.fDocumentProvider != null) {
                return this.fDocumentProvider;
            }
            if (this.isUsingDefaultContentProvider() && (input = this.getDocumentKey()) != null) {
                return SharedDocumentAdapter.getDocumentProvider((IEditorInput)input);
            }
            return null;
        }

        private boolean isUsingDefaultContentProvider() {
            return this.fViewer.isUsingDefaultContentProvider();
        }

        private boolean canHaveSharedDocument() {
            return this.fViewer.canHaveSharedDocument();
        }

        boolean hasSharedDocument(Object object) {
            return this.fElement == object && this.fDocumentProvider != null && this.fDocumentProvider.getDocument((Object)this.getDocumentKey()) != null;
        }

        public boolean flush() throws CoreException {
            IEditorInput input;
            IDocument document;
            if (this.fDocumentProvider != null && (document = this.fDocumentProvider.getDocument((Object)(input = this.getDocumentKey()))) != null) {
                ISharedDocumentAdapter sda = (ISharedDocumentAdapter)Utilities.getAdapter((Object)this.fElement, ISharedDocumentAdapter.class);
                if (sda != null) {
                    sda.flushDocument(this.fDocumentProvider, input, document, false);
                    return true;
                }
                try {
                    this.fDocumentProvider.aboutToChange((Object)input);
                    this.fDocumentProvider.saveDocument((IProgressMonitor)new NullProgressMonitor(), (Object)input, document, false);
                    return true;
                }
                finally {
                    this.fDocumentProvider.changed((Object)input);
                }
            }
            return false;
        }

        public void elementMoved(Object originalElement, Object movedElement) {
            IEditorInput input = this.getDocumentKey();
            if (input != null && input.equals(originalElement)) {
                this.resetDocument();
            }
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
            if (!this.checkState()) {
                return;
            }
            IEditorInput input = this.getDocumentKey();
            if (input != null && input.equals(element)) {
                this.fViewer.updateDirtyState(input, this.getDocumentProvider(), this.fLeg);
            }
        }

        public void elementDeleted(Object element) {
            IEditorInput input = this.getDocumentKey();
            if (input != null && input.equals(element)) {
                this.resetDocument();
            }
        }

        private void resetDocument() {
            this.clearCachedDocument();
            if (this.checkState()) {
                this.fViewer.refresh();
            }
        }

        private boolean checkState() {
            if (this.fViewer == null) {
                return false;
            }
            Control control = this.fViewer.getControl();
            if (control == null) {
                return false;
            }
            return !control.isDisposed();
        }

        public void elementContentReplaced(Object element) {
            if (!this.checkState()) {
                return;
            }
            IEditorInput input = this.getDocumentKey();
            if (input != null && input.equals(element)) {
                this.fViewer.updateDirtyState(input, this.getDocumentProvider(), this.fLeg);
            }
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }

        public Object getElement() {
            return this.fElement;
        }

        public void cacheSelection(MergeSourceViewer viewer) {
            if (viewer == null) {
                this.fSelection = null;
                this.fTopIndex = -1;
            } else {
                this.fSelection = viewer.getSelection();
                this.fTopIndex = viewer.getTopIndex();
            }
        }

        public void updateSelection(MergeSourceViewer viewer, boolean includeScroll) {
            if (this.fSelection != null) {
                viewer.setSelection(this.fSelection);
            }
            if (includeScroll && this.fTopIndex != -1) {
                viewer.setTopIndex(this.fTopIndex);
            }
        }

        public void transferContributorStateFrom(ContributorInfo oldContributor) {
            if (oldContributor != null) {
                this.fSelection = oldContributor.fSelection;
                this.fTopIndex = oldContributor.fTopIndex;
            }
        }

        public boolean validateChange() {
            IStatus status;
            if (this.fElement == null) {
                return true;
            }
            if (this.fDocumentProvider instanceof IDocumentProviderExtension) {
                IDocumentProviderExtension ext = (IDocumentProviderExtension)this.fDocumentProvider;
                if (ext.isReadOnly((Object)this.fDocumentKey)) {
                    try {
                        ext.validateState((Object)this.fDocumentKey, (Object)TextMergeViewer.this.getControl().getShell());
                        ext.updateStateCache((Object)this.fDocumentKey);
                    }
                    catch (CoreException e) {
                        ErrorDialog.openError((Shell)TextMergeViewer.this.getControl().getShell(), (String)CompareMessages.TextMergeViewer_12, (String)CompareMessages.TextMergeViewer_13, (IStatus)e.getStatus());
                        return false;
                    }
                }
                return !ext.isReadOnly((Object)this.fDocumentKey);
            }
            IEditableContentExtension ext = (IEditableContentExtension)Utilities.getAdapter((Object)this.fElement, IEditableContentExtension.class);
            if (ext != null && ext.isReadOnly() && !(status = ext.validateEdit(TextMergeViewer.this.getControl().getShell())).isOK()) {
                if (status.getSeverity() == 4) {
                    ErrorDialog.openError((Shell)TextMergeViewer.this.getControl().getShell(), (String)CompareMessages.TextMergeViewer_14, (String)CompareMessages.TextMergeViewer_15, (IStatus)status);
                    return false;
                }
                if (status.getSeverity() == 8) {
                    return false;
                }
            }
            return true;
        }

        public void verifyText(VerifyEvent e) {
            if (!this.validateChange()) {
                e.doit = false;
            }
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
        }

        public void documentChanged(DocumentEvent e) {
            boolean dirty = true;
            if (this.fDocumentProvider != null && this.fDocumentKey != null) {
                dirty = this.fDocumentProvider.canSaveDocument((Object)this.fDocumentKey);
            }
            TextMergeViewer.this.documentChanged(e, dirty);
            if (this.fNeedsValidation && this.fSourceViewer != null && !this.fSourceViewer.getTextWidget().isDisposed()) {
                this.fSourceViewer.getTextWidget().removeVerifyListener((VerifyListener)this);
                this.fNeedsValidation = false;
            }
        }
    }

    private class FindReplaceTarget
    implements IFindReplaceTarget {
        private FindReplaceTarget() {
        }

        public boolean canPerformFind() {
            return TextMergeViewer.this.fFocusPart != null;
        }

        public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
            return TextMergeViewer.this.fFocusPart.getFindReplaceTarget().findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord);
        }

        public Point getSelection() {
            return TextMergeViewer.this.fFocusPart.getFindReplaceTarget().getSelection();
        }

        public String getSelectionText() {
            return TextMergeViewer.this.fFocusPart.getFindReplaceTarget().getSelectionText();
        }

        public boolean isEditable() {
            return TextMergeViewer.this.fFocusPart.getFindReplaceTarget().isEditable();
        }

        public void replaceSelection(String text) {
            TextMergeViewer.this.fFocusPart.getFindReplaceTarget().replaceSelection(text);
        }
    }

    class HeaderPainter
    implements PaintListener {
        private static final int INSET = 2;
        private RGB fIndicatorColor;
        private Color fSeparatorColor;

        public HeaderPainter() {
            this.fSeparatorColor = TextMergeViewer.this.fSummaryHeader.getDisplay().getSystemColor(18);
        }

        public boolean setColor(RGB color) {
            RGB oldColor = this.fIndicatorColor;
            this.fIndicatorColor = color;
            if (color == null) {
                return oldColor != null;
            }
            if (oldColor != null) {
                return !color.equals((Object)oldColor);
            }
            return true;
        }

        private void drawBevelRect(GC gc, int x, int y, int w, int h, Color topLeft, Color bottomRight) {
            gc.setForeground(topLeft);
            gc.drawLine(x, y, x + w - 1, y);
            gc.drawLine(x, y, x, y + h - 1);
            gc.setForeground(bottomRight);
            gc.drawLine(x + w, y, x + w, y + h);
            gc.drawLine(x, y + h, x + w, y + h);
        }

        public void paintControl(PaintEvent e) {
            Point s = TextMergeViewer.this.fSummaryHeader.getSize();
            if (this.fIndicatorColor != null) {
                Display d = TextMergeViewer.this.fSummaryHeader.getDisplay();
                e.gc.setBackground(TextMergeViewer.this.getColor(d, this.fIndicatorColor));
                int min = Math.min(s.x, s.y) - 4;
                Rectangle r = new Rectangle((s.x - min) / 2, (s.y - min) / 2, min, min);
                e.gc.fillRectangle(r);
                if (d != null) {
                    this.drawBevelRect(e.gc, r.x, r.y, r.width - 1, r.height - 1, d.getSystemColor(18), d.getSystemColor(20));
                }
                e.gc.setForeground(this.fSeparatorColor);
                e.gc.setLineWidth(0);
                e.gc.drawLine(1, s.y - 1, s.x - 1 - 1, s.y - 1);
            }
        }
    }

    class HoverResizer
    extends ContentMergeViewer.Resizer {
        Canvas fCanvas;

        public HoverResizer(Canvas c, int dir) {
            super(TextMergeViewer.this, (Control)c, dir);
            this.fCanvas = c;
        }

        @Override
        public void mouseMove(MouseEvent e) {
            if (!this.fIsDown && TextMergeViewer.this.fUseSingleLine && TextMergeViewer.this.showResolveUI() && TextMergeViewer.this.handleMouseMoveOverCenter(this.fCanvas, e.x, e.y)) {
                return;
            }
            super.mouseMove(e);
        }
    }

    private final class InternalOutlineViewerCreator
    extends OutlineViewerCreator
    implements ISelectionChangedListener {
        private InternalOutlineViewerCreator() {
        }

        public Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent, CompareConfiguration configuration) {
            if (input != this.getInput()) {
                return null;
            }
            final Viewer v = CompareUI.findStructureViewer((Viewer)oldViewer, (ICompareInput)input, (Composite)parent, (CompareConfiguration)configuration);
            if (v != null) {
                v.getControl().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        v.removeSelectionChangedListener((ISelectionChangedListener)InternalOutlineViewerCreator.this);
                    }
                });
                v.addSelectionChangedListener((ISelectionChangedListener)this);
            }
            return v;
        }

        public boolean hasViewerFor(Object input) {
            return true;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection ss;
            Object element;
            DocumentMerger.Diff diff;
            ISelection s = event.getSelection();
            if (s instanceof IStructuredSelection && (diff = this.findDiff(element = (ss = (IStructuredSelection)s).getFirstElement())) != null) {
                TextMergeViewer.this.setCurrentDiff(diff, true);
            }
        }

        private DocumentMerger.Diff findDiff(Object element) {
            if (element instanceof ICompareInput) {
                ICompareInput ci = (ICompareInput)element;
                Position p = this.getPosition(ci.getLeft());
                if (p != null) {
                    return this.findDiff(p, true);
                }
                p = this.getPosition(ci.getRight());
                if (p != null) {
                    return this.findDiff(p, false);
                }
            }
            return null;
        }

        private DocumentMerger.Diff findDiff(Position p, boolean left) {
            Iterator iterator = TextMergeViewer.this.fMerger.rangesIterator();
            while (iterator.hasNext()) {
                DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
                Position diffPos = left ? diff.getPosition('L') : diff.getPosition('R');
                if (diffPos.offset + diffPos.length >= p.offset && diff.getKind() != 0) {
                    return diff;
                }
                if (diffPos.offset < p.offset) continue;
                return diff;
            }
            return null;
        }

        private Position getPosition(ITypedElement left) {
            if (left instanceof DocumentRangeNode) {
                DocumentRangeNode drn = (DocumentRangeNode)left;
                return drn.getRange();
            }
            return null;
        }

        public Object getInput() {
            return TextMergeViewer.this.getInput();
        }
    }
}

