/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.ui.editor.SemanticHighlightingStyle;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;

public class SemanticHighlightingManager {
    private static SemanticHighlightingManager instance;
    private List<AbstractSemanticHighlighting> rules = new LinkedList<AbstractSemanticHighlighting>();
    private Map<String, AbstractSemanticHighlighting> highlightings = new LinkedHashMap<String, AbstractSemanticHighlighting>();

    public static synchronized SemanticHighlightingManager getInstance() {
        if (instance == null) {
            instance = new SemanticHighlightingManager();
        }
        return instance;
    }

    private SemanticHighlightingManager() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wst.sse.ui.semanticHighlighting");
        try {
            this.loadContributor(elements);
            Collections.sort(this.rules);
            for (AbstractSemanticHighlighting rule : this.rules) {
                this.highlightings.put(rule.getPreferenceKey(), rule);
            }
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
    }

    private SemanticHighlightingManager loadContributor(IConfigurationElement[] elements) throws Exception {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object o;
            IConfigurationElement element = iConfigurationElementArray[n2];
            String target = element.getAttribute("target");
            if ("org.eclipse.php.core.phpsource".equals(target) && (o = element.createExecutableExtension("class")) instanceof AbstractSemanticHighlighting) {
                AbstractSemanticHighlighting instance = (AbstractSemanticHighlighting)o;
                this.rules.add(instance);
            }
            ++n2;
        }
        return this;
    }

    public Map<String, AbstractSemanticHighlighting> getSemanticHighlightings() {
        return this.highlightings;
    }

    public SemanticHighlightingManager initDefaults(IPreferenceStore store) {
        Collection<AbstractSemanticHighlighting> semanticHighlightings = this.highlightings.values();
        for (AbstractSemanticHighlighting rule : semanticHighlightings) {
            rule.initDefaultPreferences();
            SemanticHighlightingStyle style = rule.getStyle();
            SemanticHighlightingManager.setDefaultAndFireEvent(store, rule.getColorPreferenceKey(), style.getDefaultTextColor());
            store.setDefault(rule.getBoldPreferenceKey(), style.isBoldByDefault());
            store.setDefault(rule.getItalicPreferenceKey(), style.isItalicByDefault());
            store.setDefault(rule.getStrikethroughPreferenceKey(), style.isStrikethroughByDefault());
            store.setDefault(rule.getUnderlinePreferenceKey(), style.isUnderlineByDefault());
            store.setDefault(rule.getEnabledPreferenceKey(), style.isEnabledByDefault());
        }
        return this;
    }

    private static void setDefaultAndFireEvent(IPreferenceStore store, String key, RGB newValue) {
        RGB oldValue = null;
        if (store.isDefault(key)) {
            oldValue = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key);
        }
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (RGB)newValue);
        store.setDefault(key, ColorHelper.toRGBString((RGB)newValue));
        if (oldValue != null && !oldValue.equals((Object)newValue)) {
            store.firePropertyChangeEvent(key, (Object)oldValue, (Object)newValue);
        }
    }
}

