/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.ui.folding.IPHPFoldingPreferenceBlock;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;

public class DefaultPHPFoldingPreferenceBlock
implements IPHPFoldingPreferenceBlock {
    private IPreferenceStore fStore;
    private OverlayPreferenceStore fOverlayStore;
    private OverlayPreferenceStore.OverlayKey[] fKeys;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            DefaultPHPFoldingPreferenceBlock.this.fOverlayStore.setValue((String)DefaultPHPFoldingPreferenceBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };

    public DefaultPHPFoldingPreferenceBlock() {
        this.fStore = PreferenceConstants.getPreferenceStore();
        this.fKeys = this.createKeys();
        this.fOverlayStore = new OverlayPreferenceStore(this.fStore, this.fKeys);
    }

    private OverlayPreferenceStore.OverlayKey[] createKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "foldPHPDoc"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "foldClasses"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "foldFunctions"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "foldHeaderComment"));
        return overlayKeys.toArray(new OverlayPreferenceStore.OverlayKey[overlayKeys.size()]);
    }

    @Override
    public Control createControl(Composite composite) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.verticalSpacing = 3;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        Label label = new Label(inner, 16384);
        label.setText(PHPUIMessages.DefaultPHPFoldingPreferenceBlock_title);
        this.addCheckBox(inner, PHPUIMessages.DefaultPHPFoldingPreferenceBlock_classes, "foldClasses", 0);
        this.addCheckBox(inner, PHPUIMessages.DefaultPHPFoldingPreferenceBlock_functions, "foldFunctions", 0);
        this.addCheckBox(inner, PHPUIMessages.DefaultPHPFoldingPreferenceBlock_PHPdoc, "foldPHPDoc", 0);
        this.addCheckBox(inner, PHPUIMessages.DefaultPHPFoldingPreferenceBlock_header_comments, "foldHeaderComment", 0);
        return inner;
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 1;
        gd.grabExcessVerticalSpace = false;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private void initializeFields() {
        for (Button b : this.fCheckBoxes.keySet()) {
            String key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
    }

    @Override
    public void performOk() {
        this.fOverlayStore.propagate();
    }

    @Override
    public void initialize() {
        this.initializeFields();
    }

    @Override
    public void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
    }

    @Override
    public void dispose() {
        this.fOverlayStore.stop();
    }
}

