/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.folding.IStructuredTextFoldingProvider;
import org.eclipse.php.internal.ui.folding.PHPFoldingStructureProviderDescriptor;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;

public class PHPFoldingStructureProviderRegistry {
    private static final String EXTENSION_POINT = "foldingStructureProviders";
    private Map fDescriptors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PHPFoldingStructureProviderDescriptor[] getFoldingProviderDescriptors() {
        PHPFoldingStructureProviderRegistry pHPFoldingStructureProviderRegistry = this;
        synchronized (pHPFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return this.fDescriptors.values().toArray(new PHPFoldingStructureProviderDescriptor[this.fDescriptors.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PHPFoldingStructureProviderDescriptor getFoldingProviderDescriptor(String id) {
        PHPFoldingStructureProviderRegistry pHPFoldingStructureProviderRegistry = this;
        synchronized (pHPFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return (PHPFoldingStructureProviderDescriptor)this.fDescriptors.get(id);
        }
    }

    public IStructuredTextFoldingProvider getCurrentFoldingProvider() {
        String id = PreferenceConstants.getPreferenceStore().getString("editor_folding_provider");
        PHPFoldingStructureProviderDescriptor desc = this.getFoldingProviderDescriptor(id);
        if (desc != null) {
            try {
                return desc.createProvider();
            }
            catch (CoreException e) {
                PHPUiPlugin.log(e);
            }
        }
        return null;
    }

    private void ensureRegistered() {
        if (this.fDescriptors == null) {
            this.reloadExtensions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        HashMap<String, PHPFoldingStructureProviderDescriptor> map = new HashMap<String, PHPFoldingStructureProviderDescriptor>();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(PHPUiPlugin.getPluginId(), EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            PHPFoldingStructureProviderDescriptor desc = new PHPFoldingStructureProviderDescriptor(elements[i]);
            map.put(desc.getId(), desc);
            ++i;
        }
        PHPFoldingStructureProviderRegistry pHPFoldingStructureProviderRegistry = this;
        synchronized (pHPFoldingStructureProviderRegistry) {
            this.fDescriptors = Collections.unmodifiableMap(map);
        }
    }
}

