/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class MultipleFolderSelectionDialog
extends SelectionStatusDialog
implements ISelectionChangedListener {
    private CheckboxTreeViewer fViewer;
    private ILabelProvider fLabelProvider;
    private ITreeContentProvider fContentProvider;
    private List fFilters;
    private Object fInput;
    private Button fNewFolderButton;
    private IContainer fSelectedContainer;
    private Set fExisting;
    private Object fFocusElement;

    public MultipleFolderSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent);
        this.fLabelProvider = labelProvider;
        this.fContentProvider = contentProvider;
        this.setSelectionResult(null);
        this.setStatusLineAboveButtons(true);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
        this.fExisting = null;
        this.fFocusElement = null;
        this.fFilters = null;
    }

    public void setExisting(Object[] existing) {
        this.fExisting = new HashSet();
        int i = 0;
        while (i < existing.length) {
            this.fExisting.add(existing[i]);
            ++i;
        }
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    public void addFilter(ViewerFilter filter) {
        if (this.fFilters == null) {
            this.fFilters = new ArrayList(4);
        }
        this.fFilters.add(filter);
    }

    protected void cancelPressed() {
        this.setSelectionResult(null);
        super.cancelPressed();
    }

    protected void computeResult() {
        Object checked = this.fViewer.getCheckedElements();
        if (this.fExisting == null) {
            if (((Object[])checked).length == 0) {
                checked = null;
            }
        } else {
            ArrayList<Object> res = new ArrayList<Object>();
            int i = 0;
            while (i < ((Object[])checked).length) {
                Object elem = checked[i];
                if (!this.fExisting.contains(elem)) {
                    res.add(elem);
                }
                ++i;
            }
            checked = !res.isEmpty() ? res.toArray() : null;
        }
        this.setSelectionResult((Object[])checked);
    }

    private void access$superCreate() {
        super.create();
    }

    public void create() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                MultipleFolderSelectionDialog.this.access$superCreate();
                MultipleFolderSelectionDialog.this.fViewer.setCheckedElements(MultipleFolderSelectionDialog.this.getInitialElementSelections().toArray());
                MultipleFolderSelectionDialog.this.fViewer.expandToLevel(2);
                if (MultipleFolderSelectionDialog.this.fExisting != null) {
                    Iterator iter = MultipleFolderSelectionDialog.this.fExisting.iterator();
                    while (iter.hasNext()) {
                        MultipleFolderSelectionDialog.this.fViewer.reveal(iter.next());
                    }
                }
                MultipleFolderSelectionDialog.this.updateOKStatus();
            }
        });
    }

    protected CheckboxTreeViewer createTreeViewer(Composite parent) {
        this.fViewer = new CheckboxTreeViewer(parent, 2048);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                MultipleFolderSelectionDialog.this.updateOKStatus();
            }
        });
        this.fViewer.setComparator((ViewerComparator)new ResourceComparator(1));
        if (this.fFilters != null) {
            int i = 0;
            while (i != this.fFilters.size()) {
                this.fViewer.addFilter((ViewerFilter)this.fFilters.get(i));
                ++i;
            }
        }
        this.fViewer.setInput(this.fInput);
        return this.fViewer;
    }

    protected void updateOKStatus() {
        this.computeResult();
        if (this.getResult() != null) {
            this.updateStatus((IStatus)new StatusInfo());
        } else {
            this.updateStatus((IStatus)new StatusInfo(4, ""));
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        CheckboxTreeViewer treeViewer = this.createTreeViewer(composite);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(60);
        data.heightHint = this.convertHeightInCharsToPixels(18);
        Tree treeWidget = treeViewer.getTree();
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(composite.getFont());
        Button button = new Button(composite, 8);
        button.setText(NewWizardMessages.MultipleFolderSelectionDialog_button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MultipleFolderSelectionDialog.this.newFolderButtonPressed();
            }
        });
        button.setFont(composite.getFont());
        this.fNewFolderButton = button;
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.fExisting != null) {
            Object[] existing = this.fExisting.toArray();
            treeViewer.setGrayedElements(existing);
            this.setInitialSelections(existing);
        }
        if (this.fFocusElement != null) {
            treeViewer.setSelection((ISelection)new StructuredSelection(this.fFocusElement), true);
        }
        treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                MultipleFolderSelectionDialog.this.forceExistingChecked(event);
            }
        });
        MultipleFolderSelectionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void forceExistingChecked(CheckStateChangedEvent event) {
        Object elem;
        if (this.fExisting != null && this.fExisting.contains(elem = event.getElement())) {
            this.fViewer.setChecked(elem, true);
        }
    }

    private void updateNewFolderButtonState() {
        Object first;
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        this.fSelectedContainer = null;
        if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof IContainer) {
            this.fSelectedContainer = (IContainer)first;
        }
        this.fNewFolderButton.setEnabled(this.fSelectedContainer != null);
    }

    protected void newFolderButtonPressed() {
        Object createdFolder = this.createFolder(this.fSelectedContainer);
        if (createdFolder != null) {
            CheckboxTreeViewer treeViewer = this.fViewer;
            treeViewer.refresh((Object)this.fSelectedContainer);
            treeViewer.reveal(createdFolder);
            treeViewer.setChecked(createdFolder, true);
            treeViewer.setSelection((ISelection)new StructuredSelection(createdFolder));
            this.updateOKStatus();
        }
    }

    protected Object createFolder(IContainer container) {
        NewFolderDialog dialog = new NewFolderDialog(this.getShell(), container);
        if (dialog.open() == 0) {
            return dialog.getResult()[0];
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateNewFolderButtonState();
    }

    public void setInitialFocus(Object focusElement) {
        this.fFocusElement = focusElement;
    }
}

