/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.includepath.ArchieveFileFilter;
import org.eclipse.php.internal.ui.preferences.includepath.IPVariableElement;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.IStringButtonAdapter;
import org.eclipse.php.internal.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.internal.ui.wizards.fields.StringButtonDialogField;
import org.eclipse.php.internal.ui.wizards.fields.StringDialogField;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class VariableCreationDialog
extends StatusDialog {
    private IDialogSettings fDialogSettings;
    private StringDialogField fNameField;
    private StatusInfo fNameStatus;
    private StringButtonDialogField fPathField;
    private StatusInfo fPathStatus;
    private IPVariableElement fElement;
    private List fExistingNames;

    public VariableCreationDialog(Shell parent, IPVariableElement element, List existingNames) {
        super(parent);
        if (element == null) {
            this.setTitle(PHPUIMessages.VariableCreationDialog_titlenew);
        } else {
            this.setTitle(PHPUIMessages.VariableCreationDialog_titleedit);
        }
        this.fDialogSettings = PHPUiPlugin.getDefault().getDialogSettings();
        this.fElement = element;
        this.fNameStatus = new StatusInfo();
        this.fPathStatus = new StatusInfo();
        NewVariableAdapter adapter = new NewVariableAdapter();
        this.fNameField = new StringDialogField();
        this.fNameField.setDialogFieldListener(adapter);
        this.fNameField.setLabelText(PHPUIMessages.VariableCreationDialog_name_label);
        this.fPathField = new StringButtonDialogField(adapter);
        this.fPathField.setDialogFieldListener(adapter);
        this.fPathField.setLabelText(PHPUIMessages.VariableCreationDialog_path_label);
        this.fPathField.setButtonLabel(PHPUIMessages.VariableCreationDialog_path_dir_button);
        this.fExistingNames = existingNames;
        if (element != null) {
            this.fNameField.setText(element.getName());
            this.fPathField.setText(element.getPath().toString());
            this.fExistingNames.remove(element.getName());
        } else {
            this.fNameField.setText("");
            this.fPathField.setText("");
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.php.help.path_variables_preferences");
    }

    public IPVariableElement getIncludePathElement() {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        inner.setFont(composite.getFont());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        inner.setLayout((Layout)layout);
        int fieldWidthHint = this.convertWidthInCharsToPixels(50);
        this.fNameField.doFillIntoGrid(inner, 2);
        LayoutUtil.setWidthHint((Control)this.fNameField.getTextControl(null), fieldWidthHint);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        DialogField.createEmptySpace(inner, 1);
        this.fPathField.doFillIntoGrid(inner, 3);
        LayoutUtil.setWidthHint((Control)this.fPathField.getTextControl(null), fieldWidthHint);
        StringDialogField focusField = this.fElement == null ? this.fNameField : this.fPathField;
        focusField.postSetFocusOnDialogField(parent.getDisplay());
        VariableCreationDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doChangeControlPressed(DialogField field) {
        IPath path;
        if (field == this.fPathField && (path = this.chooseExtDirectory()) != null) {
            this.fPathField.setText(path.toString());
        }
    }

    private void doFieldUpdated(DialogField field) {
        if (field == this.fNameField) {
            this.fNameStatus = this.nameUpdated();
        } else if (field == this.fPathField) {
            this.fPathStatus = this.pathUpdated();
        }
        this.updateStatus(VariableCreationDialog.getMoreSevere((IStatus)this.fPathStatus, (IStatus)this.fNameStatus));
    }

    private static IStatus getMoreSevere(IStatus s1, IStatus s2) {
        if (s1.getSeverity() > s2.getSeverity()) {
            return s1;
        }
        return s2;
    }

    private StatusInfo nameUpdated() {
        StatusInfo status = new StatusInfo();
        String name = this.fNameField.getText();
        if (name.length() == 0) {
            status.setError(PHPUIMessages.VariableCreationDialog_error_entername);
            return status;
        }
        if (name.trim().length() != name.length()) {
            status.setError(PHPUIMessages.VariableCreationDialog_error_whitespace);
        } else if (!Path.ROOT.isValidSegment(name)) {
            status.setError(PHPUIMessages.VariableCreationDialog_error_invalidname);
        } else if (this.nameConflict(name)) {
            status.setError(PHPUIMessages.VariableCreationDialog_error_nameexists);
        }
        return status;
    }

    private boolean nameConflict(String name) {
        if (this.fElement != null && this.fElement.getName().equals(name)) {
            return false;
        }
        int i = 0;
        while (i < this.fExistingNames.size()) {
            IPVariableElement elem = (IPVariableElement)this.fExistingNames.get(i);
            if (name.equals(elem.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private StatusInfo pathUpdated() {
        StatusInfo status = new StatusInfo();
        String path = this.fPathField.getText();
        if (path.length() > 0) {
            if (!Path.ROOT.isValidPath(path)) {
                status.setError(PHPUIMessages.VariableCreationDialog_error_invalidpath);
            } else if (!new File(path).exists()) {
                status.setWarning(PHPUIMessages.VariableCreationDialog_warning_pathnotexists);
            }
        }
        return status;
    }

    private String getInitPath() {
        String initPath = this.fPathField.getText();
        if (initPath.length() == 0) {
            initPath = "";
        } else {
            Path entryPath = new Path(initPath);
            if (ArchieveFileFilter.isZipPath((IPath)entryPath)) {
                entryPath.removeLastSegments(1);
            }
            initPath = entryPath.toOSString();
        }
        return initPath;
    }

    private IPath chooseExtDirectory() {
        String initPath = this.getInitPath();
        DirectoryDialog dialog = new DirectoryDialog(this.getParentShell(), 65536);
        dialog.setText(PHPUIMessages.VariableCreationDialog_extdirdialog_text);
        dialog.setMessage(PHPUIMessages.VariableCreationDialog_extdirdialog_message);
        dialog.setFilterPath(initPath);
        String res = dialog.open();
        if (res != null) {
            return Path.fromOSString((String)res);
        }
        return null;
    }

    private class NewVariableAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private NewVariableAdapter() {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            VariableCreationDialog.this.doFieldUpdated(field);
        }

        @Override
        public void changeControlPressed(DialogField field) {
            VariableCreationDialog.this.doChangeControlPressed(field);
        }
    }
}

