/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.ui.editor.PHPPairMatcher;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.internal.text.DocumentRegionEdgeMatcher;

public class PHPDocumentRegionEdgeMatcher
extends DocumentRegionEdgeMatcher {
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};

    public PHPDocumentRegionEdgeMatcher() {
        super(new String[]{"XML_TAG_NAME", "XML_COMMENT_TEXT", "XML_CDATA_TEXT", "XML_PI_OPEN", "XML_PI_CONTENT"}, (ICharacterPairMatcher)new PHPPairMatcher(BRACKETS));
    }

    public IRegion match(IDocument document, int offset) {
        IRegion match;
        block25: {
            IStructuredDocumentRegion docRegion;
            if (offset < 0 || offset > document.getLength()) {
                return null;
            }
            match = null;
            if (!this.fRegionTypes.isEmpty() && document instanceof IStructuredDocument && (docRegion = ((IStructuredDocument)document).getRegionAtCharacterOffset(offset)) != null) {
                if (docRegion.getPrevious() != null && docRegion.getPrevious().getEndOffset() == offset && this.fRegionTypes.contains(docRegion.getPrevious().getType())) {
                    this.fAnchor = 0;
                    match = new Region(docRegion.getPrevious().getStartOffset(), 1);
                } else if (this.fRegionTypes.contains(docRegion.getType()) && docRegion.getStartOffset(docRegion.getLastRegion()) <= offset && offset <= docRegion.getEndOffset(docRegion.getLastRegion())) {
                    this.fAnchor = 0;
                    match = new Region(docRegion.getStartOffset(), 1);
                } else if (this.fRegionTypes.contains(docRegion.getType()) && docRegion.getStartOffset(docRegion.getFirstRegion()) <= offset && offset <= docRegion.getEndOffset(docRegion.getFirstRegion())) {
                    this.fAnchor = 1;
                    match = new Region(docRegion.getEndOffset() - 1, 1);
                }
                if (match == null) {
                    ITextRegion currentTextRegion = docRegion.getRegionAtCharacterOffset(offset);
                    if (currentTextRegion instanceof ITextRegionContainer) {
                        ITextRegionContainer container = (ITextRegionContainer)currentTextRegion;
                        currentTextRegion = container.getRegionAtCharacterOffset(offset);
                    }
                    if (currentTextRegion instanceof IPhpScriptRegion) {
                        IPhpScriptRegion scriptRegion = (IPhpScriptRegion)currentTextRegion;
                        try {
                            currentTextRegion = scriptRegion.getPhpToken(offset - docRegion.getStartOffset((ITextRegion)scriptRegion));
                            if (currentTextRegion == null || currentTextRegion.getTextLength() <= 1) break block25;
                            int offsetAtNearEdge = offset;
                            if (offset == docRegion.getTextEndOffset(currentTextRegion)) {
                                offsetAtNearEdge = offset - 1;
                            } else if (offset == docRegion.getStartOffset(currentTextRegion) + 1) {
                                offsetAtNearEdge = offset - 1;
                            }
                            if (offsetAtNearEdge == docRegion.getStartOffset(currentTextRegion)) {
                                int end = docRegion.getTextEndOffset(currentTextRegion);
                                try {
                                    if (document.getChar(offsetAtNearEdge) == document.getChar(end - 1)) {
                                        this.fAnchor = 1;
                                        match = new Region(end - 1, 1);
                                    }
                                    break block25;
                                }
                                catch (BadLocationException badLocationException) {}
                                break block25;
                            }
                            if (offsetAtNearEdge == docRegion.getTextEndOffset(currentTextRegion) - 1) {
                                int start = docRegion.getStartOffset(currentTextRegion);
                                if (document.getChar(offsetAtNearEdge) == document.getChar(start)) {
                                    this.fAnchor = 0;
                                    match = new Region(start, 1);
                                }
                            }
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }
            }
        }
        try {
            char currChar;
            if (match != null && match.getLength() == 1 && ((currChar = document.getChar(match.getOffset())) == ' ' || currChar == '\t')) {
                match = null;
            }
        }
        catch (BadLocationException badLocationException) {}
        if (match == null && this.fNextMatcher != null) {
            this.fAnchor = -1;
            match = this.fNextMatcher.match(document, offset);
        }
        return match;
    }
}

