/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.php.internal.ui.util.DefaultElementComparer;

public final class TreePath {
    private Object[] fSegments;
    private int fHash;

    public TreePath(Object[] segments) {
        Assert.isNotNull((Object)segments);
        int i = 0;
        while (i < segments.length) {
            Assert.isNotNull((Object)segments[i]);
            ++i;
        }
        this.fSegments = segments;
    }

    public Object getSegment(int index) {
        return this.fSegments[index];
    }

    public int getSegmentCount() {
        return this.fSegments.length;
    }

    public Object getFirstSegment() {
        if (this.fSegments.length == 0) {
            return null;
        }
        return this.fSegments[0];
    }

    public Object getLastSegment() {
        if (this.fSegments.length == 0) {
            return null;
        }
        return this.fSegments[this.fSegments.length - 1];
    }

    public boolean equals(Object other) {
        if (!(other instanceof TreePath)) {
            return false;
        }
        TreePath otherPath = (TreePath)other;
        if (this.fSegments.length != otherPath.fSegments.length) {
            return false;
        }
        int i = 0;
        while (i < this.fSegments.length) {
            if (!this.fSegments[i].equals(otherPath.fSegments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        if (this.fHash != 0) {
            return this.fHash;
        }
        int i = 0;
        while (i < this.fSegments.length) {
            this.fHash += this.fSegments[i].hashCode();
            ++i;
        }
        return this.fHash;
    }

    public boolean equals(TreePath otherPath, IElementComparer comparer) {
        if (comparer == null) {
            comparer = DefaultElementComparer.INSTANCE;
        }
        if (otherPath == null) {
            return false;
        }
        if (this.fSegments.length != otherPath.fSegments.length) {
            return false;
        }
        int i = 0;
        while (i < this.fSegments.length) {
            if (!comparer.equals(this.fSegments[i], otherPath.fSegments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

