/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui.launching.zend;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.debug.ui.IDebugServerConnectionTest;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerSettingsUtil;
import org.eclipse.php.internal.debug.core.zend.testConnection.DebugServerTestController;
import org.eclipse.php.internal.debug.core.zend.testConnection.DebugServerTestEvent;
import org.eclipse.php.internal.debug.core.zend.testConnection.IDebugServerTestListener;
import org.eclipse.php.internal.server.PHPServerUIMessages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.ui.Logger;
import org.eclipse.php.internal.server.ui.launching.zend.DefaultServerTestMessageDialog;
import org.eclipse.swt.widgets.Shell;

public class DefaultDebugServerConnectionTest
implements IDebugServerConnectionTest,
IDebugServerTestListener {
    private static final int DEFAULT_TIMEOUT = 10000;
    protected Shell fShell;
    protected Server fServer;
    protected String fURL;
    protected Boolean fIsFinished = false;
    protected ProgressMonitorDialog fProgressDialog = null;
    protected List<String> fTimeoutServerList = new ArrayList<String>();
    protected ClientTest fClientTest;
    protected CountDownLatch fClientTestLatch;
    protected String fCurrentHost;

    public void testConnection(Server server, Shell shell) {
        this.fServer = server;
        this.fShell = shell;
        this.fURL = server.getBaseURL();
        TestPerformer runnableWithProgress = new TestPerformer();
        this.fProgressDialog = new ProgressMonitorDialog(this.fShell);
        this.fProgressDialog.setBlockOnOpen(false);
        this.fProgressDialog.setCancelable(true);
        this.fProgressDialog.open();
        this.fProgressDialog.getShell().setText(PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_debugger_connection_test"));
        try {
            this.fProgressDialog.run(true, true, (IRunnableWithProgress)runnableWithProgress);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    public void testEventReceived(DebugServerTestEvent e) {
        this.fIsFinished = true;
        this.fClientTestLatch.countDown();
        switch (e.getEventType()) {
            case 0: {
                this.showSuccessDialog();
                break;
            }
            case 2: {
                MessageDialog.openError((Shell)this.fShell, (String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_testDebugServer"), (String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_oldDebuggerVersion"));
                break;
            }
            case 1: {
                this.showCustomErrorDialog(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_timeOutMessage"), (Object)this.fURL));
            }
        }
    }

    protected String generateDebugQuery(String host) {
        String urlToDebug = "";
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(this.fURL);
        queryBuilder.append("/dummy.php?start_debug=1&debug_port=");
        queryBuilder.append(this.getPort());
        queryBuilder.append("&debug_fastfile=1&debug_host=");
        queryBuilder.append(String.valueOf(host) + "&testConnection=true");
        urlToDebug = queryBuilder.toString();
        return urlToDebug;
    }

    protected String getPort() {
        String port = Integer.toString(PHPDebugPlugin.getDebugPort((String)"org.eclipse.php.debug.core.zendDebugger"));
        int customPort = ZendDebuggerSettingsUtil.getDebugPort((String)this.fServer.getUniqueId());
        if (customPort != -1) {
            port = String.valueOf(customPort);
        }
        return port;
    }

    protected String[] getAllLocalHostsAddresses() {
        String hosts = PHPDebugPlugin.getDebugHosts();
        String customHosts = ZendDebuggerSettingsUtil.getDebugHosts((String)this.fServer.getUniqueId());
        if (!customHosts.isEmpty()) {
            hosts = customHosts;
        }
        StringTokenizer tokenizer = new StringTokenizer(hosts, ", ");
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    protected String addTimeOutsMessage(String message) {
        String result = message;
        if (this.fTimeoutServerList.size() > 0) {
            Iterator<String> iter = this.fTimeoutServerList.iterator();
            StringBuilder stringBuilder = new StringBuilder();
            while (iter.hasNext()) {
                stringBuilder.append("\u2022 " + iter.next() + '\n');
            }
            result = String.valueOf(result) + stringBuilder.toString();
        }
        return result;
    }

    protected void showCustomErrorDialog(final String message) {
        this.fShell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DefaultServerTestMessageDialog dialog = new DefaultServerTestMessageDialog(DefaultDebugServerConnectionTest.this.fShell, PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_testDebugServer"), null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.open();
            }
        });
    }

    protected void showSuccessDialog() {
        String message = NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_success"), (Object)this.fCurrentHost);
        final StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(message);
        if (this.fTimeoutServerList.size() > 0) {
            stringBuilder.append("\n");
            stringBuilder.append(PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_however"));
            stringBuilder.append(this.addTimeOutsMessage(""));
        }
        this.fShell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)DefaultDebugServerConnectionTest.this.fShell, (String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_testDebugServer"), (String)stringBuilder.toString());
            }
        });
    }

    protected class ClientTest
    extends Job {
        protected String query;
        protected Exception exception;

        public ClientTest(String query) {
            super("");
            this.query = query;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                try {
                    this.perform();
                }
                catch (Exception e) {
                    this.exception = e;
                    DefaultDebugServerConnectionTest.this.fClientTestLatch.countDown();
                }
            }
            finally {
                DefaultDebugServerConnectionTest.this.fClientTestLatch.countDown();
            }
            return Status.OK_STATUS;
        }

        private void perform() throws MalformedURLException, IOException {
            try (InputStream inputStream = null;){
                URL checkDebugURL = new URL(this.query);
                URLConnection debugConnection = checkDebugURL.openConnection();
                debugConnection.setReadTimeout(10000);
                inputStream = debugConnection.getInputStream();
            }
        }
    }

    protected class TestPerformer
    implements IRunnableWithProgress {
        protected TestPerformer() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            DebugServerTestController.getInstance().addListener((IDebugServerTestListener)DefaultDebugServerConnectionTest.this);
            monitor.beginTask(PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_testingConnectivity"), -1);
            try {
                String[] clientHosts;
                monitor.subTask(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_testingServerExistence"), (Object)DefaultDebugServerConnectionTest.this.fServer.getName()));
                this.checkServer();
                if (monitor.isCanceled()) {
                    return;
                }
                String[] stringArray = clientHosts = DefaultDebugServerConnectionTest.this.getAllLocalHostsAddresses();
                int n = clientHosts.length;
                int n2 = 0;
                while (n2 < n) {
                    block25: {
                        String clientHost;
                        block24: {
                            clientHost = stringArray[n2];
                            if (monitor.isCanceled()) {
                                return;
                            }
                            DefaultDebugServerConnectionTest.this.fCurrentHost = clientHost;
                            String debugQuery = DefaultDebugServerConnectionTest.this.generateDebugQuery(clientHost);
                            monitor.subTask(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_testingCommunication"), (Object)clientHost));
                            try {
                                this.checkClient(monitor, debugQuery);
                            }
                            catch (SocketTimeoutException socketTimeoutException) {
                                if (DefaultDebugServerConnectionTest.this.fIsFinished.booleanValue()) break block24;
                                DefaultDebugServerConnectionTest.this.fTimeoutServerList.add(clientHost);
                                break block25;
                            }
                        }
                        if (monitor.isCanceled() || DefaultDebugServerConnectionTest.this.fIsFinished.booleanValue()) {
                            return;
                        }
                        if (!this.checkTimeout(monitor)) break;
                        DefaultDebugServerConnectionTest.this.fTimeoutServerList.add(clientHost);
                    }
                    ++n2;
                }
                if (monitor.isCanceled() || DefaultDebugServerConnectionTest.this.fIsFinished.booleanValue()) {
                    return;
                }
                try {
                    DefaultDebugServerConnectionTest.this.showCustomErrorDialog(DefaultDebugServerConnectionTest.this.addTimeOutsMessage(PHPServerUIMessages.getString("DefaultDebugServerConnectionTest.1")));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    DefaultDebugServerConnectionTest.this.showCustomErrorDialog(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_theURLCouldNotBeFound"), (Object)DefaultDebugServerConnectionTest.this.fURL));
                    return;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    DefaultDebugServerConnectionTest.this.showCustomErrorDialog(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_timeOutMessage"), (Object)DefaultDebugServerConnectionTest.this.fURL));
                    return;
                }
                catch (ConnectException connectException) {
                    DefaultDebugServerConnectionTest.this.showCustomErrorDialog(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_webServerConnectionFailed"), (Object)DefaultDebugServerConnectionTest.this.fURL));
                    return;
                }
                catch (IOException iOException) {
                    DefaultDebugServerConnectionTest.this.showCustomErrorDialog(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_webServerConnectionFailed"), (Object)DefaultDebugServerConnectionTest.this.fURL));
                    return;
                }
                catch (Exception ex) {
                    Logger.logException(ex);
                    DefaultDebugServerConnectionTest.this.showCustomErrorDialog(PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_Unexpected_error_occurred"));
                }
            }
            finally {
                DebugServerTestController.getInstance().removeListener((IDebugServerTestListener)DefaultDebugServerConnectionTest.this);
            }
        }

        private boolean checkTimeout(IProgressMonitor monitor) throws InterruptedException {
            int i = 0;
            while (i < 10) {
                if (monitor.isCanceled()) {
                    return false;
                }
                Thread.sleep(1000L);
                if (DefaultDebugServerConnectionTest.this.fIsFinished.booleanValue()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private void checkClient(IProgressMonitor monitor, String debugQuery) throws Exception {
            DefaultDebugServerConnectionTest.this.fClientTestLatch = new CountDownLatch(1);
            DefaultDebugServerConnectionTest.this.fClientTest = new ClientTest(debugQuery);
            DefaultDebugServerConnectionTest.this.fClientTest.schedule();
            while (!monitor.isCanceled() && !DefaultDebugServerConnectionTest.this.fIsFinished.booleanValue() && DefaultDebugServerConnectionTest.this.fClientTest.getState() != 0) {
                try {
                    DefaultDebugServerConnectionTest.this.fClientTestLatch.await(500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (DefaultDebugServerConnectionTest.this.fClientTest.exception != null) {
                throw DefaultDebugServerConnectionTest.this.fClientTest.exception;
            }
        }

        private void checkServer() throws MalformedURLException, IOException {
            try (InputStream inputStream = null;){
                URL checkURL = new URL(String.valueOf(DefaultDebugServerConnectionTest.this.fURL) + "/dummy.php");
                URLConnection connection = checkURL.openConnection();
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(10000);
                inputStream = connection.getInputStream();
            }
        }
    }
}

