/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core;

import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.php.internal.core.IUniqueIdentityElement;
import org.eclipse.php.internal.core.UniqueIdentityElementUtil;
import org.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;
import org.eclipse.php.internal.server.core.Logger;
import org.eclipse.php.internal.server.core.ServerHelper;

public class Server
implements IXMLPreferencesStorable,
IAdaptable,
IUniqueIdentityElement {
    public static final String SERVER_ELEMENT = "server";
    public static final String UNIQUE_ID = "id";
    public static final String NAME = "name";
    public static final String BASE_URL = "base_url";
    public static final String DOCUMENT_ROOT = "document_root";
    public static final String PORT = "port";
    public static final String HOSTNAME = "hostname";
    public static final String FILE_NAME = "file_name";
    public static final String DEBUGGER = "debuggerId";
    public static final String LOCALSERVER = "localserver";
    public static final String ID_PREFIX = "php-server";
    public static final String NONE_DEBUGGER_ID = "org.eclipse.php.debug.core.noneDebugger";
    private static final int DEFAULT_HTTP_PORT = 80;
    private ServerHelper helper = new ServerHelper(this);

    public Server() {
        this.createUniqueId();
        this.setDebuggerId(NONE_DEBUGGER_ID);
    }

    public Server(String name, String host, String baseURL, String documentRoot) throws MalformedURLException {
        this();
        this.setName(name);
        this.setHost(host);
        this.setBaseURL(baseURL);
        this.setDocumentRoot(documentRoot);
    }

    public String getUniqueId() {
        return this.getAttribute(UNIQUE_ID, null);
    }

    private void createUniqueId() {
        this.setAttribute(UNIQUE_ID, UniqueIdentityElementUtil.generateId((String)ID_PREFIX));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.helper.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.helper.removePropertyChangeListener(listener);
    }

    public void setAttribute(String attributeName, String value) {
        this.helper.setAttribute(attributeName, value);
    }

    public String getAttribute(String attributeName, String defaultValue) {
        return this.helper.getAttribute(attributeName, defaultValue);
    }

    public void removeAttribute(String attributeName) {
        this.helper.removeAttribute(attributeName);
    }

    public String getName() {
        return this.getAttribute(NAME, "");
    }

    public void setName(String name) {
        this.setAttribute(NAME, name);
    }

    public String getBaseURL() {
        URL resultURL;
        String base = this.getAttribute(BASE_URL, "");
        String port = this.getPortString();
        try {
            URL baseURL = new URL(base);
            resultURL = new URL(baseURL.getProtocol(), baseURL.getHost(), this.getFormattedPort(port), "");
        }
        catch (MalformedURLException malformedURLException) {
            return base;
        }
        return resultURL.toString();
    }

    private int getFormattedPort(String port) {
        int i;
        int n = i = port == null || port.length() == 0 ? -1 : Integer.valueOf(port);
        if (i == 80) {
            i = -1;
        }
        return i;
    }

    public void setBaseURL(String url) throws MalformedURLException {
        URL baseURL = new URL(url);
        if (baseURL.getPort() != -1) {
            this.setPort(String.valueOf(baseURL.getPort()));
        }
        URL url2 = new URL(baseURL.getProtocol(), baseURL.getHost(), "");
        this.setAttribute(BASE_URL, url2.toString());
    }

    public String getHost() {
        return this.getAttribute(HOSTNAME, "localhost");
    }

    public void setHost(String host) {
        this.setAttribute(HOSTNAME, host);
    }

    public void setDocumentRoot(String docRoot) {
        this.setAttribute(DOCUMENT_ROOT, docRoot);
    }

    public String getDocumentRoot() {
        return this.getAttribute(DOCUMENT_ROOT, "");
    }

    public URL getRootURL() {
        try {
            return new URL(this.getBaseURL());
        }
        catch (Exception e) {
            Logger.logException("Could not get root URL", e);
            return null;
        }
    }

    protected static String renderCommandLine(String[] commandLine, String separator) {
        if (commandLine == null || commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer(commandLine[0]);
        int i = 1;
        while (i < commandLine.length) {
            buf.append(separator);
            buf.append(commandLine[i]);
            ++i;
        }
        return buf.toString();
    }

    public int getPort() {
        int port = Integer.parseInt(this.getPortString());
        if (port < 0) {
            port = 80;
        }
        return port;
    }

    public String getPortString() {
        return this.getAttribute(PORT, "80");
    }

    public void setPort(String port) {
        try {
            if (port.equals("")) {
                this.setAttribute(PORT, "80");
            } else {
                this.setAttribute(PORT, port);
            }
        }
        catch (Throwable throwable) {}
    }

    public void setDebuggerId(String debuggerId) {
        this.setAttribute(DEBUGGER, debuggerId);
    }

    public String getDebuggerId() {
        return this.getAttribute(DEBUGGER, null);
    }

    public int hashCode() {
        if (this.getName() != null) {
            return this.getName().hashCode();
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Server)) {
            return false;
        }
        String name = this.getName();
        String otherName = ((Server)obj).getName();
        if (name == null && otherName != null) {
            return false;
        }
        return name.equals(otherName);
    }

    public String toString() {
        return "Server [" + this.getName() + "::" + this.getHost() + ']';
    }

    public void restoreFromMap(Map<String, Object> map) {
        Map properties = (Map)map.get(SERVER_ELEMENT);
        for (Map.Entry entry : properties.entrySet()) {
            this.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        if (!properties.containsKey(UNIQUE_ID)) {
            this.createUniqueId();
        }
    }

    public Map<String, Object> storeToMap() {
        HashMap<String, String> properties = new HashMap<String, String>(this.helper.map);
        HashMap<String, Object> serverMap = new HashMap<String, Object>(1);
        serverMap.put(SERVER_ELEMENT, properties);
        return serverMap;
    }

    public boolean isLocal() {
        try {
            String host = this.getHost();
            if (host != null) {
                InetAddress addr = InetAddress.getByName(host);
                return addr.isLoopbackAddress() || addr.isSiteLocalAddress();
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public Server makeCopy() {
        Server copy = new Server();
        copy.helper.map = new HashMap<String, String>(this.helper.map);
        return copy;
    }

    public void update(Server copy) {
        Assert.isTrue((boolean)this.getUniqueId().equals(copy.getUniqueId()));
        Set<String> keys = copy.helper.map.keySet();
        for (String key : keys) {
            if (key.equals(UNIQUE_ID)) continue;
            this.helper.setAttribute(key, copy.helper.map.get(key));
        }
        ArrayList<String> attributesToRemove = new ArrayList<String>();
        for (String key : this.helper.map.keySet()) {
            if (copy.helper.map.containsKey(key)) continue;
            attributesToRemove.add(key);
        }
        for (String key : attributesToRemove) {
            this.helper.removeAttribute(key);
        }
    }
}

