/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceProcessors;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.ast.locator.PhpElementConciliator;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ConstantDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Dispatch;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FullyQualifiedTraitMethodReference;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticDispatch;
import org.eclipse.php.internal.core.ast.nodes.TraitAlias;
import org.eclipse.php.internal.core.ast.nodes.TraitUseStatement;
import org.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.typeinference.TraitUtils;
import org.eclipse.php.refactoring.core.PhpRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.RefactoringPlugin;
import org.eclipse.php.refactoring.core.rename.AbstractRenameProcessor;
import org.eclipse.php.refactoring.core.rename.ITextUpdating;
import org.eclipse.php.refactoring.core.rename.logic.RenameClassMember;
import org.eclipse.php.refactoring.core.utils.RefactoringUtility;

public class RenameClassMemberProcessor
extends AbstractRenameProcessor<IFile>
implements ITextUpdating {
    private static final String RENAME_IS_PROCESSING = PhpRefactoringCoreMessages.getString("RenameClassPropertyProcessor.2");
    private static final String CREATING_MODIFICATIONS_LABEL = PhpRefactoringCoreMessages.getString("RenameClassPropertyProcessor.3");
    private static final String ID_RENAME_CLASS_MEMBER = "php.refactoring.ui.rename.classProperty";
    protected static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    public static final String RENAME_CLASS_MEMBER_PROCESSOR_NAME = PhpRefactoringCoreMessages.getString("RenameClassPropertyProcessor.5");
    private ASTNode identifier = null;
    private boolean isUpdateTextualMatches;
    public boolean showShouldOverrideMessage = false;
    private ITypeBinding typeBinding;

    public RenameClassMemberProcessor(IFile operatedFile, ASTNode locateNode) {
        super(operatedFile);
        this.identifier = locateNode;
        this.showShouldOverrideMessage = true;
        this.typeBinding = this.getCurrentType();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange rootChange = new CompositeChange(PhpRefactoringCoreMessages.getString("RenameClassPropertyProcessor.7"));
        rootChange.markAsSynthetic();
        try {
            pm.beginTask(RENAME_IS_PROCESSING, this.participantFiles.size());
            pm.setTaskName(CREATING_MODIFICATIONS_LABEL);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            String newElementName = this.getNewElementName();
            for (Map.Entry entry : this.participantFiles.entrySet()) {
                IFile file = (IFile)entry.getKey();
                Program program = (Program)entry.getValue();
                RenameClassMember rename = new RenameClassMember(file, this.getCurrentElementName(), newElementName, this.getUpdateTextualMatches(), this.typeBinding, this.getParent(this.identifier).getType(), this.identifier);
                try {
                    program.accept((Visitor)rename);
                }
                catch (Exception e) {
                    RefactoringPlugin.logException(e);
                }
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                pm.worked(1);
                if (!rename.hasChanges()) continue;
                TextFileChange change = this.acquireChange(file, program);
                rename.updateChange(change);
                rootChange.add((Change)change);
            }
            CompositeChange compositeChange = rootChange;
            return compositeChange;
        }
        catch (Exception e) {
            RefactoringPlugin.logException(e);
            CompositeChange compositeChange = rootChange;
            return compositeChange;
        }
        finally {
            pm.done();
        }
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.identifier};
    }

    public String getIdentifier() {
        return ID_RENAME_CLASS_MEMBER;
    }

    public String getProcessorName() {
        return RENAME_CLASS_MEMBER_PROCESSOR_NAME;
    }

    @Override
    public Object getNewElement() {
        return this.getNewElementName();
    }

    @Override
    public String getCurrentElementName() {
        if (this.identifier instanceof Variable) {
            Identifier id = (Identifier)((Variable)this.identifier).getName();
            return id.getName();
        }
        if (this.identifier instanceof Identifier) {
            return ((Identifier)this.identifier).getName();
        }
        if (this.identifier instanceof FunctionDeclaration) {
            Identifier name = ((FunctionDeclaration)this.identifier).getFunctionName();
            return name.getName();
        }
        if (this.identifier instanceof MethodDeclaration) {
            Identifier name = ((MethodDeclaration)this.identifier).getFunction().getFunctionName();
            return name.getName();
        }
        return this.identifier.toString();
    }

    @Override
    public boolean canEnableTextUpdating() {
        return true;
    }

    @Override
    public String getCurrentElementQualifier() {
        return this.identifier.toString();
    }

    @Override
    public boolean getUpdateTextualMatches() {
        return this.isUpdateTextualMatches;
    }

    @Override
    public void setUpdateTextualMatches(boolean update) {
        this.isUpdateTextualMatches = update;
    }

    public ITypeBinding getCurrentType() {
        TypeDeclaration type;
        if (this.identifier instanceof Identifier) {
            if (this.identifier.getParent().getType() == 73) {
                FullyQualifiedTraitMethodReference reference = (FullyQualifiedTraitMethodReference)this.identifier.getParent();
                return reference.getClassName().resolveTypeBinding();
            }
            if (this.identifier.getParent().getType() == 74) {
                TraitAlias traitAlias = (TraitAlias)this.identifier.getParent();
                List nameList = ((TraitUseStatement)traitAlias.getParent().getParent()).getTraitList();
                String memberName = null;
                if (this.identifier == traitAlias.getFunctionName()) {
                    Expression expression = traitAlias.getTraitMethod();
                    if (expression.getType() == 73) {
                        FullyQualifiedTraitMethodReference fqtm = (FullyQualifiedTraitMethodReference)expression;
                        memberName = fqtm.getFunctionName().getName();
                    } else {
                        memberName = ((Identifier)expression).getName();
                    }
                } else {
                    memberName = ((Identifier)this.identifier).getName();
                }
                for (NamespaceName namespaceName : nameList) {
                    ITypeBinding typeBinding = namespaceName.resolveTypeBinding();
                    if (typeBinding == null || !typeBinding.isTrait() || typeBinding.getPHPElement() == null) continue;
                    try {
                        IModelElement[] members;
                        IModelElement[] iModelElementArray = members = ((IType)typeBinding.getPHPElement()).getChildren();
                        int n = members.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IModelElement modelElement = iModelElementArray[n2];
                            if (modelElement.getElementName().equals(memberName) || modelElement.getElementName().equals("$" + memberName)) {
                                return typeBinding;
                            }
                            ++n2;
                        }
                    }
                    catch (ModelException modelException) {}
                }
            }
        }
        if (this.identifier instanceof Expression) {
            ASTNode parent = this.identifier.getParent();
            Dispatch dispatch = this.getDispatch(parent);
            if (dispatch != null) {
                return dispatch.getDispatcher().resolveTypeBinding();
            }
            TypeDeclaration type2 = RefactoringUtility.getType(this.identifier);
            if (type2 != null) {
                return type2.resolveTypeBinding();
            }
            StaticDispatch staticDispatch = this.getStaticDispatch(parent);
            if (staticDispatch != null) {
                return staticDispatch.getClassName().resolveTypeBinding();
            }
        }
        if (this.identifier instanceof FieldsDeclaration && (type = RefactoringUtility.getType(this.identifier)) != null) {
            return type.resolveTypeBinding();
        }
        if (this.identifier instanceof FunctionDeclaration && (type = RefactoringUtility.getType(this.identifier)) != null) {
            return type.resolveTypeBinding();
        }
        if (this.identifier instanceof MethodDeclaration && (type = RefactoringUtility.getType(this.identifier)) != null) {
            return type.resolveTypeBinding();
        }
        if (this.identifier instanceof ConstantDeclaration && (type = RefactoringUtility.getType(this.identifier)) != null) {
            return type.resolveTypeBinding();
        }
        return null;
    }

    private Dispatch getDispatch(ASTNode node) {
        if (node == null) {
            return null;
        }
        ASTNode model = node;
        while (!(model instanceof Dispatch)) {
            if (node == null) {
                return null;
            }
            ASTNode parent = model.getParent();
            if (parent == model) {
                return null;
            }
            model = parent;
            if (!(model instanceof Program) && model != null) continue;
            return null;
        }
        return (Dispatch)model;
    }

    private StaticDispatch getStaticDispatch(ASTNode node) {
        if (node == null) {
            return null;
        }
        ASTNode model = node;
        while (!(model instanceof StaticDispatch)) {
            if (node == null) {
                return null;
            }
            ASTNode parent = model.getParent();
            if (parent == model) {
                return null;
            }
            model = parent;
            if (!(model instanceof Program) && model != null) continue;
            return null;
        }
        return (StaticDispatch)model;
    }

    @Override
    protected void collectReferences(Program program, IProgressMonitor pm) {
        SearchEngine engine;
        final ArrayList<IResource> list = new ArrayList<IResource>();
        if (this.identifier instanceof Identifier) {
            if (this.identifier.getParent().getType() == 73) {
                list.add(this.identifier.getProgramRoot().getSourceModule().getResource());
            } else if (this.identifier.getParent().getType() == 74) {
                list.add(this.identifier.getProgramRoot().getSourceModule().getResource());
            }
        }
        try {
            IModelElement[] elements;
            IModelElement[] iModelElementArray = elements = this.identifier.getProgramRoot().getSourceModule().codeSelect(this.identifier.getStart(), 0);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement modelElement = iModelElementArray[n2];
                if (modelElement instanceof TraitUtils.ITraitMember) {
                    TraitUtils.ITraitMember tm = (TraitUtils.ITraitMember)modelElement;
                    list.add(tm.getHostType().getResource());
                }
                ++n2;
            }
        }
        catch (ModelException modelException) {}
        IScriptProject project = this.identifier.getProgramRoot().getSourceModule().getScriptProject();
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project, (int)RenameClassMemberProcessor.getSearchFlags(false));
        ASTNode node = this.getParent(this.identifier);
        SearchPattern pattern = null;
        if (node instanceof Variable || node instanceof FieldsDeclaration) {
            pattern = SearchPattern.createPattern((String)("$" + this.getCurrentElementName()), (int)2, (int)2, (int)16, (IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
            engine = new SearchEngine();
            try {
                engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                    public void acceptSearchMatch(SearchMatch match) throws CoreException {
                        IModelElement element = (IModelElement)match.getElement();
                        list.add(element.getResource());
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
        }
        if (node instanceof ConstantDeclaration || node instanceof StaticConstantAccess) {
            pattern = SearchPattern.createPattern((String)this.getCurrentElementName(), (int)2, (int)2, (int)16, (IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
            engine = new SearchEngine();
            try {
                engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                    public void acceptSearchMatch(SearchMatch match) throws CoreException {
                        IModelElement element = (IModelElement)match.getElement();
                        list.add(element.getResource());
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
        }
        int matchMode = 16;
        if (node instanceof FunctionDeclaration || node instanceof MethodDeclaration || node instanceof FunctionName) {
            pattern = SearchPattern.createPattern((String)this.getCurrentElementName(), (int)1, (int)2, (int)matchMode, (IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
            SearchEngine engine2 = new SearchEngine();
            try {
                engine2.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                    public void acceptSearchMatch(SearchMatch match) throws CoreException {
                        IModelElement element = (IModelElement)match.getElement();
                        list.add(element.getResource());
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
        }
        for (IResource file : list) {
            if (!(file instanceof IFile)) continue;
            try {
                this.participantFiles.put((IFile)file, RefactoringUtility.getProgramForFile((IFile)file));
            }
            catch (Exception exception) {}
        }
    }

    private ASTNode getParent(ASTNode identifier) {
        ASTNode node = identifier instanceof Identifier ? identifier.getParent() : identifier;
        if (node instanceof Variable && node.getParent() instanceof FunctionName) {
            return node.getParent();
        }
        return node;
    }

    @Override
    public RefactoringStatus getRefactoringStatus(IFile key, Program program) {
        TypeDeclaration host;
        int type = PhpElementConciliator.concile((ASTNode)this.identifier);
        this.identifier.getParent();
        if (type == 6 && (host = RefactoringUtility.getType(this.identifier)) != null && PhpElementConciliator.classMemeberAlreadyExists((TypeDeclaration)host, (String)this.getNewElementName(), (int)this.identifier.getParent().getType())) {
            String message = MessageFormat.format("A same class member with name {0} already exist in the same class scope", this.getNewElementName());
            return RefactoringStatus.createWarningStatus((String)message);
        }
        return new RefactoringStatus();
    }

    @Override
    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        String[] affectedNatures = ResourceProcessors.computeAffectedNatures((IResource)this.resource);
        RenameArguments fRenameArguments = new RenameArguments(this.getNewElementName(), false);
        return ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.identifier, (RenameArguments)fRenameArguments, null, (String[])affectedNatures, (SharableParticipants)sharedParticipants);
    }

    private class RenameClassMemberArguments
    extends RenameArguments {
        public RenameClassMemberArguments(String newName, boolean updateReferences) {
            super(newName, updateReferences);
        }
    }

    class RenameClassMemberParticipant
    extends RenameParticipant {
        RenameClassMemberParticipant() {
        }

        public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
            try {
                return this.getProcessor().checkFinalConditions(pm, context);
            }
            catch (CoreException coreException) {
                return new RefactoringStatus();
            }
        }

        public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return this.getProcessor().createChange(pm);
        }

        public String getName() {
            return RenameClassMemberProcessor.this.getProcessorName();
        }

        protected boolean initialize(Object element) {
            try {
                RenameClassMemberArguments arguments = (RenameClassMemberArguments)this.getArguments();
                ((AbstractRenameProcessor)this.getProcessor()).setNewElementName(arguments.getNewName());
                this.getProcessor().checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
    }
}

