/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename.logic;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.editor.highlighter.ModelUtils;
import org.eclipse.php.refactoring.core.PhpRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.rename.logic.AbstractRename;
import org.eclipse.php.refactoring.core.utils.RefactoringUtility;

public class RenameClass
extends AbstractRename {
    private static final String RENAME_CLASS = PhpRefactoringCoreMessages.getString("RenameClassName.0");
    private ASTNode originalDeclaration;
    private IType[] types;

    public RenameClass(IFile file, ASTNode originalNode, String oldName, String newName, boolean searchTextual, IType[] types) {
        super(file, oldName, newName, searchTextual);
        if (originalNode != null) {
            this.originalDeclaration = RefactoringUtility.getTypeOrClassInstance(originalNode);
        }
        this.types = types;
    }

    public boolean visit(StaticConstantAccess staticDispatch) {
        Expression className = staticDispatch.getClassName();
        Identifier identifier = null;
        if (className instanceof Variable) {
            identifier = (Identifier)((Variable)className).getName();
        }
        if (className instanceof Identifier) {
            identifier = (Identifier)className;
        }
        if (identifier != null) {
            this.checkIdentifier(identifier);
        }
        return false;
    }

    public boolean visit(UseStatement useStatement) {
        List parts = useStatement.parts();
        for (UseStatementPart useStatementPart : parts) {
            List idList = useStatementPart.getName().segments();
            if (idList.isEmpty()) continue;
            this.checkIdentifier((Identifier)idList.get(idList.size() - 1));
        }
        return false;
    }

    public boolean visit(StaticFieldAccess staticDispatch) {
        this.checkIdentifier((Identifier)staticDispatch.getClassName());
        return false;
    }

    public boolean visit(StaticMethodInvocation staticDispatch) {
        this.checkIdentifier((Identifier)staticDispatch.getClassName());
        return false;
    }

    public boolean visit(ClassName className) {
        if (className.getName() instanceof Identifier) {
            NamespaceName namespaceName;
            Identifier identifier = (Identifier)className.getName();
            if (identifier instanceof NamespaceName && (namespaceName = (NamespaceName)identifier).segments() != null && namespaceName.segments().size() > 0) {
                identifier = (Identifier)namespaceName.segments().get(namespaceName.segments().size() - 1);
            }
            this.checkIdentifier(identifier);
        }
        return false;
    }

    public boolean visit(ClassDeclaration classDeclaration) {
        ITypeBinding originalType = null;
        if (this.originalDeclaration != null) {
            if (this.originalDeclaration instanceof TypeDeclaration) {
                originalType = ((TypeDeclaration)this.originalDeclaration).resolveTypeBinding();
            }
            if (this.originalDeclaration instanceof ClassInstanceCreation) {
                originalType = ((ClassInstanceCreation)this.originalDeclaration).resolveTypeBinding();
            }
        }
        ITypeBinding currType = classDeclaration.resolveTypeBinding();
        if (this.originalDeclaration == null || currType == null || this.originalDeclaration.getStart() == classDeclaration.getStart() || originalType.equals((Object)currType) || originalType.isSubTypeCompatible(currType)) {
            this.checkIdentifier(classDeclaration.getName());
        }
        this.checkSuper((Identifier)classDeclaration.getSuperClass(), classDeclaration.interfaces());
        return true;
    }

    public boolean visit(InterfaceDeclaration interfaceDeclaration) {
        if (this.originalDeclaration == null || this.originalDeclaration.getStart() == interfaceDeclaration.getStart()) {
            this.checkIdentifier(interfaceDeclaration.getName());
        }
        this.checkSuper(null, interfaceDeclaration.interfaces());
        return true;
    }

    public boolean visit(CatchClause catchStatement) {
        this.checkIdentifier((Identifier)catchStatement.getClassName());
        return true;
    }

    public boolean visit(FormalParameter formalParameter) {
        this.checkIdentifier((Identifier)formalParameter.getParameterType());
        return true;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        ASTNode parent = methodDeclaration.getParent();
        if (parent.getType() == 6 && parent.getParent().getType() == 12) {
            ClassDeclaration classDeclaration = (ClassDeclaration)parent.getParent();
            Identifier functionName = methodDeclaration.getFunction().getFunctionName();
            if (this.checkForNameEquality(classDeclaration.getName()) && this.checkForNameEquality(functionName)) {
                this.checkIdentifier(functionName);
            }
        }
        return true;
    }

    public boolean visit(FunctionDeclaration function) {
        boolean result = super.visit(function);
        if (this.searchTextual) {
            return result;
        }
        IMethod method = ModelUtils.getFunctionMethod((FunctionDeclaration)function);
        if (method != null) {
            PHPDocTag[] tags;
            IType currentNamespace = PHPModelUtils.getCurrentNamespace((IModelElement)method);
            ISourceModule sm = method.getSourceModule();
            PHPDocBlock doc = ModelUtils.getPHPDoc((IModelElement)method);
            if (doc == null) {
                return result;
            }
            PHPDocTag[] pHPDocTagArray = tags = doc.getTags();
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocTag tag = pHPDocTagArray[n2];
                ArrayList<TypeReference> matchRefs = new ArrayList<TypeReference>();
                for (TypeReference ref : tag.getTypeReferences()) {
                    if (!ref.getName().equals(this.oldName)) continue;
                    IType[] elements = ModelUtils.getTypes((String)this.oldName, (ISourceModule)sm, (int)doc.sourceStart(), (IType)currentNamespace);
                    int i = 0;
                    while (i < elements.length) {
                        int j = 0;
                        while (j < this.types.length) {
                            if (elements[i].equals(this.types[j])) {
                                matchRefs.add(ref);
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                for (TypeReference ref : matchRefs) {
                    this.addChange(ref.sourceStart(), this.getRenameDescription());
                }
                ++n2;
            }
        }
        return result;
    }

    private void checkSuper(Identifier superClass, List<Identifier> interfaces) {
        if (superClass != null) {
            NamespaceName namespaceName;
            if (superClass instanceof NamespaceName && (namespaceName = (NamespaceName)superClass).segments() != null && namespaceName.segments().size() > 0) {
                superClass = (Identifier)namespaceName.segments().get(namespaceName.segments().size() - 1);
            }
            this.checkIdentifier(superClass);
        }
        if (interfaces != null) {
            for (Identifier identifier : interfaces) {
                NamespaceName namespaceName;
                if (identifier instanceof NamespaceName && (namespaceName = (NamespaceName)identifier).segments() != null && namespaceName.segments().size() > 0) {
                    identifier = (Identifier)namespaceName.segments().get(namespaceName.segments().size() - 1);
                }
                this.checkIdentifier(identifier);
            }
        }
    }

    protected void checkIdentifier(Identifier identifier) {
        if (this.checkForNameEquality(identifier)) {
            if (this.types == null || this.types.length == 0) {
                this.addChange(identifier);
                return;
            }
            try {
                IModelElement[] elements = identifier.getProgramRoot().getSourceModule().codeSelect(identifier.getStart(), 0);
                int i = 0;
                while (i < elements.length) {
                    int j = 0;
                    while (j < this.types.length) {
                        if (elements[i] instanceof IType) {
                            if (elements[i].equals(this.types[j])) {
                                this.addChange(identifier);
                                return;
                            }
                        } else if (elements[i] instanceof IMethod && ((IMethod)elements[i]).getDeclaringType().equals(this.types[j])) {
                            this.addChange(identifier);
                            return;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (ModelException modelException) {}
        }
    }

    private boolean checkForNameEquality(Identifier identifier) {
        return identifier != null && identifier.getName() != null && identifier.getName().equals(this.oldName);
    }

    @Override
    public String getRenameDescription() {
        return RENAME_CLASS;
    }
}

