/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.performance.filenetwork;

import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.tests.performance.AbstractPDTTTest;
import org.eclipse.php.core.tests.performance.PHPCorePerformanceTests;
import org.eclipse.php.core.tests.performance.PerformanceMonitor;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.filenetwork.FileNetworkUtility;
import org.eclipse.php.internal.core.filenetwork.ReferenceTree;

public class FileNetworkTestsWrapper
extends AbstractPDTTTest {
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected IProject project;
    private PerformanceMonitor perfMonitor;
    protected static final String PROJECT = "filenetwork";
    protected IScriptProject SCRIPT_PROJECT;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/project/filenetwork/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/project/filenetwork/php53"});
    }

    public FileNetworkTestsWrapper() {
        super("");
    }

    public Test suite(Map map) {
        TestSuite suite;
        block9: {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(map.get("project").toString());
            this.perfMonitor = PHPCorePerformanceTests.getPerformanceMonitor();
            suite = new TestSuite("Auto File Network Tests");
            try {
                AbstractPDTTTest test;
                String fileName;
                int n;
                int n2;
                String[] stringArray;
                String[] fileNames = (String[])map.get("referencedfiles");
                if (fileNames != null) {
                    stringArray = (String[])map.get("referencedfiles");
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        fileName = stringArray[n];
                        try {
                            test = new FileNetworkReferencedFilesTests(this, fileName){

                                protected void runTest() throws Throwable {
                                    this.testReferencedFiles(fileName);
                                }
                            };
                            suite.addTest((Test)test);
                        }
                        catch (Exception e) {
                            suite.addTest((Test)new TestCase(fileName){

                                protected void runTest() throws Throwable {
                                    throw e;
                                }
                            });
                        }
                        ++n;
                    }
                }
                if ((fileNames = (String[])map.get("referencingfiles")) == null) break block9;
                stringArray = (String[])map.get("referencingfiles");
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    fileName = stringArray[n];
                    try {
                        test = new FileNetworkReferencingFilesTests(this, fileName){

                            protected void runTest() throws Throwable {
                                this.testReferencingFiles(fileName);
                            }
                        };
                        suite.addTest((Test)test);
                    }
                    catch (Exception e) {
                        suite.addTest((Test)new TestCase(fileName){

                            protected void runTest() throws Throwable {
                                throw e;
                            }
                        });
                    }
                    ++n;
                }
            }
            catch (Exception exception) {}
        }
        return suite;
    }

    public void testReferencingFiles(String fileName) throws Exception {
        IFile file = this.project.getFile(fileName);
        final ISourceModule sourceModule = (ISourceModule)DLTKCore.create((IFile)file);
        this.perfMonitor.execute("PerformanceTests.testReferencingfiles_" + fileName, new PerformanceMonitor.Operation(){

            @Override
            public void run() throws Exception {
                ReferenceTree tree = FileNetworkUtility.buildReferencingFilesTree((ISourceModule)sourceModule, null);
                System.out.println(tree.toString());
            }
        }, 1, 10);
    }

    public void testReferencedFiles(String fileName) throws Exception {
        IFile file = this.project.getFile(fileName);
        final ISourceModule sourceModule = (ISourceModule)DLTKCore.create((IFile)file);
        this.perfMonitor.execute("PerformanceTests.testReferencedfiles_" + fileName, new PerformanceMonitor.Operation(){

            @Override
            public void run() throws Exception {
                ReferenceTree tree = FileNetworkUtility.buildReferencedFilesTree((ISourceModule)sourceModule, null);
                System.out.println(tree.toString());
            }
        }, 1, 10);
    }

    public class FileNetworkReferencedFilesTests
    extends AbstractPDTTTest {
        public FileNetworkReferencedFilesTests(String name) {
            super(name);
        }
    }

    public class FileNetworkReferencingFilesTests
    extends AbstractPDTTTest {
        public FileNetworkReferencingFilesTests(String name) {
            super(name);
        }
    }
}

