/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.wizard;

import java.util.List;
import org.eclipse.dltk.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.ui.editor.PHPSourceViewer;
import org.eclipse.php.refactoring.core.extract.function.ExtractFunctionRefactoring;
import org.eclipse.php.refactoring.core.extract.function.IParameterListChangeListener;
import org.eclipse.php.refactoring.core.extract.function.ParameterInfo;
import org.eclipse.php.refactoring.ui.PHPRefactoringUIMessages;
import org.eclipse.php.refactoring.ui.RefactoringUIPlugin;
import org.eclipse.php.refactoring.ui.wizard.ChangeParametersControl;
import org.eclipse.php.refactoring.ui.wizard.RowLayouter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExtractFunctionInputPage
extends UserInputWizardPage {
    public static final String PAGE_NAME = "ExtractMethodInputPage";
    private ExtractFunctionRefactoring fRefactoring;
    private Text fTextField;
    private boolean fFirstTime;
    private PHPSourceViewer fSignaturePreview;
    private String fSignaturePreviewDocument;
    private IDialogSettings fSettings;
    private static final String DESCRIPTION = RefactoringMessages.ExtractMethodInputPage_description;
    private static final String GENERATE_PHPDOC = "GeneratePHPdoc";

    public ExtractFunctionInputPage() {
        super(PAGE_NAME);
        this.setImageDescriptor(RefactoringUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.php.refactoring.ui", (String)"icons/full/wizban/compunitrefact_wiz.png"));
        this.setDescription(DESCRIPTION);
        this.fFirstTime = true;
        this.fSignaturePreviewDocument = "";
    }

    public void createControl(Composite parent) {
        boolean enabled;
        this.fRefactoring = (ExtractFunctionRefactoring)this.getRefactoring();
        this.loadSettings();
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        RowLayouter layouter = new RowLayouter(2);
        GridData gd = null;
        this.initializeDialogUnits((Control)result);
        Label label = new Label(result, 0);
        label.setText(this.getLabelText());
        this.fTextField = this.createTextInputField(result, 2048);
        this.fTextField.setLayoutData((Object)new GridData(768));
        layouter.perform((Control)label, (Control)this.fTextField, 1);
        if (this.fRefactoring.isClassMethod()) {
            label = new Label(result, 0);
            label.setText(RefactoringMessages.ExtractMethodInputPage_access_Modifiers);
            Composite group = new Composite(result, 0);
            group.setLayoutData((Object)new GridData(768));
            layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginWidth = 0;
            group.setLayout((Layout)layout);
            String[] labels = new String[]{RefactoringMessages.ExtractMethodInputPage_public, RefactoringMessages.ExtractMethodInputPage_protected, RefactoringMessages.ExtractMethodInputPage_default, RefactoringMessages.ExtractMethodInputPage_private};
            Integer[] data = new Integer[]{64, 32, 0, 16};
            Integer visibility = this.fRefactoring.getVisibility();
            int i = 0;
            while (i < labels.length) {
                Button radio = new Button(group, 16);
                radio.setText(labels[i]);
                radio.setData((Object)data[i]);
                if (data[i].equals(visibility)) {
                    radio.setSelection(true);
                }
                radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        ExtractFunctionInputPage.this.setVisibility((Integer)event.widget.getData());
                    }
                });
                ++i;
            }
            layouter.perform((Control)label, (Control)group, 1);
        }
        if (!this.fRefactoring.getParameterInfos().isEmpty()) {
            ChangeParametersControl cp = new ChangeParametersControl(result, 0, RefactoringMessages.ExtractMethodInputPage_parameters, new IParameterListChangeListener(){

                public void parameterChanged(ParameterInfo parameter) {
                    ExtractFunctionInputPage.this.parameterModified();
                }

                public void parameterListChanged() {
                    ExtractFunctionInputPage.this.parameterModified();
                }

                public void parameterAdded(ParameterInfo parameter) {
                    ExtractFunctionInputPage.this.updatePreview(ExtractFunctionInputPage.this.getText());
                }
            }, ChangeParametersControl.Mode.EXTRACT_METHOD);
            gd = new GridData(1808);
            gd.horizontalSpan = 2;
            cp.setLayoutData(gd);
            cp.setInput(this.fRefactoring.getParameterInfos());
        }
        Button checkBox = new Button(result, 32);
        if (this.fRefactoring.isClassMethod()) {
            checkBox.setText(PHPRefactoringUIMessages.getString("ExtractFunctionInputPage_2"));
        } else {
            checkBox.setText(PHPRefactoringUIMessages.getString("ExtractFunctionInputPage_1"));
        }
        boolean generate = this.computeGeneratePHPdoc();
        this.setGeneratePHPdoc(generate);
        checkBox.setSelection(generate);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtractFunctionInputPage.this.setGeneratePHPdoc(((Button)e.widget).getSelection());
            }
        });
        layouter.perform((Control)checkBox);
        int duplicates = this.fRefactoring.getNumberOfDuplicates();
        checkBox = new Button(result, 32);
        if (duplicates == 0) {
            checkBox.setText(RefactoringMessages.ExtractMethodInputPage_duplicates_none);
        } else if (duplicates == 1) {
            checkBox.setText(RefactoringMessages.ExtractMethodInputPage_duplicates_single);
        } else {
            checkBox.setText(NLS.bind((String)RefactoringMessages.ExtractMethodInputPage_duplicates_multi, (Object)duplicates));
        }
        boolean bl = enabled = duplicates > 0;
        if (enabled) {
            checkBox.setSelection(this.fRefactoring.getReplaceDuplicates());
        } else {
            checkBox.setSelection(false);
        }
        checkBox.setEnabled(enabled);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtractFunctionInputPage.this.fRefactoring.setReplaceDuplicates(((Button)e.widget).getSelection());
            }
        });
        layouter.perform((Control)checkBox);
        label = new Label(result, 258);
        label.setLayoutData((Object)new GridData(768));
        layouter.perform((Control)label);
        this.createSignaturePreview(result, layouter);
        Dialog.applyDialogFont((Control)result);
    }

    private Text createTextInputField(Composite parent, int style) {
        Text result = new Text(parent, style);
        result.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExtractFunctionInputPage.this.textModified(ExtractFunctionInputPage.this.getText());
            }
        });
        TextFieldNavigationHandler.install((Text)result);
        return result;
    }

    private String getText() {
        if (this.fTextField == null) {
            return null;
        }
        return this.fTextField.getText();
    }

    private String getLabelText() {
        return RefactoringMessages.ExtractMethodInputPage_label_text;
    }

    private void setVisibility(Integer visibility) {
        this.fRefactoring.setVisibility(visibility.intValue());
        this.updatePreview(this.getText());
    }

    private boolean computeGeneratePHPdoc() {
        boolean result = this.fRefactoring.getGeneratePHPdoc();
        if (result) {
            return result;
        }
        return this.fSettings.getBoolean(GENERATE_PHPDOC);
    }

    private void setGeneratePHPdoc(boolean value) {
        this.fSettings.put(GENERATE_PHPDOC, value);
        this.fRefactoring.setGeneratePHPdoc(value);
    }

    private void createSignaturePreview(Composite composite, RowLayouter layouter) {
        Label previewLabel = new Label(composite, 0);
        previewLabel.setText(RefactoringMessages.ExtractMethodInputPage_signature_preview);
        layouter.perform((Control)previewLabel);
        this.fSignaturePreview = new PHPSourceViewer(composite, 584);
        this.fSignaturePreview.getTextWidget().setBackground(composite.getBackground());
        this.fSignaturePreview.setText(this.fSignaturePreviewDocument);
        this.fSignaturePreview.setEditable(false);
        StyledText signaturePreviewControl = this.fSignaturePreview.getTextWidget();
        this.fSignaturePreview.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.fSignaturePreview.setLayoutData((Object)gd);
        PixelConverter pixelConverter = new PixelConverter((Control)signaturePreviewControl);
        GridData gdata = new GridData(1808);
        gdata.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        gdata.heightHint = pixelConverter.convertHeightInCharsToPixels(2);
        signaturePreviewControl.setLayoutData((Object)gdata);
        layouter.perform((Control)signaturePreviewControl);
    }

    private void updatePreview(String text) {
        String signature;
        if (this.fSignaturePreview == null) {
            return;
        }
        if (text.length() == 0) {
            text = "someMethodName";
        }
        int top = this.fSignaturePreview.getTextWidget().getTopPixel();
        try {
            signature = this.fRefactoring.getSignature(text);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            signature = "";
        }
        this.fSignaturePreview.setText(signature);
        this.fSignaturePreview.getTextWidget().setTopPixel(top);
    }

    private void loadSettings() {
        this.fSettings = this.getDialogSettings().getSection("ExtractMethodWizard");
        if (this.fSettings == null) {
            this.fSettings = this.getDialogSettings().addNewSection("ExtractMethodWizard");
            this.fSettings.put(GENERATE_PHPDOC, true);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.setPageComplete(false);
                this.updatePreview(this.getText());
                this.fTextField.setFocus();
            } else {
                this.setPageComplete(this.validatePage(true));
            }
        }
        super.setVisible(visible);
    }

    private void textModified(String text) {
        this.fRefactoring.setMethodName(text);
        RefactoringStatus status = this.validatePage(true);
        if (!status.hasFatalError()) {
            this.updatePreview(text);
        } else {
            this.fSignaturePreviewDocument = "";
        }
        this.setPageComplete(status);
    }

    private void parameterModified() {
        this.updatePreview(this.getText());
        this.setPageComplete(this.validatePage(false));
    }

    private RefactoringStatus validatePage(boolean text) {
        RefactoringStatus result = new RefactoringStatus();
        if (text) {
            result.merge(this.validateMethodName());
            result.merge(this.validateParameters());
        } else {
            result.merge(this.validateParameters());
            result.merge(this.validateMethodName());
        }
        return result;
    }

    private RefactoringStatus validateMethodName() {
        RefactoringStatus result = new RefactoringStatus();
        String text = this.getText();
        if ("".equals(text)) {
            result.addFatalError(RefactoringMessages.ExtractMethodInputPage_validation_emptyMethodName);
            return result;
        }
        result.merge(this.fRefactoring.checkFunctionName());
        return result;
    }

    private RefactoringStatus validateParameters() {
        RefactoringStatus result = new RefactoringStatus();
        List parameters = this.fRefactoring.getParameterInfos();
        for (ParameterInfo info : parameters) {
            if (!"".equals(info.getNewName())) continue;
            result.addFatalError(RefactoringMessages.ExtractMethodInputPage_validation_emptyParameterName);
            return result;
        }
        result.merge(this.fRefactoring.checkParameterNames());
        return result;
    }
}

