/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.wizard;

import java.lang.reflect.Array;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.refactoring.core.move.PHPMoveProcessor;
import org.eclipse.php.refactoring.ui.PHPRefactoringUIMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class RefactoringMoveWizardPage
extends UserInputWizardPage {
    private TreeViewer fViewer;
    private Button fReferenceCheckbox;

    public RefactoringMoveWizardPage() {
        super(PHPRefactoringUIMessages.getString("RefactoringMoveWizardPage.0"));
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        result.setLayout((Layout)new GridLayout());
        IResource[] initialSelections = new IResource[]{this.getPHPMoveProcessor().getDestination()};
        this.verifyDestination(initialSelections, true);
        this.addLabel(result);
        this.fViewer = this.createViewer(result);
        IResource target = initialSelections[0];
        if (target instanceof IFile) {
            target = target.getParent();
        }
        if (target != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)target), true);
        }
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RefactoringMoveWizardPage.this.viewerSelectionChanged(event);
            }
        });
        this.addUpdateReferenceComponent(result);
        Dialog.applyDialogFont((Control)result);
    }

    private Control addLabel(Composite parent) {
        Label label = new Label(parent, 0);
        String text = PHPRefactoringUIMessages.getString("RefactoringMoveWizardPage.1");
        label.setText(text);
        label.setLayoutData((Object)new GridData(1, 0x1000008, false, false));
        return label;
    }

    private TreeViewer createViewer(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent, 2820);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(40);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        treeViewer.getTree().setLayoutData((Object)gd);
        treeViewer.getTree().setLayoutData((Object)gd);
        treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        treeViewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        treeViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    return project.isAccessible();
                }
                return element instanceof IFolder;
            }
        });
        return treeViewer;
    }

    public TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    private void viewerSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        this.verifyDestination(ss.getFirstElement(), false);
    }

    private final void verifyDestination(Object selected, boolean initialVerification) {
        try {
            RefactoringStatus status = this.verifyDestination(selected);
            if (initialVerification) {
                this.setPageComplete(status.isOK());
            } else {
                this.setPageComplete(status);
            }
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
            this.setPageComplete(false);
        }
    }

    protected RefactoringStatus verifyDestination(Object selected) throws Exception {
        PHPMoveProcessor processor = this.getPHPMoveProcessor();
        if (selected.getClass().isArray() && Array.getLength(selected) == 1) {
            try {
                selected = Array.get(selected, 0);
            }
            catch (Exception exception) {}
        }
        RefactoringStatus refactoringStatus = selected instanceof IContainer ? processor.setDestination((IContainer)selected) : RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringUIMessages.getString("RefactoringMoveWizardPage.2"));
        return refactoringStatus;
    }

    private PHPMoveProcessor getPHPMoveProcessor() {
        return (PHPMoveProcessor)this.getRefactoring().getAdapter(PHPMoveProcessor.class);
    }

    private void addUpdateReferenceComponent(Composite result) {
        final PHPMoveProcessor processor = this.getPHPMoveProcessor();
        this.fReferenceCheckbox = new Button(result, 32);
        this.fReferenceCheckbox.setText(PHPRefactoringUIMessages.getString("RefactoringMoveWizardPage.3"));
        this.fReferenceCheckbox.setSelection(processor.getUpdateReferences());
        this.fReferenceCheckbox.setEnabled(true);
        this.fReferenceCheckbox.setSelection(true);
        processor.setUpdateReferences(true);
        this.getRefactoringWizard().setForcePreviewReview(true);
        this.fReferenceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                processor.setUpdateReferences(((Button)e.widget).getSelection());
                RefactoringMoveWizardPage.this.getRefactoringWizard().setForcePreviewReview(processor.getUpdateReferences());
            }
        });
    }
}

