/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.autoEdit.MatchingCharAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.TypingPreferences;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class QuotesAutoEditStrategy
extends MatchingCharAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (TypingPreferences.closeQuotes && command.text != null) {
            char c;
            int length = command.text.length();
            if (length == 0 && command.length == 1) {
                try {
                    char removedChar = document.getChar(command.offset);
                    if (this.isQuote(removedChar)) {
                        this.deleteQuote((IStructuredDocument)document, command, removedChar);
                    }
                }
                catch (BadLocationException e) {
                    Logger.logException(e);
                }
            }
            if (length == 1 && this.isQuote(c = command.text.charAt(0))) {
                this.autoAddPairQuote((IStructuredDocument)document, command, c);
            }
        }
    }

    private void autoAddPairQuote(IStructuredDocument document, DocumentCommand command, char insertedChar) {
        int startOffset = command.offset;
        int endOffset = startOffset + command.length;
        try {
            int result;
            String startState = FormatterUtils.getPartitionType((IStructuredDocument)document, (int)startOffset, (boolean)true);
            String endState = FormatterUtils.getPartitionType((IStructuredDocument)document, (int)endOffset, (boolean)true);
            if (startState == "org.eclipse.php.PHP_QUOTED_STRING" || endState == "org.eclipse.php.PHP_QUOTED_STRING" || startState == "org.eclipse.php.PHP_DEFAULT" && endState == "org.eclipse.php.PHP_DEFAULT" && document.getChar(endOffset - 1) == '\'') {
                if (endOffset < document.getLength() && startOffset == endOffset) {
                    char nextChar = document.getChar(endOffset);
                    if (insertedChar == nextChar) {
                        char prevChar = document.getChar(startOffset - 1);
                        if (prevChar != '\\') {
                            if (command.length == 0) {
                                this.adjustDocumentOffset(command);
                                command.text = "";
                            } else {
                                ++command.length;
                            }
                        }
                    } else {
                        IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(startOffset);
                        ITextRegion tRegion = this.getPhpRegion(sdRegion, startOffset);
                        int regionLength = tRegion.getLength();
                        int regionTextLength = tRegion.getTextLength();
                        if (regionTextLength != regionLength && startOffset > this.getRegionStart(sdRegion, startOffset) + regionTextLength && this.shouldAddClosingBracket(document, endOffset, true)) {
                            command.text = String.valueOf(command.text) + insertedChar;
                            document.replace(command.offset, command.length, command.text);
                            document.getUndoManager().disableUndoManagement();
                            document.replace(command.offset + 1, 0, "");
                            document.getUndoManager().enableUndoManagement();
                            this.adjustDocumentOffset(command);
                            command.length = 0;
                            command.text = "";
                        }
                    }
                }
                return;
            }
            if (this.isQuoteAllowed(startState, insertedChar) && this.shouldAddClosingBracket(document, endOffset, true) && (result = this.isMatchingCharNeeded(document, endOffset, insertedChar)) == 0) {
                command.text = String.valueOf(command.text) + insertedChar;
                document.replace(command.offset, command.length, command.text);
                document.getUndoManager().disableUndoManagement();
                document.replace(command.offset + 1, 0, "");
                document.getUndoManager().enableUndoManagement();
                this.adjustDocumentOffset(command);
                command.length = 0;
                command.text = "";
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            document.getUndoManager().enableUndoManagement();
        }
    }

    private ITextRegion getPhpRegion(IStructuredDocumentRegion sdRegion, int offset) throws BadLocationException {
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
        if (tRegion.getType().equals("PHP_CLOSE")) {
            tRegion = sdRegion.getRegionAtCharacterOffset(--offset);
        }
        int regionStart = sdRegion.getStartOffset(tRegion);
        if (tRegion instanceof ITextRegionContainer) {
            ITextRegionContainer container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
            regionStart += tRegion.getStart();
        }
        if (tRegion instanceof IPhpScriptRegion) {
            IPhpScriptRegion scriptRegion = (IPhpScriptRegion)tRegion;
            tRegion = scriptRegion.getPhpToken(offset - regionStart);
            return tRegion;
        }
        return null;
    }

    private int getRegionStart(IStructuredDocumentRegion sdRegion, int offset) throws BadLocationException {
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
        if (tRegion.getType().equals("PHP_CLOSE")) {
            tRegion = sdRegion.getRegionAtCharacterOffset(--offset);
        }
        int regionStart = sdRegion.getStartOffset(tRegion);
        if (tRegion instanceof ITextRegionContainer) {
            ITextRegionContainer container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
            regionStart += tRegion.getStart();
        }
        if (tRegion instanceof IPhpScriptRegion) {
            IPhpScriptRegion scriptRegion = (IPhpScriptRegion)tRegion;
            tRegion = scriptRegion.getPhpToken(offset - regionStart);
            regionStart += tRegion.getStart();
        }
        return regionStart;
    }

    private boolean isQuoteAllowed(String state, char quote) {
        return state == "org.eclipse.php.PHP_DEFAULT" || state == "PHP_OPENTAG" || state == "PHP_CLOSETAG";
    }

    public int isMatchingCharNeeded(IStructuredDocument document, int offset, char quoteChar) {
        block6: {
            String postCharState = FormatterUtils.getPartitionType((IStructuredDocument)document, (int)offset, (boolean)true);
            if (postCharState != "org.eclipse.php.PHP_DEFAULT" && postCharState != "PHP_OPENTAG" && postCharState != "PHP_CLOSETAG" && QuotesAutoEditStrategy.isSpecialOpenCurlyInQuotes(document, offset)) {
                postCharState = FormatterUtils.getPartitionType((IStructuredDocument)document, (int)(offset + 1));
            }
            if (postCharState == "org.eclipse.php.PHP_DEFAULT" || postCharState == "PHP_OPENTAG" || postCharState == "PHP_CLOSETAG") break block6;
            return -1;
        }
        try {
            if (FormatterUtils.getPartitionType((IStructuredDocument)document, (int)(document.getLength() - 1)) == "org.eclipse.php.PHP_QUOTED_STRING") {
                IStructuredDocumentRegion sdRegion = document.getLastStructuredDocumentRegion();
                ITextRegion tRegion = sdRegion.getLastRegion();
                char lastChar = document.getChar(sdRegion.getStartOffset() + tRegion.getTextEnd() - 1);
                if (lastChar != quoteChar) {
                    return 1;
                }
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        return 0;
    }

    private void deleteQuote(IStructuredDocument document, DocumentCommand command, char removedChar) {
        int offset = command.offset;
        IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
        if (sdRegion == null || sdRegion.getType() != "PHP_CONTENT") {
            return;
        }
        try {
            ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
            int regionStart = sdRegion.getStartOffset(tRegion);
            if (tRegion instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)tRegion;
                tRegion = container.getRegionAtCharacterOffset(offset);
                regionStart += tRegion.getStart();
            }
            if (tRegion instanceof IPhpScriptRegion) {
                IPhpScriptRegion scriptRegion = (IPhpScriptRegion)tRegion;
                if ((tRegion = scriptRegion.getPhpToken(offset - regionStart)).getType() != "PHP_CONSTANT_ENCAPSED_STRING") {
                    return;
                }
                if (offset != tRegion.getStart() + regionStart || tRegion.getTextLength() != 2 && !this.isBetweenBackquotes(sdRegion, offset)) {
                    return;
                }
                char nextChar = document.getChar(offset + 1);
                if (nextChar != removedChar) {
                    return;
                }
                command.length = 2;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean isBetweenBackquotes(IStructuredDocumentRegion sdRegion, int offset) throws BadLocationException {
        if (sdRegion.getParentDocument().getLength() <= offset) {
            return false;
        }
        ITextRegion quoteRegion = this.getPhpRegion(sdRegion, offset);
        if (quoteRegion == null || quoteRegion.getLength() > 1) {
            return false;
        }
        if (sdRegion.getFullText().charAt(offset - sdRegion.getStartOffset()) != '`') {
            return false;
        }
        quoteRegion = this.getPhpRegion(sdRegion, offset + 1);
        if (quoteRegion == null || quoteRegion.getLength() > 1) {
            return false;
        }
        return sdRegion.getFullText().charAt(offset + 1 - sdRegion.getStartOffset()) == '`';
    }
}

