/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.Messages;

public class StaticMethodHighlighting
extends AbstractSemanticHighlighting {
    @Override
    public AbstractSemanticApply getSemanticApply() {
        return new StaticMethodApply();
    }

    @Override
    public int getPriority() {
        return 110;
    }

    @Override
    protected void initDefaultPreferences() {
        this.getStyle().setItalicByDefault(true);
    }

    public String getDisplayName() {
        return Messages.StaticMethodHighlighting_0;
    }

    protected class StaticMethodApply
    extends AbstractSemanticApply {
        protected StaticMethodApply() {
        }

        public boolean visit(FunctionDeclaration functionDeclaration) {
            MethodDeclaration methodDeclaration;
            ASTNode parent = functionDeclaration.getParent();
            while (parent.getType() == 6 || parent.getType() == 29) {
                parent = parent.getParent();
            }
            if (parent.getType() == 42 && ((methodDeclaration = (MethodDeclaration)parent).getModifier() & 0x80) != 0) {
                StaticMethodHighlighting.this.highlight((ASTNode)functionDeclaration.getFunctionName());
            }
            return true;
        }

        public boolean visit(FunctionInvocation functionInvocation) {
            Expression functionName = functionInvocation.getFunctionName().getName();
            int invocationParent = functionInvocation.getParent().getType();
            if ((functionName.getType() == 33 || functionName.getType() == 60 && ((Variable)functionName).getName().getType() == 33) && invocationParent == 53) {
                StaticMethodHighlighting.this.highlight((ASTNode)functionName);
            }
            return true;
        }
    }
}

