/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import java.util.Arrays;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.IPHPDataType;
import org.eclipse.php.internal.debug.core.model.VirtualPartition;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.AbstractDBGpValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpUninitVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractDBGpContainerValue
extends AbstractDBGpValue {
    protected IVariable[] fCurrentVariables = null;
    protected IVariable[] fPreviousVariables = null;
    protected IVariable[] fPartitions = new IVariable[0];

    public AbstractDBGpContainerValue(DBGpVariable owner) {
        super(owner);
    }

    @Override
    public synchronized IVariable[] getVariables() throws DebugException {
        if (this.fCurrentVariables == null) {
            this.fetchVariables();
        }
        if (!this.hasPages()) {
            return this.fCurrentVariables;
        }
        return this.fPartitions;
    }

    protected abstract IVariable createVariable(Node var1);

    @Override
    protected void update(Node descriptor) {
        super.update(descriptor);
        this.fPreviousVariables = this.fCurrentVariables;
        this.fCurrentVariables = null;
        this.fPartitions = new IVariable[0];
        String childCountNumber = DBGpResponse.getAttribute(this.fDescriptor, "numchildren");
        int childCount = 0;
        this.fHasVariables = false;
        if (childCountNumber != null && childCountNumber.trim().length() != 0) {
            try {
                childCount = Integer.parseInt(childCountNumber);
                if (childCount > 0) {
                    this.fHasVariables = true;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    protected boolean hasPages() {
        return this.fPartitions.length > 0;
    }

    protected boolean isUninit(Node property) {
        String type = DBGpResponse.getAttribute(property, "type");
        return IPHPDataType.DataType.find(type) == IPHPDataType.DataType.PHP_UNINITIALIZED;
    }

    protected void fetchVariables() {
        block12: {
            int pageSize;
            int childCount;
            block11: {
                this.fCurrentVariables = new IVariable[0];
                this.fPartitions = new IVariable[0];
                String childCountString = DBGpResponse.getAttribute(this.fDescriptor, "numchildren");
                childCount = 0;
                if (childCountString != null && childCountString.trim().length() != 0) {
                    try {
                        childCount = Integer.parseInt(childCountString);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                String pageSizeStr = null;
                pageSizeStr = DBGpResponse.getAttribute(this.fDescriptor, "pagesize");
                pageSize = ((DBGpTarget)this.getDebugTarget()).getMaxChildren();
                if (pageSizeStr != null && pageSizeStr.trim().length() != 0) {
                    try {
                        pageSize = Integer.parseInt(pageSizeStr);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (childCount > pageSize) break block11;
                NodeList childProperties = this.fDescriptor.getChildNodes();
                int childrenReceived = childProperties.getLength();
                if (childCount != childrenReceived) {
                    DBGpTarget target = (DBGpTarget)this.getDebugTarget();
                    this.fDescriptor = target.getProperty(this.getOwner().getFullName(), String.valueOf(this.getOwner().getStackLevel()), 0);
                    if (this.fDescriptor == null) {
                        this.fCurrentVariables = new IVariable[0];
                        return;
                    }
                    childProperties = this.fDescriptor.getChildNodes();
                    childCount = childrenReceived = childProperties.getLength();
                }
                this.fCurrentVariables = new IVariable[childCount];
                if (childrenReceived <= 0) break block12;
                int i = 0;
                while (i < childrenReceived) {
                    Node childProperty = childProperties.item(i);
                    IVariable child = this.isUninit(childProperty) ? new DBGpUninitVariable(this.getDebugTarget()) : this.createVariable(childProperty);
                    this.fCurrentVariables[i] = this.merge(child);
                    ++i;
                }
                break block12;
            }
            int subCount = (int)Math.ceil((double)childCount / (double)pageSize);
            this.fPartitions = new IVariable[subCount];
            int i = 0;
            while (i < subCount) {
                int startIndex = i * pageSize;
                int endIndex = (i + 1) * pageSize - 1;
                if (endIndex > childCount) {
                    endIndex = childCount - 1;
                }
                VirtualPartition page = new VirtualPartition((IDebugElement)this, new DBGpPage(i), startIndex, endIndex);
                this.fPartitions[i] = page;
                ++i;
            }
        }
    }

    protected IVariable merge(IVariable variable) {
        if (this.fPreviousVariables == null) {
            return variable;
        }
        if (!(variable instanceof DBGpVariable)) {
            return variable;
        }
        DBGpVariable incoming = (DBGpVariable)variable;
        if (incoming.getFullName().isEmpty()) {
            return incoming;
        }
        IVariable[] iVariableArray = this.fPreviousVariables;
        int n = this.fPreviousVariables.length;
        int n2 = 0;
        while (n2 < n) {
            DBGpVariable previous;
            IVariable stored = iVariableArray[n2];
            if (stored instanceof DBGpVariable && (previous = (DBGpVariable)stored).getFullName().equals(incoming.getFullName())) {
                ((DBGpVariable)stored).update(incoming.getDescriptor());
                return stored;
            }
            ++n2;
        }
        return variable;
    }

    protected class DBGpPage
    implements VirtualPartition.IVariableProvider {
        private final int fPage;
        private IVariable[] fPartitionVariables = null;

        public DBGpPage(int page) {
            this.fPage = page;
        }

        @Override
        public synchronized IVariable[] getVariables() throws DebugException {
            if (this.fPartitionVariables == null) {
                DBGpTarget target = (DBGpTarget)AbstractDBGpContainerValue.this.getDebugTarget();
                Node property = target.getProperty(AbstractDBGpContainerValue.this.getOwner().getFullName(), String.valueOf(AbstractDBGpContainerValue.this.getOwner().getStackLevel()), this.fPage);
                NodeList childProperties = property.getChildNodes();
                int childrenReceived = childProperties.getLength();
                this.fPartitionVariables = new IVariable[childrenReceived];
                if (childrenReceived > 0) {
                    int i = 0;
                    while (i < childrenReceived) {
                        Node childProperty = childProperties.item(i);
                        IVariable child = AbstractDBGpContainerValue.this.isUninit(childProperty) ? new DBGpUninitVariable(AbstractDBGpContainerValue.this.getDebugTarget()) : AbstractDBGpContainerValue.this.createVariable(childProperty);
                        this.fPartitionVariables[i] = AbstractDBGpContainerValue.this.merge(child);
                        ++i;
                    }
                }
                IVariable[] concat = Arrays.copyOf(AbstractDBGpContainerValue.this.fCurrentVariables, AbstractDBGpContainerValue.this.fCurrentVariables.length + this.fPartitionVariables.length);
                System.arraycopy(this.fPartitionVariables, 0, concat, AbstractDBGpContainerValue.this.fCurrentVariables.length, this.fPartitionVariables.length);
                AbstractDBGpContainerValue.this.fCurrentVariables = concat;
            }
            return this.fPartitionVariables;
        }
    }
}

