/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.communication;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.php.internal.core.util.VersionUtils;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.PHPDebugUtil;
import org.eclipse.php.internal.debug.core.debugger.DebuggerSettingsManager;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettings;
import org.eclipse.php.internal.debug.core.zend.communication.Messages;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerServerSettings;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerSettingsUtil;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;

public class BroadcastConnection {
    protected Socket socket;

    public BroadcastConnection(Socket socket) {
        this.init(socket);
    }

    protected void init(Socket socket) {
        this.socket = socket;
        new ConnectionHandler().schedule();
    }

    protected boolean isRequestFromZendServer(String line) {
        if (line == null) {
            return false;
        }
        String zendServerString = "ZendServer=";
        int index = line.indexOf(zendServerString);
        if (index == -1) {
            return false;
        }
        String value = null;
        value = line.substring(index + zendServerString.length());
        if ((index = value.indexOf("HTTP")) == -1) {
            return false;
        }
        value = value.substring(0, index);
        return this.isBiggerOrEqual(value, "4.0.0");
    }

    protected boolean isBiggerOrEqual(String value, String baseVersion) {
        if (value == null) {
            return false;
        }
        return VersionUtils.equal((String)value, (String)baseVersion, (int)3) || VersionUtils.greater((String)value, (String)baseVersion, (int)3);
    }

    protected String getPlatformValue(String line) {
        if (line == null) {
            return null;
        }
        int index = line.indexOf("platform_gui=");
        if (index == -1) {
            return null;
        }
        String value = null;
        try {
            value = line.substring(index + "platform_gui=".length());
            value = value.substring(0, value.indexOf(" "));
            value = URLDecoder.decode(value, "UTF-8");
        }
        catch (Exception e) {
            DebugPlugin.log((Throwable)e);
            return null;
        }
        return value;
    }

    protected String getStandardHTTPResponse() {
        return "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n\r\n";
    }

    protected String getResponseString(boolean addQuestionMark, String host, int port) {
        String result = addQuestionMark ? "?" : "&";
        result = String.valueOf(result) + "debug_port=" + port;
        result = String.valueOf(result) + "&debug_host=" + host;
        result = String.valueOf(result) + "&debug_fastfile=" + String.valueOf(1);
        result = String.valueOf(result) + "&use_tunneling=" + String.valueOf(0);
        return result;
    }

    protected String getJSonResponseString(boolean addQuestionMark, String host, int port) {
        String result = null;
        JSONDescriptor descriptor = new JSONDescriptor();
        descriptor.put("debug_host", JSONDescriptor.quote(host));
        descriptor.put("debug_port", String.valueOf(port));
        descriptor.put("debug_fastfile", String.valueOf(1));
        descriptor.put("use_tunneling", String.valueOf(0));
        result = "var zendStudioSettings = " + descriptor.getString();
        return result;
    }

    protected String getHTMLContent(String platformValue, String host, int port) {
        String platformPath = platformValue;
        if (platformValue.indexOf("://") == -1) {
            platformPath = "http://" + platformValue;
        }
        platformPath = String.valueOf(platformPath) + this.getResponseString(platformValue.indexOf(63) == -1, host, port);
        String htmlContent = MessageFormat.format(Messages.BroadcastConnection_HTML_content_message, platformPath, platformPath);
        return htmlContent;
    }

    protected Server lookupServer(List<String> requestLines) {
        Iterator<String> iterator = requestLines.iterator();
        while (iterator.hasNext()) {
            String currentLine = iterator.next().trim();
            if (!currentLine.startsWith("Referer:")) continue;
            String referer = currentLine.replaceFirst("Referer:", "").trim();
            return ServersManager.findByURL((String)referer);
        }
        return null;
    }

    protected String lookupHosts(Server server) {
        IDebuggerSettings settings;
        if (server != null && (settings = DebuggerSettingsManager.INSTANCE.findSettings(server.getUniqueId(), server.getDebuggerId())) instanceof ZendDebuggerServerSettings) {
            return ZendDebuggerSettingsUtil.getDebugHosts(server.getUniqueId());
        }
        return PHPDebugUtil.getZendAllHosts();
    }

    protected int lookupPort(Server server) {
        IDebuggerSettings settings;
        if (server != null && (settings = DebuggerSettingsManager.INSTANCE.findSettings(server.getUniqueId(), server.getDebuggerId())) instanceof ZendDebuggerServerSettings) {
            return ZendDebuggerSettingsUtil.getDebugPort(server.getUniqueId());
        }
        return PHPDebugPlugin.getDebugPort("org.eclipse.php.debug.core.zendDebugger");
    }

    public static interface ConnectionConstants {
        public static final String DEBUG_HOST = "debug_host";
        public static final String DEBUG_PORT = "debug_port";
        public static final String DEBUG_FASTFILE = "debug_fastfile";
        public static final String USE_SSL = "use_ssl";
        public static final String USE_TUNNELING = "use_tunneling";
        public static final String IDE_SETTINGS = "var zendStudioSettings = ";
        public static final String PLATFORM_GUI = "platform_gui=";
        public static final String REFERER = "Referer:";
        public static final String STANDARD_HTTP_RESPONSE = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n\r\n";
    }

    protected class ConnectionHandler
    extends Job {
        public ConnectionHandler() {
            super(Messages.BroadcastConnection_Broadcast_connection_handler_name);
            this.setSystem(true);
            this.setUser(false);
            this.setPriority(30);
        }

        protected IStatus run(IProgressMonitor monitor) {
            block25: {
                InputStream inputStream = null;
                OutputStream outputStream = null;
                try {
                    try {
                        String currentLine;
                        inputStream = BroadcastConnection.this.socket.getInputStream();
                        outputStream = BroadcastConnection.this.socket.getOutputStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                        PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream));
                        ArrayList<String> requestLines = new ArrayList<String>();
                        while ((currentLine = reader.readLine()) != null && !currentLine.isEmpty()) {
                            requestLines.add(currentLine);
                        }
                        String firstLine = requestLines.isEmpty() ? null : (String)requestLines.get(0);
                        Server server = BroadcastConnection.this.lookupServer(requestLines);
                        String host = BroadcastConnection.this.lookupHosts(server);
                        int port = BroadcastConnection.this.lookupPort(server);
                        writer.write(BroadcastConnection.this.getStandardHTTPResponse());
                        if (BroadcastConnection.this.isRequestFromZendServer(firstLine)) {
                            writer.println(BroadcastConnection.this.getJSonResponseString(false, host, port));
                        } else {
                            String platform = BroadcastConnection.this.getPlatformValue(firstLine);
                            if (platform == null) {
                                writer.println(BroadcastConnection.this.getResponseString(false, host, port));
                            } else {
                                writer.write(BroadcastConnection.this.getHTMLContent(platform, host, port));
                            }
                        }
                        writer.flush();
                    }
                    catch (Exception e) {
                        DebugPlugin.log((Throwable)e);
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException oe) {
                                DebugPlugin.log((Throwable)oe);
                            }
                        }
                        if (BroadcastConnection.this.socket == null) break block25;
                        try {
                            BroadcastConnection.this.socket.close();
                        }
                        catch (IOException ioe) {
                            DebugPlugin.log((Throwable)ioe);
                        }
                    }
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException oe) {
                            DebugPlugin.log((Throwable)oe);
                        }
                    }
                    if (BroadcastConnection.this.socket != null) {
                        try {
                            BroadcastConnection.this.socket.close();
                        }
                        catch (IOException ioe) {
                            DebugPlugin.log((Throwable)ioe);
                        }
                    }
                }
            }
            return Status.OK_STATUS;
        }
    }

    protected static class JSONDescriptor {
        protected Map<String, String> properties = new HashMap<String, String>();

        public void put(String key, String value) {
            this.properties.put(key, value);
        }

        public String getString() {
            try {
                Iterator<String> keys = this.properties.keySet().iterator();
                StringBuffer sb = new StringBuffer("{");
                while (keys.hasNext()) {
                    if (sb.length() > 1) {
                        sb.append(',');
                    }
                    String o = keys.next();
                    sb.append(JSONDescriptor.quote(o.toString()));
                    sb.append(':');
                    sb.append(this.properties.get(o));
                }
                sb.append('}');
                return sb.toString();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public static String quote(String string) {
            if (string == null || string.length() == 0) {
                return "''";
            }
            char c = '\u0000';
            int len = string.length();
            StringBuffer sb = new StringBuffer(len + 4);
            sb.append('\'');
            int i = 0;
            while (i < len) {
                char b = c;
                c = string.charAt(i);
                switch (c) {
                    case '\'': 
                    case '\\': {
                        sb.append('\\');
                        sb.append(c);
                        break;
                    }
                    case '/': {
                        if (b == '<') {
                            sb.append('\\');
                        }
                        sb.append(c);
                        break;
                    }
                    case '\b': {
                        sb.append("\\b");
                        break;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\f': {
                        sb.append("\\f");
                        break;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    default: {
                        if (c < ' ') {
                            String t = "000" + Integer.toHexString(c);
                            sb.append("\\u" + t.substring(t.length() - 4));
                            break;
                        }
                        sb.append(c);
                    }
                }
                ++i;
            }
            sb.append('\'');
            return sb.toString();
        }
    }
}

