/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.php.internal.debug.core.model.IPHPDataType;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;

public class ExpressionsValueDeserializer {
    private String fEncoding;

    public ExpressionsValueDeserializer(String encoding) {
        this.fEncoding = encoding;
    }

    public ExpressionValue deserializer(Expression expression, byte[] value) {
        if (value == null) {
            value = new byte[]{78};
        }
        return this.build(expression, new VariableReader(value));
    }

    private String getText(byte[] buf) {
        try {
            return new String(buf, this.fEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(buf);
        }
    }

    private ExpressionValue build(Expression expression, VariableReader reader) {
        char type = reader.readType();
        switch (type) {
            case 'i': {
                return this.buildIntType(reader);
            }
            case 'd': {
                return this.buildFloatType(reader);
            }
            case 's': {
                return this.buildSringType(reader);
            }
            case 'b': {
                return this.buildBooleanType(reader);
            }
            case 'r': {
                return this.buildResourceType(reader);
            }
            case 'a': {
                return this.buildArrayType(expression, reader);
            }
            case 'O': {
                return this.buildObjectType(expression, reader);
            }
        }
        return ExpressionValue.NULL_VALUE;
    }

    private ExpressionValue buildIntType(VariableReader reader) {
        String value = reader.readToken();
        String valueAsString = "(int) " + value;
        return new ExpressionValue(IPHPDataType.DataType.PHP_INT, value, valueAsString, null);
    }

    private ExpressionValue buildFloatType(VariableReader reader) {
        String value = reader.readToken();
        String valueAsString = "(float) " + value;
        return new ExpressionValue(IPHPDataType.DataType.PHP_FLOAT, value, valueAsString, null);
    }

    private ExpressionValue buildSringType(VariableReader reader) {
        String value = reader.readString();
        String valueAsString = "(string:" + value.length() + ") " + value;
        return new ExpressionValue(IPHPDataType.DataType.PHP_STRING, value, valueAsString, null);
    }

    private ExpressionValue buildBooleanType(VariableReader reader) {
        String value = reader.readToken();
        String valueAsString = "(boolean) " + (value.equals("0") ? "false" : "true");
        return new ExpressionValue(IPHPDataType.DataType.PHP_BOOL, value, valueAsString, null);
    }

    private ExpressionValue buildResourceType(VariableReader reader) {
        int resourceNumber = reader.readInt();
        reader.readInt();
        String value = reader.readToken();
        String valueAsString = "resource (" + resourceNumber + ") of type (" + value + ')';
        return new ExpressionValue(IPHPDataType.DataType.PHP_RESOURCE, value, valueAsString, null);
    }

    private ExpressionValue buildArrayType(Expression expression, VariableReader reader) {
        int objectLength;
        int originalLength = objectLength = reader.readInt();
        if (reader.isLastEnd()) {
            objectLength = 0;
        }
        Expression[] variableNodes = new Expression[objectLength];
        int i = 0;
        while (i < objectLength) {
            String name;
            char type = reader.readType();
            if (type == 'i') {
                name = Integer.toString(reader.readInt());
            } else if (type == 's') {
                name = reader.readString();
            } else {
                return ExpressionValue.NULL_VALUE;
            }
            variableNodes[i] = expression == null ? this.createDefaultVariable(name) : expression.createChildExpression(name, String.valueOf('[') + name + ']', IVariableFacet.Facet.KIND_ARRAY_MEMBER);
            variableNodes[i].setValue(this.build(expression, reader));
            ++i;
        }
        return new ExpressionValue(IPHPDataType.DataType.PHP_ARRAY, "Array", "Array [" + originalLength + ']', variableNodes, originalLength);
    }

    private ExpressionValue buildObjectType(Expression expression, VariableReader reader) {
        int objectLength;
        String className = reader.readString();
        int originalLength = objectLength = reader.readInt();
        if (reader.isLastEnd()) {
            objectLength = 0;
        }
        Expression[] expressionNodes = new Expression[objectLength];
        int i = 0;
        while (i < objectLength) {
            String name;
            char type = reader.readType();
            if (type == 'i') {
                name = Integer.toString(reader.readInt());
            } else if (type == 's') {
                name = reader.readString();
            } else {
                return ExpressionValue.NULL_VALUE;
            }
            expressionNodes[i] = expression == null ? this.createDefaultVariable(name) : expression.createChildExpression(name, "->" + name, IVariableFacet.Facet.KIND_OBJECT_MEMBER);
            expressionNodes[i].setValue(this.build(expression, reader));
            ++i;
        }
        String valueAsString = "Object of: " + className;
        return new ExpressionValue(IPHPDataType.DataType.PHP_OBJECT, className, valueAsString, expressionNodes, originalLength);
    }

    private Expression createDefaultVariable(String name) {
        return new DefaultExpression(String.valueOf('$') + name);
    }

    private class VariableReader
    extends ByteArrayInputStream {
        private VariableReader(byte[] result) {
            super(result);
        }

        private char readType() {
            int temp;
            char curr;
            do {
                if ((temp = super.read()) != -1) continue;
                return ' ';
            } while ((curr = (char)temp) == ';' || curr == ':' || curr == '{' || curr == '}');
            return curr;
        }

        private String readToken() {
            char curr;
            StringBuffer buffer = new StringBuffer(6);
            while ((curr = (char)super.read()) == ';' || curr == ':') {
            }
            while (curr != ';' && curr != ':') {
                buffer.append(curr);
                curr = (char)super.read();
            }
            return buffer.toString();
        }

        private String readString() {
            int length = this.readInt();
            while ((char)super.read() != '\"') {
            }
            byte[] bytes = new byte[length];
            this.read(bytes, 0, length);
            super.read();
            return ExpressionsValueDeserializer.this.getText(bytes);
        }

        public int readInt() {
            char curr;
            int result = 0;
            boolean isMinus = false;
            do {
                if ((curr = (char)super.read()) != '-') continue;
                isMinus = true;
            } while (!Character.isDigit(curr));
            do {
                result *= 10;
                result += Character.getNumericValue(curr);
                this.mark(1);
            } while (Character.isDigit(curr = (char)super.read()));
            if (isMinus) {
                result *= -1;
            }
            return result;
        }

        private boolean isLastEnd() {
            this.reset();
            char curr = (char)super.read();
            return curr == ';';
        }
    }
}

