/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class GlobalStatement
extends Statement {
    private final ASTNode.NodeList<Variable> variables = new ASTNode.NodeList(VARIABLES_PROPERTY);
    public static final ChildListPropertyDescriptor VARIABLES_PROPERTY = new ChildListPropertyDescriptor(GlobalStatement.class, "variables", Variable.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildListPropertyDescriptor> properyList = new ArrayList<ChildListPropertyDescriptor>(1);
        properyList.add(VARIABLES_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    private GlobalStatement(int start, int end, AST ast, Variable[] variables) {
        super(start, end, ast);
        if (variables == null) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            this.variables.add(variable);
            ++n2;
        }
    }

    public GlobalStatement(int start, int end, AST ast, List variables) {
        this(start, end, ast, variables == null ? null : variables.toArray(new Variable[variables.size()]));
    }

    public GlobalStatement(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (ASTNode aSTNode : this.variables) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            for (ASTNode aSTNode : this.variables) {
                aSTNode.traverseTopDown(visitor);
            }
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (ASTNode aSTNode : this.variables) {
            aSTNode.traverseBottomUp(visitor);
        }
        visitor.visit(this);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<GlobalStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        for (ASTNode aSTNode : this.variables) {
            aSTNode.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</GlobalStatement>");
    }

    @Override
    public int getType() {
        return 32;
    }

    public List<Variable> variables() {
        return this.variables;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        List variables = ASTNode.copySubtrees(target, this.variables());
        GlobalStatement result = new GlobalStatement(this.getStart(), this.getEnd(), target, variables);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == VARIABLES_PROPERTY) {
            return this.variables();
        }
        return super.internalGetChildListProperty(property);
    }
}

