/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.IMethodBinding;
import org.eclipse.php.internal.core.ast.nodes.StaticDispatch;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class StaticMethodInvocation
extends StaticDispatch {
    private FunctionInvocation method;
    public static final ChildPropertyDescriptor CLASS_NAME_PROPERTY = new ChildPropertyDescriptor(StaticMethodInvocation.class, "className", Expression.class, true, false);
    public static final ChildPropertyDescriptor METHOD_PROPERTY = new ChildPropertyDescriptor(StaticMethodInvocation.class, "method", FunctionInvocation.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildPropertyDescriptor> propertyList = new ArrayList<ChildPropertyDescriptor>(2);
        propertyList.add(METHOD_PROPERTY);
        propertyList.add(CLASS_NAME_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    @Override
    ChildPropertyDescriptor getClassNameProperty() {
        return CLASS_NAME_PROPERTY;
    }

    public StaticMethodInvocation(int start, int end, AST ast, Expression className, FunctionInvocation method) {
        super(start, end, ast, className);
        if (method == null) {
            throw new IllegalArgumentException();
        }
        this.setMethod(method);
    }

    public StaticMethodInvocation(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.getClassName().accept(visitor);
        this.method.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getClassName().traverseTopDown(visitor);
        this.method.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.getClassName().traverseBottomUp(visitor);
        this.method.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<StaticMethodInvocation");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<ClassName>\n");
        this.getClassName().toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</ClassName>\n");
        this.method.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</StaticMethodInvocation>");
    }

    @Override
    public int getType() {
        return 53;
    }

    public FunctionInvocation getMethod() {
        return this.method;
    }

    @Override
    public ASTNode getMember() {
        return this.getMethod();
    }

    public void setMethod(FunctionInvocation method) {
        if (method == null) {
            throw new IllegalArgumentException();
        }
        FunctionInvocation oldChild = this.method;
        this.preReplaceChild(oldChild, method, METHOD_PROPERTY);
        this.method = method;
        this.postReplaceChild(oldChild, method, METHOD_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == METHOD_PROPERTY) {
            if (get) {
                return this.getMethod();
            }
            this.setMethod((FunctionInvocation)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression className = ASTNode.copySubtree(target, this.getClassName());
        FunctionInvocation method = ASTNode.copySubtree(target, this.getMethod());
        StaticMethodInvocation result = new StaticMethodInvocation(this.getStart(), this.getEnd(), target, className, method);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    public IMethodBinding resolveMethodBinding() {
        return this.ast.getBindingResolver().resolveMethod(this);
    }
}

