/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Statement;

public abstract class TypeDeclaration
extends Statement {
    private Identifier name;
    protected ASTNode.NodeList<Identifier> interfaces = new ASTNode.NodeList(this.getInterfacesProperty());
    private Block body;

    protected abstract ChildPropertyDescriptor getNameProperty();

    protected abstract ChildListPropertyDescriptor getInterfacesProperty();

    protected abstract ChildPropertyDescriptor getBodyProperty();

    public TypeDeclaration(int start, int end, AST ast, Identifier name, Identifier[] interfaces, Block body) {
        super(start, end, ast);
        if (name == null || body == null) {
            throw new IllegalArgumentException();
        }
        this.setName(name);
        this.setBody(body);
        if (interfaces != null) {
            Identifier[] identifierArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Identifier identifier = identifierArray[n2];
                this.interfaces.add(identifier);
                ++n2;
            }
        }
    }

    public TypeDeclaration(AST ast) {
        super(ast);
    }

    public Block getBody() {
        return this.body;
    }

    public void setBody(Block block) {
        if (block == null) {
            throw new IllegalArgumentException();
        }
        Block oldChild = this.body;
        this.preReplaceChild(oldChild, block, this.getBodyProperty());
        this.body = block;
        this.postReplaceChild(oldChild, block, this.getBodyProperty());
    }

    public List<Identifier> interfaces() {
        return this.interfaces;
    }

    public Identifier getName() {
        return this.name;
    }

    public void setName(Identifier id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        Identifier oldChild = this.name;
        this.preReplaceChild(oldChild, id, this.getNameProperty());
        this.name = id;
        this.postReplaceChild(oldChild, id, this.getNameProperty());
    }

    @Override
    ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == this.getNameProperty()) {
            if (get) {
                return this.getName();
            }
            this.setName((Identifier)child);
            return null;
        }
        if (property == this.getBodyProperty()) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Block)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == this.getInterfacesProperty()) {
            return this.interfaces();
        }
        return super.internalGetChildListProperty(property);
    }

    public final ITypeBinding resolveTypeBinding() {
        return this.ast.getBindingResolver().resolveType(this);
    }
}

