/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class ArrayKeyContext
extends AbstractCompletionContext {
    private String arrayVarName;
    private boolean hasQuotes;

    public String getArrayVarName() {
        return this.arrayVarName;
    }

    public boolean hasQuotes() {
        return this.hasQuotes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        try {
            ITextRegion phpToken = this.getPHPToken();
            TextSequence statementText = this.getStatementText();
            int length = statementText.length();
            int endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statementText, length);
            int startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex(this.getPhpVersion(), statementText, endPosition, true);
            this.hasQuotes = false;
            if (PHPPartitionTypes.isPHPQuotesState(phpToken.getType())) {
                this.hasQuotes = true;
                endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statementText, startPosition);
                if (endPosition <= 0 || statementText.charAt(endPosition - 1) != '\"' && statementText.charAt(endPosition - 1) != '\'') {
                    return false;
                }
                startPosition = endPosition - 1;
            }
            if ((endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statementText, startPosition)) > 0 && (statementText.charAt(endPosition - 1) == '\"' || statementText.charAt(endPosition - 1) == '\'')) {
                this.hasQuotes = true;
                startPosition = endPosition - 1;
                endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statementText, startPosition);
            }
            if (startPosition < 0 || endPosition <= 0 || statementText.charAt(endPosition - 1) != '[') {
                return false;
            }
            endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statementText, endPosition - 1);
            startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex(this.getPhpVersion(), statementText, endPosition, true);
            this.arrayVarName = statementText.subSequence(startPosition, endPosition).toString();
            if (this.arrayVarName.startsWith("$")) return true;
            return false;
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return true;
    }

    @Override
    public int getPrefixEnd() throws BadLocationException {
        int prefixEnd = super.getPrefixEnd();
        if (this.hasQuotes) {
            --prefixEnd;
        }
        return prefixEnd;
    }
}

