/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.LinkedList;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.NamespaceUseFunctionNameContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;

public class NamespaceUseFunctionNameStrategy
extends AbstractCompletionStrategy {
    public NamespaceUseFunctionNameStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof NamespaceUseFunctionNameContext)) {
            return;
        }
        NamespaceUseFunctionNameContext concreteContext = (NamespaceUseFunctionNameContext)context;
        String suffix = "";
        ISourceRange replaceRange = this.getReplacementRange(concreteContext);
        IMethod[] iMethodArray = this.getMethods(concreteContext);
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            reporter.reportMethod(method, suffix, replaceRange, this.getExtraInfo());
            ++n2;
        }
    }

    public IMethod[] getMethods(NamespaceUseFunctionNameContext context) throws BadLocationException {
        String prefix = context.getPrefix();
        LinkedList<IMethod> result = new LinkedList<IMethod>();
        IType[] iTypeArray = context.getNamespaces();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType ns = iTypeArray[n2];
            try {
                IMethod[] iMethodArray = ns.getMethods();
                int n3 = iMethodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMethod method = iMethodArray[n4];
                    if (CodeAssistUtils.startsWithIgnoreCase(method.getElementName(), prefix)) {
                        result.add(method);
                    }
                    ++n4;
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public String getSuffix(AbstractCompletionContext abstractContext) {
        String nextWord = null;
        try {
            nextWord = abstractContext.getNextWord();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return "::".equals(nextWord) ? "" : "::";
    }

    protected int getExtraInfo() {
        return 577;
    }
}

