/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.nodes.IRecoverable;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class AnonymousClassDeclaration
extends Expression
implements IRecoverable {
    private TypeReference superClass;
    private List<TypeReference> interfaceList;
    private Block body;
    private boolean isRecovered;

    public AnonymousClassDeclaration(int start, int end, TypeReference superClass, List<TypeReference> interfaceList, Block body) {
        super(start, end);
        assert (body != null);
        this.superClass = superClass;
        this.interfaceList = interfaceList;
        this.body = body;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Expression)this);
        if (visit) {
            if (this.superClass != null) {
                this.superClass.traverse(visitor);
            }
            if (this.interfaceList != null) {
                for (TypeReference type : this.interfaceList) {
                    type.traverse(visitor);
                }
            }
            this.body.traverse(visitor);
        }
        visitor.endvisit((Expression)this);
    }

    public TypeReference getSuperClass() {
        return this.superClass;
    }

    public List<TypeReference> getInterfaceList() {
        return this.interfaceList;
    }

    public Block getBody() {
        return this.body;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }

    public int getKind() {
        return 76;
    }

    @Override
    public boolean isRecovered() {
        return this.isRecovered;
    }

    @Override
    public void setRecovered(boolean isRecovered) {
        this.isRecovered = isRecovered;
    }
}

