/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.corext.dom;

import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.visitor.ApplyAll;

public class NodeFinder
extends ApplyAll {
    private int fStart;
    private int fEnd;
    private ASTNode fCoveringNode;
    private ASTNode fCoveredNode;

    public static ASTNode perform(ASTNode root, int start, int length) {
        NodeFinder finder = new NodeFinder(start, length);
        root.accept(finder);
        ASTNode result = finder.getCoveredNode();
        if (result == null || result.getStart() != start || result.getLength() != length) {
            return finder.getCoveringNode();
        }
        return result;
    }

    public static ASTNode perform(ASTNode root, ISourceRange range) {
        return NodeFinder.perform(root, range.getOffset(), range.getLength());
    }

    public NodeFinder(int offset, int length) {
        this.fStart = offset;
        this.fEnd = offset + length;
    }

    @Override
    protected boolean apply(ASTNode node) {
        int nodeStart = node.getStart();
        int nodeEnd = nodeStart + node.getLength();
        if (nodeEnd < this.fStart || this.fEnd < nodeStart) {
            return false;
        }
        if (nodeStart <= this.fStart && this.fEnd <= nodeEnd) {
            this.fCoveringNode = node;
        }
        if (this.fStart <= nodeStart && nodeEnd <= this.fEnd) {
            if (this.fCoveringNode == node) {
                this.fCoveredNode = node;
                return true;
            }
            if (this.fCoveredNode == null) {
                this.fCoveredNode = node;
            }
            return false;
        }
        return true;
    }

    public ASTNode getCoveredNode() {
        return this.fCoveredNode;
    }

    public ASTNode getCoveringNode() {
        return this.fCoveringNode;
    }
}

