/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.format.IFormatterCommonPrferences;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencePropagatorFactory;
import org.eclipse.php.internal.core.preferences.PreferencesPropagator;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.wst.sse.core.StructuredModelManager;

public class FormatPreferencesSupport
implements IFormatterCommonPrferences {
    private IDocument fLastDocument = null;
    private IProject fLastProject = null;
    private char indentationChar;
    private int indentationSize;
    private int tabSize;
    private boolean useTab;
    private int fIndentationWrappedLineSize;
    private int fIndentationArrayInitSize;
    private PreferencesSupport preferencesSupport = null;
    private PreferencesPropagatorListener listener = null;
    private boolean preferencesChanged = false;
    private PreferencesPropagator preferencesPropagator = PreferencePropagatorFactory.getPreferencePropagator("org.eclipse.php.core");
    private static final String NODES_QUALIFIER = "org.eclipse.php.core";
    private static FormatPreferencesSupport instance = null;

    private FormatPreferencesSupport() {
        this.preferencesSupport = new PreferencesSupport(NODES_QUALIFIER);
    }

    public static FormatPreferencesSupport getInstance() {
        if (instance == null) {
            instance = new FormatPreferencesSupport();
        }
        return instance;
    }

    @Override
    public int getIndentationWrappedLineSize(IDocument document) {
        if (!this.verifyValidity(document)) {
            String indentSize = this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.phpForamtterIndentationWrappedLineSize");
            if (indentSize == null || indentSize.length() == 0) {
                return this.fIndentationWrappedLineSize;
            }
            return Integer.valueOf(indentSize);
        }
        return this.fIndentationWrappedLineSize;
    }

    @Override
    public int getIndentationArrayInitSize(IDocument document) {
        if (!this.verifyValidity(document)) {
            String indentSize = this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.phpForamtterArrayInitSize");
            if (indentSize == null || indentSize.length() == 0) {
                return this.fIndentationArrayInitSize;
            }
            return Integer.valueOf(indentSize);
        }
        return this.fIndentationArrayInitSize;
    }

    @Override
    public int getIndentationSize(IDocument document) {
        if (!this.verifyValidity(document)) {
            String indentSize = this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.phpForamtterIndentationSize");
            if (indentSize == null || indentSize.length() == 0) {
                return this.indentationSize;
            }
            return Integer.valueOf(indentSize);
        }
        return this.indentationSize;
    }

    @Override
    public int getTabSize(IDocument document) {
        if (!this.verifyValidity(document)) {
            String tabSizeStr = this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.phpForamtterTabSize");
            if (tabSizeStr == null || tabSizeStr.length() == 0) {
                return this.tabSize;
            }
            return Integer.valueOf(tabSizeStr);
        }
        return this.tabSize;
    }

    @Override
    public char getIndentationChar(IDocument document) {
        if (!this.verifyValidity(document)) {
            String useTab = this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.phpForamtterUseTabs");
            if (useTab == null) {
                return '\t';
            }
            return Boolean.valueOf(useTab) != false ? (char)'\t' : ' ';
        }
        return this.indentationChar;
    }

    @Override
    public boolean useTab(IDocument document) {
        if (!this.verifyValidity(document)) {
            String useTab = this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.phpForamtterUseTabs");
            if (useTab == null) {
                return true;
            }
            return Boolean.valueOf(useTab);
        }
        return this.useTab;
    }

    private boolean verifyValidity(IDocument document) {
        if (this.fLastDocument != document) {
            DOMModelForPHP editorModel = null;
            try {
                editorModel = (DOMModelForPHP)StructuredModelManager.getModelManager().getExistingModelForRead(document);
                if (editorModel == null) {
                    return false;
                }
                String baseLocation = editorModel.getBaseLocation();
                Path basePath = new Path(baseLocation);
                IFile file = null;
                if (basePath.segmentCount() > 1 && !(file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)basePath)).exists()) {
                    file = null;
                }
                if (file == null) {
                    return false;
                }
                IProject project = file.getProject();
                if (this.fLastProject != project) {
                    this.fLastProject = project;
                    this.verifyListening();
                }
            }
            finally {
                if (editorModel != null) {
                    editorModel.releaseFromRead();
                }
            }
        }
        if (this.fLastDocument != document || this.preferencesChanged) {
            String indentationArrayInitSize;
            String useTab = this.preferencesSupport.getPreferencesValue("org.eclipse.php.core.phpForamtterUseTabs", null, this.fLastProject);
            String indentSize = this.preferencesSupport.getPreferencesValue("org.eclipse.php.core.phpForamtterIndentationSize", null, this.fLastProject);
            String tabSize = this.preferencesSupport.getPreferencesValue("org.eclipse.php.core.phpForamtterTabSize", null, this.fLastProject);
            String indentationWrappedLineSize = this.preferencesSupport.getPreferencesValue("org.eclipse.php.core.phpForamtterIndentationWrappedLineSize", null, this.fLastProject);
            if (indentationWrappedLineSize == null || indentationWrappedLineSize.trim().length() == 0) {
                indentationWrappedLineSize = "2";
            }
            if ((indentationArrayInitSize = this.preferencesSupport.getPreferencesValue("org.eclipse.php.core.phpForamtterArrayInitSize", null, this.fLastProject)) == null || indentationArrayInitSize.trim().length() == 0) {
                indentationArrayInitSize = "2";
            }
            this.indentationChar = (char)(Boolean.valueOf(useTab) != false ? 9 : 32);
            this.useTab = Boolean.valueOf(useTab);
            this.indentationSize = Integer.valueOf(indentSize);
            this.tabSize = Integer.valueOf(tabSize);
            this.fIndentationWrappedLineSize = Integer.valueOf(indentationWrappedLineSize);
            this.fIndentationArrayInitSize = Integer.valueOf(indentationArrayInitSize);
            this.preferencesChanged = false;
            this.fLastDocument = document;
        }
        return true;
    }

    private void verifyListening() {
        if (this.listener != null) {
            this.preferencesPropagator.removePropagatorListener(this.listener, "org.eclipse.php.core.phpForamtterIndentationWrappedLineSize");
            this.preferencesPropagator.removePropagatorListener(this.listener, "org.eclipse.php.core.phpForamtterArrayInitSize");
            this.preferencesPropagator.removePropagatorListener(this.listener, "org.eclipse.php.core.phpForamtterUseTabs");
            this.preferencesPropagator.removePropagatorListener(this.listener, "org.eclipse.php.core.phpForamtterIndentationSize");
        }
        this.listener = new PreferencesPropagatorListener(this.fLastProject);
        this.preferencesPropagator.addPropagatorListener(this.listener, "org.eclipse.php.core.phpForamtterIndentationWrappedLineSize");
        this.preferencesPropagator.addPropagatorListener(this.listener, "org.eclipse.php.core.phpForamtterArrayInitSize");
        this.preferencesPropagator.addPropagatorListener(this.listener, "org.eclipse.php.core.phpForamtterUseTabs");
        this.preferencesPropagator.addPropagatorListener(this.listener, "org.eclipse.php.core.phpForamtterIndentationSize");
    }

    private class PreferencesPropagatorListener
    implements IPreferencesPropagatorListener {
        private IProject project;

        public PreferencesPropagatorListener(IProject project) {
            this.project = project;
        }

        @Override
        public void preferencesEventOccured(PreferencesPropagatorEvent event) {
            FormatPreferencesSupport.this.preferencesChanged = true;
        }

        @Override
        public IProject getProject() {
            return this.project;
        }
    }
}

